/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.tools;

import com.inprise.vbroker.compiler.ast.NodeFactory;
import com.inprise.vbroker.compiler.backends.common.GenericBackend;
import com.inprise.vbroker.compiler.tools.ToolOptions;
import com.inprise.vbroker.compiler.util.BufferReader;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.PrintER;
import com.inprise.vbroker.compiler.util.Utils;
import com.inprise.vbroker.util.StringFunctions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class tool {
    public static final int SUCCESS = 0;
    public static final int BOOTSTRAP_ERROR = 10;
    public static final int COMMAND_LINE_ERROR = 20;
    public static final int PREPROCESSOR_ERROR = 30;
    public static final int FRONTEND_ERROR = 40;
    public static final int BACKEND_ERROR = 50;
    public static final int INTERNAL_ERROR = 60;
    public String _toolName;
    public GenericBackend _backend;
    public int _frontEndResult;
    public int _exitCode;
    public ErrorReporter _ER;
    private static final Class[] frontendConstructorArgs = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = tool.class$("java.lang.Class")) : class$java$lang$Class, class$com$inprise$vbroker$compiler$util$ErrorReporter == null ? (class$com$inprise$vbroker$compiler$util$ErrorReporter = tool.class$("com.inprise.vbroker.compiler.util.ErrorReporter")) : class$com$inprise$vbroker$compiler$util$ErrorReporter, class$com$inprise$vbroker$compiler$util$BufferReader == null ? (class$com$inprise$vbroker$compiler$util$BufferReader = tool.class$("com.inprise.vbroker.compiler.util.BufferReader")) : class$com$inprise$vbroker$compiler$util$BufferReader, class$com$inprise$vbroker$compiler$util$BufferWriter == null ? (class$com$inprise$vbroker$compiler$util$BufferWriter = tool.class$("com.inprise.vbroker.compiler.util.BufferWriter")) : class$com$inprise$vbroker$compiler$util$BufferWriter, array$Ljava$lang$String == null ? (array$Ljava$lang$String = tool.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    private static final Class[] backendConstructorArgs = new Class[]{class$com$inprise$vbroker$compiler$ast$ContainerNode == null ? (class$com$inprise$vbroker$compiler$ast$ContainerNode = tool.class$("com.inprise.vbroker.compiler.ast.ContainerNode")) : class$com$inprise$vbroker$compiler$ast$ContainerNode, class$com$inprise$vbroker$compiler$util$BufferWriter == null ? (class$com$inprise$vbroker$compiler$util$BufferWriter = tool.class$("com.inprise.vbroker.compiler.util.BufferWriter")) : class$com$inprise$vbroker$compiler$util$BufferWriter, class$java$lang$String == null ? (class$java$lang$String = tool.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = tool.class$("java.util.Vector")) : class$java$util$Vector};
    static Class class$com$inprise$vbroker$compiler$ast$ContainerNode;
    static Class class$java$lang$String;
    static Class array$Ljava$lang$String;
    static Class class$com$inprise$vbroker$compiler$util$BufferReader;
    static Class class$java$util$Vector;
    static Class class$com$inprise$vbroker$compiler$util$BufferWriter;
    static Class class$com$inprise$vbroker$compiler$util$ErrorReporter;
    static Class class$java$lang$Class;

    public tool(ErrorReporter ER) {
        this._ER = ER;
        this._toolName = ER.getToolName();
    }

    public static Object construct(Class clas, String name, Object[] args, ErrorReporter ER) {
        return tool.construct(clas, name, args, ER, backendConstructorArgs);
    }

    public static Object construct(Class clas, String name, Object[] args, ErrorReporter ER, Class[] constructorArgs) {
        Exception t = null;
        try {
            Object temp2;
            Constructor temp1 = clas.getConstructor(constructorArgs);
            Object t2 = temp2 = temp1.newInstance(args);
            return t2;
        }
        catch (SecurityException e) {
            t = e;
        }
        catch (NoSuchMethodException e) {
            t = e;
        }
        catch (ClassCastException e) {
            t = e;
        }
        catch (InstantiationException e) {
            t = e;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException instanceof Error) {
                throw (Error)realException;
            }
            if (realException instanceof RuntimeException) {
                throw (RuntimeException)realException;
            }
            t = e;
        }
        ER.internalError(t);
        return null;
    }

    public static final ErrorReporter createER(String toolName, String[] args) {
        PrintER ER = null;
        try {
            ER = new PrintER("com.inprise.vbroker.compiler.Messages");
            if (ER == null) {
                System.err.println("<internal>: unable to instantiate new classes; giving up");
                ErrorReporter errorReporter = null;
                return errorReporter;
            }
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-XXX_debug")) continue;
                ER._verbose = true;
            }
            ER.setToolName(toolName);
        }
        catch (Throwable t) {
            System.err.println("<internal>: unable to load the compiler's message resources");
            System.err.println("<internal>: (check your installation and CLASSPATH settings)");
            ErrorReporter errorReporter = null;
            return errorReporter;
        }
        return ER;
    }

    public static Class getClassForName(String className, ErrorReporter ER, String mesgName) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            ER.error(mesgName, new Object[]{className});
        }
        catch (ExceptionInInitializerError e) {
            ER.internalError(e.getException());
        }
        return null;
    }

    protected NodeFactory getNodeFactory(Class backendClass) {
        NodeFactory factory;
        block11: {
            Throwable t = null;
            factory = null;
            try {
                try {
                    factory = (NodeFactory)backendClass.getMethod("makeNodeFactory", class$com$inprise$vbroker$compiler$util$ErrorReporter == null ? (class$com$inprise$vbroker$compiler$util$ErrorReporter = tool.class$("com.inprise.vbroker.compiler.util.ErrorReporter")) : class$com$inprise$vbroker$compiler$util$ErrorReporter).invoke(null, this._ER);
                }
                catch (NoSuchMethodException e) {
                    t = e;
                    Object var6_5 = null;
                    if (t != null) {
                        this._ER.internalError(t);
                        return null;
                    }
                    break block11;
                }
                catch (InvocationTargetException e) {
                    t = e.getTargetException();
                    Object var6_6 = null;
                    if (t != null) {
                        this._ER.internalError(t);
                        return null;
                    }
                    break block11;
                }
                catch (IllegalAccessException e) {
                    t = e;
                    Object var6_7 = null;
                    if (t != null) {
                        this._ER.internalError(t);
                        return null;
                    }
                }
                Object var6_4 = null;
                if (t != null) {
                    this._ER.internalError(t);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (t != null) {
                    this._ER.internalError(t);
                    return null;
                }
                throw throwable;
            }
        }
        return factory;
    }

    public static int main(ToolOptions options, String[] args) {
        tool t = tool.main(args, options);
        if (t == null) {
            return 10;
        }
        return t._exitCode;
    }

    public static void main(String[] args) {
        try {
            ToolOptions toolOptions;
            ErrorReporter ER = tool.createER("tool", args);
            if (ER == null) {
                System.exit(10);
            }
            if ((toolOptions = new ToolOptions(ER)) == null) {
                System.err.println(String.valueOf(ER.getToolName()).concat(": unable to parse command line; aborting"));
                System.exit(10);
            }
            boolean[] usageResult = new boolean[]{false, false};
            args = toolOptions.parse(args, usageResult);
            if (usageResult[0]) {
                toolOptions.printUsage(null, new String[]{"Comp.Tools.toolUsage"});
            }
            if (usageResult[1]) {
                System.exit(20);
            }
            System.exit(tool.main((String[])args, (ToolOptions)toolOptions)._exitCode);
        }
        catch (Throwable t) {
            System.err.println("<internal>: unrecoverable error launching tool; aborting");
            System.exit(10);
        }
    }

    public static tool main(String[] args, ToolOptions options) {
        if (options._frontEnd == null) {
            return null;
        }
        ErrorReporter ER = options._ER;
        try {
            tool driver;
            Object[] frontendConstructorParams = new Object[]{options._backEnd, options._userER, options._bufferReader, options._bufferWriter, args};
            tool tool2 = driver = (tool)tool.construct(options._frontEnd, String.valueOf(options._frontEnd.getName()).concat(" driver"), frontendConstructorParams, options._userER, frontendConstructorArgs);
            return tool2;
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                if (ER._verbose) {
                    ER.fatal("Comp.Tools.verboseOutOfMemory", new Object[]{"Stack Trace :".concat(String.valueOf(Utils.getStackTrace(t)))});
                } else {
                    ER.fatal("Comp.Tools.outOfMemory");
                }
            }
            if (t instanceof ExceptionInInitializerError || t instanceof StackOverflowError) {
                ER.internalError(t);
            }
            if (t instanceof NoClassDefFoundError) {
                if (ER._verbose) {
                    ER.fatal("Comp.Tools.verboseNoClassDefFound", new Object[]{t.toString(), "Stack Trace :".concat(String.valueOf(Utils.getStackTrace(t)))});
                } else {
                    ER.fatal("Comp.Tools.noClassDefFound", new Object[]{t.toString()});
                }
            }
            if (t instanceof Error) {
                if (ER._verbose) {
                    ER.fatal("Comp.Tools.verboseErrorCaught", new Object[]{t.toString(), "Stack Trace :".concat(String.valueOf(Utils.getStackTrace(t)))});
                } else {
                    ER.fatal("Comp.Tools.errorCaught", new Object[]{t.toString()});
                }
            }
            ER.internalError(t);
            tool tool3 = null;
            return tool3;
        }
    }

    public String readFrom(String fileName, BufferReader reader) {
        File file = reader.getFile(fileName);
        String printName = String.valueOf(new StringBuffer("\"").append(StringFunctions.prepFilename(fileName)).append("\""));
        if (!file.exists()) {
            this._ER.error("Comp.File.doesntExist", printName);
            return null;
        }
        if (!file.canRead()) {
            this._ER.error("Comp.File.cantRead", printName);
            return null;
        }
        if (file.isDirectory()) {
            this._ER.error("Comp.File.isDirectory", printName);
            return null;
        }
        try {
            int len;
            InputStream istream = reader.getInputStream(file);
            StringBuffer str = new StringBuffer(65536);
            byte[] buf = new byte[65536];
            while ((len = istream.read(buf)) > 0) {
                String s = new String(buf, 0, len, "8859_1");
                str.append(s);
            }
            String string = str.toString();
            return string;
        }
        catch (IOException e) {
            this._ER.error("Comp.File.readingIOError", printName);
            String string = null;
            return string;
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

