/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.tools;

import com.inprise.vbroker.compiler.ast.NodeFactory;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;
import com.inprise.vbroker.compiler.backends.common.GenericBackend;
import com.inprise.vbroker.compiler.frontends.idl.IdlFeOptions;
import com.inprise.vbroker.compiler.frontends.idl.Parser;
import com.inprise.vbroker.compiler.preprocessor.IDLpp;
import com.inprise.vbroker.compiler.preprocessor.IDLppOptions;
import com.inprise.vbroker.compiler.tools.tool;
import com.inprise.vbroker.compiler.util.BufferReader;
import com.inprise.vbroker.compiler.util.BufferWriter;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.Options;
import com.inprise.vbroker.compiler.util.SerialBufferReader;
import com.inprise.vbroker.compiler.util.SerialBufferWriter;
import com.inprise.vbroker.compiler.util.Utils;
import java.util.Vector;

public class idl2XXX
extends tool {
    public idl2XXX(Class backendClass, ErrorReporter ER, BufferReader reader, BufferWriter writer, String[] args) {
        super(ER);
        if (reader == null) {
            reader = new SerialBufferReader(this._ER);
        }
        if (writer == null) {
            writer = new SerialBufferWriter(this._ER, reader);
        }
        if (backendClass == null) {
            this._ER.error("Comp.Tools.undefinedTargetBackend");
            this._exitCode = 10;
            return;
        }
        NodeFactory factory = this.getNodeFactory(backendClass);
        RepositoryNode repository = factory._repository;
        CommonOptions backendOptions = repository._options;
        IDLppOptions IDLppOptions2 = new IDLppOptions(this._ER);
        IdlFeOptions IdlFeOptions2 = new IdlFeOptions(this._ER);
        boolean[] result = new boolean[]{false, false};
        args = IDLppOptions2.parse(args, result);
        args = IdlFeOptions2.parse(args, result);
        args = backendOptions.parse(args, result);
        IDLppOptions2.checkForUnusedFlags(args, result);
        repository.updateOptionsDependencies();
        if (result[0]) {
            IDLppOptions2.printUsage(new Options[]{IdlFeOptions2, backendOptions}, new String[]{"Comp.Tools.oneOrMoreFiles"});
        }
        if (result[1]) {
            this._exitCode = 20;
            return;
        }
        boolean sawAtLeastOneFile = false;
        for (int i = 0; i < args.length; ++i) {
            Parser parser;
            String fileName = args[i];
            if (fileName == null) continue;
            fileName = Utils.canonicalize(fileName);
            sawAtLeastOneFile = true;
            Vector topLevelInclFiles = new Vector();
            if (!IdlFeOptions2._preprocess) {
                String source = this.readFrom(fileName, reader);
                if (source == null) {
                    this._exitCode = 40;
                    return;
                }
                parser = Parser.make(repository, fileName, source, IdlFeOptions2);
                parser.parse();
                this._frontEndResult = this._ER.getSummary();
            } else {
                IDLpp.Result ppResult = IDLpp.VisiBrokerPreprocess(IDLppOptions2, fileName, reader, topLevelInclFiles);
                if (IdlFeOptions2._preprocessOnly) {
                    this._ER.report();
                    System.out.print(ppResult._output);
                    this._exitCode = ppResult._status >= 0 ? 0 : 30;
                    return;
                }
                this._ER.setToolName(this._toolName);
                if (ppResult._status >= 0) {
                    parser = Parser.make(repository, fileName, ppResult._output, IdlFeOptions2);
                    parser.parse();
                    this._frontEndResult = this._ER.getSummary();
                    if (this._frontEndResult < 0) {
                        this._exitCode = 40;
                    }
                } else {
                    this._frontEndResult = ppResult._status;
                    this._exitCode = 30;
                }
            }
            this._ER.report();
            if (this._frontEndResult >= 0) {
                this._ER._currentLineNumber = 0L;
                this._backend = (GenericBackend)tool.construct(backendClass, backendClass.getName(), new Object[]{repository, writer, fileName, topLevelInclFiles}, this._ER);
                if (this._ER._numErrors > 0) {
                    this._exitCode = 50;
                }
            }
            if (this._exitCode != 0) {
                return;
            }
            repository.clear();
        }
        if (!sawAtLeastOneFile) {
            this._ER.error("Comp.Tools.noInputFiles");
            IDLppOptions2.printUsage(new Options[]{IdlFeOptions2, backendOptions}, new String[]{"Comp.Tools.oneOrMoreFiles"});
            this._exitCode = 20;
        }
    }
}

