/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.tools.cmdline;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public final class CLProcessor {
    private Vector Strings;
    private int Index;
    private String Version;
    private Dictionary NameTable = null;
    private Dictionary FlagTable = null;
    private Vector NameLog;
    private Vector ArgLog;
    public static final int BOOL = 1;
    public static final int STRING = 2;
    public static final int LIST = 3;
    public static final int PAIR = 4;
    public static final int DICT = 5;
    public static final int BUILTIN = 6;

    public CLProcessor(String version, ResourceBundle[] specifications) {
        this.Version = version;
        this.NameLog = new Vector();
        this.ArgLog = new Vector();
        this.NameTable = new Hashtable();
        this.FlagTable = new Hashtable();
        this.initialize(specifications);
    }

    public boolean add(String[] commandLineArgs) {
        return this.read(commandLineArgs, true);
    }

    public boolean add(String[] defaults, String[] commandLineArgs) {
        boolean b1 = this.read(defaults, false);
        boolean b2 = this.read(commandLineArgs, true);
        return b1 || b2;
    }

    private void addObjectToVector(String name, Object obj) {
        Name n = (Name)this.NameTable.get(name);
        Vector<Object> v = (Vector<Object>)n.Value;
        if (v == null) {
            n.Value = v = new Vector<Object>();
        }
        v.addElement(obj);
    }

    public static boolean allHyphens(String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    public static Vector arrayToVector(Object[] array) {
        Vector<Object> ret = new Vector<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            ret.addElement(array[i]);
        }
        return ret;
    }

    private void clearGeneratedValues() {
        this.NameTable.put("REMAINING", new Name(3, null));
        this.NameTable.put("UNRECOGNIZED", new Name(3, null));
        this.NameTable.put("INVALID", new Name(3, null));
        this.NameTable.put("ERRORS", new Name(1, Boolean.FALSE));
    }

    public boolean errors() {
        try {
            boolean bl = this.getBool("ERRORS");
            return bl;
        }
        catch (MissingNameException e) {
            boolean bl = false;
            return bl;
        }
        catch (InvalidTypeException e) {
            boolean bl = false;
            return bl;
        }
    }

    private void fatal(String mesg) {
        System.err.println(mesg);
        System.exit(1);
    }

    public Vector getArgLog() {
        return this.ArgLog;
    }

    public boolean getBool(String name) throws InvalidTypeException, MissingNameException {
        Name n = (Name)this.NameTable.get(name);
        if (n == null) {
            throw new MissingNameException(name);
        }
        if (n.Type != 1) {
            throw new InvalidTypeException(name, 1, n.Type);
        }
        return (Boolean)n.Value;
    }

    public Dictionary getDict(String name) throws InvalidTypeException, MissingNameException {
        Name n = (Name)this.NameTable.get(name);
        if (n == null) {
            throw new MissingNameException(name);
        }
        if (n.Type != 5) {
            throw new InvalidTypeException(name, 5, n.Type);
        }
        return (Dictionary)n.Value;
    }

    public Vector getList(String name) throws InvalidTypeException, MissingNameException {
        Name n = (Name)this.NameTable.get(name);
        if (n == null) {
            throw new MissingNameException(name);
        }
        if (n.Type != 3) {
            throw new InvalidTypeException(name, 3, n.Type);
        }
        return (Vector)n.Value;
    }

    public Vector getNameLog() {
        return this.NameLog;
    }

    public String[] getPair(String name) throws InvalidTypeException, MissingNameException {
        Name n = (Name)this.NameTable.get(name);
        if (n == null) {
            throw new MissingNameException(name);
        }
        if (n.Type != 4) {
            throw new InvalidTypeException(name, 4, n.Type);
        }
        return (String[])n.Value;
    }

    public String getString(String name) throws InvalidTypeException, MissingNameException {
        Name n = (Name)this.NameTable.get(name);
        if (n == null) {
            throw new MissingNameException(name);
        }
        if (n.Type != 2) {
            throw new InvalidTypeException(name, 2, n.Type);
        }
        return (String)n.Value;
    }

    public int getType(String name) throws MissingNameException {
        Name n = (Name)this.NameTable.get(name);
        if (n == null) {
            throw new MissingNameException(name);
        }
        return n.Type;
    }

    public void initialize(ResourceBundle[] specifications) {
        this.reset();
        this.installBuiltins();
        for (int i = 0; i < specifications.length; ++i) {
            Enumeration<String> keys = specifications[i].getKeys();
            while (keys.hasMoreElements()) {
                String value;
                String name = keys.nextElement();
                if (this.parseAndRecord(name, value = specifications[i].getString(name)) != null) continue;
                System.err.println(String.valueOf(new StringBuffer("Command-line property for key ").append(name).append(" had errors.")));
            }
        }
    }

    private void insertAfterString(String toAdd, int index) {
        int spIndex = -1;
        while ((spIndex = toAdd.indexOf(32)) != -1) {
            this.Strings.insertElementAt(toAdd.substring(0, spIndex), index++);
            toAdd = toAdd.substring(spIndex + 1, toAdd.length());
        }
    }

    private void installBuiltins() {
        this.NameTable.put("VERSION", new Name(6, null));
        this.NameTable.put("USAGE", new Name(6, null));
    }

    public Vector invalidArgs() {
        try {
            Vector vector = this.getList("INVALID");
            return vector;
        }
        catch (MissingNameException e) {
            Vector vector = null;
            return vector;
        }
        catch (InvalidTypeException e) {
            Vector vector = null;
            return vector;
        }
    }

    private Object parseAndRecord(String name, String spec) {
        Object alias;
        Object flag;
        int nextIndex;
        Vector<String> v = new Vector<String>();
        int lastIndex = 0;
        while ((nextIndex = spec.indexOf(44, lastIndex)) != -1) {
            v.addElement(spec.substring(0, nextIndex).trim());
            spec = spec.substring(nextIndex + 1, spec.length());
        }
        if (spec.length() > 0) {
            v.addElement(spec.trim());
        }
        Object[] pieces = new String[v.size()];
        v.copyInto(pieces);
        if (pieces.length == 0) {
            return null;
        }
        int type = this.typeNameToType((String)pieces[0]);
        if (type == -1) {
            return null;
        }
        if (type == 1) {
            Object off;
            Object on;
            Object usage;
            Object object = usage = pieces.length > 1 ? pieces[1] : null;
            if (usage == null || ((String)usage).length() == 0) {
                usage = "enable [disable] ".concat(String.valueOf(name));
            }
            Object object2 = on = pieces.length > 2 ? pieces[2] : null;
            if (on == null || ((String)on).length() == 0) {
                on = "-".concat(String.valueOf(name));
            }
            Object object3 = off = pieces.length > 3 ? pieces[3] : null;
            if (off == null || ((String)off).length() == 0) {
                off = "-no".concat(String.valueOf(name));
            }
            Object after = pieces.length > 4 ? pieces[4] : null;
            Object alias2 = pieces.length > 5 ? pieces[5] : null;
            Arg arg = new Arg(name, (String)usage, (String)on, (String)off, (String)after, (String)alias2);
            this.FlagTable.put(on, arg);
            this.FlagTable.put(off, arg);
            String realName = this.realName(arg);
            this.verifyNotBuiltin(realName);
            this.NameTable.put(realName, new Name(type, Boolean.FALSE));
            return arg;
        }
        if (type == 2 || type == 3) {
            Object flag2;
            Object space;
            if (pieces.length == 1) {
                this.fatal("Missing `space' specifier");
            }
            if (!((String)(space = pieces[1])).equals("true") && !((String)space).equals("false")) {
                this.fatal("Malformed `space' specifier (true or false expected)");
            }
            Object usage = pieces.length > 2 ? pieces[2] : (type == 2 ? String.valueOf(new StringBuffer("set ").append(name).append(" to <arg>")) : String.valueOf(new StringBuffer("add <arg> to the ").append(name).append(" list")));
            Object object = flag2 = pieces.length > 3 ? pieces[3] : null;
            if (flag2 == null || ((String)flag2).length() == 0) {
                flag2 = "-".concat(String.valueOf(name));
            }
            Object after = pieces.length > 4 ? pieces[4] : null;
            Object alias3 = pieces.length > 5 ? pieces[5] : null;
            Arg arg = new Arg(name, type, ((String)space).equals("true"), (String)usage, (String)flag2, (String)after, (String)alias3);
            this.FlagTable.put(flag2, arg);
            String realName = this.realName(arg);
            this.verifyNotBuiltin(realName);
            this.NameTable.put(realName, new Name(type, null));
            return arg;
        }
        if (type == 4 || type == 5) {
            Object flag3;
            Object usage;
            Object object = usage = pieces.length > 1 ? pieces[1] : null;
            if (usage == null || ((String)usage).length() == 0) {
                usage = type == 4 ? String.valueOf(new StringBuffer("set ").append(name).append(" <name> to <value>")) : "add name=value to ".concat(String.valueOf(name));
            }
            Object object4 = flag3 = pieces.length > 2 ? pieces[2] : null;
            if (flag3 == null || ((String)flag3).length() == 0) {
                flag3 = "-".concat(String.valueOf(name));
            }
            Object after = pieces.length > 3 ? pieces[3] : null;
            Object alias4 = pieces.length > 4 ? pieces[4] : null;
            Arg arg = new Arg(name, type, (String)usage, (String)flag3, (String)after, (String)alias4);
            this.FlagTable.put(flag3, arg);
            String realName = this.realName(arg);
            this.verifyNotBuiltin(realName);
            this.NameTable.put(realName, new Name(type, null));
            return arg;
        }
        Object usage = pieces.length > 1 ? pieces[1] : null;
        Object object = flag = pieces.length > 2 ? pieces[2] : null;
        if (flag == null || ((String)flag).length() == 0) {
            flag = "-".concat(String.valueOf(name));
        }
        Object after = pieces.length > 3 ? pieces[3] : null;
        Object object5 = alias = pieces.length > 4 ? pieces[4] : null;
        if (alias == null || !((String)alias).equals("USAGE") && !((String)alias).equals("VERSION")) {
            this.fatal("BUILTIN types must reference one of the operators: USAGE, VERSION");
        }
        if (usage == null || ((String)usage).length() == 0) {
            usage = ((String)alias).equals("USAGE") ? "print this list" : "print software version";
        }
        Arg arg = new Arg(name, type, (String)usage, (String)flag, (String)after, (String)alias);
        this.FlagTable.put(flag, arg);
        return arg;
    }

    private boolean processBOOL(Arg arg, boolean allowAfterString) {
        ((Name)this.NameTable.get((Object)this.realName((Arg)arg))).Value = this.Strings.elementAt(this.Index).equals(arg.Flag1) ? Boolean.TRUE : Boolean.FALSE;
        this.ArgLog.addElement(null);
        if (allowAfterString && arg.AfterString != null) {
            this.insertAfterString(arg.AfterString, this.Index + 1);
        }
        return true;
    }

    private void processBUILTIN(Arg arg) {
        Name name = (Name)this.NameTable.get(arg.AliasFor);
        if (name.Type != 6) {
            this.fatal(String.valueOf(new StringBuffer("Flag specified BUILTIN, but name had type ").append(name.Type).append(".")));
        }
        if (arg.AliasFor.equals("VERSION")) {
            this.version();
        } else if (arg.AliasFor.equals("USAGE")) {
            System.out.println(this.usage());
        } else {
            this.fatal(String.valueOf(new StringBuffer("Unknown BUILTIN name ").append(arg.AliasFor).append(": cannot handle.")));
        }
        this.ArgLog.addElement(null);
    }

    private boolean processPAIR(Arg arg, boolean allowAfterString, boolean replacementSemantics) {
        if (this.Index + 2 >= this.Strings.size()) {
            Name name = (Name)this.NameTable.get("ERRORS");
            name.Value = Boolean.TRUE;
            this.addObjectToVector("INVALID", this.realName(arg));
            this.ArgLog.addElement(new String[2]);
            return false;
        }
        String value1 = (String)this.Strings.elementAt(this.Index + 1);
        String value2 = (String)this.Strings.elementAt(this.Index + 2);
        String[] duple = new String[]{value1, value2};
        String realName = this.realName(arg);
        Name name = (Name)this.NameTable.get(realName);
        if (replacementSemantics) {
            name.Value = duple;
        } else {
            Hashtable<String, String> d = (Hashtable<String, String>)name.Value;
            if (d == null) {
                name.Value = d = new Hashtable<String, String>(10);
            }
            ((Dictionary)d).put(value1, value2);
        }
        this.ArgLog.addElement(duple);
        this.Index += 2;
        if (allowAfterString && arg.AfterString != null) {
            this.insertAfterString(arg.AfterString, this.Index + 1);
        }
        return true;
    }

    private boolean processSTRING(Arg arg, boolean allowAfterString, boolean replacementSemantics) {
        if (!arg.NeedsSpace) {
            String current = (String)this.Strings.elementAt(this.Index);
            String value = current.substring(2, current.length());
            String realName = this.realName(arg);
            Name name = (Name)this.NameTable.get(realName);
            if (replacementSemantics) {
                name.Value = value;
            } else {
                this.addObjectToVector(realName, value);
            }
            this.ArgLog.addElement(new String[]{value});
            if (allowAfterString && arg.AfterString != null) {
                this.insertAfterString(arg.AfterString, this.Index + 1);
            }
            return true;
        }
        if (this.Index + 1 == this.Strings.size()) {
            Name name = (Name)this.NameTable.get("ERRORS");
            name.Value = Boolean.TRUE;
            this.addObjectToVector("INVALID", this.realName(arg));
            this.ArgLog.addElement(null);
            return false;
        }
        String value = (String)this.Strings.elementAt(this.Index + 1);
        String realName = this.realName(arg);
        Name name = (Name)this.NameTable.get(realName);
        if (replacementSemantics) {
            name.Value = value;
        } else {
            this.addObjectToVector(realName, value);
        }
        this.ArgLog.addElement(new String[]{value});
        ++this.Index;
        if (allowAfterString && arg.AfterString != null) {
            this.insertAfterString(arg.AfterString, this.Index + 1);
        }
        return true;
    }

    private boolean processUnrecognizedWord() {
        boolean ret = false;
        String s = (String)this.Strings.elementAt(this.Index);
        if (s == null || s.equals("")) {
            return ret;
        }
        char c = s.charAt(0);
        if (c == '-' && !CLProcessor.allHyphens(s) || c == '+') {
            this.addObjectToVector("UNRECOGNIZED", s);
        } else {
            this.addObjectToVector("REMAINING", s);
            ret = true;
        }
        ++this.Index;
        return ret;
    }

    private boolean read(String[] strings, boolean allowAfterStrings) {
        boolean ret = true;
        this.clearGeneratedValues();
        this.Strings = CLProcessor.arrayToVector(strings);
        this.Index = 0;
        while (this.Index < this.Strings.size()) {
            block11: {
                boolean tmp;
                Arg arg;
                block9: {
                    block10: {
                        String current = (String)this.Strings.elementAt(this.Index);
                        arg = (Arg)this.FlagTable.get(current);
                        if (arg != null) break block9;
                        if (current.length() <= 2) break block10;
                        arg = (Arg)this.FlagTable.get(current.substring(0, 2));
                        if (arg != null && !arg.NeedsSpace && (arg.Type == 2 || arg.Type == 3)) break block9;
                        tmp = this.processUnrecognizedWord();
                        ret = ret && tmp;
                        break block11;
                    }
                    tmp = this.processUnrecognizedWord();
                    ret = ret && tmp;
                    break block11;
                }
                this.NameLog.addElement(this.realName(arg));
                tmp = true;
                switch (arg.Type) {
                    case 1: {
                        tmp = this.processBOOL(arg, allowAfterStrings);
                        break;
                    }
                    case 2: {
                        tmp = this.processSTRING(arg, allowAfterStrings, true);
                        break;
                    }
                    case 3: {
                        tmp = this.processSTRING(arg, allowAfterStrings, false);
                        break;
                    }
                    case 4: {
                        tmp = this.processPAIR(arg, allowAfterStrings, true);
                        break;
                    }
                    case 5: {
                        tmp = this.processPAIR(arg, allowAfterStrings, false);
                        break;
                    }
                    case 6: {
                        this.processBUILTIN(arg);
                    }
                }
                ret = ret && tmp;
            }
            ++this.Index;
        }
        return ret;
    }

    String realName(Arg arg) {
        return arg.AliasFor != null ? arg.AliasFor : arg.Name;
    }

    public Vector remainingArgs() {
        try {
            Vector vector = this.getList("REMAINING");
            return vector;
        }
        catch (MissingNameException e) {
            Vector vector = null;
            return vector;
        }
        catch (InvalidTypeException e) {
            Vector vector = null;
            return vector;
        }
    }

    public boolean replace(String[] commandLineArgs) {
        this.reset();
        return this.read(commandLineArgs, true);
    }

    public boolean replace(String[] defaults, String[] commandLineArgs) {
        this.reset();
        boolean b1 = this.read(defaults, false);
        boolean b2 = this.read(commandLineArgs, true);
        return b1 || b2;
    }

    private void reset() {
        Enumeration elems = this.NameTable.elements();
        while (elems.hasMoreElements()) {
            Name name = (Name)elems.nextElement();
            name.Value = name.Type == 1 ? Boolean.FALSE : null;
        }
        this.NameLog.setSize(0);
        this.ArgLog.setSize(0);
    }

    public int typeNameToType(String typeName) {
        if (typeName.equals("BOOL")) {
            return 1;
        }
        if (typeName.equals("STRING")) {
            return 2;
        }
        if (typeName.equals("LIST")) {
            return 3;
        }
        if (typeName.equals("PAIR")) {
            return 4;
        }
        if (typeName.equals("DICT")) {
            return 5;
        }
        if (typeName.equals("BUILTIN")) {
            return 6;
        }
        return -1;
    }

    public Vector unrecognizedArgs() {
        try {
            Vector vector = this.getList("UNRECOGNIZED");
            return vector;
        }
        catch (MissingNameException e) {
            Vector vector = null;
            return vector;
        }
        catch (InvalidTypeException e) {
            Vector vector = null;
            return vector;
        }
    }

    public String usage() {
        int i;
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer("Usage:".concat(String.valueOf(lineSeparator)));
        Arg[] args = new Arg[this.FlagTable.size()];
        int len = 0;
        Enumeration keys = this.FlagTable.keys();
        while (keys.hasMoreElements()) {
            String flag = (String)keys.nextElement();
            Arg arg = (Arg)this.FlagTable.get(flag);
            if (arg.Flag2 != null && arg.Flag2 == flag) continue;
            args[len++] = arg;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            for (int j = i2 + 1; j < len; ++j) {
                if (args[i2].Flag1.compareTo(args[j].Flag1) <= 0) continue;
                Arg tmp = args[i2];
                args[i2] = args[j];
                args[j] = tmp;
            }
        }
        int max = -1;
        for (i = 0; i < len; ++i) {
            int argLength = args[i].Flag1.length();
            if (args[i].Flag2 != null) {
                argLength += args[i].Flag2.length() + 3;
            }
            if (argLength <= max) continue;
            max = argLength;
        }
        for (i = 0; i < len; ++i) {
            int argLength = args[i].Flag1.length();
            buf.append(" ");
            buf.append(args[i].Flag1);
            if (args[i].Flag2 != null) {
                buf.append(" [");
                buf.append(args[i].Flag2);
                buf.append("]");
                argLength += args[i].Flag2.length() + 3;
            }
            int spacesNeeded = max - argLength + 3;
            for (int j = 0; j < spacesNeeded; ++j) {
                buf.append(".");
            }
            buf.append(args[i].Usage);
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    private void verifyNotBuiltin(String name) {
        Name n = (Name)this.NameTable.get(name);
        if (n != null && n.Type == 6) {
            this.fatal(String.valueOf(new StringBuffer("Cannot redefine builtin name \"").append(name).append("\".")));
        }
    }

    private void version() {
        System.out.println(this.Version);
    }

    public static final class InvalidTypeException
    extends Exception {
        private final String Name;
        private final int ActualType;
        private final int RequestedType;

        public InvalidTypeException() {
            this.Name = null;
            this.ActualType = -1;
            this.RequestedType = -1;
        }

        public InvalidTypeException(String name, int actualType, int requestedType) {
            super(String.valueOf(new StringBuffer("\"").append(name).append("\" with type ").append(actualType).append(" was accessed as type ").append(requestedType).append(".")));
            this.Name = name;
            this.ActualType = actualType;
            this.RequestedType = requestedType;
        }
    }

    public static final class MissingNameException
    extends Exception {
        private final String Name;

        public MissingNameException() {
            this.Name = null;
        }

        public MissingNameException(String name) {
            super(String.valueOf(new StringBuffer("\"").append(name).append("\" not found in command line repository")));
            this.Name = name;
        }
    }

    private static final class Arg {
        final String Name;
        final int Type;
        final boolean NeedsSpace;
        final String Usage;
        final String Flag1;
        final String Flag2;
        final String AfterString;
        final String AliasFor;

        Arg(String name, String usage, String onFlag, String offFlag, String afterString, String aliasFor) {
            this.Name = name;
            this.Type = 1;
            this.NeedsSpace = false;
            this.Usage = usage != null && !usage.equals("") ? usage : null;
            this.Flag1 = onFlag != null && !onFlag.equals("") ? onFlag : null;
            this.Flag2 = offFlag != null && !offFlag.equals("") ? offFlag : null;
            this.AfterString = afterString != null && !afterString.equals("") ? afterString : null;
            this.AliasFor = aliasFor != null && !aliasFor.equals("") ? aliasFor : null;
        }

        Arg(String name, int type, boolean needsSpace, String usage, String flag, String afterString, String aliasFor) {
            this.Name = name;
            this.Type = type;
            this.NeedsSpace = needsSpace;
            this.Usage = usage != null && !usage.equals("") ? usage : null;
            this.Flag1 = flag != null && !flag.equals("") ? flag : null;
            this.Flag2 = null;
            this.AfterString = afterString != null && !afterString.equals("") ? afterString : null;
            this.AliasFor = aliasFor != null && !aliasFor.equals("") ? aliasFor : null;
        }

        Arg(String name, int type, String usage, String flag, String afterString, String aliasFor) {
            this.Name = name;
            this.Type = type;
            this.NeedsSpace = false;
            this.Usage = usage != null && !usage.equals("") ? usage : null;
            this.Flag1 = flag != null && !flag.equals("") ? flag : null;
            this.Flag2 = null;
            this.AfterString = afterString != null && !afterString.equals("") ? afterString : null;
            this.AliasFor = aliasFor != null && !aliasFor.equals("") ? aliasFor : null;
        }
    }

    private static final class Name {
        final int Type;
        Object Value;

        Name(int type, Object value) {
            this.Type = type;
            this.Value = value;
        }
    }
}

