/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.frontends.idl;

import com.inprise.vbroker.compiler.ast.ContainedContainerNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.frontends.idl.Parser;
import com.inprise.vbroker.compiler.util.PrintER;
import com.inprise.vbroker.compiler.util.QName;
import java.util.Hashtable;

final class Scope {
    ContainerNode _def;
    Scope _outerScope;
    private Hashtable _table = new Hashtable();
    private Parser _parser;
    private boolean _IownTheErrorSuppression = false;
    String _prefix;
    boolean _error;
    String _name;

    Scope(Parser parser, RepositoryNode repository) {
        this._parser = parser;
        this._def = repository;
        this._prefix = "";
        this._error = false;
        this._name = "";
    }

    Scope(Parser parser, Scope outerScope, ContainerNode container) {
        this._parser = parser;
        this.reset(outerScope, container);
    }

    public String defaultPrefix() {
        String ret = null;
        Scope sc = this;
        while (sc._outerScope != null) {
            ret = ret == null ? ((ContainedContainerNode)sc._def)._name : String.valueOf(new StringBuffer(String.valueOf(((ContainedContainerNode)sc._def)._name)).append('/').append(ret));
            sc = sc._outerScope;
        }
        return ret != null ? ret : "";
    }

    public Node define(int kind, String name, String repId, String version, String comment) {
        ContainedNode ret;
        String canonicalName = name.toLowerCase();
        if (canonicalName.equalsIgnoreCase(this._name)) {
            ContainedNode n = (ContainedNode)((Object)this._def);
            n._repository._ER.error("Comp.FE.IDL.rename", new Object[]{name, n._fullName});
        }
        if ((ret = (ContainedNode)this._table.get(canonicalName)) == null && kind == 6 && (ret = this._def.lookup(canonicalName, false)) != null && ret._name != null) {
            this._table.put(canonicalName, ret);
        }
        if (ret == null) {
            ret = (ContainedNode)this._def.define(kind, name, repId, version, comment);
            if (ret != null && ret._name != null) {
                this._table.put(canonicalName, ret);
            }
            return ret;
        }
        if (kind == 6 && ret._kind == 6) {
            ret._fileNumber = ret._repository._ER._currentFileNumber;
            ret._lineNumber = ret._repository._ER._currentLineNumber;
            return ret;
        }
        if (ret._name != null) {
            ret._repository._ER._previousFileNumber = ret._fileNumber;
            ret._repository._ER._previousLineNumber = ret._lineNumber;
            if (ret._container == this._def) {
                ret._repository._ER.error2("Comp.FE.IDL.alreadyExists", new Object[]{ret._name});
            } else {
                ret._repository._ER.error2("Comp.FE.IDL.alreadyUsed", new Object[]{ret._name});
            }
        }
        return (ContainedNode)Node.getErrorObject(kind);
    }

    public Node define(int kind, String name, String repId, String version, String comment, boolean forwardDecl, boolean abstrct) {
        ContainedNode ret;
        String canonicalName;
        if (!Node.isInheritable(kind)) {
            this._def.ER().internalError(String.valueOf(new StringBuffer(String.valueOf(Node.typeName(kind))).append(" (").append(kind).append(") is an invalid type for a forward-declarable define() call")));
        }
        if ((canonicalName = name.toLowerCase()).equalsIgnoreCase(this._name)) {
            ContainedNode n = (ContainedNode)((Object)this._def);
            n._repository._ER.error("Comp.FE.IDL.rename", new Object[]{name, n._fullName});
        }
        if ((ret = (ContainedNode)this._table.get(canonicalName)) == null) {
            ret = (ContainedNode)this._def.define(kind, name, repId, version, comment, forwardDecl);
            if (ret != null && ret._name != null) {
                this._table.put(canonicalName, ret);
                ((InheritableNode)ret)._abstract = abstrct;
            }
            return ret;
        }
        if (kind == ret._kind && ret._container == this._def) {
            ret = (ContainedNode)this._def.define(kind, name, repId, version, comment, forwardDecl);
            if (ret != null && ret._name != null) {
                this._table.put(canonicalName, ret);
                InheritableNode inh = (InheritableNode)ret;
                if (inh._abstract != abstrct) {
                    ret._repository._ER.warn(forwardDecl ? "Comp.FE.IDL.abstractMismatchDecl" : "Comp.FE.IDL.abstractMismatchDefn", new Object[]{inh.typeName(), inh._fullName});
                    ret._repository._ER.warnAdd("Comp.FE.IDL.abstractMismatchAdd");
                }
                inh._abstract = abstrct;
            }
            return ret;
        }
        if (ret._name != null) {
            ret._repository._ER._previousFileNumber = ret._fileNumber;
            ret._repository._ER._previousLineNumber = ret._lineNumber;
            if (ret._container == this._def) {
                ret._repository._ER.error2("Comp.FE.IDL.alreadyExists", new Object[]{ret._name});
            } else {
                ret._repository._ER.error2("Comp.FE.IDL.alreadyUsed", new Object[]{ret._name});
            }
        }
        return (ContainedNode)Node.getErrorObject(kind);
    }

    ContainerNode finish() {
        this._parser.Scopes.addElement(this);
        if (this._IownTheErrorSuppression) {
            ((PrintER)this._parser._repository._ER)._print = true;
        }
        return this._def;
    }

    void reset(Scope outerScope, ContainerNode container) {
        this._table.clear();
        this._def = container;
        this._name = ((ContainedNode)((Object)this._def))._name;
        this._outerScope = outerScope;
        this._prefix = outerScope._prefix.length() == 0 ? ((ContainedNode)((Object)container))._name : String.valueOf(new StringBuffer(String.valueOf(outerScope._prefix)).append('/').append(((ContainedNode)((Object)container))._name));
        boolean bl = this._error = ((ContainedNode)((Object)container))._name == null;
        if (this._error && ((PrintER)this._parser._repository._ER)._print) {
            this._IownTheErrorSuppression = true;
            ((PrintER)this._parser._repository._ER)._print = false;
        } else {
            this._IownTheErrorSuppression = false;
        }
    }

    ContainedNode use(QName qname) {
        ContainedNode node = this.use(qname._s);
        if (node == null) {
            return null;
        }
        if (!node.isContainer()) {
            return null;
        }
        return ((ContainerNode)((Object)node)).lookup(qname._next, true);
    }

    ContainedNode use(String simpleName) {
        if (this._error) {
            return null;
        }
        String canonicalName = simpleName.toLowerCase();
        ContainedNode ret = (ContainedNode)this._table.get(canonicalName);
        if (ret == null && (ret = this._def.lookup(canonicalName, false)) != null && ret._name != null) {
            this._table.put(canonicalName, ret);
        }
        if (ret != null && ret._name != null && !ret._name.equals(simpleName)) {
            ret.warnCaseViolation(simpleName);
        }
        return ret;
    }
}

