/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.frontends.idl;

import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FieldNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.frontends.idl.ASCII_CharStream;
import com.inprise.vbroker.compiler.frontends.idl.ErrorFormat;
import com.inprise.vbroker.compiler.frontends.idl.IdlFeOptions;
import com.inprise.vbroker.compiler.frontends.idl.ParseException;
import com.inprise.vbroker.compiler.frontends.idl.PragmaParserConstants;
import com.inprise.vbroker.compiler.frontends.idl.PragmaParserTokenManager;
import com.inprise.vbroker.compiler.frontends.idl.Scope;
import com.inprise.vbroker.compiler.frontends.idl.Token;
import com.inprise.vbroker.compiler.frontends.idl.TokenMgrError;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.PrintER;
import com.inprise.vbroker.compiler.util.QName;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class PragmaParser
implements PragmaParserConstants {
    private static final boolean _Debug = false;
    private static final boolean _Trace = false;
    ErrorReporter _ER;
    IdlFeOptions _options;
    RepositoryNode _repository;
    Scope _scope;
    String _input;
    private String _lastScopedName;
    private QName _lastScopedQName;
    private ContainedNode _hintNode;
    private String _hintFieldName;
    private Vector _hintNames = new Vector();
    private Vector _hintValues = new Vector();
    private int _reportingLevel;
    public PragmaParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private final int[] jj_la1_0 = new int[]{2040, 131072, 49152, 49152, 51200, 2048, 51200, 4096, 131072, 16384, 16384, 49152};
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public PragmaParser() {
        this(new StringReader(""));
    }

    public PragmaParser(PragmaParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PragmaParser(InputStream stream) {
        int i;
        this.jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        this.token_source = new PragmaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PragmaParser(Reader stream) {
        int i;
        this.jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        this.token_source = new PragmaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PragmaParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public final void directive() throws ParseException {
        this.jj_consume_token(1);
        this.jj_consume_token(2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.prefix();
                break;
            }
            case 4: {
                this.version();
                break;
            }
            case 5: {
                this.repId();
                break;
            }
            case 6: {
                this.originalNameForAttributeSet();
                break;
            }
            case 7: {
                this.originalNameForAttributeGet();
                break;
            }
            case 8: {
                this.originalName();
                break;
            }
            case 9: {
                this.pseudo();
                break;
            }
            case 10: {
                this.toolHints();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.unrecognizedPragma();
            }
        }
        this.jj_consume_token(0);
    }

    public final void disable_tracing() {
    }

    private void doPragmaOriginalName(ContainedNode node, String originalName, boolean setter) {
        if (this._options._backCompatMapping) {
            return;
        }
        if (node == InterfaceNode.ERROR) {
            node = this.getContainer();
        }
        if (node == null) {
            this.error("cantLocateNodeForRename");
            return;
        }
        switch (node._kind) {
            case 4: {
                ((ExceptionNode)node)._originalName = originalName;
                break;
            }
            case 7: {
                ((OperationNode)node)._originalName = originalName;
                break;
            }
            case 2: {
                if (setter) {
                    AttributeNode attr = (AttributeNode)node;
                    if (attr._readOnly) {
                        this.error("cantRenameSetterOnReadOnlyAttribute");
                        return;
                    }
                    attr._mutatorName = originalName;
                    break;
                }
                ((AttributeNode)node)._accessorName = originalName;
                break;
            }
            default: {
                this.error("invalidTypeForRename");
            }
        }
    }

    public final void enable_tracing() {
    }

    private void error(String mesg) {
        if (this._lastScopedQName != null) {
            this._ER.error("Comp.FE.IDL.".concat(String.valueOf(mesg)), this._lastScopedQName.fullName());
        } else {
            this._ER.error("Comp.FE.IDL.".concat(String.valueOf(mesg)), this._lastScopedName);
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[23];
        for (i = 0; i < 23; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 12; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 23; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, PragmaParserConstants.tokenImage);
    }

    private ContainedNode getContainer() {
        Node n = (Node)((Object)this._scope._def);
        if (n._kind == 17) {
            this._ER.error("Comp.FE.IDL.cantOnRepository");
            return null;
        }
        ContainedNode ret = (ContainedNode)n;
        this._lastScopedName = ret._fullName;
        return ret;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    public final void hint() throws ParseException {
        Token s = null;
        Token id = this.jj_consume_token(15);
        this.jj_consume_token(13);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                s = this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        this._hintNames.addElement(id.image);
        this._hintValues.addElement(s == null ? null : s.image);
    }

    public final void hintList() throws ParseException {
        this.hint();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            this.hint();
        }
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_3R_4() {
        if (this.jj_3R_6()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_5() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_6() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_4()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        Token xsp;
        block5: {
            if (this.jj_scan_token(15)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_5()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_5()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final void objectSpecifier() throws ParseException {
        Token id = null;
        this._hintNode = InterfaceNode.ERROR;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                id = this.jj_consume_token(15);
                this._hintFieldName = id.image;
                break;
            }
            case 14: 
            case 15: {
                this._hintNode = this.scopedName();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        id = this.jj_consume_token(15);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                this._hintFieldName = id == null ? null : id.image;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void originalName() throws ParseException {
        ContainedNode node = InterfaceNode.ERROR;
        this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: {
                node = this.scopedName();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        Token id = this.jj_consume_token(17);
        this.doPragmaOriginalName(node, id.image, false);
    }

    public final void originalNameForAttributeGet() throws ParseException {
        this.jj_consume_token(7);
        ContainedNode node = this.scopedName();
        Token id = this.jj_consume_token(17);
        this.doPragmaOriginalName(node, id.image, false);
    }

    public final void originalNameForAttributeSet() throws ParseException {
        this.jj_consume_token(6);
        ContainedNode node = this.scopedName();
        Token id = this.jj_consume_token(17);
        this.doPragmaOriginalName(node, id.image, true);
    }

    void parse(RepositoryNode repository, ErrorReporter er, String input, Scope scope, IdlFeOptions options) {
        this._repository = repository;
        this._ER = er;
        this._options = options;
        this._scope = scope;
        this._input = input;
        this.token_source._ER = er;
        this.ReInit(new StringReader(input));
        this._reportingLevel = 2;
        try {
            this.directive();
        }
        catch (ParseException e) {
            this.reportError("PragmaParserSyntaxError", ErrorFormat.formatExpectedLookaheadList(e.expectedTokenSequences, e.tokenImage, this._ER, true), e.currentToken.next.beginColumn);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage(), null, this.token.beginColumn);
        }
        catch (TokenMgrError e) {
            this.reportError("PragmaParserLexicalError", null, ErrorFormat.getColumnFromLexerException(e.getMessage()));
        }
    }

    public final void prefix() throws ParseException {
        Token t = null;
        this.jj_consume_token(3);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                t = this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this._scope._prefix = t == null ? this._scope.defaultPrefix() : t.image;
    }

    public final void pseudo() throws ParseException {
        ContainedNode node = InterfaceNode.ERROR;
        this.jj_consume_token(9);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: {
                node = this.scopedName();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        if (node == InterfaceNode.ERROR) {
            node = this.getContainer();
        }
        if (node == null) {
            this.error("cantLocateNodeForPseudo");
            return;
        }
        switch (node._kind) {
            case 5: 
            case 20: {
                InheritableNode n = node;
                if (n._bases != null && n._bases.size() > 0) {
                    Enumeration e = n._bases.elements();
                    while (e.hasMoreElements()) {
                        InheritableNode base = (InheritableNode)e.nextElement();
                        if (base._pseudo) continue;
                        this._ER.error("Comp.FE.IDL.pseudoHasRegularBase", new Object[]{n._fullName, base._fullName});
                    }
                }
                if (node._kind == 20 && ((ValueNode)node)._custom) {
                    this.error("pseudoIsCustom");
                }
                n._pseudo = true;
                break;
            }
            default: {
                this.error("invalidTypeForPseudo");
            }
        }
    }

    public final void repId() throws ParseException {
        this.jj_consume_token(5);
        ContainedNode node = this.scopedName();
        Token id = this.jj_consume_token(17);
        if (node == null) {
            this.error("cantLocateNodeForID");
        } else {
            String oldId = node._repId;
            node._repId = id.image;
            if (node._repId.startsWith("IDL:")) {
                if (node._repId.lastIndexOf(":") == 3) {
                    node._version = "1.0";
                    node._repId = node.recomputeRepIdForVersionChange(node._version);
                } else {
                    node._version = node._repId.substring(node._repId.lastIndexOf(":") + 1);
                }
            } else if (!this._options._backCompatMapping && node._repId.startsWith("RMI:")) {
                switch (node._kind) {
                    case 5: {
                        ((InterfaceNode)node)._style = (short)(((InterfaceNode)node).checkForEJBStyle() ? 2 : 1);
                    }
                    case 20: {
                        ((InheritableNode)node)._idlEntity = false;
                        break;
                    }
                    case 21: {
                        ((ValueBoxNode)node)._idlEntity = false;
                        break;
                    }
                    case 4: {
                        ((ExceptionNode)node)._idlEntity = false;
                        break;
                    }
                    default: {
                        this.error("invalidTypeForRMIRepId");
                    }
                }
            }
            node._repository.replaceId(oldId, node);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reportError(String mesg, String[] arg, long column) {
        boolean savedPrintingStatus;
        block7: {
            block8: {
                savedPrintingStatus = ((PrintER)this._ER)._print;
                try {
                    ((PrintER)this._ER)._print = true;
                    if (this._reportingLevel == 0) break block7;
                    if (this._reportingLevel == 1) {
                        if (!this._ER.warn("Comp.FE.IDL.".concat(String.valueOf(mesg)))) {
                            Object var7_5 = null;
                            ((PrintER)this._ER)._print = savedPrintingStatus;
                            return;
                        }
                        ErrorFormat.showColumn(this._ER, this._input, column);
                        if (arg != null) {
                            ErrorFormat.showExpected(this._ER, arg, null);
                        }
                        break block7;
                    }
                    if (!this._ER.error("Comp.FE.IDL.".concat(String.valueOf(mesg)))) {
                        break block8;
                    }
                    ErrorFormat.showColumn(this._ER, this._input, column);
                    if (arg != null) {
                        ErrorFormat.showExpected(this._ER, arg, null);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    ((PrintER)this._ER)._print = savedPrintingStatus;
                    throw throwable;
                }
            }
            Object var7_6 = null;
            ((PrintER)this._ER)._print = savedPrintingStatus;
            return;
        }
        Object var7_7 = null;
        ((PrintER)this._ER)._print = savedPrintingStatus;
    }

    public final ContainedNode scopedName() throws ParseException {
        this._lastScopedName = null;
        this._lastScopedQName = null;
        if (this.jj_2_2(2)) {
            Token id = this.jj_consume_token(15);
            QName qname = new QName(id.image);
            block10: while (true) {
                this.jj_consume_token(14);
                id = this.jj_consume_token(15);
                qname.append(id.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this._lastScopedQName = qname;
            return this._scope.use(qname);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token id = this.jj_consume_token(15);
                this._lastScopedName = id.image;
                return this._scope.use(id.image);
            }
            case 14: {
                this.jj_consume_token(14);
                Token id = this.jj_consume_token(15);
                QName qname = new QName(id.image);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 14: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(14);
                    id = this.jj_consume_token(15);
                    qname.append(id.image);
                }
                this._lastScopedQName = qname;
                return this._repository.lookup(qname, true);
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void toolHints() throws ParseException {
        block14: {
            block13: {
                this._hintNames.setSize(0);
                this._hintValues.setSize(0);
                this._hintNode = InterfaceNode.ERROR;
                this._hintFieldName = null;
                this.jj_consume_token(10);
                if (this.jj_2_1(2)) {
                    this.hintList();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 11: 
                        case 14: 
                        case 15: {
                            this.objectSpecifier();
                            this.hintList();
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (this._hintNode == InterfaceNode.ERROR) {
                    this._hintNode = this.getContainer();
                }
                if (this._hintNode == null) {
                    this.error("cantLocateNodeForHint");
                    return;
                }
                if (this._hintFieldName == null) break block13;
                switch (this._hintNode._kind) {
                    case 4: 
                    case 10: 
                    case 11: {
                        FieldNode fnode = (FieldNode)this._hintNode;
                        int len = this._hintNames.size();
                        for (int i = 0; i < len; ++i) {
                            fnode.annotateMember(this._hintFieldName, (String)this._hintNames.elementAt(i), (String)this._hintValues.elementAt(i));
                        }
                        break block14;
                    }
                    default: {
                        this.error("invalidTypeForFieldHint");
                        return;
                    }
                }
            }
            int len = this._hintNames.size();
            if (len > 0 && this._hintNode._annotations == null) {
                this._hintNode._annotations = new Hashtable(len);
            }
            for (int i = 0; i < len; ++i) {
                this._hintNode._annotations.put((String)this._hintNames.elementAt(i), (String)this._hintValues.elementAt(i));
            }
        }
    }

    void unrecognizedPragma() throws ParseException {
        this._reportingLevel = this._options._warnUnrecognizedPragmas ? 1 : 0;
    }

    public final void version() throws ParseException {
        this.jj_consume_token(4);
        ContainedNode node = this.scopedName();
        Token version = this.jj_consume_token(16);
        if (node == null) {
            this.error("cantLocateNodeForVersion");
            return;
        }
        String oldId = node._repId;
        node._version = version.image;
        node._repId = node.recomputeRepIdForVersionChange(node._version);
        node._repository.replaceId(oldId, node);
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

