/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.frontends.idl;

import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.EnumNameNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.FixedValue;
import com.inprise.vbroker.compiler.util.IntValue;
import java.math.BigDecimal;

final class Literal {
    int _type;
    Object _value;
    ErrorReporter _ER;

    Literal(int type, Object value, ErrorReporter ER) {
        this._type = type;
        this._value = value;
        this._ER = ER;
    }

    Literal(ConstantNode def) {
        this._ER = def.ER();
        if (def._type == InterfaceNode.ERROR) {
            this._type = 14;
            this._value = "";
            return;
        }
        switch (def._type.kind()) {
            case 14: {
                this._type = 14;
                break;
            }
            case 18: {
                this._type = 20;
                break;
            }
            case 12: {
                this._type = 30001;
                break;
            }
            case 19: {
                this._type = 30000;
                break;
            }
            case 13: {
                this._type = ((PrimitiveNode)def._type)._pkind;
                break;
            }
            default: {
                this._ER.internalError("Literal(ConstantNode): attempt to construct from unexpected ConstantNode type ".concat(String.valueOf(((Node)((Object)def._type)).typeName())));
            }
        }
        switch (this._type) {
            case 2: 
            case 3: 
            case 16: {
                this._value = new IntValue((Long)def._value, false);
                break;
            }
            case 4: 
            case 5: 
            case 17: {
                this._value = new IntValue((Long)def._value, true);
                break;
            }
            default: {
                this._value = def._value;
            }
        }
    }

    Literal(EnumNameNode enumName) {
        this._type = 30001;
        this._value = enumName;
        this._ER = enumName.ER();
    }

    void add(Literal rhs) {
        if (!Literal.anumber(this) || !Literal.anumber(rhs)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            if (Literal.integralType(rhs._type)) {
                try {
                    ((IntValue)this._value).add((IntValue)rhs._value);
                }
                catch (ArithmeticException e) {
                    this._ER.error("Comp.FE.IDL.overflow", "+");
                }
            } else {
                this._ER.error("Comp.FE.IDL.integralOperandMismatch", "+");
            }
        } else if (Literal.floatType(this._type)) {
            if (Literal.floatType(rhs._type)) {
                this._value = new Double((Double)this._value + (Double)rhs._value);
            } else {
                this._ER.error("Comp.FE.IDL.floatOperandMismatch", "+");
            }
        } else if (rhs._type == 30000) {
            ((FixedValue)this._value).add((FixedValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.fixedOperandMismatch", "+");
        }
    }

    private static boolean anumber(Literal literal) {
        if (Literal.numericType(literal._type)) {
            return true;
        }
        literal._ER.error("Comp.FE.IDL.expectedNumericLiteralButGot", PrimitiveNode.typeName(literal._type));
        return false;
    }

    void append(String string) {
        this._value = String.valueOf((String)this._value).concat(String.valueOf(string));
    }

    void bitNot() {
        if (Literal.integralType(this)) {
            ((IntValue)this._value).bitNot();
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperand", "!");
        }
    }

    void bitand(Literal rhs) {
        if (Literal.integralType(this) || !Literal.integralType(rhs)) {
            ((IntValue)this._value).bitand((IntValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "&");
        }
    }

    void bitor(Literal rhs) {
        if (Literal.integralType(this) || !Literal.integralType(rhs)) {
            ((IntValue)this._value).bitor((IntValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "|");
        }
    }

    void bitxor(Literal rhs) {
        if (Literal.integralType(this) || !Literal.integralType(rhs)) {
            ((IntValue)this._value).bitxor((IntValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "^");
        }
    }

    void div(Literal rhs) {
        if (!Literal.anumber(this) || !Literal.anumber(rhs)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            if (Literal.integralType(rhs._type)) {
                try {
                    ((IntValue)this._value).div((IntValue)rhs._value);
                }
                catch (ArithmeticException e) {
                    this._ER.error("Comp.FE.IDL.divideByZero");
                }
            } else {
                this._ER.error("Comp.FE.IDL.integralOperandMismatch", "/");
            }
        } else if (Literal.floatType(this._type)) {
            if (Literal.floatType(rhs._type)) {
                this._value = new Double((Double)this._value / (Double)rhs._value);
            } else {
                this._ER.error("Comp.FE.IDL.floatOperandMismatch", "/");
            }
        } else if (rhs._type == 30000) {
            ((FixedValue)this._value).div((FixedValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.fixedOperandMismatch", "/");
        }
    }

    int ensurePositiveInteger() {
        if (!Literal.integralType(this._type)) {
            this._ER.error("Comp.FE.IDL.expectedIntegralTypeButGot", PrimitiveNode.typeName(this._type));
            return 1;
        }
        long value = ((IntValue)this._value)._val;
        if (value <= (long)0) {
            this._ER.error("Comp.FE.IDL.expectedPositiveIntegerButGotValue", new Object[]{new Long(value)});
            return 1;
        }
        if ((long)((int)value) != value) {
            this._ER.error("Comp.FE.IDL.positiveIntegerOutOfRange", new Object[]{new Long(value)});
            return 1;
        }
        return (int)value;
    }

    private void enumMismatch(String name, String enumName, String elemName) {
        if (name == null) {
            this._ER.error("Comp.FE.IDL.unnamedConstantEnumNameMismatch", new Object[]{enumName, elemName});
        } else {
            this._ER.error("Comp.FE.IDL.constantEnumNameMismatch", new Object[]{name, enumName, elemName});
        }
    }

    Object finalValue(Type type, String name) {
        switch (type.kind()) {
            case 13: {
                int pkind = ((PrimitiveNode)type)._pkind;
                switch (pkind) {
                    case 10: {
                        if (this._type == 10) {
                            return new Byte((byte)((IntValue)this._value)._val);
                        }
                        if (this._value instanceof IntValue) {
                            long l = ((IntValue)this._value)._val;
                            if (l < (long)0 || l > (long)255) {
                                this.outOfRange(name, type, new Long(l));
                            }
                            return new Byte((byte)l);
                        }
                        this._value = new Byte(0);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 16: 
                    case 17: {
                        if (this._value instanceof Byte) {
                            return new Long(((IntValue)this._value)._val);
                        }
                        if (this._value instanceof IntValue) {
                            long l = ((IntValue)this._value)._val;
                            boolean unsigned = ((IntValue)this._value)._unsigned;
                            switch (pkind) {
                                case 2: {
                                    if (l > (long)Short.MAX_VALUE && !unsigned) {
                                        ((IntValue)this._value)._val = l = -((l - 1L) / 2L);
                                    }
                                    if ((long)((short)l) == l) break;
                                    this.outOfRange(name, type, new Long(l));
                                    break;
                                }
                                case 3: {
                                    if (l > (long)Integer.MAX_VALUE && !unsigned) {
                                        ((IntValue)this._value)._val = l = -((l - 1L) / 2L);
                                    }
                                    if ((long)((int)l) == l) break;
                                    this.outOfRange(name, type, new Long(l));
                                    break;
                                }
                                case 16: {
                                    break;
                                }
                                case 4: {
                                    if (l >= (long)0 && l <= 65535L) break;
                                    this.outOfRange(name, type, new Long(l));
                                    break;
                                }
                                case 5: {
                                    if (l >= (long)0 && l <= 0xFFFFFFFFL) break;
                                    this.outOfRange(name, type, new Long(l));
                                    break;
                                }
                                case 17: {
                                    break;
                                }
                            }
                            return new Long(l);
                        }
                        this._value = new Long(0L);
                        break;
                    }
                    case 14: 
                    case 20: {
                        if (this._value instanceof String) {
                            return this._value;
                        }
                        this._value = "";
                        break;
                    }
                    case 9: 
                    case 19: {
                        if (this._value instanceof Character) {
                            return this._value;
                        }
                        this._value = new Character('\u0000');
                        break;
                    }
                    case 8: {
                        if (this._value instanceof Boolean) {
                            return this._value;
                        }
                        this._value = Boolean.FALSE;
                        break;
                    }
                    case 6: {
                        if (this._value instanceof Float) {
                            return this._value;
                        }
                        if (this._value instanceof Double) {
                            double d = (Double)this._value;
                            if (d < (double)-3.4028235E38f || d > (double)Float.MAX_VALUE) {
                                this._ER.error("Comp.FE.IDL.floatOutOfRange", "".concat(String.valueOf(d)));
                            }
                            return this._value;
                        }
                        this._value = new Float(0.0);
                        break;
                    }
                    case 7: {
                        if (this._value instanceof Double) {
                            return this._value;
                        }
                        this._value = new Double(0.0);
                        break;
                    }
                    case 18: {
                        if (this._value instanceof Double) {
                            return this._value;
                        }
                        this._value = new Double(0.0);
                        break;
                    }
                    default: {
                        this._ER.internalError("Literal.finalValue(Type,String): invalid primitive type ".concat(String.valueOf(((PrimitiveNode)type).typeName())));
                    }
                }
                this.typeMismatch(name, type);
                return this._value;
            }
            case 12: {
                if (this._value instanceof EnumNameNode) {
                    EnumNameNode enumName = (EnumNameNode)this._value;
                    EnumNode enumNode = (EnumNode)type;
                    if (enumName._definingEnum != enumNode) {
                        this.enumMismatch(name, enumNode._fullName, enumName._name);
                        this._value = (String)enumNode._memberNames.elementAt(0);
                        return this._value;
                    }
                    return this._value;
                }
                this._value = (String)((EnumNode)type)._memberNames.elementAt(0);
                break;
            }
            case 14: 
            case 18: {
                if (this._value instanceof String) {
                    int bound;
                    String value = (String)this._value;
                    int n = bound = type.kind() == 14 ? ((StringNode)type)._bound : ((WStringNode)type)._bound;
                    if (value.length() > bound) {
                        this.stringOverrun(name, new Long(bound), value);
                        this._value = "";
                        return "";
                    }
                    return this._value;
                }
                this._value = "";
                break;
            }
            case 19: {
                if (this._value instanceof BigDecimal) {
                    return this._value;
                }
                this._value = new FixedValue(0, 0, 0);
                break;
            }
            case 5: {
                if (type == InterfaceNode.ERROR) {
                    return null;
                }
            }
            default: {
                this._ER.internalError("Literal.finalValue(Type,String): invalid type ".concat(String.valueOf(((Node)((Object)type)).typeName())));
            }
        }
        this.typeMismatch(name, type);
        return this._value;
    }

    public static boolean floatType(int type) {
        switch (type) {
            case 6: 
            case 7: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public static boolean integralType(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public static boolean integralType(Literal literal) {
        return Literal.integralType(literal._type);
    }

    void lshift(Literal rhs) {
        if (Literal.integralType(this._type) && Literal.integralType(rhs._type)) {
            long numBits = ((IntValue)rhs._value)._val;
            if (numBits < (long)0 || numBits >= (long)64) {
                this._ER.error("Comp.FE.IDL.operandOutOfRange", new Object[]{"<<", new Long(numBits)});
                return;
            }
            ((IntValue)this._value).lshift((IntValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "<<");
        }
    }

    void mod(Literal rhs) {
        if (Literal.integralType(this) || !Literal.integralType(rhs)) {
            try {
                ((IntValue)this._value).mod((IntValue)rhs._value);
            }
            catch (ArithmeticException e) {
                this._ER.error("Comp.FE.IDL.divideByZero");
            }
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "%");
        }
    }

    void mul(Literal rhs) {
        if (!Literal.anumber(this) || !Literal.anumber(rhs)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            if (Literal.integralType(rhs._type)) {
                try {
                    ((IntValue)this._value).mul((IntValue)rhs._value);
                }
                catch (ArithmeticException e) {
                    this._ER.error("Comp.FE.IDL.overflow", "*");
                }
            } else {
                this._ER.error("Comp.FE.IDL.integralOperandMismatch", "*");
            }
        } else if (Literal.floatType(this._type)) {
            if (Literal.floatType(rhs._type)) {
                this._value = new Double((Double)this._value * (Double)rhs._value);
            } else {
                this._ER.error("Comp.FE.IDL.floatOperandMismatch", "*");
            }
        } else if (rhs._type == 30000) {
            ((FixedValue)this._value).mul((FixedValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.fixedOperandMismatch", "*");
        }
    }

    public static boolean numericType(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 30000: {
                return true;
            }
        }
        return false;
    }

    private void outOfRange(String name, Type type, Long value) {
        if (name == null) {
            this._ER.error("Comp.FE.IDL.unnamedConstantValueOutOfRange", new Object[]{((Node)((Object)type)).typeName(), value});
        } else {
            this._ER.error("Comp.FE.IDL.constantValueOutOfRange", new Object[]{name, ((Node)((Object)type)).typeName(), value});
        }
    }

    void rshift(Literal rhs) {
        if (Literal.integralType(this._type) && Literal.integralType(rhs._type)) {
            long numBits = ((IntValue)rhs._value)._val;
            if (numBits < (long)0 || numBits >= (long)64) {
                this._ER.error("Comp.FE.IDL.operandOutOfRange", new Object[]{">>", new Long(numBits)});
                return;
            }
            ((IntValue)this._value).rshift_pad_zero((IntValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", ">>");
        }
    }

    private void stringOverrun(String name, Long bound, String value) {
        if (name == null) {
            this._ER.error("Comp.FE.IDL.unnamedConstantStringExceedsBound", new Object[]{bound, value});
        } else {
            this._ER.error("Comp.FE.IDL.constantStringExceedsBound", new Object[]{name, bound, value});
        }
    }

    void sub(Literal rhs) {
        if (!Literal.anumber(this) || !Literal.anumber(rhs)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            if (Literal.integralType(rhs._type)) {
                try {
                    ((IntValue)this._value).sub((IntValue)rhs._value);
                }
                catch (ArithmeticException e) {
                    this._ER.error("Comp.FE.IDL.overflow", "-");
                }
            } else {
                this._ER.error("Comp.FE.IDL.integralOperandMismatch", "-");
            }
        } else if (Literal.floatType(this._type)) {
            if (Literal.floatType(rhs._type)) {
                this._value = new Double((Double)this._value - (Double)rhs._value);
            } else {
                this._ER.error("Comp.FE.IDL.floatOperandMismatch", "-");
            }
        } else if (rhs._type == 30000) {
            ((FixedValue)this._value).sub((FixedValue)rhs._value);
        } else {
            this._ER.error("Comp.FE.IDL.fixedOperandMismatch", "-");
        }
    }

    private void typeMismatch(String name, Type declaredType) {
        if (name == null) {
            this._ER.error("Comp.FE.IDL.unnnamedConstantTypeValueMismatch", new Object[]{((Node)((Object)declaredType)).typeName()});
        } else {
            this._ER.error("Comp.FE.IDL.constantTypeValueMismatch", new Object[]{name, ((Node)((Object)declaredType)).typeName()});
        }
    }

    void unaryMinus() {
        if (!Literal.anumber(this)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            ((IntValue)this._value).unaryMinus();
        } else if (Literal.floatType(this._type)) {
            this._value = new Double(-((Double)this._value).doubleValue());
        } else {
            ((FixedValue)this._value).unaryMinus();
        }
    }
}

