/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.pascal.ast;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FixedNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.NativeNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.TypeMapper;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;
import com.inprise.vbroker.compiler.backends.pascal.ast.PAliasNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PArrayNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PEnumNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PExceptionNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PInterfaceNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PModuleNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PRepositoryNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PStructNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PUnionNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PascalBeOptions;
import com.inprise.vbroker.compiler.backends.pascal.ast.PascalMapperDefs;
import com.inprise.vbroker.util.SimpleStringBuffer;
import java.util.Vector;

public final class PascalMapper
extends TypeMapper
implements PascalMapperDefs {
    protected static final transient boolean trace = false;
    private final SimpleStringBuffer _buf = new SimpleStringBuffer();
    private final Vector _v = new Vector(20);
    public PascalBeOptions _options;

    public PascalMapper(CommonOptions options) {
        super(options);
        this._options = (PascalBeOptions)((TypeMapper)this)._options;
        this._keywordAvoider.avoid(this._options.keywordMap);
    }

    public String avoidKeywords(String name) {
        return this._keywordAvoider.convertSimpleName(name);
    }

    protected final String context2string(int context) {
        switch (context) {
            case 2: {
                return "$HOLDER";
            }
            case 3: {
                return "$HOLDER";
            }
        }
        return "";
    }

    private int countSuffixes(String name) {
        int len = name.length();
        if (len < 4) {
            return 0;
        }
        switch (name.charAt(len - 1)) {
            case 'r': {
                if (name.charAt(len - 2) != 'e') {
                    return 0;
                }
                if (len >= 6 && name.lastIndexOf("Helper") == len - 6) {
                    return this.countSuffixes(name.substring(0, len - 6)) + 1;
                }
                return 0;
            }
            case 'b': {
                if (name.charAt(len - 2) != 'u') {
                    return 0;
                }
                if (len >= 4 && name.lastIndexOf("Stub") == len - 4) {
                    return this.countSuffixes(name.substring(0, len - 4)) + 1;
                }
                return 0;
            }
            case 'y': {
                if (name.charAt(len - 2) != 'r') {
                    return 0;
                }
                if (len >= 7 && name.lastIndexOf("Factory") == len - 7) {
                    return this.countSuffixes(name.substring(0, len - 7)) + 1;
                }
                return 0;
            }
            case 'c': {
                if (name.charAt(len - 2) != 's') {
                    return 0;
                }
                if (len >= 4 && name.lastIndexOf("Desc") == len - 4) {
                    return this.countSuffixes(name.substring(0, len - 4)) + 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public String fullName(ContainedNode node, String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        this._buf.reset();
        if (node.kind() == 6) {
            if (node._container.kind() == 6) {
                this._buf.append(String.valueOf(((PModuleNode)node._container)._beFullName).concat(String.valueOf('_')));
            }
        } else if (node._container.kind() != 17 && node._container.kind() != 6 && node.kind() != 6) {
            this._buf.append(String.valueOf(((ContainedNode)((Object)node._container))._beFullName).concat(String.valueOf('_')));
        }
        if (s != null) {
            this._buf.append(s);
        }
        return this._buf.toString();
    }

    protected static String genAdtStubName(String baseName) {
        if (baseName != null) {
            return "T".concat(String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)));
        }
        return null;
    }

    protected static String genClientModuleQualifiedName(String baseName) {
        return PascalMapper.genModuleQualifiedName(baseName, PascalBeOptions.clientExtension);
    }

    protected static String genClientModuleQualifiedName(String baseName, String name) {
        return PascalMapper.genModuleQualifiedName(baseName, name, PascalBeOptions.clientExtension);
    }

    protected static String genDescName(String baseName) {
        if (baseName != null) {
            return String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)).concat("Desc");
        }
        return null;
    }

    protected static String genExceptionName(String baseName) {
        if (baseName != null) {
            return "E".concat(String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)));
        }
        return null;
    }

    protected static String genFactoryName(String baseName) {
        if (baseName != null) {
            return String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)).concat("_Factory");
        }
        return null;
    }

    protected static String genFieldName(String baseName) {
        if (baseName != null) {
            return "F".concat(String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)));
        }
        return null;
    }

    protected static String genGetMethodName(String baseName) {
        if (baseName != null) {
            return "_get_".concat(String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)));
        }
        return null;
    }

    protected static String genHelperName(String baseName) {
        if (baseName != null) {
            return String.valueOf(new StringBuffer("T").append(PascalMapper.removeLeadingUnderbar(baseName)).append("Helper"));
        }
        return null;
    }

    protected static String genIfaceModuleQualifiedName(String baseName) {
        return PascalMapper.genModuleQualifiedName(baseName, PascalBeOptions.interfaceExtension);
    }

    protected static String genIfaceModuleQualifiedName(String baseName, String name) {
        return PascalMapper.genModuleQualifiedName(baseName, name, PascalBeOptions.interfaceExtension);
    }

    protected static String genImplModuleQualifiedName(String baseName) {
        return PascalMapper.genModuleQualifiedName(baseName, PascalBeOptions.implExtension);
    }

    protected static String genImplModuleQualifiedName(String baseName, String name) {
        return PascalMapper.genModuleQualifiedName(baseName, name, PascalBeOptions.implExtension);
    }

    protected static String genImplName(String baseName) {
        if (baseName != null) {
            return "T".concat(String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)));
        }
        return null;
    }

    private static String genModuleQualifiedName(String baseName, String extension) {
        int i;
        if (baseName != null && (i = baseName.lastIndexOf(46)) > 0) {
            return String.valueOf(new StringBuffer(String.valueOf(baseName.substring(0, i).replace('.', '_'))).append(extension).append(baseName.substring(i, baseName.length())));
        }
        return baseName;
    }

    private static String genModuleQualifiedName(String baseName, String name, String extension) {
        if (baseName != null) {
            return String.valueOf(new StringBuffer(String.valueOf(baseName)).append(extension).append(".").append(name));
        }
        return baseName;
    }

    public final String genReadWriteType(String baseType) {
        String readTypeRef = new String(baseType.toLowerCase());
        StringBuffer readType = null;
        if (baseType != null) {
            if (readTypeRef.equals("object")) {
                readType = new StringBuffer("Object");
            } else if (readTypeRef.equals("::corba::typecode")) {
                readType = new StringBuffer("TypeCode");
            } else if (readTypeRef.equals("::corba::principal")) {
                readType = new StringBuffer("Principal");
            } else {
                readType = new StringBuffer();
                int iFromCount = 0;
                boolean bFoundSpace = false;
                if (readTypeRef.startsWith("unsigned")) {
                    readType.append('U');
                    iFromCount = 8;
                } else if (readTypeRef.startsWith("u")) {
                    readType.append('U');
                    iFromCount = 1;
                    bFoundSpace = true;
                }
                while (iFromCount < readTypeRef.length()) {
                    if (readTypeRef.charAt(iFromCount) == ' ') {
                        bFoundSpace = true;
                    } else {
                        if (bFoundSpace) {
                            readType.append(Character.toUpperCase(readTypeRef.charAt(iFromCount)));
                        } else {
                            readType.append(Character.toLowerCase(readTypeRef.charAt(iFromCount)));
                        }
                        bFoundSpace = false;
                    }
                    ++iFromCount;
                }
                readType.setCharAt(0, Character.toUpperCase(readType.charAt(0)));
            }
        }
        if (readType == null) {
            return null;
        }
        return readType.toString();
    }

    protected static String genServerModuleQualifiedName(String baseName) {
        return PascalMapper.genModuleQualifiedName(baseName, PascalBeOptions.serverExtension);
    }

    protected static String genServerModuleQualifiedName(String baseName, String name) {
        return PascalMapper.genModuleQualifiedName(baseName, name, PascalBeOptions.serverExtension);
    }

    protected static String genSetMethodName(String baseName) {
        if (baseName != null) {
            return "_set_".concat(String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)));
        }
        return null;
    }

    protected static String genSkeletonMarshalName(String baseName) {
        if (baseName != null) {
            return "_".concat(String.valueOf(baseName));
        }
        return null;
    }

    protected static String genSkeletonName(String baseName) {
        if (baseName != null) {
            return String.valueOf(new StringBuffer("T").append(PascalMapper.removeLeadingUnderbar(baseName)).append("Skeleton"));
        }
        return null;
    }

    protected static String genStubName(String baseName) {
        if (baseName != null) {
            return String.valueOf(new StringBuffer("T").append(PascalMapper.removeLeadingUnderbar(baseName)).append("Stub"));
        }
        return null;
    }

    protected String genTkName(String baseName) {
        String temp = this.genReadWriteType(PascalMapper.removeLeadingUnderbar(baseName)).toLowerCase();
        if (temp.equalsIgnoreCase("object")) {
            temp = "objref";
        } else if (temp.charAt(0) == 'u') {
            temp = temp.substring(1);
        }
        return "tk_".concat(String.valueOf(temp));
    }

    protected static String genVarName(String baseName) {
        if (baseName != null) {
            return "_".concat(String.valueOf(PascalMapper.removeLeadingUnderbar(baseName)));
        }
        return null;
    }

    protected void initializeKeywordAvoider() {
        this._keywordAvoider.caseSensitive(false);
        this._keywordAvoider.avoid("and");
        this._keywordAvoider.avoid("array");
        this._keywordAvoider.avoid("as");
        this._keywordAvoider.avoid("asm");
        this._keywordAvoider.avoid("begin");
        this._keywordAvoider.avoid("case");
        this._keywordAvoider.avoid("class");
        this._keywordAvoider.avoid("const");
        this._keywordAvoider.avoid("constructor");
        this._keywordAvoider.avoid("destructor");
        this._keywordAvoider.avoid("dispinterface");
        this._keywordAvoider.avoid("div");
        this._keywordAvoider.avoid("do");
        this._keywordAvoider.avoid("downto");
        this._keywordAvoider.avoid("else");
        this._keywordAvoider.avoid("end");
        this._keywordAvoider.avoid("except");
        this._keywordAvoider.avoid("exports");
        this._keywordAvoider.avoid("file");
        this._keywordAvoider.avoid("finalization");
        this._keywordAvoider.avoid("finally");
        this._keywordAvoider.avoid("for");
        this._keywordAvoider.avoid("function");
        this._keywordAvoider.avoid("goto");
        this._keywordAvoider.avoid("if");
        this._keywordAvoider.avoid("inline");
        this._keywordAvoider.avoid("implementation");
        this._keywordAvoider.avoid("initialization");
        this._keywordAvoider.avoid("inherited");
        this._keywordAvoider.avoid("in");
        this._keywordAvoider.avoid("is");
        this._keywordAvoider.avoid("label");
        this._keywordAvoider.avoid("library");
        this._keywordAvoider.avoid("mod");
        this._keywordAvoider.avoid("nil");
        this._keywordAvoider.avoid("not");
        this._keywordAvoider.avoid("object");
        this._keywordAvoider.avoid("of");
        this._keywordAvoider.avoid("or");
        this._keywordAvoider.avoid("owner");
        this._keywordAvoider.avoid("packed");
        this._keywordAvoider.avoid("procedure");
        this._keywordAvoider.avoid("program");
        this._keywordAvoider.avoid("property");
        this._keywordAvoider.avoid("raise");
        this._keywordAvoider.avoid("record");
        this._keywordAvoider.avoid("repeat");
        this._keywordAvoider.avoid("resourcestring");
        this._keywordAvoider.avoid("self");
        this._keywordAvoider.avoid("set");
        this._keywordAvoider.avoid("shl");
        this._keywordAvoider.avoid("shr");
        this._keywordAvoider.avoid("string");
        this._keywordAvoider.avoid("then");
        this._keywordAvoider.avoid("threadvar");
        this._keywordAvoider.avoid("to");
        this._keywordAvoider.avoid("try");
        this._keywordAvoider.avoid("type");
        this._keywordAvoider.avoid("unit");
        this._keywordAvoider.avoid("until");
        this._keywordAvoider.avoid("uses");
        this._keywordAvoider.avoid("var");
        this._keywordAvoider.avoid("while");
        this._keywordAvoider.avoid("with");
        this._keywordAvoider.avoid("xor");
        this._keywordAvoider.avoid("Boolean");
        this._keywordAvoider.avoid("Char");
        this._keywordAvoider.avoid("WideChar");
        this._keywordAvoider.avoid("Shortint");
        this._keywordAvoider.avoid("Smallint");
        this._keywordAvoider.avoid("Integer");
        this._keywordAvoider.avoid("Byte");
        this._keywordAvoider.avoid("Word");
        this._keywordAvoider.avoid("Extended");
        this._keywordAvoider.avoid("Pointer");
        this._keywordAvoider.avoid("AnsiChar");
        this._keywordAvoider.avoid("Longint");
        this._keywordAvoider.avoid("Cardinal");
        this._keywordAvoider.avoid("Single");
        this._keywordAvoider.avoid("Double");
        this._keywordAvoider.avoid("Real");
        this._keywordAvoider.avoid("Real48");
        this._keywordAvoider.avoid("Comp");
        this._keywordAvoider.avoid("Currency");
        this._keywordAvoider.avoid("ShortString");
        this._keywordAvoider.avoid("OpenString");
        this._keywordAvoider.avoid("File");
        this._keywordAvoider.avoid("Text");
        this._keywordAvoider.avoid("Variant");
        this._keywordAvoider.avoid("Int64");
        this._keywordAvoider.avoid("PCurrency");
        this._keywordAvoider.avoid("AnsiString");
        this._keywordAvoider.avoid("PAnsiString");
        this._keywordAvoider.avoid("TextFile");
        this._keywordAvoider.avoid("PAnsiChar");
        this._keywordAvoider.avoid("PChar");
        this._keywordAvoider.avoid("ByteBool");
        this._keywordAvoider.avoid("WordBool");
        this._keywordAvoider.avoid("LongBool");
        this._keywordAvoider.avoid("WideString");
        this._keywordAvoider.avoid("TVarArrayBound");
        this._keywordAvoider.avoid("TVarArray");
        this._keywordAvoider.avoid("TVarData");
        this._keywordAvoider.avoid("PVarArray");
        this._keywordAvoider.avoid("PVarData");
        this._keywordAvoider.avoid("PShortString");
        this._keywordAvoider.avoid("PWideString");
        this._keywordAvoider.avoid("PWideChar");
        this._keywordAvoider.avoid("PString");
        this._keywordAvoider.avoid("PExtended");
        this._keywordAvoider.avoid("TDateTime");
        this._keywordAvoider.avoid("PVarRec");
        this._keywordAvoider.avoid("TObject");
        this._keywordAvoider.avoid("TClass");
        this._keywordAvoider.avoid("IUnknown");
        this._keywordAvoider.avoid("Create");
        this._keywordAvoider.avoid("Destroy");
        this._keywordAvoider.avoid("Print");
        this._keywordAvoider.avoid("Printer");
        this._keywordAvoider.avoid("Application");
        this._keywordAvoider.avoid("Screen");
    }

    protected void initializeNativeMap() {
        this._nativeMap.put("?initializeNativeMap()?", "?initializeNativeMap()?");
    }

    public String map(AliasNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = ((PAliasNode)node).pascalName;
                break;
            }
            case 10: {
                temp = ((PAliasNode)node).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                temp = this.map(node._type, context, null);
                break;
            }
            case 0: {
                temp = this.map(node._type, context, null);
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(AliasNode, int)")));
            }
        }
        return temp;
    }

    public String map(ArrayNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = ((PArrayNode)node).pascalName;
                break;
            }
            case 10: {
                temp = ((PArrayNode)node).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                temp = null;
                break;
            }
            case 0: {
                temp = this.map(node._type, context, null);
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(ArrayNode, int)")));
            }
        }
        return temp;
    }

    public String map(EnumNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = ((PEnumNode)node).pascalName;
                break;
            }
            case 10: {
                temp = ((PEnumNode)node).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                temp = null;
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(EnumNode, int)")));
            }
        }
        return temp;
    }

    public String map(ExceptionNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = ((PExceptionNode)node).pascalName;
                break;
            }
            case 10: {
                temp = ((PExceptionNode)node).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                temp = null;
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(InterfaceNode, int)")));
            }
        }
        return temp;
    }

    public String map(FixedNode node, int context, ContainerNode useSite) {
        return "?map(FixedNode)?";
    }

    public String map(InterfaceNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = ((PInterfaceNode)node).pascalFullName;
                break;
            }
            case 10: {
                temp = ((PInterfaceNode)node).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                temp = null;
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(InterfaceNode, int)")));
            }
        }
        return temp;
    }

    public String map(NativeNode node, int context, ContainerNode useSite) {
        return "";
    }

    public String map(PrimitiveNode node, int context, ContainerNode useSite) {
        String temp = null;
        block0 : switch (context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                switch (node._pkind) {
                    case 1: {
                        temp = "void";
                        break block0;
                    }
                    case 2: {
                        temp = "SmallInt";
                        break block0;
                    }
                    case 3: {
                        temp = "Integer";
                        break block0;
                    }
                    case 16: {
                        temp = "Int64";
                        break block0;
                    }
                    case 4: {
                        temp = "Word";
                        break block0;
                    }
                    case 5: {
                        temp = "Cardinal";
                        break block0;
                    }
                    case 17: {
                        temp = "Int64";
                        break block0;
                    }
                    case 6: {
                        temp = "Single";
                        break block0;
                    }
                    case 7: {
                        temp = "Double";
                        break block0;
                    }
                    case 18: {
                        temp = "Extended";
                        break block0;
                    }
                    case 8: {
                        temp = "Boolean";
                        break block0;
                    }
                    case 9: {
                        temp = "Char";
                        break block0;
                    }
                    case 19: {
                        temp = "WideChar";
                        break block0;
                    }
                    case 10: {
                        temp = "Byte";
                        break block0;
                    }
                    case 12: {
                        temp = "TypeCode";
                        break block0;
                    }
                    case 13: {
                        temp = "Principal";
                        break block0;
                    }
                    case 11: {
                        temp = "Any";
                        break block0;
                    }
                    case 15: {
                        temp = "CORBAObject";
                        break block0;
                    }
                    case 14: {
                        temp = "AnsiString";
                        break block0;
                    }
                    case 20: {
                        temp = "WideString";
                        break block0;
                    }
                }
                node.ER().internalError(String.valueOf(new StringBuffer("invalid primitive type ").append(node.typeName()).append(" in PascalMapper.map(PrimitiveNode, int)")));
                break;
            }
            case 10: {
                temp = null;
                break;
            }
            case 9: {
                temp = this.genTkName(node.typeName());
                break;
            }
            case 11: {
                temp = this.genReadWriteType(node.typeName());
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(PrimitiveNode, int)")));
            }
        }
        return temp;
    }

    public String map(SequenceNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 10: {
                break;
            }
            case 9: {
                temp = null;
                break;
            }
            case 11: {
                temp = null;
                break;
            }
            case 0: {
                temp = this.map(node._type, context, null);
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(SequenceNode, int)")));
            }
        }
        return temp;
    }

    public String map(StringNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = "AnsiString";
                break;
            }
            case 10: {
                temp = null;
                break;
            }
            case 9: {
                temp = this.genTkName(node.typeName());
                break;
            }
            case 11: {
                temp = this.genReadWriteType(node.typeName());
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(StringNode, int)")));
            }
        }
        return temp;
    }

    public String map(StructNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = ((PStructNode)node).pascalName;
                break;
            }
            case 10: {
                temp = ((PStructNode)node).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                temp = null;
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(StructNode, int)")));
            }
        }
        return temp;
    }

    public String map(Type idlType) {
        return this.map(idlType, 0);
    }

    public String map(Type type, int context) {
        String temp = null;
        switch (type.kind()) {
            case 5: {
                temp = this.map((InterfaceNode)type, context, null);
                break;
            }
            case 10: {
                temp = this.map((StructNode)type, context, null);
                break;
            }
            case 11: {
                temp = this.map((UnionNode)type, context, null);
                break;
            }
            case 12: {
                temp = this.map((EnumNode)type, context, null);
                break;
            }
            case 4: 
            case 20: 
            case 21: {
                temp = ((ContainedNode)((Object)type))._beName;
                break;
            }
            case 9: {
                temp = this.map((AliasNode)type, context, null);
                break;
            }
            case 13: {
                temp = this.map((PrimitiveNode)type, context, null);
                break;
            }
            case 14: {
                temp = this.map((StringNode)type, context, null);
                break;
            }
            case 15: {
                temp = this.map((SequenceNode)type, context, null);
                break;
            }
            case 16: {
                temp = this.map((ArrayNode)type, context, null);
                break;
            }
            case 18: {
                temp = this.map((WStringNode)type, context, null);
                break;
            }
            case 19: {
                temp = this.map((FixedNode)type, context, null);
                break;
            }
            case 23: {
                temp = this.map((NativeNode)type, context, null);
                break;
            }
            default: {
                type.ER().internalError(String.valueOf(new StringBuffer("invalid type ").append(((Node)((Object)type)).typeName()).append(" in PascalMapper.map(Type, int)")));
            }
        }
        return temp;
    }

    public String map(UnionNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = ((PUnionNode)node).pascalName;
                break;
            }
            case 10: {
                temp = ((PUnionNode)node).pascalHelperName;
                break;
            }
            case 9: 
            case 11: {
                temp = null;
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(UnionNode, int)")));
            }
        }
        return temp;
    }

    public String map(ValueBoxNode node, int context, ContainerNode useSite) {
        String name = this.relativeName(node, useSite);
        switch (context) {
            case 2: 
            case 3: {
                return String.valueOf(name).concat("Holder");
            }
        }
        return this.map(node._type, context, useSite);
    }

    public String map(ValueNode node, int context, ContainerNode useSite) {
        String name = this.relativeName(node, useSite);
        switch (context) {
            case 2: 
            case 3: {
                return String.valueOf(name).concat("Holder");
            }
        }
        return name;
    }

    public String map(WStringNode node, int context, ContainerNode useSite) {
        String temp = null;
        switch (context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                temp = "WideString";
                break;
            }
            case 10: {
                temp = null;
                break;
            }
            case 9: {
                temp = this.genTkName(node.typeName());
                break;
            }
            case 11: {
                temp = this.genReadWriteType(node.typeName());
                break;
            }
            default: {
                node.ER().internalError(String.valueOf(new StringBuffer("invalid context ").append(context).append(" in PascalMapper.map(WStringNode, int)")));
            }
        }
        return temp;
    }

    public String mapFull(NativeNode node, int context) {
        return "";
    }

    public String mapFull(Type type) {
        return this.mapFull(type, 0);
    }

    public String mapFull(Type type, int context) {
        if (type.kind() == 23) {
            return this.mapFull((NativeNode)type);
        }
        if (type.isContained()) {
            String _temp;
            this._buf.reset();
            ContainerNode container = ((ContainedNode)((Object)type))._container;
            if (container.kind() != 17 && context != 11) {
                this._buf.append(((ContainedNode)((Object)container))._beFullName);
                this._buf.append('.');
            }
            if ((_temp = this.map(type, context)) != null) {
                this._buf.append(this.map(type, context));
                return this._buf.toString();
            }
            return _temp;
        }
        return this.map(type, context);
    }

    public String mapIdentifier(String name) {
        String kwAvoid = this._keywordAvoider.convertSimpleName(name);
        if (kwAvoid.charAt(0) == '_') {
            return kwAvoid;
        }
        for (int i = this.countSuffixes(name); i > 0; --i) {
            name = "_".concat(String.valueOf(name));
        }
        return name;
    }

    public String mapPackage(ContainerNode node) {
        this._v.setSize(0);
        ContainerNode c = node;
        while (c.kind() != 6 && c.kind() != 17) {
            c = ((ContainedNode)((Object)c))._container;
        }
        if (c.kind() == 6) {
            this._v.addElement(c);
        }
        this._buf.reset();
        if (!((PRepositoryNode)((Node)((Object)node))._repository).bUnitIsEmpty) {
            this._buf.append(((PRepositoryNode)((Node)((Object)node))._repository).pascalName);
            if (this._v.size() > 0) {
                this._buf.append("_");
            }
        }
        for (int i = this._v.size() - 1; i >= 0; --i) {
            ContainedNode n = (ContainedNode)this._v.elementAt(i);
            if (i > 0) {
                this._buf.append('_');
            }
            this._buf.append(n._beFullName);
        }
        return this._buf.toString();
    }

    public String mapScoped(Type type, int context, String scope) {
        int lastValidStart = 0;
        String full = this.mapFull(type, context);
        int len1 = full.length();
        int len2 = scope.length();
        for (int i = 0; i < len1 && i < len2; ++i) {
            if (full.charAt(i) != scope.charAt(i)) {
                return full.substring(lastValidStart, len1);
            }
            if (full.charAt(i) != '_') continue;
            lastValidStart = i + 1;
        }
        return scope;
    }

    public String relativeName(ContainedNode node, ContainerNode useSite) {
        return this.relativeName(node, useSite, ".", false);
    }

    private static String removeLeadingUnderbar(String baseName) {
        if (baseName != null) {
            return baseName.charAt(0) == '_' ? baseName.substring(1) : baseName;
        }
        return null;
    }
}

