/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.pascal.ast;

import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PType;

public final class PPrimitiveNode
extends PrimitiveNode
implements PType {
    public transient String pascalTypeName;

    public PPrimitiveNode(int pkind) {
        super(pkind);
    }

    public static String asString(String str, boolean javaRestrictions) {
        return String.valueOf(new StringBuffer("'").append(PPrimitiveNode.pascalISOLatin1StringToPrintable(str, javaRestrictions)).append("'"));
    }

    private static void convertChar(StringBuffer cookedChar, char rawChar) {
        StringBuffer newCharLiteral = new StringBuffer();
        switch (rawChar) {
            case '\b': {
                cookedChar.append("#8");
                break;
            }
            case '\f': {
                cookedChar.append("#12");
                break;
            }
            case '\n': {
                cookedChar.append("#10");
                break;
            }
            case '\r': {
                cookedChar.append("#13");
                break;
            }
            case '\t': {
                cookedChar.append("#9");
                break;
            }
            case '\\': {
                cookedChar.append("''");
                break;
            }
            case '\'': {
                cookedChar.append("''''");
                break;
            }
            default: {
                char i = rawChar;
                cookedChar.append(String.valueOf('#').concat(String.valueOf(String.valueOf((int)i))));
            }
        }
    }

    private static void convertWChar(StringBuffer cookedChar, char rawChar) {
        StringBuffer newCharLiteral = new StringBuffer();
        switch (rawChar) {
            case '\b': {
                cookedChar.append("#8");
                break;
            }
            case '\f': {
                cookedChar.append("#12");
                break;
            }
            case '\n': {
                cookedChar.append("#10");
                break;
            }
            case '\r': {
                cookedChar.append("#13");
                break;
            }
            case '\t': {
                cookedChar.append("#9");
                break;
            }
            case '\\': {
                cookedChar.append("''");
                break;
            }
            case '\'': {
                cookedChar.append("''''");
                break;
            }
            default: {
                char i = rawChar;
                cookedChar.append(String.valueOf('#').concat(String.valueOf(String.valueOf((int)i))));
            }
        }
    }

    public boolean finish(int code) {
        this.pascalTypeName = this._repository._mapper.map(this, null);
        return true;
    }

    public String getHelperFullName() {
        return null;
    }

    public String getReadWritePrefix() {
        return this._repository._mapper.map(this, 11, null);
    }

    public String getScope() {
        return null;
    }

    public String getTkHelperFullName() {
        return null;
    }

    public String getTkName() {
        return this._repository._mapper.map(this, 9, null);
    }

    public String getTypeFullName() {
        return this._repository._mapper.map(this, 0, null);
    }

    private static boolean isSpecialChar(char rawChar) {
        return rawChar < ' ' || rawChar > '~' || rawChar == '\'';
    }

    private static boolean isSpecialWChar(char rawChar) {
        return rawChar < ' ' || rawChar > '~' || rawChar == '\'';
    }

    public static String pascalISOLatin1CharToPrintable(char c, boolean pascalStyle) {
        switch (c) {
            case '\\': {
                return "\\";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "''";
            }
        }
        if (c >= ' ' && c <= '~') {
            return "".concat(String.valueOf(c));
        }
        switch (c) {
            case '\n': {
                return "#10";
            }
            case '\t': {
                return "#9";
            }
            case '\b': {
                return "#8";
            }
            case '\r': {
                return "#13";
            }
            case '\f': {
                return "#12";
            }
            case '\u0007': {
                if (!pascalStyle) {
                    return "\\a";
                }
            }
            case '\u000b': {
                if (pascalStyle) break;
                return "\\v";
            }
        }
        char i = c;
        char digit1 = (char)(48 + (i >> 6));
        char digit2 = (char)(48 + (i >> 3 & 7));
        char digit3 = (char)(48 + (i & 7));
        return String.valueOf(new StringBuffer("\\").append(digit1).append(digit2).append(digit3));
    }

    public static String pascalISOLatin1StringToPrintable(String s, boolean pascalStyle) {
        int len = s.length();
        StringBuffer buf = new StringBuffer(len * 2);
        for (int i = 0; i < len; ++i) {
            buf.append(PPrimitiveNode.pascalISOLatin1CharToPrintable(s.charAt(i), pascalStyle));
        }
        return buf.toString();
    }

    public String toLiteral(Object value) {
        switch (this._pkind) {
            case 8: {
                return value == Boolean.TRUE ? "True" : "False";
            }
            case 10: {
                int bValue = ((Byte)value).byteValue();
                Integer CookedOctet = new Integer(bValue < 0 ? 256 + bValue : bValue);
                return CookedOctet.toString();
            }
            case 14: {
                String rawString = value.toString();
                StringBuffer cookedString = new StringBuffer();
                int j = 0;
                int len = rawString.length();
                for (int i = 0; i < len; ++i) {
                    if (j > 0) {
                        cookedString.append("+");
                    }
                    if (PPrimitiveNode.isSpecialChar(rawString.charAt(i))) {
                        PPrimitiveNode.convertChar(cookedString, rawString.charAt(i));
                    } else {
                        int m;
                        for (m = i; m < len && !PPrimitiveNode.isSpecialChar(rawString.charAt(m)); ++m) {
                        }
                        cookedString.append("'");
                        if (m < len) {
                            cookedString.append(rawString.substring(i, m));
                            i = m - 1;
                        } else {
                            cookedString.append(rawString.substring(i));
                            i = m - 1;
                        }
                        cookedString.append("'");
                    }
                    ++j;
                }
                return cookedString.toString();
            }
            case 20: {
                String rawString = value.toString();
                StringBuffer cookedString = new StringBuffer();
                int j = 0;
                int len = rawString.length();
                for (int i = 0; i < len; ++i) {
                    if (j > 0) {
                        cookedString.append("+");
                    }
                    if (PPrimitiveNode.isSpecialWChar(rawString.charAt(i))) {
                        PPrimitiveNode.convertWChar(cookedString, rawString.charAt(i));
                    } else {
                        int m;
                        for (m = i; m < len && !PPrimitiveNode.isSpecialWChar(rawString.charAt(m)); ++m) {
                        }
                        cookedString.append("'");
                        if (m < len) {
                            cookedString.append(rawString.substring(i, m));
                            i = m - 1;
                        } else {
                            cookedString.append(rawString.substring(i));
                            i = m - 1;
                        }
                        cookedString.append("'");
                    }
                    ++j;
                }
                return cookedString.toString();
            }
            case 9: {
                StringBuffer cookedChar = new StringBuffer();
                char rawChar = ((Character)value).charValue();
                if (PPrimitiveNode.isSpecialChar(rawChar)) {
                    PPrimitiveNode.convertChar(cookedChar, rawChar);
                } else {
                    cookedChar.append(String.valueOf(new StringBuffer("'").append(rawChar).append("'")));
                }
                return cookedChar.toString();
            }
            case 19: {
                StringBuffer cookedChar = new StringBuffer();
                char rawChar = ((Character)value).charValue();
                if (PPrimitiveNode.isSpecialWChar(rawChar)) {
                    PPrimitiveNode.convertWChar(cookedChar, rawChar);
                } else {
                    cookedChar.append(String.valueOf(new StringBuffer("'").append(rawChar).append("'")));
                }
                return cookedChar.toString();
            }
        }
        return value.toString();
    }

    public String toPascalLiteral(Object value) {
        switch (this._pkind) {
            case 8: {
                return value == Boolean.TRUE ? "True" : "False";
            }
            case 10: {
                int bValue = ((Byte)value).byteValue();
                Integer CookedOctet = new Integer(bValue < 0 ? 256 + bValue : bValue);
                return CookedOctet.toString();
            }
            case 14: {
                String rawString = value.toString();
                StringBuffer cookedString = new StringBuffer();
                int j = 0;
                int len = rawString.length();
                for (int i = 0; i < len; ++i) {
                    if (j > 0) {
                        cookedString.append("+");
                    }
                    if (PPrimitiveNode.isSpecialChar(rawString.charAt(i))) {
                        PPrimitiveNode.convertChar(cookedString, rawString.charAt(i));
                    } else {
                        int m;
                        for (m = i; m < len && !PPrimitiveNode.isSpecialChar(rawString.charAt(m)); ++m) {
                        }
                        cookedString.append("'");
                        if (m < len) {
                            cookedString.append(rawString.substring(i, m));
                            i = m - 1;
                        } else {
                            cookedString.append(rawString.substring(i));
                            i = m - 1;
                        }
                        cookedString.append("'");
                    }
                    ++j;
                }
                return cookedString.toString();
            }
            case 20: {
                String rawString = value.toString();
                StringBuffer cookedString = new StringBuffer();
                int j = 0;
                int len = rawString.length();
                for (int i = 0; i < len; ++i) {
                    if (j > 0) {
                        cookedString.append("+");
                    }
                    if (PPrimitiveNode.isSpecialWChar(rawString.charAt(i))) {
                        PPrimitiveNode.convertWChar(cookedString, rawString.charAt(i));
                    } else {
                        int m;
                        for (m = i; m < len && !PPrimitiveNode.isSpecialWChar(rawString.charAt(m)); ++m) {
                        }
                        cookedString.append("'");
                        if (m < len) {
                            cookedString.append(rawString.substring(i, m));
                            i = m - 1;
                        } else {
                            cookedString.append(rawString.substring(i));
                            i = m - 1;
                        }
                        cookedString.append("'");
                    }
                    ++j;
                }
                return cookedString.toString();
            }
            case 9: {
                StringBuffer cookedChar = new StringBuffer();
                char rawChar = ((Character)value).charValue();
                if (PPrimitiveNode.isSpecialChar(rawChar)) {
                    PPrimitiveNode.convertChar(cookedChar, rawChar);
                } else {
                    cookedChar.append(String.valueOf(new StringBuffer("'").append(rawChar).append("'")));
                }
                return cookedChar.toString();
            }
            case 19: {
                StringBuffer cookedChar = new StringBuffer();
                char rawChar = ((Character)value).charValue();
                if (PPrimitiveNode.isSpecialWChar(rawChar)) {
                    PPrimitiveNode.convertWChar(cookedChar, rawChar);
                } else {
                    cookedChar.append(String.valueOf(new StringBuffer("'").append(rawChar).append("'")));
                }
                return cookedChar.toString();
            }
        }
        return value.toString();
    }
}

