/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.pascal;

import com.inprise.vbroker.compiler.util.IndentableStringBuffer;

public class PascalWriteBuffers {
    protected static final transient boolean trace = false;
    protected int nodeKind = 0;
    protected int iNumberOfBuffers = 0;
    protected int iNumberOfPasses = 0;
    protected int iBaseIndent = 0;
    protected IndentableStringBuffer[][] buffers = null;

    public PascalWriteBuffers(int _iGroupId, int _iNumberOfPasses, int _iNumberOfBuffers, int _iBaseIndent) {
        this.nodeKind = _iGroupId;
        this.iNumberOfBuffers = _iNumberOfBuffers;
        this.iNumberOfPasses = _iNumberOfPasses;
        this.iBaseIndent = _iBaseIndent;
        this.buffers = new IndentableStringBuffer[this.iNumberOfPasses][this.iNumberOfBuffers];
    }

    void discard(int _pass) {
        for (int iCount = 0; iCount < this.iNumberOfBuffers; ++iCount) {
            this.buffers[_pass][iCount] = null;
        }
    }

    public IndentableStringBuffer getBuffer(int _pass, int _iBufferNumber) {
        IndentableStringBuffer _buffer = null;
        if (_iBufferNumber >= 0 && _iBufferNumber < this.iNumberOfBuffers) {
            if (this.buffers[_pass][_iBufferNumber] == null) {
                this.buffers[_pass][_iBufferNumber] = new IndentableStringBuffer();
            }
            _buffer = this.buffers[_pass][_iBufferNumber];
        } else {
            _buffer = null;
        }
        return _buffer;
    }

    void reset() {
        for (int p = 0; p < this.iNumberOfPasses; ++p) {
            this.reset(p, this.iBaseIndent);
        }
    }

    void reset(int _pass) {
        this.reset(_pass, this.iBaseIndent);
    }

    void reset(int _pass, int _baseIndent) {
        for (int iCount = 0; iCount < this.iNumberOfBuffers; ++iCount) {
            if (this.buffers[_pass][iCount] == null) continue;
            this.buffers[_pass][iCount].reset();
            this.buffers[_pass][iCount].indent(_baseIndent);
        }
    }
}

