/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.EnumNameNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.FieldNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.Type;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UnionNode
extends FieldNode
implements Type {
    public static final UnionNode ERROR = new UnionNode();
    public Type _discriminator;
    public Vector _memberLabels = new Vector();
    public int _defaultIndex = -1;
    public boolean _explicitDefault;
    public boolean _implicitDefault;
    public Object _defaultValue;

    public UnionNode() {
        super(11);
    }

    public void addLabel() {
        if (this._defaultIndex != -1) {
            this.error("Comp.AST.duplicateDefaultLabel");
        } else {
            this.addLabel(null);
            this._defaultIndex = this._memberNames.size();
        }
    }

    public void addLabel(Object label) {
        if (this._memberNames.size() > this._memberLabels.size()) {
            this._memberLabels.addElement(new Vector());
        }
        if (this._memberNames.size() == this._memberLabels.size()) {
            this._memberLabels.addElement(new Vector());
        }
        if (label != null) {
            if (this.labelExists(label)) {
                this.error("Comp.AST.duplicateLabel", PrimitiveNode.format(label));
                return;
            }
            if (!this.verifyLabelTypeMatch(label)) {
                return;
            }
            ((Vector)this._memberLabels.elementAt(this._memberLabels.size() - 1)).addElement(label);
        }
    }

    public Object[] allLabels() {
        int num = 0;
        int outerLen = this._memberLabels.size();
        for (int i = 0; i < outerLen; ++i) {
            Vector labels = (Vector)this._memberLabels.elementAt(i);
            int innerLen = labels.size();
            for (int j = 0; j < innerLen; ++j) {
                ++num;
            }
        }
        Object[] ret = new Object[num];
        int outerLen2 = this._memberLabels.size();
        for (int i = 0; i < outerLen2; ++i) {
            Vector labels = (Vector)this._memberLabels.elementAt(i);
            int innerLen = labels.size();
            for (int j = 0; j < innerLen; ++j) {
                ret[--num] = labels.elementAt(j);
            }
        }
        return ret;
    }

    public boolean badLabel(Object label) {
        this.error("Comp.AST.invalidLabelType", new Object[]{PrimitiveNode.format(label), ((Node)((Object)this._discriminator)).typeName()});
        return false;
    }

    private Object chooseDefaultLabelsValue() {
        Type type = this._discriminator.trueType();
        Node node = (Node)((Object)type);
        Object[] allLabels = this.allLabels();
        if (node._kind == 12) {
            int i;
            EnumNode enumNode = (EnumNode)node;
            Vector names = enumNode._memberNames;
            int len = names.size();
            Hashtable h = new Hashtable(len);
            for (i = 0; i < len; ++i) {
                h.put(names.elementAt(i), names.elementAt(i));
            }
            for (i = 0; i < allLabels.length; ++i) {
                h.remove(((EnumNameNode)allLabels[i])._name);
            }
            Enumeration remainder = h.elements();
            return remainder.nextElement();
        }
        long from = 0L;
        long to = 0L;
        int pkind = ((PrimitiveNode)node)._pkind;
        switch (pkind) {
            case 8: {
                from = 0L;
                to = 1L;
                break;
            }
            case 9: {
                from = 0L;
                to = 255L;
                break;
            }
            case 2: {
                from = -32768L;
                to = 32767L;
                break;
            }
            case 4: {
                from = 0L;
                to = 65534L;
                break;
            }
            case 3: {
                from = Integer.MIN_VALUE;
                to = Integer.MAX_VALUE;
                break;
            }
            case 5: {
                from = 0L;
                to = 0xFFFFFFFEL;
                break;
            }
            case 16: {
                from = Long.MIN_VALUE;
                to = Long.MAX_VALUE;
                break;
            }
            case 17: {
                from = 0L;
                to = 0xFFFFFFFEL;
                break;
            }
            default: {
                this._repository._ER.internalError("unexpected discriminator type in JUnionNode.chooseDefaultLabelsValue");
            }
        }
        block17: for (long domainIndex = from; domainIndex <= to; ++domainIndex) {
            for (int labelIndex = 0; labelIndex < allLabels.length; ++labelIndex) {
                if (this.integralValue(allLabels[labelIndex]) == domainIndex) continue block17;
            }
            switch (pkind) {
                case 9: {
                    return new Character((char)domainIndex);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 16: 
                case 17: {
                    return new Long(domainIndex);
                }
                case 8: {
                    return domainIndex == (long)0 ? Boolean.FALSE : Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    protected String createLabel(Object value) {
        if (this._discriminator.kind() == 12) {
            EnumNode d = (EnumNode)this._discriminator;
            return d._repository._mapper.fullName(d, d.toLiteral(value));
        }
        return this._discriminator.toLiteral(value);
    }

    public void defaultValueProcessing() {
        if (this.remainingDomainSpace() == 0L) {
            if (this._defaultIndex >= 0) {
                if (((Vector)this._memberLabels.elementAt(this._defaultIndex)).size() == 0) {
                    this.error("Comp.AST.unreachableDefault", this._fullName);
                } else {
                    this._repository._ER.warn("Comp.AST.spuriousDefault", this._fullName);
                    this._defaultIndex = -1;
                }
            }
        } else {
            this._defaultValue = this.chooseDefaultLabelsValue();
        }
        this._explicitDefault = this._defaultIndex >= 0;
        this._implicitDefault = !this._explicitDefault && this._defaultValue != null;
    }

    public void discriminator(Type type) {
        Node node = (Node)((Object)type.trueType());
        if (node._kind == 13) {
            switch (((PrimitiveNode)node)._pkind) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 16: 
                case 17: {
                    this._discriminator = (Type)((Object)node);
                    return;
                }
            }
        } else if (node._kind == 12) {
            this._discriminator = (Type)((Object)node);
            return;
        }
        this.error("Comp.AST.invalidSwitchType", node.typeName());
        this._discriminator = node._repository.LONG_TYPE;
    }

    public boolean finish(int code) {
        super.finish(code);
        this.defaultValueProcessing();
        return true;
    }

    private long integralValue(Object o) {
        if (o instanceof Boolean) {
            return o == Boolean.TRUE ? 1 : 0;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        this._repository._ER.internalError("unexpected Object class in UnionNode.integralValue");
        return 0L;
    }

    public boolean labelExists(Object label) {
        int outerLen = this._memberLabels.size();
        for (int i = 0; i < outerLen; ++i) {
            Vector labels = (Vector)this._memberLabels.elementAt(i);
            int innerLen = labels.size();
            for (int j = 0; j < innerLen; ++j) {
                if (!labels.elementAt(j).equals(label)) continue;
                return true;
            }
        }
        return false;
    }

    public long numRealLabels() {
        long ret = 0L;
        int len = this._memberLabels.size();
        for (int i = 0; i < len; ++i) {
            ret += (long)((Vector)this._memberLabels.elementAt(i)).size();
        }
        return ret;
    }

    public static final boolean numberFits(long num, int pkind) {
        switch (pkind) {
            case 2: {
                return num >= -32768L && num <= 32767L;
            }
            case 3: {
                return num >= Integer.MIN_VALUE && num <= Integer.MAX_VALUE;
            }
            case 16: {
                return true;
            }
            case 4: {
                return num >= 0L && num <= 32767L;
            }
            case 5: {
                return num >= 0L && num <= Integer.MAX_VALUE;
            }
            case 17: {
                return num >= 0L && num <= Long.MAX_VALUE;
            }
        }
        return false;
    }

    public long remainingDomainSpace() {
        Node node = (Node)((Object)this._discriminator);
        if (node._kind == 12) {
            return (long)((EnumNode)this._discriminator)._memberNames.size() - this.numRealLabels();
        }
        PrimitiveNode prim = (PrimitiveNode)node;
        switch (prim._pkind) {
            case 2: 
            case 4: {
                return 65536L - this.numRealLabels();
            }
            case 3: 
            case 5: {
                return 0x100000000L - this.numRealLabels();
            }
            case 16: 
            case 17: {
                return 0x100000000L - this.numRealLabels();
            }
            case 9: {
                return 256L - this.numRealLabels();
            }
            case 8: {
                return 2L - this.numRealLabels();
            }
        }
        this._repository._ER.internalError("unexpected discriminator type in UnionNode.domainCovered");
        return 0L;
    }

    public boolean verifyLabelTypeMatch(Object label) {
        if (label instanceof Long) {
            if (!(this._discriminator instanceof PrimitiveNode)) {
                return this.badLabel(label);
            }
            int pkind = ((PrimitiveNode)this._discriminator)._pkind;
            switch (pkind) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 16: 
                case 17: {
                    if (UnionNode.numberFits((Long)label, pkind)) {
                        return true;
                    }
                    this.error("Comp.AST.numberOutOfRange", new Object[]{PrimitiveNode.format(label), ((Node)((Object)this._discriminator)).typeName()});
                    return false;
                }
            }
            return this.badLabel(label);
        }
        if (label instanceof Boolean) {
            return this._discriminator instanceof PrimitiveNode && ((PrimitiveNode)this._discriminator)._pkind == 8 ? true : this.badLabel(label);
        }
        if (label instanceof Character) {
            return this._discriminator instanceof PrimitiveNode && ((PrimitiveNode)this._discriminator)._pkind == 9 ? true : this.badLabel(label);
        }
        if (label instanceof EnumNameNode) {
            EnumNameNode ename = (EnumNameNode)label;
            if (ename._definingEnum == this._discriminator) {
                return true;
            }
            if (this._discriminator instanceof EnumNode) {
                this.error("Comp.AST.badEnumName", new Object[]{ename._name, ((EnumNode)this._discriminator)._name});
                return false;
            }
            return this.badLabel(label);
        }
        return this.badLabel(label);
    }
}

