/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FixedNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.NativeNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;
import com.inprise.vbroker.compiler.util.KeywordAvoider;
import com.inprise.vbroker.util.SimpleStringBuffer;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public abstract class TypeMapper {
    protected final KeywordAvoider _keywordAvoider = new KeywordAvoider();
    protected Dictionary _nativeMap = new Hashtable(10);
    public CommonOptions _options;
    protected final SimpleStringBuffer _buf = new SimpleStringBuffer();
    protected final Vector _v = new Vector(20);

    public TypeMapper(CommonOptions options) {
        this._options = options;
        this.initializeKeywordAvoider();
    }

    public void avoidKeyword(String keyword) {
        this._keywordAvoider.avoid(keyword);
    }

    public void avoidKeyword(String keyword, String replacement) {
        this._keywordAvoider.avoid(keyword, replacement);
    }

    public void avoidKeyword(Hashtable keywordMap) {
        this._keywordAvoider.avoid(keywordMap);
    }

    protected abstract String context2string(int var1);

    public abstract String fullName(ContainedNode var1, String var2);

    protected abstract void initializeKeywordAvoider();

    public abstract String map(AliasNode var1, int var2, ContainerNode var3);

    public abstract String map(ArrayNode var1, int var2, ContainerNode var3);

    public abstract String map(EnumNode var1, int var2, ContainerNode var3);

    public abstract String map(ExceptionNode var1, int var2, ContainerNode var3);

    public abstract String map(FixedNode var1, int var2, ContainerNode var3);

    public abstract String map(InterfaceNode var1, int var2, ContainerNode var3);

    public String map(NativeNode node, int context, ContainerNode useSite) {
        String trial1 = (String)this._nativeMap.get(String.valueOf(node._fullName).concat(String.valueOf(this.context2string(context))));
        if (trial1 == null) {
            String trial2 = (String)this._nativeMap.get(node._fullName);
            if (trial2 == null) {
                node._repository._ER.error("Comp.BE.unknownNative", node._fullName);
                return "???";
            }
            return trial2;
        }
        return trial1;
    }

    public abstract String map(PrimitiveNode var1, int var2, ContainerNode var3);

    public abstract String map(SequenceNode var1, int var2, ContainerNode var3);

    public abstract String map(StringNode var1, int var2, ContainerNode var3);

    public abstract String map(StructNode var1, int var2, ContainerNode var3);

    public String map(Type type, int context, ContainerNode useSite) {
        switch (type.kind()) {
            case 4: {
                return this.map((ExceptionNode)((Object)type), context, useSite);
            }
            case 5: {
                return this.map((InterfaceNode)type, context, useSite);
            }
            case 9: {
                return this.map((AliasNode)type, context, useSite);
            }
            case 10: {
                return this.map((StructNode)type, context, useSite);
            }
            case 11: {
                return this.map((UnionNode)type, context, useSite);
            }
            case 12: {
                return this.map((EnumNode)type, context, useSite);
            }
            case 13: {
                return this.map((PrimitiveNode)type, context, useSite);
            }
            case 14: {
                return this.map((StringNode)type, context, useSite);
            }
            case 15: {
                return this.map((SequenceNode)type, context, useSite);
            }
            case 16: {
                return this.map((ArrayNode)type, context, useSite);
            }
            case 18: {
                return this.map((WStringNode)type, context, useSite);
            }
            case 19: {
                return this.map((FixedNode)type, context, useSite);
            }
            case 20: {
                return this.map((ValueNode)type, context, useSite);
            }
            case 21: {
                return this.map((ValueBoxNode)type, context, useSite);
            }
            case 23: {
                return this.map((NativeNode)type, context, useSite);
            }
        }
        type.ER().internalError(String.valueOf(new StringBuffer("invalid type ").append(((Node)((Object)type)).typeName()).append(" in ").append(this.getClass().getName()).append(".map(Type, int, ContainerNode)")));
        return null;
    }

    public String map(Type idlType, ContainerNode useSite) {
        return this.map(idlType, 0, useSite);
    }

    public abstract String map(UnionNode var1, int var2, ContainerNode var3);

    public abstract String map(ValueBoxNode var1, int var2, ContainerNode var3);

    public abstract String map(ValueNode var1, int var2, ContainerNode var3);

    public abstract String map(WStringNode var1, int var2, ContainerNode var3);

    public String mapIdentifier(ContainedNode node) {
        return this._keywordAvoider.convertSimpleName(node._name);
    }

    public String mapIdentifier(String name) {
        return this._keywordAvoider.convertSimpleName(name);
    }

    public abstract String relativeName(ContainedNode var1, ContainerNode var2);

    protected String relativeName(ContainedNode node, ContainerNode useSite, String delim, boolean allowPartialScope) {
        if (useSite == node._repository) {
            return this.fullName(node, node._beName);
        }
        if (useSite == null) {
            return node._beName;
        }
        if (useSite == node._container) {
            return node._beName;
        }
        if (allowPartialScope) {
            int i;
            this._v.setSize(0);
            ContainerNode c = node._container;
            while (c != node._repository) {
                this._v.addElement(c);
                c = ((ContainedNode)((Object)c))._container;
            }
            int len = this._v.size();
            int LCAindex = -1;
            c = useSite;
            block1: while (c != node._repository) {
                for (i = 0; i < len; ++i) {
                    ContainerNode d = (ContainerNode)this._v.elementAt(i);
                    if (d != c) continue;
                    LCAindex = i;
                    break block1;
                }
                c = ((ContainedNode)((Object)c))._container;
            }
            if (LCAindex == -1) {
                return this.fullName(node, node._beName);
            }
            this._buf.reset();
            for (i = LCAindex - 1; i >= 0; --i) {
                this._buf.append(((ContainedNode)this._v.elementAt((int)i))._beName);
                this._buf.append(delim);
            }
            this._buf.append(node._beName);
            return this._buf.toString();
        }
        return this.fullName(node, node._beName);
    }

    protected static final String relativize(String name, String scope, String delim, boolean allowPartialScope) {
        int len2;
        char firstDelimChar = delim.charAt(0);
        int delimLen = delim.length();
        int len1 = name.length();
        int minlen = len1 > (len2 = scope.length()) ? len2 : len1;
        boolean unequal = false;
        int index = 0;
        int i = 0;
        while (i < minlen) {
            char d;
            char c = name.charAt(i);
            if (c != (d = scope.charAt(i))) {
                unequal = true;
                break;
            }
            if (c == firstDelimChar) {
                index = i += delimLen;
                continue;
            }
            ++i;
        }
        if (!unequal && len1 != len2 && i == len2 && name.charAt(i) == firstDelimChar) {
            index = i + delimLen;
        }
        String relativeName = name.substring(index);
        if (allowPartialScope) {
            return relativeName;
        }
        if (relativeName.indexOf(delim) < 0) {
            return relativeName;
        }
        return name;
    }

    public void updateOptionsDependencies() {
    }
}

