/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.util.StringFunctions;

public class PrimitiveNode
extends Node
implements Type {
    public static final int NULL = 0;
    public static final int VOID = 1;
    public static final int SHORT = 2;
    public static final int LONG = 3;
    public static final int USHORT = 4;
    public static final int ULONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BOOLEAN = 8;
    public static final int CHAR = 9;
    public static final int OCTET = 10;
    public static final int ANY = 11;
    public static final int TYPECODE = 12;
    public static final int PRINCIPAL = 13;
    public static final int STRING = 14;
    public static final int OBJREF = 15;
    public static final int LONGLONG = 16;
    public static final int ULONGLONG = 17;
    public static final int LONGDOUBLE = 18;
    public static final int WCHAR = 19;
    public static final int WSTRING = 20;
    public static final int VALUEBASE = 21;
    public static final int FIXED = 30000;
    public static final int ENUMNAME = 30001;
    public int _pkind;

    public PrimitiveNode(int pkind) {
        super(13);
        this._pkind = pkind;
    }

    public static String asString(String str, boolean javaRestrictions) {
        return String.valueOf(new StringBuffer("\"").append(StringFunctions.ISOLatin1StringToPrintable(str, javaRestrictions)).append("\""));
    }

    public static String asWideString(String str, boolean javaRestrictions) {
        return String.valueOf(new StringBuffer("\"").append(StringFunctions.ISOLatin1StringToPrintable(str, javaRestrictions)).append("\""));
    }

    public static final String format(Object o) {
        if (o instanceof Boolean) {
            return o == Boolean.TRUE ? "TRUE" : "FALSE";
        }
        return o.toString();
    }

    public final String shortTypeName() {
        switch (this._pkind) {
            case 4: {
                return "ushort";
            }
            case 5: {
                return "ulong";
            }
            case 16: {
                return "longlong";
            }
            case 17: {
                return "ulonglong";
            }
            case 18: {
                return "longdouble";
            }
            case 13: {
                return "Principal";
            }
            case 12: {
                return "TypeCode";
            }
        }
        return this.typeName();
    }

    public final String tkTypeName() {
        return this._pkind == 15 ? "objref" : this.shortTypeName();
    }

    public String toLiteral(Object value) {
        switch (this._pkind) {
            case 8: {
                return value.equals(Boolean.TRUE) ? "TRUE" : "FALSE";
            }
            case 14: {
                return PrimitiveNode.asString((String)value, false);
            }
            case 20: {
                return PrimitiveNode.asWideString((String)value, false);
            }
            case 9: {
                return String.valueOf(new StringBuffer("'").append(StringFunctions.ISOLatin1CharToPrintable(((Character)value).charValue(), false)).append("'"));
            }
            case 19: {
                return String.valueOf(new StringBuffer("L'").append(StringFunctions.ISOLatin1CharToPrintable(((Character)value).charValue(), false)).append("'"));
            }
        }
        return value.toString();
    }

    public String toString() {
        return this.typeName();
    }

    public final String typeName() {
        return PrimitiveNode.typeName(this._pkind);
    }

    public static final String typeName(int pkind) {
        switch (pkind) {
            case 0: {
                return "null";
            }
            case 11: {
                return "any";
            }
            case 8: {
                return "boolean";
            }
            case 9: {
                return "char";
            }
            case 7: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 3: {
                return "long";
            }
            case 18: {
                return "long double";
            }
            case 16: {
                return "long long";
            }
            case 15: {
                return "Object";
            }
            case 10: {
                return "octet";
            }
            case 13: {
                return "::CORBA::Principal";
            }
            case 2: {
                return "short";
            }
            case 14: {
                return "string";
            }
            case 12: {
                return "::CORBA::TypeCode";
            }
            case 5: {
                return "unsigned long";
            }
            case 17: {
                return "unsigned long long";
            }
            case 4: {
                return "unsigned short";
            }
            case 1: {
                return "void";
            }
            case 19: {
                return "wchar";
            }
            case 20: {
                return "wstring";
            }
            case 21: {
                return "ValueBase";
            }
        }
        return "<UNKNOWN OR INVALID PRIMITIVE TYPE>";
    }
}

