/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNameNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FixedNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.NativeNode;
import com.inprise.vbroker.compiler.ast.ObjectKey;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Node
implements Serializable {
    protected static final transient boolean trace = false;
    public static final int NONE = 0;
    public static final int ALL = 1;
    public static final int ATTRIBUTE = 2;
    public static final int CONSTANT = 3;
    public static final int EXCEPTION = 4;
    public static final int INTERFACE = 5;
    public static final int MODULE = 6;
    public static final int OPERATION = 7;
    public static final int ALIAS = 9;
    public static final int STRUCT = 10;
    public static final int UNION = 11;
    public static final int ENUM = 12;
    public static final int PRIMITIVE = 13;
    public static final int STRING = 14;
    public static final int SEQUENCE = 15;
    public static final int ARRAY = 16;
    public static final int REPOSITORY = 17;
    public static final int WSTRING = 18;
    public static final int FIXED = 19;
    public static final int VALUE = 20;
    public static final int VALUEBOX = 21;
    public static final int VALUEMEMBER = 22;
    public static final int NATIVE = 23;
    public static final short ENUMNAME = 24;
    public static final short _numTypes = 24;
    public RepositoryNode _repository;
    public int _kind;
    public int _fileNumber;
    public long _lineNumber;
    public ObjectKey _objectKey;

    public Node(int kind) {
        this._kind = kind;
    }

    public final ErrorReporter ER() {
        return this._repository._ER;
    }

    protected static final ContainedNode define(int kind, String name, ContainerNode container, String repId, String version, String comment, Vector contents) {
        ContainedNode previousDef;
        RepositoryNode rep = ((Node)((Object)container))._repository;
        if (rep == null) {
            return (ContainedNode)Node.getErrorObject(kind);
        }
        if ((container.kind() == 6 || container.kind() == 17) && kind != 6 && (previousDef = container.lookup(name, true)) != null) {
            rep._ER._previousFileNumber = previousDef._fileNumber;
            rep._ER._previousLineNumber = previousDef._lineNumber;
            rep._ER.error2("Comp.AST.alreadyDefined", new Object[]{name});
            return (ContainedNode)Node.getErrorObject(kind);
        }
        ContainedNode ret = (ContainedNode)rep._factory.create(kind);
        ret._name = name;
        ret._container = container;
        ret._fullName = container == rep ? "::".concat(String.valueOf(name)) : String.valueOf(new StringBuffer(String.valueOf(((ContainedNode)((Object)container))._fullName)).append("::").append(name));
        ret._fileNumber = rep._ER._currentFileNumber;
        ret._lineNumber = rep._ER._currentLineNumber;
        ret._repository = rep;
        ret._repId = repId;
        ret._version = version;
        ret._beName = rep._mapper.mapIdentifier(ret);
        ret._beFullName = rep._mapper.fullName(ret, ret._beName);
        contents.addElement(ret);
        rep.updateId(ret);
        ret._comment = comment;
        return ret;
    }

    protected static final ContainedNode define(int kind, String name, ContainerNode container, String repId, String version, String comment, Vector contents, boolean forwardDecl) {
        ContainedNode ret = container.lookup(name, true);
        RepositoryNode rep = ((Node)((Object)container))._repository;
        if (ret == null) {
            ret = (ContainedNode)rep._factory.create(kind);
            ret._name = name;
            ret._container = container;
            ret._fullName = container == rep ? "::".concat(String.valueOf(name)) : String.valueOf(new StringBuffer(String.valueOf(((ContainedNode)((Object)container))._fullName)).append("::").append(name));
            ret._fileNumber = rep._ER._currentFileNumber;
            ret._lineNumber = rep._ER._currentLineNumber;
            ret._repository = rep;
            ret._repId = repId;
            ret._version = version;
            ret._beName = rep._mapper.mapIdentifier(ret);
            ret._beFullName = rep._mapper.fullName(ret, ret._beName);
            contents.addElement(ret);
            rep.updateId(ret);
            ret._comment = comment;
            return ret;
        }
        if (forwardDecl) {
            return ret;
        }
        if (!((InheritableNode)ret)._defined) {
            ret._fileNumber = rep._ER._currentFileNumber;
            ret._lineNumber = rep._ER._currentLineNumber;
            return ret;
        }
        rep._ER._previousFileNumber = ret._fileNumber;
        rep._ER._previousLineNumber = ret._lineNumber;
        rep._ER.error2("Comp.AST.alreadyDefined", new Object[]{ret._name});
        return (ContainedNode)Node.getErrorObject(kind);
    }

    public Node define(int type, String name, String repId, String version, String comment) {
        this._repository._ER.internalError("Node.define default implementation invoked");
        return null;
    }

    public Node define(int type, String name, String repId, String version, String comment, boolean forwardDecl) {
        this._repository._ER.internalError("Node.define default implementation invoked");
        return null;
    }

    public void error(String mesg) {
        if (this._repository != null) {
            this._repository._ER.error(mesg);
        }
    }

    public void error(String mesg, String arg) {
        if (this._repository != null) {
            this._repository._ER.error(mesg, arg);
        }
    }

    public void error(String mesg, Object[] args) {
        if (this._repository != null) {
            this._repository._ER.error(mesg, args);
        }
    }

    public static Vector find(Vector contents, String name, int depth, int type, boolean excludeInherited) {
        int size = contents == null ? 0 : contents.size();
        Vector<ContainedNode> ret = new Vector<ContainedNode>(size);
        for (int i = 0; i < size; ++i) {
            ContainedNode n = (ContainedNode)contents.elementAt(i);
            if (type == 0 || type != 1 && n._kind != type || n._kind == 24) continue;
            if (name == null || name.equals(n._name)) {
                ret.addElement(n);
            }
            if (depth <= 1 && depth != -1 || !n.isContainer()) continue;
            Vector v = ((ContainerNode)((Object)n)).find(name, depth == -1 ? -1 : depth - 1, type, excludeInherited);
            Enumeration e = v.elements();
            ret.ensureCapacity(ret.size() + v.size());
            while (e.hasMoreElements()) {
                ret.addElement((ContainedNode)e.nextElement());
            }
        }
        return ret;
    }

    public boolean finish(int code) {
        return true;
    }

    public static final Node getErrorObject(int type) {
        switch (type) {
            case 7: {
                return OperationNode.ERROR;
            }
            case 2: {
                return AttributeNode.ERROR;
            }
            case 5: {
                return InterfaceNode.ERROR;
            }
            case 3: {
                return ConstantNode.ERROR;
            }
            case 4: {
                return ExceptionNode.ERROR;
            }
            case 14: {
                return StringNode.ERROR;
            }
            case 6: {
                return ModuleNode.ERROR;
            }
            case 9: {
                return AliasNode.ERROR;
            }
            case 10: {
                return StructNode.ERROR;
            }
            case 11: {
                return UnionNode.ERROR;
            }
            case 12: {
                return EnumNode.ERROR;
            }
            case 15: {
                return SequenceNode.ERROR;
            }
            case 16: {
                return ArrayNode.ERROR;
            }
            case 19: {
                return FixedNode.ERROR;
            }
            case 20: {
                return ValueNode.ERROR;
            }
            case 21: {
                return ValueBoxNode.ERROR;
            }
            case 22: {
                return ValueMemberNode.ERROR;
            }
            case 23: {
                return NativeNode.ERROR;
            }
            case 18: {
                return WStringNode.ERROR;
            }
            case 24: {
                return EnumNameNode.ERROR;
            }
        }
        return null;
    }

    public final boolean hasFields() {
        return Node.hasFields(this._kind);
    }

    public static final boolean hasFields(int kind) {
        return kind == 4 || kind == 10 || kind == 11;
    }

    public final boolean isContained() {
        return Node.isContained(this._kind);
    }

    public static final boolean isContained(int kind) {
        switch (kind) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public final boolean isContainer() {
        return Node.isContainer(this._kind);
    }

    public static final boolean isContainer(int kind) {
        switch (kind) {
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 17: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public final boolean isInheritable() {
        return Node.isInheritable(this._kind);
    }

    public static final boolean isInheritable(int kind) {
        return kind == 5 || kind == 20;
    }

    public final boolean isRepository() {
        return Node.isRepository(this._kind);
    }

    public static final boolean isRepository(int kind) {
        return kind == 17;
    }

    public final boolean isType() {
        return Node.isType(this._kind);
    }

    public static final boolean isType(int kind) {
        switch (kind) {
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 17: 
            case 22: {
                return false;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public final int kind() {
        return this._kind;
    }

    public boolean remove() {
        return false;
    }

    public String toLiteral(Object value) {
        this._repository._ER.internalError("invalid use of toLiteral() on type ".concat(String.valueOf(Node.typeName(this._kind))));
        return null;
    }

    public Type trueType() {
        if (this.isType()) {
            return (Type)((Object)this);
        }
        this._repository._ER.internalError("invalid call to trueType() on ".concat(String.valueOf(this.typeName())));
        return null;
    }

    public String typeName() {
        return Node.typeName(this._kind);
    }

    public static String typeName(int kind) {
        switch (kind) {
            case 0: {
                return "none";
            }
            case 7: {
                return "operation";
            }
            case 2: {
                return "attribute";
            }
            case 5: {
                return "interface";
            }
            case 14: {
                return "string";
            }
            case 9: {
                return "alias";
            }
            case 10: {
                return "struct";
            }
            case 15: {
                return "sequence";
            }
            case 16: {
                return "array";
            }
            case 12: {
                return "enum";
            }
            case 3: {
                return "constant";
            }
            case 4: {
                return "exception";
            }
            case 6: {
                return "module";
            }
            case 11: {
                return "union";
            }
            case 20: {
                return "value";
            }
            case 21: {
                return "valuebox";
            }
            case 22: {
                return "valuemember";
            }
            case 23: {
                return "native";
            }
            case 18: {
                return "wstring";
            }
            case 17: {
                return "repository";
            }
            case 19: {
                return "fixed";
            }
            case 24: {
                return "enumerated name";
            }
        }
        return "<UNKNOWN TYPE>";
    }
}

