/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.AdapterImpl;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.ProtocolManager;
import com.visigenic.vbroker.util.DaemonThread;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;

class NormalAdapterListener
implements AdapterImpl.AdapterListener,
Runnable,
OrbObject {
    private ORB _orb;
    private Thread _listenerThread;
    private AdapterImpl _adapter;
    private ProtocolManager.Protocol _protocol;
    private ConnectionFactory.Listener _listener;
    private boolean _shutdown = false;

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        this._adapter = (AdapterImpl)objectArray[0];
    }

    public void listen(Adapter adapter, TaggedProfile taggedProfile) {
        this._protocol = this._orb.protocolManager().getProtocol(taggedProfile);
        if (this._protocol == null) {
            throw new OBJ_ADAPTER("Unknown protocol: " + taggedProfile);
        }
        this._listener = this._protocol.connectionFactory().listen(taggedProfile);
        this._listenerThread = new DaemonThread(this);
        this._listenerThread.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this._shutdown) {
                        return;
                    }
                    Connection connection = this._listener.accept();
                    if (this._orb.debug) {
                        this._orb.println("NormalAdapterListener: new connection: " + connection);
                    }
                    this._adapter.newConnection(connection);
                }
            }
            catch (SystemException systemException) {
                if (this._shutdown) {
                    return;
                }
                if (this._orb.debug) {
                    this._orb.println("NormalAdapterListener caught exception: " + systemException);
                    systemException.printStackTrace();
                }
                this._adapter.detachAgedConnection();
                continue;
            }
            break;
        }
    }

    public void connectionCompleted(Connection connection) {
    }

    public void shutdown() {
        this._shutdown = true;
        if (!this._orb.runningJDK_1_1) {
            return;
        }
        if (this._orb.debug) {
            this._orb.println("NormalAdapterListener shut down");
        }
        if (this._listenerThread != null) {
            this._listenerThread.interrupt();
        }
        this._listener.destroy();
    }

    public TaggedProfile listenEndpoint() {
        return this._listener.listenEndpoint();
    }

    NormalAdapterListener() {
    }
}

