/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IIOP_1_1.ProfileBodyHelper;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.Delegate;
import com.visigenic.vbroker.orb.GiopConnectionFactory;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.GiopProtocolAdapter;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.ProtocolAdapter;
import com.visigenic.vbroker.orb.ProtocolManager;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;

public class IiopProtocolImpl
implements ProtocolManager.Profile,
IiopProtocol,
OrbObject {
    private ORB _orb;
    private Hashtable _components = new Hashtable();
    private int IIOP_TAG = 0;
    private GiopConnectionFactory _giopConnectionFactory;
    private ConnectionFactory _connectionFactory;

    public void init(ORB oRB, java.lang.Object[] objectArray) {
        this._orb = oRB;
        String string = this._orb.getString("com.visigenic.vbroker.orb.iiopConnectionFactory");
        if (string != null) {
            this._orb.updateClass(30, string);
        }
    }

    public boolean supports(IOR iOR) {
        int n = 0;
        while (n < iOR.profiles.length) {
            if (iOR.profiles[n].tag == this.IIOP_TAG) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean supports(int n) {
        return n == this.IIOP_TAG;
    }

    public void addComponent(int n, ProtocolManager.Profile.Component component) {
        this._components.put(new Integer(n), component);
    }

    public ProtocolManager.Profile.Component removeComponent(int n) {
        return (ProtocolManager.Profile.Component)this._components.get(new Integer(n));
    }

    public Enumeration components() {
        return this._components.elements();
    }

    public ProtocolManager.Protocol getProtocol(TaggedProfile taggedProfile) {
        ProfileBody profileBody = this.profileBody(taggedProfile);
        if (profileBody.iiop_version.major != 1) {
            throw new INV_OBJREF("Unsupported IIOP major version: " + profileBody.iiop_version.major);
        }
        if (profileBody.iiop_version.minor == 0) {
            return this;
        }
        if (profileBody.iiop_version.minor == 1) {
            int n = 0;
            while (n < profileBody.components.length) {
                ProtocolManager.Protocol protocol = (ProtocolManager.Protocol)this._components.get(new Integer(profileBody.components[n].tag));
                if (protocol != null) {
                    return protocol;
                }
                ++n;
            }
            return this;
        }
        throw new INV_OBJREF("Unknown IIOP version: " + profileBody.iiop_version);
    }

    public int port(ProfileBody profileBody) {
        int n = profileBody.port;
        if (n < 0) {
            n += 65536;
        }
        return n;
    }

    public ProfileBody profileBody(TaggedProfile taggedProfile) {
        if (taggedProfile.tag != this.IIOP_TAG) {
            throw new BAD_PARAM("Invalid tagged profile: " + taggedProfile);
        }
        GiopInputStream giopInputStream = this._orb.newGiopInputStream(taggedProfile.profile_data);
        giopInputStream.byteOrder(giopInputStream.read_boolean());
        return ProfileBodyHelper.read(giopInputStream);
    }

    public TaggedProfile taggedProfile(ProfileBody profileBody) {
        GiopOutputStream giopOutputStream = this._orb.newGiopOutputStream();
        giopOutputStream.byteOrder(false);
        giopOutputStream.write_boolean(false);
        ProfileBodyHelper.write(giopOutputStream, profileBody);
        byte[] byArray = giopOutputStream.toByteArray();
        TaggedProfile taggedProfile = new TaggedProfile(this.IIOP_TAG, byArray);
        return taggedProfile;
    }

    public byte[] objectKey(TaggedProfile taggedProfile) {
        return this.profileBody((TaggedProfile)taggedProfile).object_key;
    }

    public Delegate createStubDelegate(Object object, IOR iOR) {
        java.lang.Object[] objectArray = new java.lang.Object[]{iOR, object, this};
        return (Delegate)this._orb.create(1, objectArray);
    }

    public ConnectionFactory connectionFactory() {
        if (this._connectionFactory == null) {
            IiopProtocolImpl iiopProtocolImpl = this;
            synchronized (iiopProtocolImpl) {
                if (this._connectionFactory == null) {
                    this._connectionFactory = (ConnectionFactory)this._orb.create(30, this);
                }
            }
        }
        return this._connectionFactory;
    }

    public ProtocolAdapter createProtocolAdapter(Adapter adapter) {
        return new GiopProtocolAdapter(this._orb, adapter, this);
    }

    public GiopConnectionFactory giopConnectionFactory() {
        if (this._giopConnectionFactory == null) {
            IiopProtocolImpl iiopProtocolImpl = this;
            synchronized (iiopProtocolImpl) {
                if (this._giopConnectionFactory == null) {
                    this._giopConnectionFactory = (GiopConnectionFactory)this._orb.create(28, this);
                }
            }
        }
        return this._giopConnectionFactory;
    }

    public String prettyPrint(TaggedProfile taggedProfile) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        ProfileBody profileBody = this.profileBody(taggedProfile);
        stringBuffer.append("IIOP Profile:" + string);
        stringBuffer.append("    version: " + profileBody.iiop_version.major + "." + profileBody.iiop_version.minor + string);
        stringBuffer.append("    host: " + profileBody.host + string);
        stringBuffer.append("    port: " + this.port(profileBody) + string);
        stringBuffer.append("    Object Key: " + this._orb.toObjectId(profileBody.object_key) + string);
        return stringBuffer.toString();
    }
}

