/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ir;

import com.visigenic.vbroker.ir.ArrayDefImpl;
import com.visigenic.vbroker.ir.Contained;
import com.visigenic.vbroker.ir.ContainerImpl;
import com.visigenic.vbroker.ir.IrGui;
import com.visigenic.vbroker.ir.PrimitiveDef;
import com.visigenic.vbroker.ir.PrimitiveDefImpl;
import com.visigenic.vbroker.ir.SequenceDefImpl;
import com.visigenic.vbroker.ir.StringDefImpl;
import com.visigenic.vbroker.ir.Visitor;
import com.visigenic.vbroker.ir.WstringDefImpl;
import com.visigenic.vbroker.ir._tie_ArrayDef;
import com.visigenic.vbroker.ir._tie_PrimitiveDef;
import com.visigenic.vbroker.ir._tie_SequenceDef;
import com.visigenic.vbroker.ir._tie_StringDef;
import com.visigenic.vbroker.ir._tie_WstringDef;
import com.visigenic.vbroker.irtx.Repository;
import com.visigenic.vbroker.irtx.RepositoryOperations;
import com.visigenic.vbroker.irtx._tie_Repository;
import com.visigenic.vbroker.tools.ir.DefinitionNotFound;
import com.visigenic.vbroker.tools.ir.FileNotFound;
import com.visigenic.vbroker.tools.ir.Language;
import com.visigenic.vbroker.tools.ir.ReadException;
import com.visigenic.vbroker.tools.ir.RepositoryManager;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.BOA;
import org.omg.CORBA.Container;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.PrimitiveKindHelper;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.StringDef;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.WstringDef;

public class RepositoryImpl
extends ContainerImpl
implements RepositoryOperations {
    private PrimitiveDef[] _primitives;
    private Dictionary _ids = new Hashtable();
    private String _saveFileName;
    private boolean _doingTransaction = false;
    private boolean _doingLoad = false;
    private RepositoryManager _manager;
    private PrintStream _out;
    private Language _language = Language.Idl;

    private void println(Object object) {
        this._out.println(object);
    }

    private RepositoryImpl(BOA bOA, RepositoryManager repositoryManager) {
        super(bOA, DefinitionKind.dk_Repository);
        this._out = System.out;
        this._manager = repositoryManager;
        try {
            int n = PrimitiveKindHelper.type().member_count();
            this._primitives = new PrimitiveDef[n];
            int n2 = 0;
            while (n2 < n) {
                PrimitiveKind primitiveKind = PrimitiveKind.from_int(n2);
                this._primitives[n2] = new _tie_PrimitiveDef(new PrimitiveDefImpl(this._boa, primitiveKind));
                bOA.obj_is_ready(this._primitives[n2]);
                ++n2;
            }
            return;
        }
        catch (BadKind badKind) {
            throw new INTF_REPOS(badKind.toString());
        }
    }

    String absolute_name() {
        return "";
    }

    Container defined_in() {
        return (org.omg.CORBA.Repository)this.tie();
    }

    org.omg.CORBA.Repository containing_repository() {
        return (org.omg.CORBA.Repository)this.tie();
    }

    public org.omg.CORBA.Contained lookup_id(String string) {
        return (org.omg.CORBA.Contained)this._ids.get(string);
    }

    public void private_add_id(Contained contained) {
        this._ids.put(contained.id(), contained);
    }

    public synchronized void private_remove_id(Contained contained) {
        this._ids.remove(contained.id());
    }

    public org.omg.CORBA.PrimitiveDef get_primitive(PrimitiveKind primitiveKind) {
        return this._primitives[primitiveKind.value()];
    }

    public StringDef create_string(int n) {
        if (n == 0) {
            throw new INTERNAL("Cannot create string with bound 0");
        }
        StringDefImpl stringDefImpl = new StringDefImpl(this._boa, n);
        _tie_StringDef _tie_StringDef2 = new _tie_StringDef(stringDefImpl);
        stringDefImpl.tie(_tie_StringDef2);
        return _tie_StringDef2;
    }

    public WstringDef create_wstring(int n) {
        if (n == 0) {
            throw new INTERNAL("Cannot create wstring with bound 0");
        }
        WstringDefImpl wstringDefImpl = new WstringDefImpl(this._boa, n);
        _tie_WstringDef _tie_WstringDef2 = new _tie_WstringDef(wstringDefImpl);
        wstringDefImpl.tie(_tie_WstringDef2);
        return _tie_WstringDef2;
    }

    public SequenceDef create_sequence(int n, IDLType iDLType) {
        ContainerImpl.check(iDLType);
        SequenceDefImpl sequenceDefImpl = new SequenceDefImpl(this._boa, n, iDLType);
        _tie_SequenceDef _tie_SequenceDef2 = new _tie_SequenceDef(sequenceDefImpl);
        sequenceDefImpl.tie(_tie_SequenceDef2);
        return _tie_SequenceDef2;
    }

    public ArrayDef create_array(int n, IDLType iDLType) {
        ContainerImpl.check(iDLType);
        if (n == 0) {
            throw new INTERNAL("Cannot create array of length 0");
        }
        ArrayDefImpl arrayDefImpl = new ArrayDefImpl(this._boa, n, iDLType);
        _tie_ArrayDef _tie_ArrayDef2 = new _tie_ArrayDef(arrayDefImpl);
        arrayDefImpl.tie(_tie_ArrayDef2);
        return _tie_ArrayDef2;
    }

    public boolean begin() {
        if (this._doingLoad) {
            return true;
        }
        if (this._saveFileName == null) {
            return true;
        }
        if (this._doingTransaction) {
            this.println("Repository::begin detected incomplete transation");
            this.rollback();
        }
        this._doingTransaction = true;
        this.doSave(this._saveFileName);
        return true;
    }

    public boolean rollback() {
        if (this._doingLoad) {
            return true;
        }
        if (this._saveFileName == null) {
            return true;
        }
        if (!this._doingTransaction) {
            this.println("Repository::rollback transaction not begun");
            return false;
        }
        this.println("Repository::rollback emptying the repository");
        org.omg.CORBA.Contained[] containedArray = this.contents(DefinitionKind.dk_all, true);
        int n = 0;
        while (n < containedArray.length) {
            containedArray[n].destroy();
            ++n;
        }
        this.println("Repository::rollback reloading the repository");
        this._doingLoad = true;
        this.doLoad(this._saveFileName);
        this._doingLoad = false;
        this._doingTransaction = false;
        return true;
    }

    public boolean commit() {
        if (this._doingLoad) {
            return true;
        }
        if (this._saveFileName == null) {
            return true;
        }
        if (!this._doingTransaction) {
            this.println("Repository::commit transaction not begun");
            return false;
        }
        this.println("Repository::commit saving the repository");
        this.doSave(this._saveFileName);
        this._doingTransaction = false;
        return true;
    }

    String saveFileName() {
        return this._saveFileName;
    }

    void doLookup(String string, PrintStream printStream) {
        this.println("Looking up: \"" + string + "\"");
        try {
            printStream.print(this._manager.write_one(string, this._language));
            return;
        }
        catch (DefinitionNotFound definitionNotFound) {
            this.println("Invalid name: \"" + string + "\"");
            return;
        }
        catch (SystemException systemException) {
            this.println("Failure looking up: \"" + string + "\"");
            this.println(systemException);
            return;
        }
    }

    void doSave(String string) {
        this.println("Saving to: " + string);
        File file = new File(string);
        if (file.exists() && !file.canWrite()) {
            this.println("The file is not writable: " + string);
            return;
        }
        this._saveFileName = string;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.println("/*");
            printStream.println("  File : " + file);
            printStream.println("  Date : " + new Date());
            printStream.println("  User : " + System.getProperty("user.name"));
            printStream.println("  Dir  : " + System.getProperty("user.dir"));
            printStream.println("*/");
            printStream.println(this._manager.write_all(Language.Idl));
            new FileOutputStream(file).write(byteArrayOutputStream.toByteArray());
            this.println("The Interface Repository was saved to: " + file);
            return;
        }
        catch (Exception exception) {
            this.println("Error occured while saving to: " + string);
            this.println(exception);
            this._saveFileName = null;
            return;
        }
    }

    public static String format(ReadException readException) {
        if (readException.line_number == 0) {
            return String.valueOf(readException.file_name) + ": " + readException.message;
        }
        return String.valueOf(readException.file_name) + ":" + readException.line_number + ":" + readException.message;
    }

    void doLoad(String string) {
        try {
            this._manager.read_file(string, false);
            return;
        }
        catch (ReadException readException) {
            this.println(RepositoryImpl.format(readException));
            return;
        }
        catch (FileNotFound fileNotFound) {
            this.println("Could not open file: " + string);
            return;
        }
        catch (SystemException systemException) {
            this.println("An exception occured while reading file: " + string + "\n\t" + systemException);
            return;
        }
    }

    public void doInit(String string) {
        if (string != null) {
            this._saveFileName = string;
            this._doingLoad = true;
            this.doLoad(string);
            this._doingLoad = false;
        }
    }

    void doExit() {
        try {
            this.tie()._boa().deactivate_obj(this.tie());
        }
        catch (SystemException systemException) {
            systemException.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    void setLanguage(Language language) {
        this._language = language;
    }

    public static Repository create(BOA bOA, RepositoryManager repositoryManager, String string, RepositoryImpl[] repositoryImplArray) {
        repositoryImplArray[0] = new RepositoryImpl(bOA, repositoryManager);
        _tie_Repository _tie_Repository2 = string == null ? new _tie_Repository(repositoryImplArray[0]) : new _tie_Repository(repositoryImplArray[0], string);
        repositoryImplArray[0].tie(_tie_Repository2, false);
        bOA.obj_is_ready(_tie_Repository2);
        return _tie_Repository2;
    }

    public void doGui() {
        IrGui irGui = new IrGui("Interface Repository: \"" + this.tie()._object_name() + "\"", this);
        this._out = irGui.out();
        irGui.show();
    }

    public void doConsole() {
        DataInputStream dataInputStream = new DataInputStream(System.in);
        while (true) {
            try {
                while (true) {
                    String string;
                    System.out.print("-> ");
                    System.out.flush();
                    if (System.getProperty("VM_THREAD_BUG") != null) {
                        while (dataInputStream.available() == 0) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if ((string = dataInputStream.readLine()).startsWith("l")) {
                        this.doLookup(string.substring(1, string.length()), System.out);
                        continue;
                    }
                    if (string.startsWith("s")) {
                        if (this.saveFileName() == null) {
                            System.out.println("Must save [a]s first...");
                            continue;
                        }
                        this.doSave(this.saveFileName());
                        continue;
                    }
                    if (string.startsWith("a")) {
                        this.doSave(string.substring(1, string.length()));
                        continue;
                    }
                    if (string.startsWith("r")) {
                        this.doLoad(string.substring(1, string.length()));
                        continue;
                    }
                    if (string.startsWith("q")) {
                        System.out.println("Quitting...");
                        this.doExit();
                    }
                    System.out.println("Commands: l<idl-name>   [l]ookup\n          s             [s]ave\n          a<file-name>  save [a]s\n          r<file-name>  read from\n          q             [q]uit\n");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public boolean traverse(Visitor visitor) {
        if (super.traverse(visitor)) {
            return true;
        }
        throw new INTERNAL("Could not visit all definitions! Unresolvable dependencies exist");
    }

    public void destroy() {
        throw new INTERNAL("Cannot destroy repository");
    }
}

