/*
 *  Program type:   Embedded Static SQL
 *
 *  Description:
 *		This program should be run in conjunction with stat12.
 *		It adds some sales records, in order to trigger the event
 *		that stat12 is waiting for.
 */

#include "example.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

EXEC SQL	
	BEGIN DECLARE SECTION;
EXEC SQL
	SET DATABASE empdb = "employee.gdb";
EXEC SQL	
	END DECLARE SECTION;

int main(ARG(int, argc), ARG(char **, argv))
ARGLIST(int argc)
ARGLIST(char **argv)
{
        EXEC SQL
		CONNECT empdb;
	EXEC SQL
		SET TRANSACTION;

	/* Clean-up. */
	EXEC SQL
		DELETE FROM sales WHERE po_number LIKE "VNEW%";
	EXEC SQL
		COMMIT;

	/* Add batch 1. */
	EXEC SQL
		SET TRANSACTION;
	printf("Stat12t:  Adding VNEW1\n");
	EXEC SQL
		INSERT INTO sales (po_number, cust_no, order_status, total_value)
		VALUES ('VNEW1', 1015, 'new', 0);
	printf("Stat12t:  Adding VNEW2\n");
	EXEC SQL
		INSERT INTO sales (po_number, cust_no, order_status, total_value)
		VALUES ('VNEW2', 1015, 'new', 0);
	printf("Stat12t:  Adding VNEW3\n");
	EXEC SQL
		INSERT INTO sales (po_number, cust_no, order_status, total_value)
		VALUES ('VNEW3', 1015, 'new', 0);
	EXEC SQL
		COMMIT;

	/* Add batch 2. */
	EXEC SQL
		SET TRANSACTION;
	printf("Stat12t:  Adding VNEW4\n");
	EXEC SQL
		INSERT INTO sales (po_number, cust_no, order_status, total_value)
		VALUES ('VNEW4', 1015, 'new', 0);
	EXEC SQL
		COMMIT RELEASE;

        exit(0);

}
