
{*******************************************************}
{                                                       }
{       Borland Delphi Runtime Library                  }
{       ActiveX / OLE 2 Interface Unit                  }
{                                                       }
{       Copyright (C) 1997,99 Inprise Corporation       }
{                                                       }
{*******************************************************}

unit ActiveX;

interface

uses Windows, Messages;

(*$HPPEMIT '' *)
(*$HPPEMIT '#include <olectl.h>' *)
(*$HPPEMIT '#include <docobj.H>' *)
(*$HPPEMIT '#include <oleauto.h>' *)
(*$HPPEMIT '#include <propidl.h>' *) // WIN2K
(*$HPPEMIT '' *)
(*$HPPEMIT '' *)

{ Do not WEAKPACKAGE this unit.
  This unit requires startup code to initialize constants. }

const

{ from WTYPES.H }
  {$EXTERNALSYM MEMCTX_TASK}
  MEMCTX_TASK      = 1;
  {$EXTERNALSYM MEMCTX_SHARED}
  MEMCTX_SHARED    = 2;
  {$EXTERNALSYM MEMCTX_MACSYSTEM}
  MEMCTX_MACSYSTEM = 3;
  {$EXTERNALSYM MEMCTX_UNKNOWN}
  MEMCTX_UNKNOWN   = -1;
  {$EXTERNALSYM MEMCTX_SAME}
  MEMCTX_SAME      = -2;

  {$EXTERNALSYM ROTFLAGS_REGISTRATIONKEEPSALIVE}
  ROTFLAGS_REGISTRATIONKEEPSALIVE = 1;
  {$EXTERNALSYM ROTFLAGS_ALLOWANYCLIENT}
  ROTFLAGS_ALLOWANYCLIENT         = 2;

  {$EXTERNALSYM CLSCTX_INPROC_SERVER}
  CLSCTX_INPROC_SERVER     = 1;
  {$EXTERNALSYM CLSCTX_INPROC_HANDLER}
  CLSCTX_INPROC_HANDLER    = 2;
  {$EXTERNALSYM CLSCTX_LOCAL_SERVER}
  CLSCTX_LOCAL_SERVER      = 4;
  {$EXTERNALSYM CLSCTX_INPROC_SERVER16}
  CLSCTX_INPROC_SERVER16   = 8;
  {$EXTERNALSYM CLSCTX_REMOTE_SERVER}
  CLSCTX_REMOTE_SERVER     = $10;
  {$EXTERNALSYM CLSCTX_INPROC_HANDLER16}
  CLSCTX_INPROC_HANDLER16  = $20;
  {$EXTERNALSYM CLSCTX_INPROC_SERVERX86}
  CLSCTX_INPROC_SERVERX86  = $40;
  {$EXTERNALSYM CLSCTX_INPROC_HANDLERX86}
  CLSCTX_INPROC_HANDLERX86 = $80;

{ from OBJBASE }
  {$EXTERNALSYM CLSCTX_ALL}
  CLSCTX_ALL    = CLSCTX_INPROC_SERVER or CLSCTX_INPROC_HANDLER or
      CLSCTX_LOCAL_SERVER;
  {$EXTERNALSYM CLSCTX_INPROC}
  CLSCTX_INPROC = CLSCTX_INPROC_SERVER or CLSCTX_INPROC_HANDLER;
  {$EXTERNALSYM CLSCTX_SERVER}
  CLSCTX_SERVER = CLSCTX_INPROC_SERVER or CLSCTX_LOCAL_SERVER;

  {$EXTERNALSYM COM_RIGHTS_EXECUTE}
  COM_RIGHTS_EXECUTE = 1;

{ from WTYPES.H }
  {$EXTERNALSYM MSHLFLAGS_NORMAL}
  MSHLFLAGS_NORMAL      = 0;
  {$EXTERNALSYM MSHLFLAGS_TABLESTRONG}
  MSHLFLAGS_TABLESTRONG = 1;
  {$EXTERNALSYM MSHLFLAGS_TABLEWEAK}
  MSHLFLAGS_TABLEWEAK   = 2;
  {$EXTERNALSYM MSHLFLAGS_NOPING}
  MSHLFLAGS_NOPING      = 4;

  {$EXTERNALSYM MSHCTX_LOCAL}
  MSHCTX_LOCAL            = 0;
  {$EXTERNALSYM MSHCTX_NOSHAREDMEM}
  MSHCTX_NOSHAREDMEM      = 1;
  {$EXTERNALSYM MSHCTX_DIFFERENTMACHINE}
  MSHCTX_DIFFERENTMACHINE = 2;
  {$EXTERNALSYM MSHCTX_INPROC}
  MSHCTX_INPROC           = 3;

  {$EXTERNALSYM DVASPECT_CONTENT}
  DVASPECT_CONTENT   = 1;
  {$EXTERNALSYM DVASPECT_THUMBNAIL}
  DVASPECT_THUMBNAIL = 2;
  {$EXTERNALSYM DVASPECT_ICON}
  DVASPECT_ICON      = 4;
  {$EXTERNALSYM DVASPECT_DOCPRINT}
  DVASPECT_DOCPRINT  = 8;

  {$EXTERNALSYM STGC_DEFAULT}
  STGC_DEFAULT                            = 0;
  {$EXTERNALSYM STGC_OVERWRITE}
  STGC_OVERWRITE                          = 1;
  {$EXTERNALSYM STGC_ONLYIFCURRENT}
  STGC_ONLYIFCURRENT                      = 2;
  {$EXTERNALSYM STGC_DANGEROUSLYCOMMITMERELYTODISKCACHE}
  STGC_DANGEROUSLYCOMMITMERELYTODISKCACHE = 4;

  {$EXTERNALSYM STGMOVE_MOVE}
  STGMOVE_MOVE        = 0;
  {$EXTERNALSYM STGMOVE_COPY}
  STGMOVE_COPY        = 1;
  {$EXTERNALSYM STGMOVE_SHALLOWCOPY}
  STGMOVE_SHALLOWCOPY = 2;

  {$EXTERNALSYM STATFLAG_DEFAULT}
  STATFLAG_DEFAULT = 0;
  {$EXTERNALSYM STATFLAG_NONAME}
  STATFLAG_NONAME  = 1;

{ from OBJIDL.H }
  {$EXTERNALSYM BIND_MAYBOTHERUSER}
  BIND_MAYBOTHERUSER     = 1;
  {$EXTERNALSYM BIND_JUSTTESTEXISTENCE}
  BIND_JUSTTESTEXISTENCE = 2;

  {$EXTERNALSYM MKSYS_NONE}
  MKSYS_NONE             = 0;
  {$EXTERNALSYM MKSYS_GENERICCOMPOSITE}
  MKSYS_GENERICCOMPOSITE = 1;
  {$EXTERNALSYM MKSYS_FILEMONIKER}
  MKSYS_FILEMONIKER      = 2;
  {$EXTERNALSYM MKSYS_ANTIMONIKER}
  MKSYS_ANTIMONIKER      = 3;
  {$EXTERNALSYM MKSYS_ITEMMONIKER}
  MKSYS_ITEMMONIKER      = 4;
  {$EXTERNALSYM MKSYS_POINTERMONIKER}
  MKSYS_POINTERMONIKER   = 5;

  {$EXTERNALSYM MKRREDUCE_ONE}
  MKRREDUCE_ONE         = 3 shl 16;
  {$EXTERNALSYM MKRREDUCE_TOUSER}
  MKRREDUCE_TOUSER      = 2 shl 16;
  {$EXTERNALSYM MKRREDUCE_THROUGHUSER}
  MKRREDUCE_THROUGHUSER = 1 shl 16;
  {$EXTERNALSYM MKRREDUCE_ALL}
  MKRREDUCE_ALL         = 0;

  {$EXTERNALSYM STGTY_STORAGE}
  STGTY_STORAGE   = 1;
  {$EXTERNALSYM STGTY_STREAM}
  STGTY_STREAM    = 2;
  {$EXTERNALSYM STGTY_LOCKBYTES}
  STGTY_LOCKBYTES = 3;
  {$EXTERNALSYM STGTY_PROPERTY}
  STGTY_PROPERTY  = 4;

  {$EXTERNALSYM STREAM_SEEK_SET}
  STREAM_SEEK_SET = 0;
  {$EXTERNALSYM STREAM_SEEK_CUR}
  STREAM_SEEK_CUR = 1;
  {$EXTERNALSYM STREAM_SEEK_END}
  STREAM_SEEK_END = 2;

  {$EXTERNALSYM LOCK_WRITE}
  LOCK_WRITE     = 1;
  {$EXTERNALSYM LOCK_EXCLUSIVE}
  LOCK_EXCLUSIVE = 2;
  {$EXTERNALSYM LOCK_ONLYONCE}
  LOCK_ONLYONCE  = 4;

  {$EXTERNALSYM ADVF_NODATA}
  ADVF_NODATA            = 1;
  {$EXTERNALSYM ADVF_PRIMEFIRST}
  ADVF_PRIMEFIRST        = 2;
  {$EXTERNALSYM ADVF_ONLYONCE}
  ADVF_ONLYONCE          = 4;
  {$EXTERNALSYM ADVF_DATAONSTOP}
  ADVF_DATAONSTOP        = 64;
  {$EXTERNALSYM ADVFCACHE_NOHANDLER}
  ADVFCACHE_NOHANDLER    = 8;
  {$EXTERNALSYM ADVFCACHE_FORCEBUILTIN}
  ADVFCACHE_FORCEBUILTIN = 16;
  {$EXTERNALSYM ADVFCACHE_ONSAVE}
  ADVFCACHE_ONSAVE       = 32;

  {$EXTERNALSYM TYMED_HGLOBAL}
  TYMED_HGLOBAL  = 1;
  {$EXTERNALSYM TYMED_FILE}
  TYMED_FILE     = 2;
  {$EXTERNALSYM TYMED_ISTREAM}
  TYMED_ISTREAM  = 4;
  {$EXTERNALSYM TYMED_ISTORAGE}
  TYMED_ISTORAGE = 8;
  {$EXTERNALSYM TYMED_GDI}
  TYMED_GDI      = 16;
  {$EXTERNALSYM TYMED_MFPICT}
  TYMED_MFPICT   = 32;
  {$EXTERNALSYM TYMED_ENHMF}
  TYMED_ENHMF    = 64;
  {$EXTERNALSYM TYMED_NULL}
  TYMED_NULL     = 0;

  {$EXTERNALSYM DATADIR_GET}
  DATADIR_GET = 1;
  {$EXTERNALSYM DATADIR_SET}
  DATADIR_SET = 2;

  {$EXTERNALSYM CALLTYPE_TOPLEVEL}
  CALLTYPE_TOPLEVEL             = 1;
  {$EXTERNALSYM CALLTYPE_NESTED}
  CALLTYPE_NESTED               = 2;
  {$EXTERNALSYM CALLTYPE_ASYNC}
  CALLTYPE_ASYNC                = 3;
  {$EXTERNALSYM CALLTYPE_TOPLEVEL_CALLPENDING}
  CALLTYPE_TOPLEVEL_CALLPENDING = 4;
  {$EXTERNALSYM CALLTYPE_ASYNC_CALLPENDING}
  CALLTYPE_ASYNC_CALLPENDING    = 5;

  {$EXTERNALSYM SERVERCALL_ISHANDLED}
  SERVERCALL_ISHANDLED  = 0;
  {$EXTERNALSYM SERVERCALL_REJECTED}
  SERVERCALL_REJECTED   = 1;
  {$EXTERNALSYM SERVERCALL_RETRYLATER}
  SERVERCALL_RETRYLATER = 2;

  {$EXTERNALSYM PENDINGTYPE_TOPLEVEL}
  PENDINGTYPE_TOPLEVEL = 1;
  {$EXTERNALSYM PENDINGTYPE_NESTED}
  PENDINGTYPE_NESTED   = 2;

  {$EXTERNALSYM PENDINGMSG_CANCELCALL}
  PENDINGMSG_CANCELCALL     = 0;
  {$EXTERNALSYM PENDINGMSG_WAITNOPROCESS}
  PENDINGMSG_WAITNOPROCESS  = 1;
  {$EXTERNALSYM PENDINGMSG_WAITDEFPROCESS}
  PENDINGMSG_WAITDEFPROCESS = 2;

  {$EXTERNALSYM PROPSETFLAG_DEFAULT}
  PROPSETFLAG_DEFAULT   = 0;
  {$EXTERNALSYM PROPSETFLAG_NONSIMPLE}
  PROPSETFLAG_NONSIMPLE	= 1;
  {$EXTERNALSYM PROPSETFLAG_ANSI}
  PROPSETFLAG_ANSI	= 2;

{ from OBJBASE.H }
  {$EXTERNALSYM REGCLS_SINGLEUSE}
  REGCLS_SINGLEUSE      = 0;
  {$EXTERNALSYM REGCLS_MULTIPLEUSE}
  REGCLS_MULTIPLEUSE    = 1;
  {$EXTERNALSYM REGCLS_MULTI_SEPARATE}
  REGCLS_MULTI_SEPARATE = 2;
  {$EXTERNALSYM REGCLS_SUSPENDED}
  REGCLS_SUSPENDED      = 4;

  {$EXTERNALSYM MARSHALINTERFACE_MIN}
  MARSHALINTERFACE_MIN = 500;

  {$EXTERNALSYM CWCSTORAGENAME}
  CWCSTORAGENAME = 32;

  {$EXTERNALSYM STGM_DIRECT}
  STGM_DIRECT           = $00000000;
  {$EXTERNALSYM STGM_TRANSACTED}
  STGM_TRANSACTED       = $00010000;
  {$EXTERNALSYM STGM_SIMPLE}
  STGM_SIMPLE           = $08000000;

  {$EXTERNALSYM STGM_READ}
  STGM_READ             = $00000000;
  {$EXTERNALSYM STGM_WRITE}
  STGM_WRITE            = $00000001;
  {$EXTERNALSYM STGM_READWRITE}
  STGM_READWRITE        = $00000002;

  {$EXTERNALSYM STGM_SHARE_DENY_NONE}
  STGM_SHARE_DENY_NONE  = $00000040;
  {$EXTERNALSYM STGM_SHARE_DENY_READ}
  STGM_SHARE_DENY_READ  = $00000030;
  {$EXTERNALSYM STGM_SHARE_DENY_WRITE}
  STGM_SHARE_DENY_WRITE = $00000020;
  {$EXTERNALSYM STGM_SHARE_EXCLUSIVE}
  STGM_SHARE_EXCLUSIVE  = $00000010;

  {$EXTERNALSYM STGM_PRIORITY}
  STGM_PRIORITY         = $00040000;
  {$EXTERNALSYM STGM_DELETEONRELEASE}
  STGM_DELETEONRELEASE  = $04000000;
  {$EXTERNALSYM STGM_NOSCRATCH}
  STGM_NOSCRATCH        = $00100000;

  {$EXTERNALSYM STGM_CREATE}
  STGM_CREATE           = $00001000;
  {$EXTERNALSYM STGM_CONVERT}
  STGM_CONVERT          = $00020000;
  {$EXTERNALSYM STGM_FAILIFTHERE}
  STGM_FAILIFTHERE      = $00000000;

  {$EXTERNALSYM FADF_AUTO}
  FADF_AUTO      = $0001;  { array is allocated on the stack }
  {$EXTERNALSYM FADF_STATIC}
  FADF_STATIC    = $0002;  { array is staticly allocated }
  {$EXTERNALSYM FADF_EMBEDDED}
  FADF_EMBEDDED  = $0004;  { array is embedded in a structure }
  {$EXTERNALSYM FADF_FIXEDSIZE}
  FADF_FIXEDSIZE = $0010;  { array may not be resized or reallocated }
  {$EXTERNALSYM FADF_BSTR}
  FADF_BSTR      = $0100;  { an array of BSTRs }
  {$EXTERNALSYM FADF_UNKNOWN}
  FADF_UNKNOWN   = $0200;  { an array of IUnknown }
  {$EXTERNALSYM FADF_DISPATCH}
  FADF_DISPATCH  = $0400;  { an array of IDispatch }
  {$EXTERNALSYM FADF_VARIANT}
  FADF_VARIANT   = $0800;  { an array of VARIANTs }
  {$EXTERNALSYM FADF_RESERVED}
  FADF_RESERVED  = $F0E8;  { bits reserved for future use }

{ from WTYPES.H }
{ VARENUM usage key,

    [V] - may appear in a VARIANT
    [T] - may appear in a TYPEDESC
    [P] - may appear in an OLE property set
    [S] - may appear in a Safe Array }

  {$EXTERNALSYM VT_EMPTY}
  VT_EMPTY           = 0;   { [V]   [P]  nothing                     }
  {$EXTERNALSYM VT_NULL}
  VT_NULL            = 1;   { [V]        SQL style Null              }
  {$EXTERNALSYM VT_I2}
  VT_I2              = 2;   { [V][T][P]  2 byte signed int           }
  {$EXTERNALSYM VT_I4}
  VT_I4              = 3;   { [V][T][P]  4 byte signed int           }
  {$EXTERNALSYM VT_R4}
  VT_R4              = 4;   { [V][T][P]  4 byte real                 }
  {$EXTERNALSYM VT_R8}
  VT_R8              = 5;   { [V][T][P]  8 byte real                 }
  {$EXTERNALSYM VT_CY}
  VT_CY              = 6;   { [V][T][P]  currency                    }
  {$EXTERNALSYM VT_DATE}
  VT_DATE            = 7;   { [V][T][P]  date                        }
  {$EXTERNALSYM VT_BSTR}
  VT_BSTR            = 8;   { [V][T][P]  binary string               }
  {$EXTERNALSYM VT_DISPATCH}
  VT_DISPATCH        = 9;   { [V][T]     IDispatch FAR*              }
  {$EXTERNALSYM VT_ERROR}
  VT_ERROR           = 10;  { [V][T]     SCODE                       }
  {$EXTERNALSYM VT_BOOL}
  VT_BOOL            = 11;  { [V][T][P]  True=-1, False=0            }
  {$EXTERNALSYM VT_VARIANT}
  VT_VARIANT         = 12;  { [V][T][P]  VARIANT FAR*                }
  {$EXTERNALSYM VT_UNKNOWN}
  VT_UNKNOWN         = 13;  { [V][T]     IUnknown FAR*               }
  {$EXTERNALSYM VT_DECIMAL}
  VT_DECIMAL         = 14;  { [V][T]   [S]  16 byte fixed point      }

  {$EXTERNALSYM VT_I1}
  VT_I1              = 16;  {    [T]     signed char                 }
  {$EXTERNALSYM VT_UI1}
  VT_UI1             = 17;  {    [T]     unsigned char               }
  {$EXTERNALSYM VT_UI2}
  VT_UI2             = 18;  {    [T]     unsigned short              }
  {$EXTERNALSYM VT_UI4}
  VT_UI4             = 19;  {    [T]     unsigned short              }
  {$EXTERNALSYM VT_I8}
  VT_I8              = 20;  {    [T][P]  signed 64-bit int           }
  {$EXTERNALSYM VT_UI8}
  VT_UI8             = 21;  {    [T]     unsigned 64-bit int         }
  {$EXTERNALSYM VT_INT}
  VT_INT             = 22;  {    [T]     signed machine int          }
  {$EXTERNALSYM VT_UINT}
  VT_UINT            = 23;  {    [T]     unsigned machine int        }
  {$EXTERNALSYM VT_VOID}
  VT_VOID            = 24;  {    [T]     C style void                }
  {$EXTERNALSYM VT_HRESULT}
  VT_HRESULT         = 25;  {    [T]                                 }
  {$EXTERNALSYM VT_PTR}
  VT_PTR             = 26;  {    [T]     pointer type                }
  {$EXTERNALSYM VT_SAFEARRAY}
  VT_SAFEARRAY       = 27;  {    [T]     (use VT_ARRAY in VARIANT)   }
  {$EXTERNALSYM VT_CARRAY}
  VT_CARRAY          = 28;  {    [T]     C style array               }
  {$EXTERNALSYM VT_USERDEFINED}
  VT_USERDEFINED     = 29;  {    [T]     user defined type          }
  {$EXTERNALSYM VT_LPSTR}
  VT_LPSTR           = 30;  {    [T][P]  null terminated string      }
  {$EXTERNALSYM VT_LPWSTR}
  VT_LPWSTR          = 31;  {    [T][P]  wide null terminated string }

  {$EXTERNALSYM VT_FILETIME}
  VT_FILETIME        = 64;  {       [P]  FILETIME                    }
  {$EXTERNALSYM VT_BLOB}
  VT_BLOB            = 65;  {       [P]  Length prefixed bytes       }
  {$EXTERNALSYM VT_STREAM}
  VT_STREAM          = 66;  {       [P]  Name of the stream follows  }
  {$EXTERNALSYM VT_STORAGE}
  VT_STORAGE         = 67;  {       [P]  Name of the storage follows }
  {$EXTERNALSYM VT_STREAMED_OBJECT}
  VT_STREAMED_OBJECT = 68;  {       [P]  Stream contains an object   }
  {$EXTERNALSYM VT_STORED_OBJECT}
  VT_STORED_OBJECT   = 69;  {       [P]  Storage contains an object  }
  {$EXTERNALSYM VT_BLOB_OBJECT}
  VT_BLOB_OBJECT     = 70;  {       [P]  Blob contains an object     }
  {$EXTERNALSYM VT_CF}
  VT_CF              = 71;  {       [P]  Clipboard format            }
  {$EXTERNALSYM VT_CLSID}
  VT_CLSID           = 72;  {       [P]  A Class ID                  }

  {$EXTERNALSYM VT_VECTOR}
  VT_VECTOR        = $1000; {       [P]  simple counted array        }
  {$EXTERNALSYM VT_ARRAY}
  VT_ARRAY         = $2000; { [V]        SAFEARRAY*                  }
  {$EXTERNALSYM VT_BYREF}
  VT_BYREF         = $4000; { [V]                                    }
  {$EXTERNALSYM VT_RESERVED}
  VT_RESERVED      = $8000;
  {$EXTERNALSYM VT_ILLEGAL}
  VT_ILLEGAL       = $ffff;
  {$EXTERNALSYM VT_ILLEGALMASKED}
  VT_ILLEGALMASKED = $0fff;
  {$EXTERNALSYM VT_TYPEMASK}
  VT_TYPEMASK      = $0fff;

type
  {$EXTERNALSYM PROPID}
  PROPID = ULONG;
  PPropID = ^TPropID;
  TPropID = PROPID;

{ from OAIDL.H }

const
  {$EXTERNALSYM TKIND_ENUM}
  TKIND_ENUM      = 0;
  {$EXTERNALSYM TKIND_RECORD}
  TKIND_RECORD    = 1;
  {$EXTERNALSYM TKIND_MODULE}
  TKIND_MODULE    = 2;
  {$EXTERNALSYM TKIND_INTERFACE}
  TKIND_INTERFACE = 3;
  {$EXTERNALSYM TKIND_DISPATCH}
  TKIND_DISPATCH  = 4;
  {$EXTERNALSYM TKIND_COCLASS}
  TKIND_COCLASS   = 5;
  {$EXTERNALSYM TKIND_ALIAS}
  TKIND_ALIAS     = 6;
  {$EXTERNALSYM TKIND_UNION}
  TKIND_UNION     = 7;
  {$EXTERNALSYM TKIND_MAX}
  TKIND_MAX       = 8;

  {$EXTERNALSYM CC_CDECL}
  CC_CDECL       = 1;
  {$EXTERNALSYM CC_PASCAL}
  CC_PASCAL      = 2;
  {$EXTERNALSYM CC_MACPASCAL}
  CC_MACPASCAL   = 3;
  {$EXTERNALSYM CC_STDCALL}
  CC_STDCALL     = 4;
  {$EXTERNALSYM CC_FPFASTCALL}
  CC_FPFASTCALL  = 5;
  {$EXTERNALSYM CC_SYSCALL}
  CC_SYSCALL     = 6;
  {$EXTERNALSYM CC_MPWCDECL}
  CC_MPWCDECL    = 7;
  {$EXTERNALSYM CC_MPWPASCAL}
  CC_MPWPASCAL   = 8;
  {$EXTERNALSYM CC_MAX}
  CC_MAX         = 9;

  {$EXTERNALSYM FUNC_VIRTUAL}
  FUNC_VIRTUAL     = 0;
  {$EXTERNALSYM FUNC_PUREVIRTUAL}
  FUNC_PUREVIRTUAL = 1;
  {$EXTERNALSYM FUNC_NONVIRTUAL}
  FUNC_NONVIRTUAL  = 2;
  {$EXTERNALSYM FUNC_STATIC}
  FUNC_STATIC      = 3;
  {$EXTERNALSYM FUNC_DISPATCH}
  FUNC_DISPATCH    = 4;

  {$EXTERNALSYM INVOKE_FUNC}
  INVOKE_FUNC           = 1;
  {$EXTERNALSYM INVOKE_PROPERTYGET}
  INVOKE_PROPERTYGET    = 2;
  {$EXTERNALSYM INVOKE_PROPERTYPUT}
  INVOKE_PROPERTYPUT    = 4;
  {$EXTERNALSYM INVOKE_PROPERTYPUTREF}
  INVOKE_PROPERTYPUTREF = 8;

  {$EXTERNALSYM VAR_PERINSTANCE}
  VAR_PERINSTANCE = 0;
  {$EXTERNALSYM VAR_STATIC}
  VAR_STATIC      = 1;
  {$EXTERNALSYM VAR_CONST}
  VAR_CONST       = 2;
  {$EXTERNALSYM VAR_DISPATCH}
  VAR_DISPATCH    = 3;

  {$EXTERNALSYM IMPLTYPEFLAG_FDEFAULT}
  IMPLTYPEFLAG_FDEFAULT        = 1;
  {$EXTERNALSYM IMPLTYPEFLAG_FSOURCE}
  IMPLTYPEFLAG_FSOURCE         = 2;
  {$EXTERNALSYM IMPLTYPEFLAG_FRESTRICTED}
  IMPLTYPEFLAG_FRESTRICTED     = 4;
  {$EXTERNALSYM IMPLTYPEFLAG_FDEFAULTVTABLE}
  IMPLTYPEFLAG_FDEFAULTVTABLE    = 8;

  {$EXTERNALSYM TYPEFLAG_FAPPOBJECT}
  TYPEFLAG_FAPPOBJECT     = $0001;
  {$EXTERNALSYM TYPEFLAG_FCANCREATE}
  TYPEFLAG_FCANCREATE     = $0002;
  {$EXTERNALSYM TYPEFLAG_FLICENSED}
  TYPEFLAG_FLICENSED      = $0004;
  {$EXTERNALSYM TYPEFLAG_FPREDECLID}
  TYPEFLAG_FPREDECLID     = $0008;
  {$EXTERNALSYM TYPEFLAG_FHIDDEN}
  TYPEFLAG_FHIDDEN        = $0010;
  {$EXTERNALSYM TYPEFLAG_FCONTROL}
  TYPEFLAG_FCONTROL       = $0020;
  {$EXTERNALSYM TYPEFLAG_FDUAL}
  TYPEFLAG_FDUAL          = $0040;
  {$EXTERNALSYM TYPEFLAG_FNONEXTENSIBLE}
  TYPEFLAG_FNONEXTENSIBLE = $0080;
  {$EXTERNALSYM TYPEFLAG_FOLEAUTOMATION}
  TYPEFLAG_FOLEAUTOMATION = $0100;
  {$EXTERNALSYM TYPEFLAG_FRESTRICTED}
  TYPEFLAG_FRESTRICTED    = $0200;
  {$EXTERNALSYM TYPEFLAG_FAGGREGATABLE}
  TYPEFLAG_FAGGREGATABLE  = $0400;
  {$EXTERNALSYM TYPEFLAG_FREPLACEABLE}
  TYPEFLAG_FREPLACEABLE   = $0800;
  {$EXTERNALSYM TYPEFLAG_FDISPATCHABLE}
  TYPEFLAG_FDISPATCHABLE  = $1000;
  {$EXTERNALSYM TYPEFLAG_FREVERSEBIND}
  TYPEFLAG_FREVERSEBIND   = $2000;

  {$EXTERNALSYM FUNCFLAG_FRESTRICTED}
  FUNCFLAG_FRESTRICTED       = $0001;
  {$EXTERNALSYM FUNCFLAG_FSOURCE}
  FUNCFLAG_FSOURCE           = $0002;
  {$EXTERNALSYM FUNCFLAG_FBINDABLE}
  FUNCFLAG_FBINDABLE         = $0004;
  {$EXTERNALSYM FUNCFLAG_FREQUESTEDIT}
  FUNCFLAG_FREQUESTEDIT      = $0008;
  {$EXTERNALSYM FUNCFLAG_FDISPLAYBIND}
  FUNCFLAG_FDISPLAYBIND      = $0010;
  {$EXTERNALSYM FUNCFLAG_FDEFAULTBIND}
  FUNCFLAG_FDEFAULTBIND      = $0020;
  {$EXTERNALSYM FUNCFLAG_FHIDDEN}
  FUNCFLAG_FHIDDEN           = $0040;
  {$EXTERNALSYM FUNCFLAG_FUSESGETLASTERROR}
  FUNCFLAG_FUSESGETLASTERROR = $0080;
  {$EXTERNALSYM FUNCFLAG_FDEFAULTCOLLELEM}
  FUNCFLAG_FDEFAULTCOLLELEM  = $0100;
  {$EXTERNALSYM FUNCFLAG_FUIDEFAULT}
  FUNCFLAG_FUIDEFAULT        = $0200;
  {$EXTERNALSYM FUNCFLAG_FNONBROWSABLE}
  FUNCFLAG_FNONBROWSABLE          = $0400;
  {$EXTERNALSYM FUNCFLAG_FREPLACEABLE}
  FUNCFLAG_FREPLACEABLE      = $0800;
  {$EXTERNALSYM FUNCFLAG_FIMMEDIATEBIND}
  FUNCFLAG_FIMMEDIATEBIND         = $1000;

  {$EXTERNALSYM VARFLAG_FREADONLY}
  VARFLAG_FREADONLY        = $0001;
  {$EXTERNALSYM VARFLAG_FSOURCE}
  VARFLAG_FSOURCE          = $0002;
  {$EXTERNALSYM VARFLAG_FBINDABLE}
  VARFLAG_FBINDABLE        = $0004;
  {$EXTERNALSYM VARFLAG_FREQUESTEDIT}
  VARFLAG_FREQUESTEDIT     = $0008;
  {$EXTERNALSYM VARFLAG_FDISPLAYBIND}
  VARFLAG_FDISPLAYBIND     = $0010;
  {$EXTERNALSYM VARFLAG_FDEFAULTBIND}
  VARFLAG_FDEFAULTBIND     = $0020;
  {$EXTERNALSYM VARFLAG_FHIDDEN}
  VARFLAG_FHIDDEN          = $0040;
  {$EXTERNALSYM VARFLAG_FRESTRICTED}
  VARFLAG_FRESTRICTED      = $0080;
  {$EXTERNALSYM VARFLAG_FDEFAULTCOLLELEM}
  VARFLAG_FDEFAULTCOLLELEM      = $0100;
  {$EXTERNALSYM VARFLAG_FUIDEFAULT}
  VARFLAG_FUIDEFAULT          = $0200;
  {$EXTERNALSYM VARFLAG_FNONBROWSABLE}
  VARFLAG_FNONBROWSABLE    = $0400;
  {$EXTERNALSYM VARFLAG_FREPLACEABLE}
  VARFLAG_FREPLACEABLE     = $0800;
  {$EXTERNALSYM VARFLAG_FIMMEDIATEBIND}
  VARFLAG_FIMMEDIATEBIND        = $1000;

  {$EXTERNALSYM DISPID_VALUE}
  DISPID_VALUE       = 0;
  {$EXTERNALSYM DISPID_UNKNOWN}
  DISPID_UNKNOWN     = -1;
  {$EXTERNALSYM DISPID_PROPERTYPUT}
  DISPID_PROPERTYPUT = -3;
  {$EXTERNALSYM DISPID_NEWENUM}
  DISPID_NEWENUM     = -4;
  {$EXTERNALSYM DISPID_EVALUATE}
  DISPID_EVALUATE    = -5;
  {$EXTERNALSYM DISPID_CONSTRUCTOR}
  DISPID_CONSTRUCTOR = -6;
  {$EXTERNALSYM DISPID_DESTRUCTOR}
  DISPID_DESTRUCTOR  = -7;
  {$EXTERNALSYM DISPID_COLLECT}
  DISPID_COLLECT     = -8;

  {$EXTERNALSYM DESCKIND_NONE}
  DESCKIND_NONE = 0;
  {$EXTERNALSYM DESCKIND_FUNCDESC}
  DESCKIND_FUNCDESC = 1;
  {$EXTERNALSYM DESCKIND_VARDESC}
  DESCKIND_VARDESC = 2;
  {$EXTERNALSYM DESCKIND_TYPECOMP}
  DESCKIND_TYPECOMP = 3;
  {$EXTERNALSYM DESCKIND_IMPLICITAPPOBJ}
  DESCKIND_IMPLICITAPPOBJ = 4;
  {$EXTERNALSYM DESCKIND_MAX}
  DESCKIND_MAX = 5;

  {$EXTERNALSYM SYS_WIN16}
  SYS_WIN16 = 0;
  {$EXTERNALSYM SYS_WIN32}
  SYS_WIN32 = 1;
  {$EXTERNALSYM SYS_MAC}
  SYS_MAC   = 2;

  {$EXTERNALSYM LIBFLAG_FRESTRICTED}
  LIBFLAG_FRESTRICTED   = 1;
  {$EXTERNALSYM LIBFLAG_FCONTROL}
  LIBFLAG_FCONTROL      = 2;
  {$EXTERNALSYM LIBFLAG_FHIDDEN}
  LIBFLAG_FHIDDEN       = 4;
  {$EXTERNALSYM LIBFLAG_FHASDISKIMAGE}
  LIBFLAG_FHASDISKIMAGE = 8;

{ from OLEAUTO.H }
  {$EXTERNALSYM STDOLE_MAJORVERNUM}
  STDOLE_MAJORVERNUM = 1;
  {$EXTERNALSYM STDOLE_MINORVERNUM}
  STDOLE_MINORVERNUM = 0;
  {$EXTERNALSYM STDOLE_LCID}
  STDOLE_LCID = 0;

  {$EXTERNALSYM VARIANT_NOVALUEPROP}
  VARIANT_NOVALUEPROP = 1;

  {$EXTERNALSYM VAR_TIMEVALUEONLY}
  VAR_TIMEVALUEONLY = 1;
  {$EXTERNALSYM VAR_DATEVALUEONLY}
  VAR_DATEVALUEONLY = 2;

  {$EXTERNALSYM MEMBERID_NIL}
  MEMBERID_NIL = DISPID_UNKNOWN;
  {$EXTERNALSYM ID_DEFAULTINST}
  ID_DEFAULTINST = -2;

  {$EXTERNALSYM DISPATCH_METHOD}
  DISPATCH_METHOD         = 1;
  {$EXTERNALSYM DISPATCH_PROPERTYGET}
  DISPATCH_PROPERTYGET    = 2;
  {$EXTERNALSYM DISPATCH_PROPERTYPUT}
  DISPATCH_PROPERTYPUT    = 4;
  {$EXTERNALSYM DISPATCH_PROPERTYPUTREF}
  DISPATCH_PROPERTYPUTREF = 8;

{ from OAIDL.H }
  {$EXTERNALSYM IDLFLAG_NONE}
  IDLFLAG_NONE    = 0;
  {$EXTERNALSYM IDLFLAG_FIN}
  IDLFLAG_FIN     = 1;
  {$EXTERNALSYM IDLFLAG_FOUT}
  IDLFLAG_FOUT    = 2;
  {$EXTERNALSYM IDLFLAG_FLCID}
  IDLFLAG_FLCID   = 4;
  {$EXTERNALSYM IDLFLAG_FRETVAL}
  IDLFLAG_FRETVAL = 8;

  {$EXTERNALSYM PARAMFLAG_NONE}
  PARAMFLAG_NONE          = $00;
  {$EXTERNALSYM PARAMFLAG_FIN}
  PARAMFLAG_FIN           = $01;
  {$EXTERNALSYM PARAMFLAG_FOUT}
  PARAMFLAG_FOUT          = $02;
  {$EXTERNALSYM PARAMFLAG_FLCID}
  PARAMFLAG_FLCID         = $04;
  {$EXTERNALSYM PARAMFLAG_FRETVAL}
  PARAMFLAG_FRETVAL       = $08;
  {$EXTERNALSYM PARAMFLAG_FOPT    }
  PARAMFLAG_FOPT          = $10;
  {$EXTERNALSYM PARAMFLAG_FHASDEFAULT }
  PARAMFLAG_FHASDEFAULT   = $20;

{ from OLE2.H }
  {$EXTERNALSYM OLEIVERB_PRIMARY}
  OLEIVERB_PRIMARY          = 0;
  {$EXTERNALSYM OLEIVERB_SHOW}
  OLEIVERB_SHOW             = -1;
  {$EXTERNALSYM OLEIVERB_OPEN}
  OLEIVERB_OPEN             = -2;
  {$EXTERNALSYM OLEIVERB_HIDE}
  OLEIVERB_HIDE             = -3;
  {$EXTERNALSYM OLEIVERB_UIACTIVATE}
  OLEIVERB_UIACTIVATE       = -4;
  {$EXTERNALSYM OLEIVERB_INPLACEACTIVATE}
  OLEIVERB_INPLACEACTIVATE  = -5;
  {$EXTERNALSYM OLEIVERB_DISCARDUNDOSTATE}
  OLEIVERB_DISCARDUNDOSTATE = -6;

  {$EXTERNALSYM EMBDHLP_INPROC_HANDLER}
  EMBDHLP_INPROC_HANDLER = $00000000;
  {$EXTERNALSYM EMBDHLP_INPROC_SERVER}
  EMBDHLP_INPROC_SERVER  = $00000001;
  {$EXTERNALSYM EMBDHLP_CREATENOW}
  EMBDHLP_CREATENOW      = $00000000;
  {$EXTERNALSYM EMBDHLP_DELAYCREATE}
  EMBDHLP_DELAYCREATE    = $00010000;

  {$EXTERNALSYM OLECREATE_LEAVERUNNING}
  OLECREATE_LEAVERUNNING = $00000001;

{ from OLEIDL.H }

type
  {$EXTERNALSYM BORDERWIDTHS}
  BORDERWIDTHS = TRect;
  PBorderWidths = ^TBorderWidths;
  TBorderWidths = BORDERWIDTHS;

const
  {$EXTERNALSYM UPDFCACHE_NODATACACHE}
  UPDFCACHE_NODATACACHE = 1;
  {$EXTERNALSYM UPDFCACHE_ONSAVECACHE}
  UPDFCACHE_ONSAVECACHE = 2;
  {$EXTERNALSYM UPDFCACHE_ONSTOPCACHE}
  UPDFCACHE_ONSTOPCACHE = 4;
  {$EXTERNALSYM UPDFCACHE_NORMALCACHE}
  UPDFCACHE_NORMALCACHE = 8;
  {$EXTERNALSYM UPDFCACHE_IFBLANK}
  UPDFCACHE_IFBLANK     = $10;
  {$EXTERNALSYM UPDFCACHE_ONLYIFBLANK}
  UPDFCACHE_ONLYIFBLANK = DWORD($80000000);

  {$EXTERNALSYM UPDFCACHE_IFBLANKORONSAVECACHE}
  UPDFCACHE_IFBLANKORONSAVECACHE = UPDFCACHE_IFBLANK or UPDFCACHE_ONSAVECACHE;
  {$EXTERNALSYM UPDFCACHE_ALL}
  UPDFCACHE_ALL                  = not UPDFCACHE_ONLYIFBLANK;
  {$EXTERNALSYM UPDFCACHE_ALLBUTNODATACACHE}
  UPDFCACHE_ALLBUTNODATACACHE    = UPDFCACHE_ALL and not UPDFCACHE_NODATACACHE;

  {$EXTERNALSYM DISCARDCACHE_SAVEIFDIRTY}
  DISCARDCACHE_SAVEIFDIRTY = 0;
  {$EXTERNALSYM DISCARDCACHE_NOSAVE}
  DISCARDCACHE_NOSAVE      = 1;

  {$EXTERNALSYM OLEGETMONIKER_ONLYIFTHERE}
  OLEGETMONIKER_ONLYIFTHERE = 1;
  {$EXTERNALSYM OLEGETMONIKER_FORCEASSIGN}
  OLEGETMONIKER_FORCEASSIGN = 2;
  {$EXTERNALSYM OLEGETMONIKER_UNASSIGN}
  OLEGETMONIKER_UNASSIGN    = 3;
  {$EXTERNALSYM OLEGETMONIKER_TEMPFORUSER}
  OLEGETMONIKER_TEMPFORUSER = 4;

  {$EXTERNALSYM OLEWHICHMK_CONTAINER}
  OLEWHICHMK_CONTAINER = 1;
  {$EXTERNALSYM OLEWHICHMK_OBJREL}
  OLEWHICHMK_OBJREL    = 2;
  {$EXTERNALSYM OLEWHICHMK_OBJFULL}
  OLEWHICHMK_OBJFULL   = 3;

  {$EXTERNALSYM USERCLASSTYPE_FULL}
  USERCLASSTYPE_FULL    = 1;
  {$EXTERNALSYM USERCLASSTYPE_SHORT}
  USERCLASSTYPE_SHORT   = 2;
  {$EXTERNALSYM USERCLASSTYPE_APPNAME}
  USERCLASSTYPE_APPNAME = 3;

  {$EXTERNALSYM OLEMISC_RECOMPOSEONRESIZE}
  OLEMISC_RECOMPOSEONRESIZE            = 1;
  {$EXTERNALSYM OLEMISC_ONLYICONIC}
  OLEMISC_ONLYICONIC                   = 2;
  {$EXTERNALSYM OLEMISC_INSERTNOTREPLACE}
  OLEMISC_INSERTNOTREPLACE             = 4;
  {$EXTERNALSYM OLEMISC_STATIC}
  OLEMISC_STATIC                       = 8;
  {$EXTERNALSYM OLEMISC_CANTLINKINSIDE}
  OLEMISC_CANTLINKINSIDE                    = $10;
  {$EXTERNALSYM OLEMISC_CANLINKBYOLE1}
  OLEMISC_CANLINKBYOLE1                = $20;
  {$EXTERNALSYM OLEMISC_ISLINKOBJECT}
  OLEMISC_ISLINKOBJECT                 = $40;
  {$EXTERNALSYM OLEMISC_INSIDEOUT}
  OLEMISC_INSIDEOUT                       = $80;
  {$EXTERNALSYM OLEMISC_ACTIVATEWHENVISIBLE}
  OLEMISC_ACTIVATEWHENVISIBLE            = $100;
  {$EXTERNALSYM OLEMISC_RENDERINGISDEVICEINDEPENDENT}
  OLEMISC_RENDERINGISDEVICEINDEPENDENT  = $200;
  {$EXTERNALSYM OLEMISC_INVISIBLEATRUNTIME}
  OLEMISC_INVISIBLEATRUNTIME             = $400;
  {$EXTERNALSYM OLEMISC_ALWAYSRUN}
  OLEMISC_ALWAYSRUN                       = $800;
  {$EXTERNALSYM OLEMISC_ACTSLIKEBUTTON}
  OLEMISC_ACTSLIKEBUTTON                    = $1000;
  {$EXTERNALSYM OLEMISC_ACTSLIKELABEL}
  OLEMISC_ACTSLIKELABEL                = $2000;
  {$EXTERNALSYM OLEMISC_NOUIACTIVATE}
  OLEMISC_NOUIACTIVATE                 = $4000;
  {$EXTERNALSYM OLEMISC_ALIGNABLE}
  OLEMISC_ALIGNABLE                       = $8000;
  {$EXTERNALSYM OLEMISC_SIMPLEFRAME}
  OLEMISC_SIMPLEFRAME                  = $10000;
  {$EXTERNALSYM OLEMISC_SETCLIENTSITEFIRST}
  OLEMISC_SETCLIENTSITEFIRST           = $20000;
  {$EXTERNALSYM OLEMISC_IMEMODE}
  OLEMISC_IMEMODE                            = $40000;
  {$EXTERNALSYM OLEMISC_IGNOREACTIVATEWHENVISIBLE}
  OLEMISC_IGNOREACTIVATEWHENVISIBLE    = $80000;
  {$EXTERNALSYM OLEMISC_WANTSTOMENUMERGE}
  OLEMISC_WANTSTOMENUMERGE             = $100000;
  {$EXTERNALSYM OLEMISC_SUPPORTSMULTILEVELUNDO}
  OLEMISC_SUPPORTSMULTILEVELUNDO              = $200000;

  {$EXTERNALSYM OLECLOSE_SAVEIFDIRTY}
  OLECLOSE_SAVEIFDIRTY = 0;
  {$EXTERNALSYM OLECLOSE_NOSAVE}
  OLECLOSE_NOSAVE      = 1;
  {$EXTERNALSYM OLECLOSE_PROMPTSAVE}
  OLECLOSE_PROMPTSAVE  = 2;

  {$EXTERNALSYM OLERENDER_NONE}
  OLERENDER_NONE   = 0;
  {$EXTERNALSYM OLERENDER_DRAW}
  OLERENDER_DRAW   = 1;
  {$EXTERNALSYM OLERENDER_FORMAT}
  OLERENDER_FORMAT = 2;
  {$EXTERNALSYM OLERENDER_ASIS}
  OLERENDER_ASIS   = 3;

  {$EXTERNALSYM OLEUPDATE_ALWAYS}
  OLEUPDATE_ALWAYS = 1;
  {$EXTERNALSYM OLEUPDATE_ONCALL}
  OLEUPDATE_ONCALL = 3;

  {$EXTERNALSYM OLELINKBIND_EVENIFCLASSDIFF}
  OLELINKBIND_EVENIFCLASSDIFF = 1;

  {$EXTERNALSYM BINDSPEED_INDEFINITE}
  BINDSPEED_INDEFINITE = 1;
  {$EXTERNALSYM BINDSPEED_MODERATE}
  BINDSPEED_MODERATE   = 2;
  {$EXTERNALSYM BINDSPEED_IMMEDIATE}
  BINDSPEED_IMMEDIATE  = 3;

  {$EXTERNALSYM OLECONTF_EMBEDDINGS}
  OLECONTF_EMBEDDINGS    = 1;
  {$EXTERNALSYM OLECONTF_LINKS}
  OLECONTF_LINKS         = 2;
  {$EXTERNALSYM OLECONTF_OTHERS}
  OLECONTF_OTHERS        = 4;
  {$EXTERNALSYM OLECONTF_ONLYUSER}
  OLECONTF_ONLYUSER      = 8;
  {$EXTERNALSYM OLECONTF_ONLYIFRUNNING}
  OLECONTF_ONLYIFRUNNING = 16;

  {$EXTERNALSYM DROPEFFECT_NONE}
  DROPEFFECT_NONE   = 0;
  {$EXTERNALSYM DROPEFFECT_COPY}
  DROPEFFECT_COPY   = 1;
  {$EXTERNALSYM DROPEFFECT_MOVE}
  DROPEFFECT_MOVE   = 2;
  {$EXTERNALSYM DROPEFFECT_LINK}
  DROPEFFECT_LINK   = 4;
  {$EXTERNALSYM DROPEFFECT_SCROLL}
  DROPEFFECT_SCROLL = DWORD($80000000);

  {$EXTERNALSYM DD_DEFSCROLLINSET}
  DD_DEFSCROLLINSET    = 11;
  {$EXTERNALSYM DD_DEFSCROLLDELAY}
  DD_DEFSCROLLDELAY    = 50;
  {$EXTERNALSYM DD_DEFSCROLLINTERVAL}
  DD_DEFSCROLLINTERVAL = 50;
  {$EXTERNALSYM DD_DEFDRAGDELAY}
  DD_DEFDRAGDELAY      = 200;
  {$EXTERNALSYM DD_DEFDRAGMINDIST}
  DD_DEFDRAGMINDIST    = 2;

  {$EXTERNALSYM OLEVERBATTRIB_NEVERDIRTIES}
  OLEVERBATTRIB_NEVERDIRTIES    = 1;
  {$EXTERNALSYM OLEVERBATTRIB_ONCONTAINERMENU}
  OLEVERBATTRIB_ONCONTAINERMENU = 2;

{ from OLECTL.H}
{ OLE control status codes }

  {$EXTERNALSYM CTL_E_ILLEGALFUNCTIONCALL}
  CTL_E_ILLEGALFUNCTIONCALL       = HRESULT($800A0000) + 5;
  {$EXTERNALSYM CTL_E_OVERFLOW}
  CTL_E_OVERFLOW                  = HRESULT($800A0000) + 6;
  {$EXTERNALSYM CTL_E_OUTOFMEMORY}
  CTL_E_OUTOFMEMORY               = HRESULT($800A0000) + 7;
  {$EXTERNALSYM CTL_E_DIVISIONBYZERO}
  CTL_E_DIVISIONBYZERO            = HRESULT($800A0000) + 11;
  {$EXTERNALSYM CTL_E_OUTOFSTRINGSPACE}
  CTL_E_OUTOFSTRINGSPACE          = HRESULT($800A0000) + 14;
  {$EXTERNALSYM CTL_E_OUTOFSTACKSPACE}
  CTL_E_OUTOFSTACKSPACE           = HRESULT($800A0000) + 28;
  {$EXTERNALSYM CTL_E_BADFILENAMEORNUMBER}
  CTL_E_BADFILENAMEORNUMBER       = HRESULT($800A0000) + 52;
  {$EXTERNALSYM CTL_E_FILENOTFOUND}
  CTL_E_FILENOTFOUND              = HRESULT($800A0000) + 53;
  {$EXTERNALSYM CTL_E_BADFILEMODE}
  CTL_E_BADFILEMODE               = HRESULT($800A0000) + 54;
  {$EXTERNALSYM CTL_E_FILEALREADYOPEN}
  CTL_E_FILEALREADYOPEN           = HRESULT($800A0000) + 55;
  {$EXTERNALSYM CTL_E_DEVICEIOERROR}
  CTL_E_DEVICEIOERROR             = HRESULT($800A0000) + 57;
  {$EXTERNALSYM CTL_E_FILEALREADYEXISTS}
  CTL_E_FILEALREADYEXISTS         = HRESULT($800A0000) + 58;
  {$EXTERNALSYM CTL_E_BADRECORDLENGTH}
  CTL_E_BADRECORDLENGTH           = HRESULT($800A0000) + 59;
  {$EXTERNALSYM CTL_E_DISKFULL}
  CTL_E_DISKFULL                  = HRESULT($800A0000) + 61;
  {$EXTERNALSYM CTL_E_BADRECORDNUMBER}
  CTL_E_BADRECORDNUMBER           = HRESULT($800A0000) + 63;
  {$EXTERNALSYM CTL_E_BADFILENAME}
  CTL_E_BADFILENAME               = HRESULT($800A0000) + 64;
  {$EXTERNALSYM CTL_E_TOOMANYFILES}
  CTL_E_TOOMANYFILES              = HRESULT($800A0000) + 67;
  {$EXTERNALSYM CTL_E_DEVICEUNAVAILABLE}
  CTL_E_DEVICEUNAVAILABLE         = HRESULT($800A0000) + 68;
  {$EXTERNALSYM CTL_E_PERMISSIONDENIED}
  CTL_E_PERMISSIONDENIED          = HRESULT($800A0000) + 70;
  {$EXTERNALSYM CTL_E_DISKNOTREADY}
  CTL_E_DISKNOTREADY              = HRESULT($800A0000) + 71;
  {$EXTERNALSYM CTL_E_PATHFILEACCESSERROR}
  CTL_E_PATHFILEACCESSERROR       = HRESULT($800A0000) + 75;
  {$EXTERNALSYM CTL_E_PATHNOTFOUND}
  CTL_E_PATHNOTFOUND              = HRESULT($800A0000) + 76;
  {$EXTERNALSYM CTL_E_INVALIDPATTERNSTRING}
  CTL_E_INVALIDPATTERNSTRING      = HRESULT($800A0000) + 93;
  {$EXTERNALSYM CTL_E_INVALIDUSEOFNULL}
  CTL_E_INVALIDUSEOFNULL          = HRESULT($800A0000) + 94;
  {$EXTERNALSYM CTL_E_INVALIDFILEFORMAT}
  CTL_E_INVALIDFILEFORMAT         = HRESULT($800A0000) + 321;
  {$EXTERNALSYM CTL_E_INVALIDPROPERTYVALUE}
  CTL_E_INVALIDPROPERTYVALUE      = HRESULT($800A0000) + 380;
  {$EXTERNALSYM CTL_E_INVALIDPROPERTYARRAYINDEX}
  CTL_E_INVALIDPROPERTYARRAYINDEX = HRESULT($800A0000) + 381;
  {$EXTERNALSYM CTL_E_SETNOTSUPPORTEDATRUNTIME}
  CTL_E_SETNOTSUPPORTEDATRUNTIME  = HRESULT($800A0000) + 382;
  {$EXTERNALSYM CTL_E_SETNOTSUPPORTED}
  CTL_E_SETNOTSUPPORTED           = HRESULT($800A0000) + 383;
  {$EXTERNALSYM CTL_E_NEEDPROPERTYARRAYINDEX}
  CTL_E_NEEDPROPERTYARRAYINDEX    = HRESULT($800A0000) + 385;
  {$EXTERNALSYM CTL_E_SETNOTPERMITTED}
  CTL_E_SETNOTPERMITTED           = HRESULT($800A0000) + 387;
  {$EXTERNALSYM CTL_E_GETNOTSUPPORTEDATRUNTIME}
  CTL_E_GETNOTSUPPORTEDATRUNTIME  = HRESULT($800A0000) + 393;
  {$EXTERNALSYM CTL_E_GETNOTSUPPORTED}
  CTL_E_GETNOTSUPPORTED           = HRESULT($800A0000) + 394;
  {$EXTERNALSYM CTL_E_PROPERTYNOTFOUND}
  CTL_E_PROPERTYNOTFOUND          = HRESULT($800A0000) + 422;
  {$EXTERNALSYM CTL_E_INVALIDCLIPBOARDFORMAT}
  CTL_E_INVALIDCLIPBOARDFORMAT    = HRESULT($800A0000) + 460;
  {$EXTERNALSYM CTL_E_INVALIDPICTURE}
  CTL_E_INVALIDPICTURE            = HRESULT($800A0000) + 481;
  {$EXTERNALSYM CTL_E_PRINTERERROR}
  CTL_E_PRINTERERROR              = HRESULT($800A0000) + 482;
  {$EXTERNALSYM CTL_E_CANTSAVEFILETOTEMP}
  CTL_E_CANTSAVEFILETOTEMP        = HRESULT($800A0000) + 735;
  {$EXTERNALSYM CTL_E_SEARCHTEXTNOTFOUND}
  CTL_E_SEARCHTEXTNOTFOUND        = HRESULT($800A0000) + 744;
  {$EXTERNALSYM CTL_E_REPLACEMENTSTOOLONG}
  CTL_E_REPLACEMENTSTOOLONG       = HRESULT($800A0000) + 746;

  {$EXTERNALSYM CTL_E_CUSTOM_FIRST}
  CTL_E_CUSTOM_FIRST = HRESULT($800A0000) + 600;

{ IClassFactory2 status codes }

  {$EXTERNALSYM CLASS_E_NOTLICENSED}
  CLASS_E_NOTLICENSED = CLASSFACTORY_E_FIRST + 2;

{ IConnectionPoint status codes }

  {$EXTERNALSYM CONNECT_E_FIRST}
  CONNECT_E_FIRST = HRESULT($80040200);
  {$EXTERNALSYM CONNECT_E_LAST}
  CONNECT_E_LAST  = HRESULT($8004020F);
  {$EXTERNALSYM CONNECT_S_FIRST}
  CONNECT_S_FIRST = $00040200;
  {$EXTERNALSYM CONNECT_S_LAST}
  CONNECT_S_LAST  = $0004020F;

  {$EXTERNALSYM CONNECT_E_NOCONNECTION}
  CONNECT_E_NOCONNECTION  = CONNECT_E_FIRST + 0;
  {$EXTERNALSYM CONNECT_E_ADVISELIMIT}
  CONNECT_E_ADVISELIMIT   = CONNECT_E_FIRST + 1;
  {$EXTERNALSYM CONNECT_E_CANNOTCONNECT}
  CONNECT_E_CANNOTCONNECT = CONNECT_E_FIRST + 2;
  {$EXTERNALSYM CONNECT_E_OVERRIDDEN}
  CONNECT_E_OVERRIDDEN    = CONNECT_E_FIRST + 3;

{ DllRegisterServer/DllUnregisterServer status codes }

  {$EXTERNALSYM SELFREG_E_FIRST}
  SELFREG_E_FIRST = HRESULT($80040200);
  {$EXTERNALSYM SELFREG_E_LAST}
  SELFREG_E_LAST  = HRESULT($80040200);
  {$EXTERNALSYM SELFREG_S_FIRST}
  SELFREG_S_FIRST = $00040200;
  {$EXTERNALSYM SELFREG_S_LAST}
  SELFREG_S_LAST  = $00040200;

  {$EXTERNALSYM SELFREG_E_TYPELIB}
  SELFREG_E_TYPELIB = SELFREG_E_FIRST + 0;
  {$EXTERNALSYM SELFREG_E_CLASS}
  SELFREG_E_CLASS   = SELFREG_E_FIRST + 1;

{ IPerPropertyBrowsing status codes }

  {$EXTERNALSYM PERPROP_E_FIRST}
  PERPROP_E_FIRST = HRESULT($80040200);
  {$EXTERNALSYM PERPROP_E_LAST}
  PERPROP_E_LAST  = HRESULT($8004020F);
  {$EXTERNALSYM PERPROP_S_FIRST}
  PERPROP_S_FIRST = $00040200;
  {$EXTERNALSYM PERPROP_S_LAST}
  PERPROP_S_LAST  = $0004020F;

  {$EXTERNALSYM PERPROP_E_NOPAGEAVAILABLE}
  PERPROP_E_NOPAGEAVAILABLE = PERPROP_E_FIRST + 0;

{ Additional OLEIVERB constants }

  {$EXTERNALSYM OLEIVERB_PROPERTIES}
  OLEIVERB_PROPERTIES = -7;

{ Additional variant type tags for property sets }

  {$EXTERNALSYM VT_STREAMED_PROPSET}
  VT_STREAMED_PROPSET = 73;  { Stream contains a property set }
  {$EXTERNALSYM VT_STORED_PROPSET}
  VT_STORED_PROPSET   = 74;  { Storage contains a property set }
  {$EXTERNALSYM VT_BLOB_PROPSET}
  VT_BLOB_PROPSET     = 75;  { Blob contains a property set }
  {$EXTERNALSYM VT_VERBOSE_ENUM}
  VT_VERBOSE_ENUM     = 76;  { Enum value with text string }

{ Variant type tags that are just aliases for others }

  {$EXTERNALSYM VT_COLOR}
  VT_COLOR          = VT_I4;
  {$EXTERNALSYM VT_XPOS_PIXELS}
  VT_XPOS_PIXELS    = VT_I4;
  {$EXTERNALSYM VT_YPOS_PIXELS}
  VT_YPOS_PIXELS    = VT_I4;
  {$EXTERNALSYM VT_XSIZE_PIXELS}
  VT_XSIZE_PIXELS   = VT_I4;
  {$EXTERNALSYM VT_YSIZE_PIXELS}
  VT_YSIZE_PIXELS   = VT_I4;
  {$EXTERNALSYM VT_XPOS_HIMETRIC}
  VT_XPOS_HIMETRIC  = VT_I4;
  {$EXTERNALSYM VT_YPOS_HIMETRIC}
  VT_YPOS_HIMETRIC  = VT_I4;
  {$EXTERNALSYM VT_XSIZE_HIMETRIC}
  VT_XSIZE_HIMETRIC = VT_I4;
  {$EXTERNALSYM VT_YSIZE_HIMETRIC}
  VT_YSIZE_HIMETRIC = VT_I4;
  {$EXTERNALSYM VT_TRISTATE}
  VT_TRISTATE       = VT_I2;
  {$EXTERNALSYM VT_OPTEXCLUSIVE}
  VT_OPTEXCLUSIVE   = VT_BOOL;
  {$EXTERNALSYM VT_FONT}
  VT_FONT           = VT_DISPATCH;
  {$EXTERNALSYM VT_PICTURE}
  VT_PICTURE        = VT_DISPATCH;
  {$EXTERNALSYM VT_HANDLE}
  VT_HANDLE         = VT_I4;

{ Reflected window message IDs }

  {$EXTERNALSYM OCM__BASE}
  OCM__BASE = WM_USER + $1C00;

  {$EXTERNALSYM OCM_COMMAND}
  OCM_COMMAND           = OCM__BASE + WM_COMMAND;
  {$EXTERNALSYM OCM_CTLCOLORBTN}
  OCM_CTLCOLORBTN       = OCM__BASE + WM_CTLCOLORBTN;
  {$EXTERNALSYM OCM_CTLCOLOREDIT}
  OCM_CTLCOLOREDIT      = OCM__BASE + WM_CTLCOLOREDIT;
  {$EXTERNALSYM OCM_CTLCOLORDLG}
  OCM_CTLCOLORDLG       = OCM__BASE + WM_CTLCOLORDLG;
  {$EXTERNALSYM OCM_CTLCOLORLISTBOX}
  OCM_CTLCOLORLISTBOX   = OCM__BASE + WM_CTLCOLORLISTBOX;
  {$EXTERNALSYM OCM_CTLCOLORMSGBOX}
  OCM_CTLCOLORMSGBOX    = OCM__BASE + WM_CTLCOLORMSGBOX;
  {$EXTERNALSYM OCM_CTLCOLORSCROLLBAR}
  OCM_CTLCOLORSCROLLBAR = OCM__BASE + WM_CTLCOLORSCROLLBAR;
  {$EXTERNALSYM OCM_CTLCOLORSTATIC}
  OCM_CTLCOLORSTATIC    = OCM__BASE + WM_CTLCOLORSTATIC;
  {$EXTERNALSYM OCM_DRAWITEM}
  OCM_DRAWITEM          = OCM__BASE + WM_DRAWITEM;
  {$EXTERNALSYM OCM_MEASUREITEM}
  OCM_MEASUREITEM       = OCM__BASE + WM_MEASUREITEM;
  {$EXTERNALSYM OCM_DELETEITEM}
  OCM_DELETEITEM        = OCM__BASE + WM_DELETEITEM;
  {$EXTERNALSYM OCM_VKEYTOITEM}
  OCM_VKEYTOITEM        = OCM__BASE + WM_VKEYTOITEM;
  {$EXTERNALSYM OCM_CHARTOITEM}
  OCM_CHARTOITEM        = OCM__BASE + WM_CHARTOITEM;
  {$EXTERNALSYM OCM_COMPAREITEM}
  OCM_COMPAREITEM       = OCM__BASE + WM_COMPAREITEM;
  {$EXTERNALSYM OCM_HSCROLL}
  OCM_HSCROLL           = OCM__BASE + WM_HSCROLL;
  {$EXTERNALSYM OCM_VSCROLL}
  OCM_VSCROLL           = OCM__BASE + WM_VSCROLL;
  {$EXTERNALSYM OCM_PARENTNOTIFY}
  OCM_PARENTNOTIFY      = OCM__BASE + WM_PARENTNOTIFY;
  {$EXTERNALSYM OCM_NOTIFY}
  OCM_NOTIFY            = OCM__BASE + WM_NOTIFY;

{ from OCIDL.H }
{ TControlInfo.dwFlags masks }

  {$EXTERNALSYM CTRLINFO_EATS_RETURN}
  CTRLINFO_EATS_RETURN = 1;  { Control doesn't send Return to container }
  {$EXTERNALSYM CTRLINFO_EATS_ESCAPE}
  CTRLINFO_EATS_ESCAPE = 2;  { Control doesn't send Escape to container }

{ IOleControlSite.TransformCoords flags }

  {$EXTERNALSYM XFORMCOORDS_POSITION}
  XFORMCOORDS_POSITION            = 1;
  {$EXTERNALSYM XFORMCOORDS_SIZE}
  XFORMCOORDS_SIZE                = 2;
  {$EXTERNALSYM XFORMCOORDS_HIMETRICTOCONTAINER}
  XFORMCOORDS_HIMETRICTOCONTAINER = 4;
  {$EXTERNALSYM XFORMCOORDS_CONTAINERTOHIMETRIC}
  XFORMCOORDS_CONTAINERTOHIMETRIC = 8;

{ IPropertyPageSite.OnStatusChange flags }

  {$EXTERNALSYM PROPPAGESTATUS_DIRTY}
  PROPPAGESTATUS_DIRTY    = 1;  { Values in page have changed }
  {$EXTERNALSYM PROPPAGESTATUS_VALIDATE}
  PROPPAGESTATUS_VALIDATE = 2;  { Appropriate time to validate/apply }
  {$EXTERNALSYM PROPPAGESTATUS_CLEAN}
  PROPPAGESTATUS_CLEAN    = 4;

{ Picture attributes }

  {$EXTERNALSYM PICTURE_SCALABLE}
  PICTURE_SCALABLE    = 1;
  {$EXTERNALSYM PICTURE_TRANSPARENT}
  PICTURE_TRANSPARENT = 2;

{ from OLECTL.H }
{ TPictDesc.picType values }

  {$EXTERNALSYM PICTYPE_UNINITIALIZED}
  PICTYPE_UNINITIALIZED = -1;
  {$EXTERNALSYM PICTYPE_NONE}
  PICTYPE_NONE          = 0;
  {$EXTERNALSYM PICTYPE_BITMAP}
  PICTYPE_BITMAP        = 1;
  {$EXTERNALSYM PICTYPE_METAFILE}
  PICTYPE_METAFILE      = 2;
  {$EXTERNALSYM PICTYPE_ICON}
  PICTYPE_ICON          = 3;
  {$EXTERNALSYM PICTYPE_ENHMETAFILE}
  PICTYPE_ENHMETAFILE   = 4;

{ Standard dispatch ID constants }

  {$EXTERNALSYM DISPID_AUTOSIZE}
  DISPID_AUTOSIZE      = -500;
  {$EXTERNALSYM DISPID_BACKCOLOR}
  DISPID_BACKCOLOR     = -501;
  {$EXTERNALSYM DISPID_BACKSTYLE}
  DISPID_BACKSTYLE     = -502;
  {$EXTERNALSYM DISPID_BORDERCOLOR}
  DISPID_BORDERCOLOR   = -503;
  {$EXTERNALSYM DISPID_BORDERSTYLE}
  DISPID_BORDERSTYLE   = -504;
  {$EXTERNALSYM DISPID_BORDERWIDTH}
  DISPID_BORDERWIDTH   = -505;
  {$EXTERNALSYM DISPID_DRAWMODE}
  DISPID_DRAWMODE      = -507;
  {$EXTERNALSYM DISPID_DRAWSTYLE}
  DISPID_DRAWSTYLE     = -508;
  {$EXTERNALSYM DISPID_DRAWWIDTH}
  DISPID_DRAWWIDTH     = -509;
  {$EXTERNALSYM DISPID_FILLCOLOR}
  DISPID_FILLCOLOR     = -510;
  {$EXTERNALSYM DISPID_FILLSTYLE}
  DISPID_FILLSTYLE     = -511;
  {$EXTERNALSYM DISPID_FONT}
  DISPID_FONT          = -512;
  {$EXTERNALSYM DISPID_FORECOLOR}
  DISPID_FORECOLOR     = -513;
  {$EXTERNALSYM DISPID_ENABLED}
  DISPID_ENABLED       = -514;
  {$EXTERNALSYM DISPID_HWND}
  DISPID_HWND          = -515;
  {$EXTERNALSYM DISPID_TABSTOP}
  DISPID_TABSTOP       = -516;
  {$EXTERNALSYM DISPID_TEXT}
  DISPID_TEXT          = -517;
  {$EXTERNALSYM DISPID_CAPTION}
  DISPID_CAPTION       = -518;
  {$EXTERNALSYM DISPID_BORDERVISIBLE}
  DISPID_BORDERVISIBLE = -519;
  {$EXTERNALSYM DISPID_APPEARANCE}
  DISPID_APPEARANCE    = -520;
  {$EXTERNALSYM DISPID_MOUSEPOINTER}
  DISPID_MOUSEPOINTER  = -521;
  {$EXTERNALSYM DISPID_MOUSEICON}
  DISPID_MOUSEICON     = -522;
  {$EXTERNALSYM DISPID_PICTURE}
  DISPID_PICTURE       = -523;
  {$EXTERNALSYM DISPID_VALID}
  DISPID_VALID         = -524;
  {$EXTERNALSYM DISPID_READYSTATE}
  DISPID_READYSTATE    = -525;

  {$EXTERNALSYM DISPID_REFRESH}
  DISPID_REFRESH  = -550;
  {$EXTERNALSYM DISPID_DOCLICK}
  DISPID_DOCLICK  = -551;
  {$EXTERNALSYM DISPID_ABOUTBOX}
  DISPID_ABOUTBOX = -552;

  {$EXTERNALSYM DISPID_CLICK}
  DISPID_CLICK            = -600;
  {$EXTERNALSYM DISPID_DBLCLICK}
  DISPID_DBLCLICK         = -601;
  {$EXTERNALSYM DISPID_KEYDOWN}
  DISPID_KEYDOWN          = -602;
  {$EXTERNALSYM DISPID_KEYPRESS}
  DISPID_KEYPRESS         = -603;
  {$EXTERNALSYM DISPID_KEYUP}
  DISPID_KEYUP            = -604;
  {$EXTERNALSYM DISPID_MOUSEDOWN}
  DISPID_MOUSEDOWN        = -605;
  {$EXTERNALSYM DISPID_MOUSEMOVE}
  DISPID_MOUSEMOVE        = -606;
  {$EXTERNALSYM DISPID_MOUSEUP}
  DISPID_MOUSEUP          = -607;
  {$EXTERNALSYM DISPID_ERROREVENT}
  DISPID_ERROREVENT       = -608;
  {$EXTERNALSYM DISPID_READYSTATECHANGE}
  DISPID_READYSTATECHANGE = -609;

  {$EXTERNALSYM DISPID_AMBIENT_BACKCOLOR}
  DISPID_AMBIENT_BACKCOLOR         = -701;
  {$EXTERNALSYM DISPID_AMBIENT_DISPLAYNAME}
  DISPID_AMBIENT_DISPLAYNAME       = -702;
  {$EXTERNALSYM DISPID_AMBIENT_FONT}
  DISPID_AMBIENT_FONT              = -703;
  {$EXTERNALSYM DISPID_AMBIENT_FORECOLOR}
  DISPID_AMBIENT_FORECOLOR         = -704;
  {$EXTERNALSYM DISPID_AMBIENT_LOCALEID}
  DISPID_AMBIENT_LOCALEID          = -705;
  {$EXTERNALSYM DISPID_AMBIENT_MESSAGEREFLECT}
  DISPID_AMBIENT_MESSAGEREFLECT    = -706;
  {$EXTERNALSYM DISPID_AMBIENT_SCALEUNITS}
  DISPID_AMBIENT_SCALEUNITS        = -707;
  {$EXTERNALSYM DISPID_AMBIENT_TEXTALIGN}
  DISPID_AMBIENT_TEXTALIGN         = -708;
  {$EXTERNALSYM DISPID_AMBIENT_USERMODE}
  DISPID_AMBIENT_USERMODE          = -709;
  {$EXTERNALSYM DISPID_AMBIENT_UIDEAD}
  DISPID_AMBIENT_UIDEAD            = -710;
  {$EXTERNALSYM DISPID_AMBIENT_SHOWGRABHANDLES}
  DISPID_AMBIENT_SHOWGRABHANDLES   = -711;
  {$EXTERNALSYM DISPID_AMBIENT_SHOWHATCHING}
  DISPID_AMBIENT_SHOWHATCHING      = -712;
  {$EXTERNALSYM DISPID_AMBIENT_DISPLAYASDEFAULT}
  DISPID_AMBIENT_DISPLAYASDEFAULT  = -713;
  {$EXTERNALSYM DISPID_AMBIENT_SUPPORTSMNEMONICS}
  DISPID_AMBIENT_SUPPORTSMNEMONICS = -714;
  {$EXTERNALSYM DISPID_AMBIENT_AUTOCLIP}
  DISPID_AMBIENT_AUTOCLIP          = -715;
  {$EXTERNALSYM DISPID_AMBIENT_APPEARANCE}
  DISPID_AMBIENT_APPEARANCE        = -716;

  {$EXTERNALSYM DISPID_AMBIENT_PALETTE}
  DISPID_AMBIENT_PALETTE           = -726;
  {$EXTERNALSYM DISPID_AMBIENT_TRANSFERPRIORITY}
  DISPID_AMBIENT_TRANSFERPRIORITY  = -728;

  {$EXTERNALSYM DISPID_Name}
  DISPID_Name                      = -800;
  {$EXTERNALSYM DISPID_Delete}
  DISPID_Delete                    = -801;
  {$EXTERNALSYM DISPID_Object}
  DISPID_Object                    = -802;
  {$EXTERNALSYM DISPID_Parent}
  DISPID_Parent                    = -803;


{ Dispatch ID constants for fonts }

  {$EXTERNALSYM DISPID_FONT_NAME}
  DISPID_FONT_NAME    = 0;
  {$EXTERNALSYM DISPID_FONT_SIZE}
  DISPID_FONT_SIZE    = 2;
  {$EXTERNALSYM DISPID_FONT_BOLD}
  DISPID_FONT_BOLD    = 3;
  {$EXTERNALSYM DISPID_FONT_ITALIC}
  DISPID_FONT_ITALIC  = 4;
  {$EXTERNALSYM DISPID_FONT_UNDER}
  DISPID_FONT_UNDER   = 5;
  {$EXTERNALSYM DISPID_FONT_STRIKE}
  DISPID_FONT_STRIKE  = 6;
  {$EXTERNALSYM DISPID_FONT_WEIGHT}
  DISPID_FONT_WEIGHT  = 7;
  {$EXTERNALSYM DISPID_FONT_CHARSET}
  DISPID_FONT_CHARSET = 8;

{ Dispatch ID constants for pictures }

  {$EXTERNALSYM DISPID_PICT_HANDLE}
  DISPID_PICT_HANDLE = 0;
  {$EXTERNALSYM DISPID_PICT_HPAL}
  DISPID_PICT_HPAL   = 2;
  {$EXTERNALSYM DISPID_PICT_TYPE}
  DISPID_PICT_TYPE   = 3;
  {$EXTERNALSYM DISPID_PICT_WIDTH}
  DISPID_PICT_WIDTH  = 4;
  {$EXTERNALSYM DISPID_PICT_HEIGHT}
  DISPID_PICT_HEIGHT = 5;
  {$EXTERNALSYM DISPID_PICT_RENDER}
  DISPID_PICT_RENDER = 6;

  // Reserved global Property IDs
  {$EXTERNALSYM PID_DICTIONARY}
  PID_DICTIONARY	 = 0;
  {$EXTERNALSYM PID_CODEPAGE}
  PID_CODEPAGE	         = $1;
  {$EXTERNALSYM PID_FIRST_USABLE}
  PID_FIRST_USABLE	 = $2;
  {$EXTERNALSYM PID_FIRST_NAME_DEFAULT}
  PID_FIRST_NAME_DEFAULT = $fff;
  {$EXTERNALSYM PID_LOCALE}
  PID_LOCALE	         = $80000000;
  {$EXTERNALSYM PID_MODIFY_TIME}
  PID_MODIFY_TIME	 = $80000001;
  {$EXTERNALSYM PID_SECURITY}
  PID_SECURITY	         = $80000002;
  {$EXTERNALSYM PID_ILLEGAL}
  PID_ILLEGAL            = $ffffffff;

  // Property IDs for the SummaryInformation Property Set
  {$EXTERNALSYM PIDSI_TITLE}
  PIDSI_TITLE               = $00000002;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_SUBJECT}
  PIDSI_SUBJECT             = $00000003;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_AUTHOR}
  PIDSI_AUTHOR              = $00000004;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_KEYWORDS}
  PIDSI_KEYWORDS            = $00000005;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_COMMENTS}
  PIDSI_COMMENTS            = $00000006;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_TEMPLATE}
  PIDSI_TEMPLATE            = $00000007;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_LASTAUTHOR}
  PIDSI_LASTAUTHOR          = $00000008;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_REVNUMBER}
  PIDSI_REVNUMBER           = $00000009;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_EDITTIME}
  PIDSI_EDITTIME            = $0000000a;  // VT_FILETIME (UTC)
  {$EXTERNALSYM PIDSI_LASTPRINTED}
  PIDSI_LASTPRINTED         = $0000000b;  // VT_FILETIME (UTC)
  {$EXTERNALSYM PIDSI_CREATE_DTM}
  PIDSI_CREATE_DTM          = $0000000c;  // VT_FILETIME (UTC)
  {$EXTERNALSYM PIDSI_LASTSAVE_DTM}
  PIDSI_LASTSAVE_DTM        = $0000000d;  // VT_FILETIME (UTC)
  {$EXTERNALSYM PIDSI_PAGECOUNT}
  PIDSI_PAGECOUNT           = $0000000e;  // VT_I4
  {$EXTERNALSYM PIDSI_WORDCOUNT}
  PIDSI_WORDCOUNT           = $0000000f;  // VT_I4
  {$EXTERNALSYM PIDSI_CHARCOUNT}
  PIDSI_CHARCOUNT           = $00000010;  // VT_I4
  {$EXTERNALSYM PIDSI_THUMBNAIL}
  PIDSI_THUMBNAIL           = $00000011;  // VT_CF
  {$EXTERNALSYM PIDSI_APPNAME}
  PIDSI_APPNAME             = $00000012;  // VT_LPSTR
  {$EXTERNALSYM PIDSI_DOC_SECURITY}
  PIDSI_DOC_SECURITY        = $00000013;  // VT_I4

  {$EXTERNALSYM PRSPEC_INVALID}
  PRSPEC_INVALID            = $ffffffff;
  {$EXTERNALSYM PRSPEC_LPWSTR}
  PRSPEC_LPWSTR             = 0;
  {$EXTERNALSYM PRSPEC_PROPID}
  PRSPEC_PROPID             = 1;

{ from WTYPES.H }
{ Result code }

type
  PHResult = ^HResult;
  {$EXTERNALSYM PSCODE}
  PSCODE = ^Integer;
  {$EXTERNALSYM SCODE}
  SCODE = Integer;

{ VT_INT and VT_UINT }
  {$EXTERNALSYM PSYSINT}
  PSYSINT = ^SYSINT;
  {$EXTERNALSYM SYSINT}
  SYSINT = Integer;
  {$EXTERNALSYM PSYSUINT}
  PSYSUINT = ^SYSUINT;
  {$EXTERNALSYM SYSUINT}
  SYSUINT = LongWord;

  PResultList = ^TResultList;
  TResultList = array[0..65535] of HRESULT;

{ Unknown lists }

  PUnknownList = ^TUnknownList;
  TUnknownList = array[0..65535] of IUnknown;

{ OLE character and string types }

  TOleChar = WideChar;
  POleStr = PWideChar;
  PPOleStr = ^POleStr;

  POleStrList = ^TOleStrList;
  TOleStrList = array[0..65535] of POleStr;

{ 64-bit large integer }

  {$EXTERNALSYM Largeint}
  Largeint = Int64;

{ 64-bit large unsigned integer }

  {$EXTERNALSYM PLargeuint}
  PLargeuint = ^Largeuint;
  {$EXTERNALSYM Largeuint}
  Largeuint = Int64;

{ Interface ID }

  PIID = PGUID;
  TIID = TGUID;

{ Class ID }

  PCLSID = PGUID;
  TCLSID = TGUID;

{ Object ID }

  PObjectID = ^TObjectID;
  {$EXTERNALSYM _OBJECTID}
  _OBJECTID = record
    Lineage: TGUID;
    Uniquifier: Longint;
  end;
  TObjectID = _OBJECTID;
  {$EXTERNALSYM OBJECTID}
  OBJECTID = TObjectID;

{ Locale ID }

  TLCID = DWORD;

{ Format ID }

  {$EXTERNALSYM FMTID}
  FMTID = TGUID;
  PFmtID = ^TFmtID;
  TFmtID = TGUID;

{ OLE control types }

  PTextMetricOle = PTextMetricW;
  TTextMetricOle = TTextMetricW;

  {$EXTERNALSYM OLE_COLOR}
  OLE_COLOR = DWORD;
  TOleColor = OLE_COLOR;

  PCoServerInfo = ^TCoServerInfo;
  {$EXTERNALSYM _COSERVERINFO}
  _COSERVERINFO = record
    dwReserved1: Longint;
    pwszName: LPWSTR;
    pAuthInfo: Pointer;
    dwReserved2: Longint;
  end;
  TCoServerInfo = _COSERVERINFO;
  {$EXTERNALSYM COSERVERINFO}
  COSERVERINFO = TCoServerInfo;

  PMultiQI = ^TMultiQI;
  {$EXTERNALSYM tagMULTI_QI}
  tagMULTI_QI = record
    IID: PIID;
    Itf: IUnknown;
    hr: HRESULT;
  end;
  TMultiQI = tagMULTI_QI;
  {$EXTERNALSYM MULTI_QI}
  MULTI_QI = TMultiQI;


  PMultiQIArray = ^TMultiQIArray;
  TMultiQIArray = array[0..65535] of TMultiQI;

{ from OAIDL.H }
  PSafeArrayBound = ^TSafeArrayBound;
  {$EXTERNALSYM tagSAFEARRAYBOUND}
  tagSAFEARRAYBOUND = record
    cElements: Longint;
    lLbound: Longint;
  end;
  TSafeArrayBound = tagSAFEARRAYBOUND;
  {$EXTERNALSYM SAFEARRAYBOUND}
  SAFEARRAYBOUND = TSafeArrayBound;

  PSafeArray = ^TSafeArray;
  {$EXTERNALSYM tagSAFEARRAY}
  tagSAFEARRAY = record
    cDims: Word;
    fFeatures: Word;
    cbElements: Longint;
    cLocks: Longint;
    pvData: Pointer;
    rgsabound: array[0..0] of TSafeArrayBound;
  end;
  TSafeArray = tagSAFEARRAY;
  {$EXTERNALSYM SAFEARRAY}
  SAFEARRAY = TSafeArray;


  {$EXTERNALSYM TOleDate}
  TOleDate = Double;
  POleDate = ^TOleDate;

  {$EXTERNALSYM TOleBool}
  TOleBool = WordBool;
  POleBool = ^TOleBool;

  {$EXTERNALSYM TVarType}
  TVarType = Word;

  TOleEnum = type Integer;

{ from OLECTL.H }
  {$EXTERNALSYM OLE_XPOS_PIXELS}
  OLE_XPOS_PIXELS  = Longint;
  {$EXTERNALSYM OLE_YPOS_PIXELS}
  OLE_YPOS_PIXELS  = Longint;
  {$EXTERNALSYM OLE_XSIZE_PIXELS}
  OLE_XSIZE_PIXELS = Longint;
  {$EXTERNALSYM OLE_YSIZE_PIXELS}
  OLE_YSIZE_PIXELS = Longint;

  {$EXTERNALSYM OLE_XPOS_HIMETRIC}
  OLE_XPOS_HIMETRIC  = Longint;
  {$EXTERNALSYM OLE_YPOS_HIMETRIC}
  OLE_YPOS_HIMETRIC  = Longint;
  {$EXTERNALSYM OLE_XSIZE_HIMETRIC}
  OLE_XSIZE_HIMETRIC = Longint;
  {$EXTERNALSYM OLE_YSIZE_HIMETRIC}
  OLE_YSIZE_HIMETRIC = Longint;

  {$EXTERNALSYM OLE_XPOS_CONTAINER}
  OLE_XPOS_CONTAINER  = Single;
  {$EXTERNALSYM OLE_YPOS_CONTAINER}
  OLE_YPOS_CONTAINER  = Single;
  {$EXTERNALSYM OLE_XSIZE_CONTAINER}
  OLE_XSIZE_CONTAINER = Single;
  {$EXTERNALSYM OLE_YSIZE_CONTAINER}
  OLE_YSIZE_CONTAINER = Single;

  {$EXTERNALSYM OLE_TRISTATE}
  OLE_TRISTATE = SmallInt;

const
  {$EXTERNALSYM triUnchecked}
  triUnchecked = 0;
  {$EXTERNALSYM triChecked}
  triChecked   = 1;
  {$EXTERNALSYM triGray}
  triGray      = 2;

type
  {$EXTERNALSYM OLE_OPTEXCLUSIVE}
  OLE_OPTEXCLUSIVE = WordBool;

  {$EXTERNALSYM OLE_CANCELBOOL}
  OLE_CANCELBOOL = WordBool;

  {$EXTERNALSYM OLE_ENABLEDEFAULTBOOL}
  OLE_ENABLEDEFAULTBOOL = WordBool;

  {$EXTERNALSYM OLE_HANDLE}
  OLE_HANDLE = LongWord;

  {$EXTERNALSYM FONTNAME}
  FONTNAME = WideString;

  {$EXTERNALSYM FONTSIZE}
  FONTSIZE = Currency;

  {$EXTERNALSYM FONTBOLD}
  FONTBOLD = WordBool;

  {$EXTERNALSYM FONTITALIC}
  FONTITALIC = WordBool;

  {$EXTERNALSYM FONTUNDERSCORE}
  FONTUNDERSCORE = WordBool;

  {$EXTERNALSYM FONTSTRIKETHROUGH}
  FONTSTRIKETHROUGH = WordBool;


{ Registration function types }

  {$EXTERNALSYM TDLLRegisterServer}
  TDLLRegisterServer = function: HResult stdcall;
  {$EXTERNALSYM TDLLUnregisterServer}
  TDLLUnregisterServer = function: HResult stdcall;

{ from OCIDL.H }
{ TPointF structure }

  PPointF = ^TPointF;
  {$EXTERNALSYM tagPOINTF}
  tagPOINTF = record
    x: Single;
    y: Single;
  end;
  TPointF = tagPOINTF;
  {$EXTERNALSYM POINTF}
  POINTF = TPointF;


{ TControlInfo structure }

  PControlInfo = ^TControlInfo;
  {$EXTERNALSYM tagCONTROLINFO}
  tagCONTROLINFO = record
    cb: Longint;
    hAccel: HAccel;
    cAccel: Word;
    dwFlags: Longint;
  end;
  TControlInfo = tagCONTROLINFO;
  {$EXTERNALSYM CONTROLINFO}
  CONTROLINFO = TControlInfo;


{ from OBJIDL.H }
{ Forward declarations }

  IStream = interface;
  IRunningObjectTable = interface;
  IEnumString = interface;
  IMoniker = interface;
  IAdviseSink = interface;
  ITypeInfo = interface;
  ITypeInfo2 = interface;
  ITypeComp = interface;
  ITypeLib = interface;
  ITypeLib2 = interface;
  IEnumOLEVERB = interface;
  IOleInPlaceActiveObject = interface;
  IOleControl = interface;
  IOleControlSite = interface;
  ISimpleFrameSite = interface;
  IPersistStreamInit = interface;
  IPersistPropertyBag = interface;
  IPropertyNotifySink = interface;
  IProvideClassInfo = interface;
  IConnectionPointContainer = interface;
  IEnumConnectionPoints = interface;
  IConnectionPoint = interface;
  IEnumConnections = interface;
  IClassFactory2 = interface;
  ISpecifyPropertyPages = interface;
  IPerPropertyBrowsing = interface;
  IPropertyPageSite = interface;
  IPropertyPage = interface;
  IPropertyPage2 = interface;
  IPropertySetStorage = interface;
  IPropertyStorage = interface;
  IEnumSTATPROPSTG = interface;
  IEnumSTATPROPSETSTG = interface;

{ IClassFactory interface }

  {$EXTERNALSYM IClassFactory}
  IClassFactory = interface(IUnknown)
    ['{00000001-0000-0000-C000-000000000046}']
    function CreateInstance(const unkOuter: IUnknown; const iid: TIID;
      out obj): HResult; stdcall;
    function LockServer(fLock: BOOL): HResult; stdcall;
  end;

{ IMarshal interface }

  {$EXTERNALSYM IMarshal}
  IMarshal = interface(IUnknown)
    ['{00000003-0000-0000-C000-000000000046}']
    function GetUnmarshalClass(const iid: TIID; pv: Pointer;
      dwDestContext: Longint; pvDestContext: Pointer; mshlflags: Longint;
      out cid: TCLSID): HResult; stdcall;
    function GetMarshalSizeMax(const iid: TIID; pv: Pointer;
      dwDestContext: Longint; pvDestContext: Pointer; mshlflags: Longint;
      out size: Longint): HResult; stdcall;
    function MarshalInterface(const stm: IStream; const iid: TIID; pv: Pointer;
      dwDestContext: Longint; pvDestContext: Pointer;
      mshlflags: Longint): HResult; stdcall;
    function UnmarshalInterface(const stm: IStream; const iid: TIID;
      out pv): HResult; stdcall;
    function ReleaseMarshalData(const stm: IStream): HResult;
      stdcall;
    function DisconnectObject(dwReserved: Longint): HResult;
      stdcall;
  end;

{ IMalloc interface }

  {$EXTERNALSYM IMalloc}
  IMalloc = interface(IUnknown)
    ['{00000002-0000-0000-C000-000000000046}']
    function Alloc(cb: Longint): Pointer; stdcall;
    function Realloc(pv: Pointer; cb: Longint): Pointer; stdcall;
    procedure Free(pv: Pointer); stdcall;
    function GetSize(pv: Pointer): Longint; stdcall;
    function DidAlloc(pv: Pointer): Integer; stdcall;
    procedure HeapMinimize; stdcall;
  end;

{ IMallocSpy interface }

  {$EXTERNALSYM IMallocSpy}
  IMallocSpy = interface(IUnknown)
    ['{0000001D-0000-0000-C000-000000000046}']
    function PreAlloc(cbRequest: Longint): Longint; stdcall;
    function PostAlloc(pActual: Pointer): Pointer; stdcall;
    function PreFree(pRequest: Pointer; fSpyed: BOOL): Pointer; stdcall;
    procedure PostFree(fSpyed: BOOL); stdcall;
    function PreRealloc(pRequest: Pointer; cbRequest: Longint;
      out ppNewRequest: Pointer; fSpyed: BOOL): Longint; stdcall;
    function PostRealloc(pActual: Pointer; fSpyed: BOOL): Pointer; stdcall;
    function PreGetSize(pRequest: Pointer; fSpyed: BOOL): Pointer; stdcall;
    function PostGetSize(pActual: Pointer; fSpyed: BOOL): Longint; stdcall;
    function PreDidAlloc(pRequest: Pointer; fSpyed: BOOL): Pointer; stdcall;
    function PostDidAlloc(pRequest: Pointer; fSpyed: BOOL; fActual: Integer): Integer; stdcall;
    procedure PreHeapMinimize; stdcall;
    procedure PostHeapMinimize; stdcall;
  end;

{ IStdMarshalInfo interface }

  {$EXTERNALSYM IStdMarshalInfo}
  IStdMarshalInfo = interface(IUnknown)
    ['{00000018-0000-0000-C000-000000000046}']
    function GetClassForHandler(dwDestContext: Longint; pvDestContext: Pointer;
      out clsid: TCLSID): HResult; stdcall;
  end;

{ IExternalConnection interface }

  {$EXTERNALSYM IExternalConnection}
  IExternalConnection = interface(IUnknown)
    ['{00000019-0000-0000-C000-000000000046}']
    function AddConnection(extconn: Longint; reserved: Longint): Longint;
      stdcall;
    function ReleaseConnection(extconn: Longint; reserved: Longint;
      fLastReleaseCloses: BOOL): Longint; stdcall;
  end;

{ IWeakRef interface }

  {$EXTERNALSYM IWeakRef}
  IWeakRef = interface(IUnknown)
    ['{A35E20C2-837D-11D0-9E9F-00A02457621F}']
    function ChangeWeakCount(delta: Longint): Longint; stdcall;
    function ReleaseKeepAlive(const unkReleased: IUnknown;
      reserved: Longint): Longint; stdcall;
  end;

{ IEnumUnknown interface }

  {$EXTERNALSYM IEnumUnknown}
  IEnumUnknown = interface(IUnknown)
    ['{00000100-0000-0000-C000-000000000046}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out enm: IEnumUnknown): HResult; stdcall;
  end;

{ IBindCtx interface }

  PBindOpts = ^TBindOpts;
  {$EXTERNALSYM tagBIND_OPTS}
  tagBIND_OPTS = record
    cbStruct: Longint;
    grfFlags: Longint;
    grfMode: Longint;
    dwTickCountDeadline: Longint;
  end;
  TBindOpts = tagBIND_OPTS;
  {$EXTERNALSYM BIND_OPTS}
  BIND_OPTS = TBindOpts;


  {$EXTERNALSYM IBindCtx}
  IBindCtx = interface(IUnknown)
    ['{0000000E-0000-0000-C000-000000000046}']
    function RegisterObjectBound(const unk: IUnknown): HResult; stdcall;
    function RevokeObjectBound(const unk: IUnknown): HResult; stdcall;
    function ReleaseBoundObjects: HResult; stdcall;
    function SetBindOptions(const bindopts: TBindOpts): HResult; stdcall;
    function GetBindOptions(var bindopts: TBindOpts): HResult; stdcall;
    function GetRunningObjectTable(out rot: IRunningObjectTable): HResult;
      stdcall;
    function RegisterObjectParam(pszKey: POleStr; const unk: IUnknown): HResult;
      stdcall;
    function GetObjectParam(pszKey: POleStr; out unk: IUnknown): HResult;
      stdcall;
    function EnumObjectParam(out Enum: IEnumString): HResult; stdcall;
    function RevokeObjectParam(pszKey: POleStr): HResult; stdcall;
  end;

{ IEnumMoniker interface }

  {$EXTERNALSYM IEnumMoniker}
  IEnumMoniker = interface(IUnknown)
    ['{00000102-0000-0000-C000-000000000046}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out enm: IEnumMoniker): HResult; stdcall;
  end;

{ IRunnableObject interface }

  {$EXTERNALSYM IRunnableObject}
  IRunnableObject = interface(IUnknown)
    ['{00000126-0000-0000-C000-000000000046}']
    function GetRunningClass(out clsid: TCLSID): HResult; stdcall;
    function Run(const bc: IBindCtx): HResult; stdcall;
    function IsRunning: BOOL; stdcall;
    function LockRunning(fLock: BOOL; fLastUnlockCloses: BOOL): HResult;
      stdcall;
    function SetContainedObject(fContained: BOOL): HResult; stdcall;
  end;

{ IRunningObjectTable interface }

  {$EXTERNALSYM IRunningObjectTable}
  IRunningObjectTable = interface(IUnknown)
    ['{00000010-0000-0000-C000-000000000046}']
    function Register(grfFlags: Longint; const unkObject: IUnknown;
      const mkObjectName: IMoniker; out dwRegister: Longint): HResult; stdcall;
    function Revoke(dwRegister: Longint): HResult; stdcall;
    function IsRunning(const mkObjectName: IMoniker): HResult; stdcall;
    function GetObject(const mkObjectName: IMoniker;
      out unkObject: IUnknown): HResult; stdcall;
    function NoteChangeTime(dwRegister: Longint;
      const filetime: TFileTime): HResult; stdcall;
    function GetTimeOfLastChange(const mkObjectName: IMoniker;
      out filetime: TFileTime): HResult; stdcall;
    function EnumRunning(out enumMoniker: IEnumMoniker): HResult; stdcall;
  end;

{ IPersist interface }

  {$EXTERNALSYM IPersist}
  IPersist = interface(IUnknown)
    ['{0000010C-0000-0000-C000-000000000046}']
    function GetClassID(out classID: TCLSID): HResult; stdcall;
  end;

{ IPersistStream interface }

  {$EXTERNALSYM IPersistStream}
  IPersistStream = interface(IPersist)
    ['{00000109-0000-0000-C000-000000000046}']
    function IsDirty: HResult; stdcall;
    function Load(const stm: IStream): HResult; stdcall;
    function Save(const stm: IStream; fClearDirty: BOOL): HResult; stdcall;
    function GetSizeMax(out cbSize: Largeint): HResult; stdcall;
  end;

{ IMoniker interface }

  {$EXTERNALSYM PIMoniker}
  PIMoniker = ^IMoniker;
  {$EXTERNALSYM IMoniker}
  IMoniker = interface(IPersistStream)
    ['{0000000F-0000-0000-C000-000000000046}']
    function BindToObject(const bc: IBindCtx; const mkToLeft: IMoniker;
      const iidResult: TIID; out vResult): HResult; stdcall;
    function BindToStorage(const bc: IBindCtx; const mkToLeft: IMoniker;
      const iid: TIID; out vObj): HResult; stdcall;
    function Reduce(const bc: IBindCtx; dwReduceHowFar: Longint;
      mkToLeft: PIMoniker; out mkReduced: IMoniker): HResult; stdcall;
    function ComposeWith(const mkRight: IMoniker; fOnlyIfNotGeneric: BOOL;
      out mkComposite: IMoniker): HResult; stdcall;
    function Enum(fForward: BOOL; out enumMoniker: IEnumMoniker): HResult;
      stdcall;
    function IsEqual(const mkOtherMoniker: IMoniker): HResult; stdcall;
    function Hash(out dwHash: Longint): HResult; stdcall;
    function IsRunning(const bc: IBindCtx; const mkToLeft: IMoniker;
      const mkNewlyRunning: IMoniker): HResult; stdcall;
    function GetTimeOfLastChange(const bc: IBindCtx; const mkToLeft: IMoniker;
      out filetime: TFileTime): HResult; stdcall;
    function Inverse(out mk: IMoniker): HResult; stdcall;
    function CommonPrefixWith(const mkOther: IMoniker;
      out mkPrefix: IMoniker): HResult; stdcall;
    function RelativePathTo(const mkOther: IMoniker;
      out mkRelPath: IMoniker): HResult; stdcall;
    function GetDisplayName(const bc: IBindCtx; const mkToLeft: IMoniker;
      out pszDisplayName: POleStr): HResult; stdcall;
    function ParseDisplayName(const bc: IBindCtx; const mkToLeft: IMoniker;
      pszDisplayName: POleStr; out chEaten: Longint;
      out mkOut: IMoniker): HResult; stdcall;
    function IsSystemMoniker(out dwMksys: Longint): HResult; stdcall;
  end;

{ IEnumString interface }

  {$EXTERNALSYM IEnumString}
  IEnumString = interface(IUnknown)
    ['{00000101-0000-0000-C000-000000000046}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out enm: IEnumString): HResult; stdcall;
  end;

{ IStream interface }

  PStatStg = ^TStatStg;
  {$EXTERNALSYM tagSTATSTG}
  tagSTATSTG = record
    pwcsName: POleStr;
    dwType: Longint;
    cbSize: Largeint;
    mtime: TFileTime;
    ctime: TFileTime;
    atime: TFileTime;
    grfMode: Longint;
    grfLocksSupported: Longint;
    clsid: TCLSID;
    grfStateBits: Longint;
    reserved: Longint;
  end;
  TStatStg = tagSTATSTG;
  {$EXTERNALSYM STATSTG}
  STATSTG = TStatStg;

  {$EXTERNALSYM ISequentialStream}
  ISequentialStream = interface(IUnknown)
    ['{0c733a30-2a1c-11ce-ade5-00aa0044773d}']
    function Read(pv: Pointer; cb: Longint; pcbRead: PLongint): HResult;
      stdcall;
    function Write(pv: Pointer; cb: Longint; pcbWritten: PLongint): HResult;
      stdcall;
  end;

  {$EXTERNALSYM IStream}
  IStream = interface(ISequentialStream)
    ['{0000000C-0000-0000-C000-000000000046}']
    function Seek(dlibMove: Largeint; dwOrigin: Longint;
      out libNewPosition: Largeint): HResult; stdcall;
    function SetSize(libNewSize: Largeint): HResult; stdcall;
    function CopyTo(stm: IStream; cb: Largeint; out cbRead: Largeint;
      out cbWritten: Largeint): HResult; stdcall;
    function Commit(grfCommitFlags: Longint): HResult; stdcall;
    function Revert: HResult; stdcall;
    function LockRegion(libOffset: Largeint; cb: Largeint;
      dwLockType: Longint): HResult; stdcall;
    function UnlockRegion(libOffset: Largeint; cb: Largeint;
      dwLockType: Longint): HResult; stdcall;
    function Stat(out statstg: TStatStg; grfStatFlag: Longint): HResult;
      stdcall;
    function Clone(out stm: IStream): HResult; stdcall;
  end;

{ IEnumStatStg interface }

  {$EXTERNALSYM IEnumStatStg}
  IEnumStatStg = interface(IUnknown)
    ['{0000000D-0000-0000-C000-000000000046}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out enm: IEnumStatStg): HResult; stdcall;
  end;

{ IStorage interface }

  TSNB = ^POleStr;

  {$EXTERNALSYM IStorage}
  IStorage = interface(IUnknown)
    ['{0000000B-0000-0000-C000-000000000046}']
    function CreateStream(pwcsName: POleStr; grfMode: Longint; reserved1: Longint;
      reserved2: Longint; out stm: IStream): HResult; stdcall;
    function OpenStream(pwcsName: POleStr; reserved1: Pointer; grfMode: Longint;
      reserved2: Longint; out stm: IStream): HResult; stdcall;
    function CreateStorage(pwcsName: POleStr; grfMode: Longint;
      dwStgFmt: Longint; reserved2: Longint; out stg: IStorage): HResult;
      stdcall;
    function OpenStorage(pwcsName: POleStr; const stgPriority: IStorage;
      grfMode: Longint; snbExclude: TSNB; reserved: Longint;
      out stg: IStorage): HResult; stdcall;
    function CopyTo(ciidExclude: Longint; rgiidExclude: PIID;
      snbExclude: TSNB; const stgDest: IStorage): HResult; stdcall;
    function MoveElementTo(pwcsName: POleStr; const stgDest: IStorage;
      pwcsNewName: POleStr; grfFlags: Longint): HResult; stdcall;
    function Commit(grfCommitFlags: Longint): HResult; stdcall;
    function Revert: HResult; stdcall;
    function EnumElements(reserved1: Longint; reserved2: Pointer; reserved3: Longint;
      out enm: IEnumStatStg): HResult; stdcall;
    function DestroyElement(pwcsName: POleStr): HResult; stdcall;
    function RenameElement(pwcsOldName: POleStr;
      pwcsNewName: POleStr): HResult; stdcall;
    function SetElementTimes(pwcsName: POleStr; const ctime: TFileTime;
      const atime: TFileTime; const mtime: TFileTime): HResult;
      stdcall;
    function SetClass(const clsid: TCLSID): HResult; stdcall;
    function SetStateBits(grfStateBits: Longint; grfMask: Longint): HResult;
      stdcall;
    function Stat(out statstg: TStatStg; grfStatFlag: Longint): HResult;
      stdcall;
  end;

{ IPersistFile interface }

  {$EXTERNALSYM IPersistFile}
  IPersistFile = interface(IPersist)
    ['{0000010B-0000-0000-C000-000000000046}']
    function IsDirty: HResult; stdcall;
    function Load(pszFileName: POleStr; dwMode: Longint): HResult;
      stdcall;
    function Save(pszFileName: POleStr; fRemember: BOOL): HResult;
      stdcall;
    function SaveCompleted(pszFileName: POleStr): HResult;
      stdcall;
    function GetCurFile(out pszFileName: POleStr): HResult;
      stdcall;
  end;

{ IPersistStorage interface }

  {$EXTERNALSYM IPersistStorage}
  IPersistStorage = interface(IPersist)
    ['{0000010A-0000-0000-C000-000000000046}']
    function IsDirty: HResult; stdcall;
    function InitNew(const stg: IStorage): HResult; stdcall;
    function Load(const stg: IStorage): HResult; stdcall;
    function Save(const stgSave: IStorage; fSameAsLoad: BOOL): HResult;
      stdcall;
    function SaveCompleted(const stgNew: IStorage): HResult; stdcall;
    function HandsOffStorage: HResult; stdcall;
  end;

{ ILockBytes interface }

  {$EXTERNALSYM ILockBytes}
  ILockBytes = interface(IUnknown)
    ['{0000000A-0000-0000-C000-000000000046}']
    function ReadAt(ulOffset: Largeint; pv: Pointer; cb: Longint;
      pcbRead: PLongint): HResult; stdcall;
    function WriteAt(ulOffset: Largeint; pv: Pointer; cb: Longint;
      pcbWritten: PLongint): HResult; stdcall;
    function Flush: HResult; stdcall;
    function SetSize(cb: Largeint): HResult; stdcall;
    function LockRegion(libOffset: Largeint; cb: Largeint;
      dwLockType: Longint): HResult; stdcall;
    function UnlockRegion(libOffset: Largeint; cb: Largeint;
      dwLockType: Longint): HResult; stdcall;
    function Stat(out statstg: TStatStg; grfStatFlag: Longint): HResult;
      stdcall;
  end;

{ IEnumFormatEtc interface }

  PDVTargetDevice = ^TDVTargetDevice;
  {$EXTERNALSYM tagDVTARGETDEVICE}
  tagDVTARGETDEVICE = record
    tdSize: Longint;
    tdDriverNameOffset: Word;
    tdDeviceNameOffset: Word;
    tdPortNameOffset: Word;
    tdExtDevmodeOffset: Word;
    tdData: record end;
  end;
  TDVTargetDevice = tagDVTARGETDEVICE;
  {$EXTERNALSYM DVTARGETDEVICE}
  DVTARGETDEVICE = TDVTargetDevice;


  {$EXTERNALSYM PClipFormat}
  PClipFormat = ^TClipFormat;
  {$EXTERNALSYM TClipFormat}
  TClipFormat = Word;

  PFormatEtc = ^TFormatEtc;
  {$EXTERNALSYM tagFORMATETC}
  tagFORMATETC = record
    cfFormat: TClipFormat;
    ptd: PDVTargetDevice;
    dwAspect: Longint;
    lindex: Longint;
    tymed: Longint;
  end;
  TFormatEtc = tagFORMATETC;
  {$EXTERNALSYM FORMATETC}
  FORMATETC = TFormatEtc;


  {$EXTERNALSYM IEnumFORMATETC}
  IEnumFORMATETC = interface(IUnknown)
    ['{00000103-0000-0000-C000-000000000046}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out Enum: IEnumFormatEtc): HResult; stdcall;
  end;

{ IEnumStatData interface }

  PStatData = ^TStatData;
  {$EXTERNALSYM tagSTATDATA}
  tagSTATDATA = record
    formatetc: TFormatEtc;
    advf: Longint;
    advSink: IAdviseSink;
    dwConnection: Longint;
  end;
  TStatData = tagSTATDATA;
  {$EXTERNALSYM STATDATA}
  STATDATA = TStatData;


  {$EXTERNALSYM IEnumSTATDATA}
  IEnumSTATDATA = interface(IUnknown)
    ['{00000105-0000-0000-C000-000000000046}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out Enum: IEnumStatData): HResult; stdcall;
  end;

{ IRootStorage interface }

  {$EXTERNALSYM IRootStorage}
  IRootStorage = interface(IUnknown)
    ['{00000012-0000-0000-C000-000000000046}']
    function SwitchToFile(pszFile: POleStr): HResult; stdcall;
  end;

{ IAdviseSink interface }

  PRemStgMedium = ^TRemStgMedium;
  {$EXTERNALSYM tagRemSTGMEDIUM}
  tagRemSTGMEDIUM = record
    tymed: Longint;
    dwHandleType: Longint;
    pData: Longint;
    pUnkForRelease: Longint;
    cbData: Longint;
    data: record end;
  end;
  TRemStgMedium = tagRemSTGMEDIUM;
  {$EXTERNALSYM RemSTGMEDIUM}
  RemSTGMEDIUM = TRemStgMedium;


  PStgMedium = ^TStgMedium;
  {$EXTERNALSYM tagSTGMEDIUM}
  tagSTGMEDIUM = record
    tymed: Longint;
    case Integer of
      0: (hBitmap: HBitmap; unkForRelease: Pointer{IUnknown});
      1: (hMetaFilePict: THandle);
      2: (hEnhMetaFile: THandle);
      3: (hGlobal: HGlobal);
      4: (lpszFileName: POleStr);
      5: (stm: Pointer{IStream});
      6: (stg: Pointer{IStorage});
  end;
  TStgMedium = tagSTGMEDIUM;
  {$EXTERNALSYM STGMEDIUM}
  STGMEDIUM = TStgMedium;


  {$EXTERNALSYM IAdviseSink}
  IAdviseSink = interface(IUnknown)
    ['{0000010F-0000-0000-C000-000000000046}']
    procedure OnDataChange(const formatetc: TFormatEtc; const stgmed: TStgMedium);
      stdcall;
    procedure OnViewChange(dwAspect: Longint; lindex: Longint);
      stdcall;
    procedure OnRename(const mk: IMoniker); stdcall;
    procedure OnSave; stdcall;
    procedure OnClose; stdcall;
  end;

{ IAdviseSink2 interface }

  {$EXTERNALSYM IAdviseSink2}
  IAdviseSink2 = interface(IAdviseSink)
    ['{00000125-0000-0000-C000-000000000046}']
    procedure OnLinkSrcChange(const mk: IMoniker); stdcall;
  end;

{ IDataObject interface }

  {$EXTERNALSYM IDataObject}
  IDataObject = interface(IUnknown)
    ['{0000010E-0000-0000-C000-000000000046}']
    function GetData(const formatetcIn: TFormatEtc; out medium: TStgMedium):
      HResult; stdcall;
    function GetDataHere(const formatetc: TFormatEtc; out medium: TStgMedium):
      HResult; stdcall;
    function QueryGetData(const formatetc: TFormatEtc): HResult;
      stdcall;
    function GetCanonicalFormatEtc(const formatetc: TFormatEtc;
      out formatetcOut: TFormatEtc): HResult; stdcall;
    function SetData(const formatetc: TFormatEtc; var medium: TStgMedium;
      fRelease: BOOL): HResult; stdcall;
    function EnumFormatEtc(dwDirection: Longint; out enumFormatEtc:
      IEnumFormatEtc): HResult; stdcall;
    function DAdvise(const formatetc: TFormatEtc; advf: Longint;
      const advSink: IAdviseSink; out dwConnection: Longint): HResult; stdcall;
    function DUnadvise(dwConnection: Longint): HResult; stdcall;
    function EnumDAdvise(out enumAdvise: IEnumStatData): HResult;
      stdcall;
  end;

{ IDataAdviseHolder interface }

  {$EXTERNALSYM IDataAdviseHolder}
  IDataAdviseHolder = interface(IUnknown)
    ['{00000110-0000-0000-C000-000000000046}']
    function Advise(const dataObject: IDataObject; const fetc: TFormatEtc;
      advf: Longint; const advise: IAdviseSink; out pdwConnection: Longint): HResult;
      stdcall;
    function Unadvise(dwConnection: Longint): HResult; stdcall;
    function EnumAdvise(out enumAdvise: IEnumStatData): HResult; stdcall;
    function SendOnDataChange(const dataObject: IDataObject; dwReserved: Longint;
      advf: Longint): HResult; stdcall;
  end;

{ IMessageFilter interface }

  PInterfaceInfo = ^TInterfaceInfo;
  {$EXTERNALSYM tagINTERFACEINFO}
  tagINTERFACEINFO = record
    unk: IUnknown;
    iid: TIID;
    wMethod: Word;
  end;
  TInterfaceInfo = tagINTERFACEINFO;
  {$EXTERNALSYM INTERFACEINFO}
  INTERFACEINFO = TInterfaceInfo;


  {$EXTERNALSYM IMessageFilter}
  IMessageFilter = interface(IUnknown)
    ['{00000016-0000-0000-C000-000000000046}']
    function HandleInComingCall(dwCallType: Longint; htaskCaller: HTask;
      dwTickCount: Longint; lpInterfaceInfo: PInterfaceInfo): Longint;
      stdcall;
    function RetryRejectedCall(htaskCallee: HTask; dwTickCount: Longint;
      dwRejectType: Longint): Longint; stdcall;
    function MessagePending(htaskCallee: HTask; dwTickCount: Longint;
      dwPendingType: Longint): Longint; stdcall;
  end;

{ IRpcChannelBuffer interface }

  TRpcOleDataRep = DWORD;

  PRpcOleMessage = ^TRpcOleMessage;
  {$EXTERNALSYM tagRPCOLEMESSAGE}
  tagRPCOLEMESSAGE = record
    reserved1: Pointer;
    dataRepresentation: TRpcOleDataRep;
    Buffer: Pointer;
    cbBuffer: Longint;
    iMethod: Longint;
    reserved2: array[0..4] of Pointer;
    rpcFlags: Longint;
  end;
  TRpcOleMessage = tagRPCOLEMESSAGE;
  {$EXTERNALSYM RPCOLEMESSAGE}
  RPCOLEMESSAGE = TRpcOleMessage;


  {$EXTERNALSYM IRpcChannelBuffer}
  IRpcChannelBuffer = interface(IUnknown)
    ['{D5F56B60-593B-101A-B569-08002B2DBF7A}']
    function GetBuffer(var message: TRpcOleMessage; iid: TIID): HResult;
      stdcall;
    function SendReceive(var message: TRpcOleMessage;
      var status: Longint): HResult; stdcall;
    function FreeBuffer(var message: TRpcOleMessage): HResult;
      stdcall;
    function GetDestCtx(out dwDestContext: Longint;
      out pvDestContext): HResult; stdcall;
    function IsConnected: HResult; stdcall;
  end;

{ IRpcProxyBuffer interface }

  {$EXTERNALSYM IRpcProxyBuffer}
  IRpcProxyBuffer = interface(IUnknown)
    ['{D5F56A34-593B-101A-B569-08002B2DBF7A}']
    function Connect(const rpcChannelBuffer: IRpcChannelBuffer): HResult;
      stdcall;
    procedure Disconnect; stdcall;
  end;

{ IRpcStubBuffer interface }

  {$EXTERNALSYM IRpcStubBuffer}
  IRpcStubBuffer = interface(IUnknown)
    ['{D5F56AFC-593B-101A-B569-08002B2DBF7A}']
    function Connect(const unkServer: IUnknown): HResult; stdcall;
    procedure Disconnect; stdcall;
    function Invoke(var rpcmsg: TRpcOleMessage; rpcChannelBuffer:
      IRpcChannelBuffer): HResult; stdcall;
    function IsIIDSupported(const iid: TIID): Pointer{IRpcStubBuffer};
      stdcall;
    function CountRefs: Longint; stdcall;
    function DebugServerQueryInterface(var pv): HResult;
      stdcall;
    procedure DebugServerRelease(pv: Pointer); stdcall;
  end;

{ IPSFactoryBuffer interface }

  {$EXTERNALSYM IPSFactoryBuffer}
  IPSFactoryBuffer = interface(IUnknown)
    ['{D5F569D0-593B-101A-B569-08002B2DBF7A}']
    function CreateProxy(const unkOuter: IUnknown; const iid: TIID;
      out proxy: IRpcProxyBuffer; out pv): HResult; stdcall;
    function CreateStub(const iid: TIID; const unkServer: IUnknown;
      out stub: IRpcStubBuffer): HResult; stdcall;
  end;

  {$EXTERNALSYM IChannelHook}
  IChannelHook = interface(IUnknown)
    ['{1008C4A0-7613-11CF-9AF1-0020AF6E72F4}']
    procedure ClientGetSize(const uExtent: TGUID; const iid: TIID;
      out DataSize: Longint); stdcall;
    procedure ClientFillBuffer(const uExtent: TGUID; const iid: TIID;
      var DataSize: Longint; var DataBuffer); stdcall;
    procedure ClientNotify(const uExtent: TGUID; const iid: TIID;
      DataSize: Longint; var DataBuffer; lDataRep: Longint;
      hrFault: HResult); stdcall;
    procedure ServerNotify(const uExtent: TGUID; const iid: TIID;
      DataSize: Longint; var DataBuffer; lDataRep: Longint); stdcall;
    procedure ServerGetSize(const uExtent: TGUID; const iid: TIID;
      hrFault: HResult; out DataSize: Longint); stdcall;
    procedure ServerFillBuffer(const uExtent: TGUID; const iid: TIID;
      var DataSize: Longint; var DataBuffer; hrFault: HResult); stdcall;
  end;

  {$EXTERNALSYM IFillLockBytes}
  IFillLockBytes = interface(IUnknown)
    ['{99CAF010-415E-11CF-8814-00AA00B569F5}']
    function FillAppend(const pv; cb: Longint;
      out cbWritten: Longint): HResult; stdcall;
    function FillAt(Offset: Longint; const pv; cb: Longint;
      out cbWritten: Longint): HResult; stdcall;
    function SetFillSize(Offset: Longint): HResult; stdcall;
    function Terminate(bCanceled: Boolean): HResult; stdcall;
  end;

{ Automation types }

  PBStr = ^TBStr;
  TBStr = POleStr;

  PBStrList = ^TBStrList;
  TBStrList = array[0..65535] of TBStr;

  PComp = ^Comp;

{ from WTYPES.H }
  PDecimal = ^TDecimal;
  {$EXTERNALSYM tagDEC}
  tagDEC = packed record
    wReserved: Word;
    case Integer of
      0: (scale, sign: Byte; Hi32: Longint;
      case Integer of
        0: (Lo32, Mid32: Longint);
        1: (Lo64: LONGLONG));
      1: (signscale: Word);
  end;
  TDecimal = tagDEC;
  {$EXTERNALSYM DECIMAL}
  DECIMAL = TDecimal;

  (* tagBLOB related types cause problem due to two definitions of BLOB in wtypes.h/nspapi.h *)
  (* Investigating something that will always work even when a BLOB is not a tagBLOB         *)
  {$EXTERNALSYM PBlob}
  PBlob = ^TBlob;
  {$EXTERNALSYM tagBLOB}
  tagBLOB = record
    cbSize: Longint;
    pBlobData: Pointer;
  end;
  (* tagBLOB related types cause problem due to two definitions of BLOB in wtypes.h/nspapi.h *)
  (* Investigating something that will always work even when a BLOB is not a tagBLOB         *)
  {$EXTERNALSYM TBlob}
  TBlob = tagBLOB;
  {$EXTERNALSYM BLOB}
  BLOB = TBlob;

  PClipData = ^TClipData;
  {$EXTERNALSYM tagCLIPDATA}
  tagCLIPDATA = record
    cbSize: Longint;
    ulClipFmt: Longint;
    pClipData: Pointer;
  end;
  TClipData = tagCLIPDATA;
  {$EXTERNALSYM CLIPDATA}
  CLIPDATA = TClipData;

{ IPropertyStorage / IPropertySetStorage }

  PPropVariant = ^TPropVariant;

  {$EXTERNALSYM tagCAUB}
  tagCAUB = packed record
    cElems: ULONG;
    pElems: PByte;
  end;
  {$EXTERNALSYM CAUB}
  CAUB = tagCAUB;
  PCAUB = ^TCAUB;
  TCAUB = tagCAUB;
                         
  {$EXTERNALSYM tagCAI}
  tagCAI = packed record
    cElems: ULONG;
    pElems: PShortInt;
  end;
  {$EXTERNALSYM CAI}
  CAI = tagCAI;
  PCAI = ^TCAI;
  TCAI = tagCAI;

  {$EXTERNALSYM tagCAUI}
  tagCAUI = packed record
    cElems: ULONG;
    pElems: PWord;
  end;
  {$EXTERNALSYM CAUI}
  CAUI = tagCAUI;
  PCAUI = ^TCAUI;
  TCAUI = tagCAUI;

  {$EXTERNALSYM tagCAL}
  tagCAL = packed record
    cElems: ULONG;
    pElems: PLongint;
  end;
  {$EXTERNALSYM CAL}
  CAL = tagCAL;
  PCAL = ^TCAL;
  TCAL = tagCAL;

  {$EXTERNALSYM tagCAUL}
  tagCAUL = packed record
    cElems: ULONG;
    pElems: PULONG;
  end;
  {$EXTERNALSYM CAUL}
  CAUL = tagCAUL;
  PCAUL = ^TCAUL;
  TCAUL = tagCAUL;

  {$EXTERNALSYM tagCAFLT}
  tagCAFLT = packed record
    cElems: ULONG;
    pElems: PSingle;
  end;
  {$EXTERNALSYM CAFLT}
  CAFLT = tagCAFLT;
  PCAFLT = ^TCAFLT;
  TCAFLT = tagCAFLT;

  {$EXTERNALSYM tagCADBL}
  tagCADBL = packed record
    cElems: ULONG;
    pElems: PDouble;
  end;
  {$EXTERNALSYM CADBL}
  CADBL = tagCADBL;
  PCADBL = ^TCADBL;
  TCADBL = tagCADBL;

  {$EXTERNALSYM tagCACY}
  tagCACY = packed record
    cElems: ULONG;
    pElems: PCurrency;
  end;
  {$EXTERNALSYM CACY}
  CACY = tagCACY;
  PCACY = ^TCACY;
  TCACY = tagCACY;

  {$EXTERNALSYM tagCADATE}
  tagCADATE = packed record
    cElems: ULONG;
    pElems: POleDate;
  end;
  {$EXTERNALSYM CADATE}
  CADATE = tagCADATE;
  PCADATE = ^TCADATE;
  TCADATE = tagCADATE;

  {$EXTERNALSYM tagCABSTR}
  tagCABSTR = packed record
    cElems: ULONG;
    pElems: PBSTR;
  end;
  {$EXTERNALSYM CABSTR}
  CABSTR = tagCABSTR;
  PCABSTR = ^TCABSTR;
  TCABSTR = tagCABSTR;

  {$EXTERNALSYM tagCABOOL}
  tagCABOOL = packed record
    cElems: ULONG;
    pElems: POleBool;
  end;
  {$EXTERNALSYM CABOOL}
  CABOOL = tagCABOOL;
  PCABOOL = ^TCABOOL;
  TCABOOL = tagCABOOL;

  {$EXTERNALSYM tagCASCODE}
  tagCASCODE = packed record
    cElems: ULONG;
    pElems: PSCODE;
  end;
  {$EXTERNALSYM CASCODE}
  CASCODE = tagCASCODE;
  PCASCODE = ^TCASCODE;
  TCASCODE = tagCASCODE;

  {$EXTERNALSYM tagCAPROPVARIANT}
  tagCAPROPVARIANT = packed record
    cElems: ULONG;
    pElems: PPropVariant;
  end;
  {$EXTERNALSYM CAPROPVARIANT}
  CAPROPVARIANT = tagCAPROPVARIANT;
  PCAPROPVARIANT = ^TCAPROPVARIANT;
  TCAPROPVARIANT = tagCAPROPVARIANT;

  {$EXTERNALSYM tagCAH}
  tagCAH = packed record
    cElems: ULONG;
    pElems: PLargeInteger;
  end;
  {$EXTERNALSYM CAH}
  CAH = tagCAH;
  PCAH = ^TCAH;
  TCAH = tagCAH;

  {$EXTERNALSYM tagCAUH}
  tagCAUH = packed record
    cElems: ULONG;
    pElems: PULargeInteger;
  end;
  {$EXTERNALSYM CAUH}
  CAUH = tagCAUH;
  PCAUH = ^TCAUH;
  TCAUH = tagCAUH;

  {$EXTERNALSYM tagCALPSTR}
  tagCALPSTR = packed record
    cElems: ULONG;
    pElems: PLPSTR;
  end;
  {$EXTERNALSYM CALPSTR}
  CALPSTR = tagCALPSTR;
  PCALPSTR = ^TCALPSTR;
  TCALPSTR = tagCALPSTR;

  {$EXTERNALSYM tagCALPWSTR}
  tagCALPWSTR = packed record
    cElems: ULONG;
    pElems: PLPWSTR;
  end;
  {$EXTERNALSYM CALPWSTR}
  CALPWSTR = tagCALPWSTR;
  PCALPWSTR = ^TCALPWSTR;
  TCALPWSTR = tagCALPWSTR;

  {$EXTERNALSYM tagCAFILETIME}
  tagCAFILETIME = packed record
    cElems: ULONG;
    pElems: PFileTime;
  end;
  {$EXTERNALSYM CAFILETIME}
  CAFILETIME = tagCAFILETIME;
  PCAFILETIME = ^TCAFILETIME;
  TCAFILETIME = tagCAFILETIME;

  {$EXTERNALSYM tagCACLIPDATA}
  tagCACLIPDATA = packed record
    cElems: ULONG;
    pElems: PClipData;
  end;
  {$EXTERNALSYM CACLIPDATA}
  CACLIPDATA = tagCACLIPDATA;
  PCACLIPDATA = ^TCACLIPDATA;
  TCACLIPDATA = tagCACLIPDATA;

  {$EXTERNALSYM tagCACLSID}
  tagCACLSID = packed record
    cElems: ULONG;
    pElems: PCLSID;
  end;
  {$EXTERNALSYM CACLSID}
  CACLSID = tagCACLSID;
  PCACLSID = ^TCACLSID;
  TCACLSID = tagCACLSID;

  {$EXTERNALSYM tagPROPVARIANT}
  tagPROPVARIANT = packed record
    vt: TVarType;
    wReserved1: Word;
    wReserved2: Word;
    wReserved3: Word;
    case Integer of
      0: (bVal: Byte);
      1: (iVal: SmallInt);
      2: (uiVal: Word);
      3: (boolVal: TOleBool);
      4: (bool: TOleBool);
      5: (lVal: Longint);
      6: (ulVal: Cardinal);
      7: (fltVal: Single);
      8: (scode: SCODE);
      9: (hVal: LARGE_INTEGER);
      10: (uhVal: ULARGE_INTEGER);
      11: (dblVal: Double);
      12: (cyVal: Currency);
      13: (date: TOleDate);
      14: (filetime: TFileTime);
      15: (puuid: PGUID);
      16: (blob: TBlob);
      17: (pclipdata: PClipData);
      18: (pStream: Pointer{IStream});
      19: (pStorage: Pointer{IStorage});
      20: (bstrVal: TBStr);
      21: (pszVal: PAnsiChar);
      22: (pwszVal: PWideChar);
      23: (caub: TCAUB);
      24: (cai: TCAI);
      25: (caui: TCAUI);
      26: (cabool: TCABOOL);
      27: (cal: TCAL);
      28: (caul: TCAUL);
      29: (caflt: TCAFLT);
      30: (cascode: TCASCODE);
      31: (cah: TCAH);
      32: (cauh: TCAUH);
      33: (cadbl: TCADBL);
      34: (cacy: TCACY);
      35: (cadate: TCADATE);
      36: (cafiletime: TCAFILETIME);
      37: (cauuid: TCACLSID);
      38: (caclipdata: TCACLIPDATA);
      39: (cabstr: TCABSTR);
      40: (calpstr: TCALPSTR);
      41: (calpwstr: TCALPWSTR );
      42: (capropvar: TCAPROPVARIANT);
  end;
  {$EXTERNALSYM PROPVARIANT}
  PROPVARIANT = tagPROPVARIANT;
  TPropVariant = tagPROPVARIANT;

  {$EXTERNALSYM tagPROPSPEC}
  tagPROPSPEC = packed record
    ulKind: ULONG;
    case Integer of
      0: (propid: TPropID);
      1: (lpwstr: POleStr);
  end;
  {$EXTERNALSYM PROPSPEC}
  PROPSPEC = tagPROPSPEC;
  PPropSpec = ^TPropSpec;
  TPropSpec = tagPROPSPEC;

  {$EXTERNALSYM tagSTATPROPSTG}
  tagSTATPROPSTG = record
    lpwstrName: POleStr;
    propid: TPropID;
    vt: TVarType;
  end;
  {$EXTERNALSYM STATPROPSTG}
  STATPROPSTG = tagSTATPROPSTG;
  PStatPropStg = ^TStatPropStg;
  TStatPropStg = tagSTATPROPSTG;

  {$EXTERNALSYM tagSTATPROPSETSTG}
  tagSTATPROPSETSTG = packed record
    fmtid: TFmtID;
    clsid: TClsID;
    grfFlags: DWORD;
    mtime: TFileTime;
    ctime: TFileTime;
    atime: TFileTime;
    dwOSVersion: DWORD;
  end;
  {$EXTERNALSYM STATPROPSETSTG}
  STATPROPSETSTG = tagSTATPROPSETSTG;
  PStatPropSetStg = ^TStatPropSetStg;
  TStatPropSetStg = tagSTATPROPSETSTG;

  {$EXTERNALSYM IPropertyStorage}
  IPropertyStorage = interface(IUnknown)
    ['{00000138-0000-0000-C000-000000000046}']
    function ReadMultiple(cpspec: ULONG; rgpspec : PPropSpec; rgpropvar: PPropVariant): HResult; stdcall;
    function WriteMultiple(cpspec: ULONG; rgpspec : PPropSpec; rgpropvar: PPropVariant;
      propidNameFirst: TPropID): HResult; stdcall;
    function DeleteMultiple(cpspec: ULONG; rgpspec: PPropSpec): HResult; stdcall;
    function ReadPropertyNames(cpropid: ULONG; rgpropid: PPropID;
      rglpwstrName: PPOleStr): HResult; stdcall;
    function WritePropertyNames(cpropid: ULONG; rgpropid: PPropID;
      rglpwstrName: PPOleStr): HResult; stdcall;
    function DeletePropertyNames(cpropid: ULONG; rgpropid: PPropID): HResult; stdcall;
    function Commit(grfCommitFlags: DWORD): HResult; stdcall;
    function Revert: HResult; stdcall;
    function Enum(out ppenum: IEnumSTATPROPSTG): HResult; stdcall;
    function SetTimes(const pctime, patime, pmtime: TFileTime): HResult; stdcall;
    function SetClass(const clsid: TCLSID): HResult; stdcall;
    function Stat(pstatpsstg: PStatPropSetStg): HResult; stdcall;
  end;

  {$EXTERNALSYM IPropertySetStorage}
  IPropertySetStorage = interface(IUnknown)
    ['{0000013A-0000-0000-C000-000000000046}']
    function Create(const rfmtid: TFmtID; const pclsid: TCLSID; grfFlags,
      grfMode: DWORD; out ppprstg: IPropertyStorage): HResult; stdcall;
    function Open(const rfmtid: TFmtID; grfMode: DWORD;
      out ppprstg: IPropertyStorage): HResult; stdcall;
    function Delete(const rfmtid: TFmtID): HResult; stdcall;
    function Enum(out ppenum: IEnumSTATPROPSETSTG): HResult; stdcall;
  end;

  {$EXTERNALSYM IEnumSTATPROPSTG}
  IEnumSTATPROPSTG = interface(IUnknown)
    ['{00000139-0000-0000-C000-000000000046}']
    function Next(celt: ULONG; out rgelt; pceltFetched: PULONG): HResult; stdcall;
    function Skip(celt: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppenum: IEnumSTATPROPSTG): HResult; stdcall;
  end;

  {$EXTERNALSYM IEnumSTATPROPSETSTG}
  IEnumSTATPROPSETSTG = interface(IUnknown)
    ['{0000013B-0000-0000-C000-000000000046}']
    function Next(celt: ULONG; out rgelt; pceltFetched: PULONG): HResult; stdcall;
    function Skip(celt: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppenum: IEnumSTATPROPSETSTG): HResult; stdcall;
  end;

{ from OAIDL.H }

  PVariantArg = ^TVariantArg;
  {$EXTERNALSYM tagVARIANT}
  tagVARIANT = record
    vt: TVarType;
    wReserved1: Word;
    wReserved2: Word;
    wReserved3: Word;
    case Integer of
      VT_UI1:                  (bVal: Byte);
      VT_I2:                   (iVal: Smallint);
      VT_I4:                   (lVal: Longint);
      VT_R4:                   (fltVal: Single);
      VT_R8:                   (dblVal: Double);
      VT_BOOL:                 (vbool: TOleBool);
      VT_ERROR:                (scode: HResult);
      VT_CY:                   (cyVal: Currency);
      VT_DATE:                 (date: TOleDate);
      VT_BSTR:                 (bstrVal: PWideChar{WideString});
      VT_UNKNOWN:              (unkVal: Pointer{IUnknown});
      VT_DISPATCH:             (dispVal: Pointer{IDispatch});
      VT_ARRAY:                (parray: PSafeArray);
      VT_BYREF or VT_UI1:      (pbVal: ^Byte);
      VT_BYREF or VT_I2:       (piVal: ^Smallint);
      VT_BYREF or VT_I4:       (plVal: ^Longint);
      VT_BYREF or VT_R4:       (pfltVal: ^Single);
      VT_BYREF or VT_R8:       (pdblVal: ^Double);
      VT_BYREF or VT_BOOL:     (pbool: ^TOleBool);
      VT_BYREF or VT_ERROR:    (pscode: ^HResult);
      VT_BYREF or VT_CY:       (pcyVal: ^Currency);
      VT_BYREF or VT_DATE:     (pdate: ^TOleDate);
      VT_BYREF or VT_BSTR:     (pbstrVal: ^WideString);
      VT_BYREF or VT_UNKNOWN:  (punkVal: ^IUnknown);
      VT_BYREF or VT_DISPATCH: (pdispVal: ^IDispatch);
      VT_BYREF or VT_ARRAY:    (pparray: ^PSafeArray);
      VT_BYREF or VT_VARIANT:  (pvarVal: PVariant);
      VT_BYREF:                (byRef: Pointer);
      VT_I1:                   (cVal: Char);
      VT_UI2:                  (uiVal: Word);
      VT_UI4:                  (ulVal: LongWord);
      VT_INT:                  (intVal: Integer);
      VT_UINT:                 (uintVal: LongWord);
      VT_BYREF or VT_DECIMAL:  (pdecVal: PDecimal);
      VT_BYREF or VT_I1:       (pcVal: PChar);
      VT_BYREF or VT_UI2:      (puiVal: PWord);
      VT_BYREF or VT_UI4:      (pulVal: PInteger);
      VT_BYREF or VT_INT:      (pintVal: PInteger);
      VT_BYREF or VT_UINT:     (puintVal: PLongWord);
  end;
  TVariantArg = tagVARIANT;


  PVariantArgList = ^TVariantArgList;
  TVariantArgList = array[0..65535] of TVariantArg;

  TDispID = Longint;

  PDispIDList = ^TDispIDList;
  TDispIDList = array[0..65535] of TDispID;

  TMemberID = TDispID;

  PMemberIDList = ^TMemberIDList;
  TMemberIDList = array[0..65535] of TMemberID;

  HRefType = DWORD;

  {$EXTERNALSYM tagTYPEKIND}
  tagTYPEKIND = DWORD;
  TTypeKind = tagTYPEKIND;

  PArrayDesc = ^TArrayDesc;

  PTypeDesc = ^TTypeDesc;
  {$EXTERNALSYM tagTYPEDESC}
  tagTYPEDESC = record
    case Integer of
      VT_PTR:         (ptdesc: PTypeDesc; vt: TVarType);
      VT_CARRAY:      (padesc: PArrayDesc);
      VT_USERDEFINED: (hreftype: HRefType);
  end;
  TTypeDesc = tagTYPEDESC;
  {$EXTERNALSYM TYPEDESC}
  TYPEDESC = TTypeDesc;


  {$EXTERNALSYM tagARRAYDESC}
  tagARRAYDESC = record
    tdescElem: TTypeDesc;
    cDims: Word;
    rgbounds: array[0..0] of TSafeArrayBound;
  end;
  TArrayDesc = tagARRAYDESC;
  {$EXTERNALSYM ARRAYDESC}
  ARRAYDESC = TArrayDesc;


  PIDLDesc = ^TIDLDesc;
  {$EXTERNALSYM tagIDLDESC}
  tagIDLDESC = record
    dwReserved: Longint;
    wIDLFlags: Word;
  end;
  TIDLDesc = tagIDLDESC;
  {$EXTERNALSYM IDLDESC}
  IDLDESC = TIDLDesc;


  PParamDescEx = ^TParamDescEx;
  {$EXTERNALSYM tagPARAMDESCEX}
  tagPARAMDESCEX = record
    cBytes: Longint;
    FourBytePad: Longint;
    varDefaultValue: TVariantArg;
  end;
  TParamDescEx = tagPARAMDESCEX;
  {$EXTERNALSYM PARAMDESCEX}
  PARAMDESCEX = TParamDescEx;


  PParamDesc = ^TParamDesc;
  {$EXTERNALSYM tagPARAMDESC}
  tagPARAMDESC = record
    pparamdescex: PParamDescEx;
    wParamFlags: Word;
  end;
  TParamDesc = tagPARAMDESC;
  {$EXTERNALSYM PARAMDESC}
  PARAMDESC = TParamDesc;


  PElemDesc = ^TElemDesc;
  {$EXTERNALSYM tagELEMDESC}
  tagELEMDESC = record
    tdesc: TTypeDesc;
    case Integer of
      0: (idldesc: TIDLDesc);
      1: (paramdesc: TParamDesc);
  end;
  TElemDesc = tagELEMDESC;
  {$EXTERNALSYM ELEMDESC}
  ELEMDESC = TElemDesc;


  PElemDescList = ^TElemDescList;
  TElemDescList = array[0..65535] of TElemDesc;


  PTypeAttr = ^TTypeAttr;
  {$EXTERNALSYM tagTYPEATTR}
  tagTYPEATTR = record
    guid: TGUID;
    lcid: TLCID;
    dwReserved: Longint;
    memidConstructor: TMemberID;
    memidDestructor: TMemberID;
    lpstrSchema: POleStr;
    cbSizeInstance: Longint;
    typekind: TTypeKind;
    cFuncs: Word;
    cVars: Word;
    cImplTypes: Word;
    cbSizeVft: Word;
    cbAlignment: Word;
    wTypeFlags: Word;
    wMajorVerNum: Word;
    wMinorVerNum: Word;
    tdescAlias: TTypeDesc;
    idldescType: TIDLDesc;
  end;
  TTypeAttr = tagTYPEATTR;
  {$EXTERNALSYM TYPEATTR}
  TYPEATTR = TTypeAttr;


  PDispParams = ^TDispParams;
  {$EXTERNALSYM tagDISPPARAMS}
  tagDISPPARAMS = record
    rgvarg: PVariantArgList;
    rgdispidNamedArgs: PDispIDList;
    cArgs: Longint;
    cNamedArgs: Longint;
  end;
  TDispParams = tagDISPPARAMS;
  {$EXTERNALSYM DISPPARAMS}
  DISPPARAMS = TDispParams;


  PExcepInfo = ^TExcepInfo;

  {$EXTERNALSYM TFNDeferredFillIn}
  TFNDeferredFillIn = function(ExInfo: PExcepInfo): HResult stdcall;


  {$EXTERNALSYM tagEXCEPINFO}
  tagEXCEPINFO = record
    wCode: Word;
    wReserved: Word;
    bstrSource: WideString;
    bstrDescription: WideString;
    bstrHelpFile: WideString;
    dwHelpContext: Longint;
    pvReserved: Pointer;
    pfnDeferredFillIn: TFNDeferredFillIn;
    scode: HResult;
  end;
  TExcepInfo = tagEXCEPINFO;
  {$EXTERNALSYM EXCEPINFO}
  EXCEPINFO = TExcepInfo;

  {$EXTERNALSYM tagFUNCKIND}
  tagFUNCKIND = Longint;
  TFuncKind = tagFUNCKIND;

  {$EXTERNALSYM tagINVOKEKIND}
  tagINVOKEKIND = Longint;
  TInvokeKind = tagINVOKEKIND;

  {$EXTERNALSYM tagCALLCONV}
  tagCALLCONV = Longint;
  TCallConv = tagCALLCONV;


  PFuncDesc = ^TFuncDesc;
  {$EXTERNALSYM tagFUNCDESC}
  tagFUNCDESC = record
    memid: TMemberID;
    lprgscode: PResultList;
    lprgelemdescParam: PElemDescList;
    funckind: TFuncKind;
    invkind: TInvokeKind;
    callconv: TCallConv;
    cParams: Smallint;
    cParamsOpt: Smallint;
    oVft: Smallint;
    cScodes: Smallint;
    elemdescFunc: TElemDesc;
    wFuncFlags: Word;
  end;
  TFuncDesc = tagFUNCDESC;
  {$EXTERNALSYM FUNCDESC}
  FUNCDESC = TFuncDesc;


  TVarKind = Longint;


  PVarDesc = ^TVarDesc;
  {$EXTERNALSYM tagVARDESC}
  tagVARDESC = record
    memid: TMemberID;
    lpstrSchema: POleStr;
    case Integer of
      VAR_PERINSTANCE: (
        oInst: Longint;
        elemdescVar: TElemDesc;
        wVarFlags: Word;
        varkind: TVarKind);
      VAR_CONST: (
        lpvarValue: POleVariant);
  end;
  TVarDesc = tagVARDESC;
  {$EXTERNALSYM VARDESC}
  VARDESC = TVarDesc;


{ ICreateTypeInfo interface }

  {$EXTERNALSYM ICreateTypeInfo}
  ICreateTypeInfo = interface(IUnknown)
    ['{00020405-0000-0000-C000-000000000046}']
    function SetGuid(const guid: TGUID): HResult; stdcall;
    function SetTypeFlags(uTypeFlags: Integer): HResult; stdcall;
    function SetDocString(pstrDoc: POleStr): HResult; stdcall;
    function SetHelpContext(dwHelpContext: Longint): HResult; stdcall;
    function SetVersion(wMajorVerNum: Word; wMinorVerNum: Word): HResult;
      stdcall;
    function AddRefTypeInfo(const tinfo: ITypeInfo; out reftype: HRefType): HResult;
      stdcall;
    function AddFuncDesc(index: Integer; const funcdesc: TFuncDesc): HResult;
      stdcall;
    function AddImplType(index: Integer; reftype: HRefType): HResult;
      stdcall;
    function SetImplTypeFlags(index: Integer; impltypeflags: Integer): HResult;
      stdcall;
    function SetAlignment(cbAlignment: Word): HResult; stdcall;
    function SetSchema(lpstrSchema: POleStr): HResult; stdcall;
    function AddVarDesc(index: Integer; const vardesc: TVarDesc): HResult;
      stdcall;
    function SetFuncAndParamNames(index: Integer; rgszNames: POleStrList;
      cNames: Integer): HResult; stdcall;
    function SetVarName(index: Integer; szName: POleStr): HResult; stdcall;
    function SetTypeDescAlias(const descAlias: TTypeDesc): HResult; stdcall;
    function DefineFuncAsDllEntry(index: Integer; szDllName: POleStr;
      szProcName: POleStr): HResult; stdcall;
    function SetFuncDocString(index: Integer; szDocString: POleStr): HResult;
      stdcall;
    function SetVarDocString(index: Integer; szDocString: POleStr): HResult;
      stdcall;
    function SetFuncHelpContext(index: Integer; dwHelpContext: Longint): HResult;
      stdcall;
    function SetVarHelpContext(index: Integer; dwHelpContext: Longint): HResult;
      stdcall;
    function SetMops(index: Integer; const bstrMops: WideString): HResult; stdcall;
    function SetTypeIdldesc(const idldesc: TIDLDesc): HResult; stdcall;
    function LayOut: HResult; stdcall;
  end;

{ ICreateTypeInfo2 interface }

  {$EXTERNALSYM ICreateTypeInfo2}
  ICreateTypeInfo2 = interface(ICreateTypeInfo)
    ['{00020412-0000-0000-C000-000000000046}']
    function DeleteFuncDesc(index: Integer): HResult; stdcall;
    function DeleteFuncDescByMemId(memid: TMemberID; invKind: TInvokeKind): HResult; stdcall;
    function DeleteVarDesc(index: Integer): HResult; stdcall;
    function DeleteVarDescByMemId(memid: TMemberID): HResult; stdcall;
    function DeleteImplType(index: Integer): HResult; stdcall;
    function SetCustData(const guid: TGUID; pVarVal: POleVariant): HResult; stdcall;
    function SetFuncCustData(index: Integer; const guid: TGUID;
      pVarVal: POleVariant): HResult; stdcall;
    function SetParamCustData(indexFunc: Integer; indexParam: Integer;
      const guid: TGUID; pVarVal: POleVariant): HResult; stdcall;
    function SetVarCustData(index: Integer; const guid: TGUID;
      pVarVal: POleVariant): HResult; stdcall;
    function SetImplTypeCustData(index: Integer; const guid: TGUID;
      pVarVal: POleVariant): HResult; stdcall;
    function SetHelpStringContext(dwHelpStringContext: Longint): HResult; stdcall;
    function SetFuncHelpStringContext(index: Integer;
      dwHelpStringContext: Longint): HResult; stdcall;
    function SetVarHelpStringContext(index: Integer;
       dwHelpStringContext: Longint): HResult; stdcall;
    function Invalidate: HResult; stdcall;
    function SetName(szName: POleStr): HResult; stdcall;
  end;

{ ICreateTypeLib interface }

  {$EXTERNALSYM ICreateTypeLib}
  ICreateTypeLib = interface(IUnknown)
    ['{00020406-0000-0000-C000-000000000046}']
    function CreateTypeInfo(szName: POleStr; tkind: TTypeKind;
      out ictinfo: ICreateTypeInfo): HResult; stdcall;
    function SetName(szName: POleStr): HResult; stdcall;
    function SetVersion(wMajorVerNum: Word; wMinorVerNum: Word): HResult; stdcall;
    function SetGuid(const guid: TGUID): HResult; stdcall;
    function SetDocString(szDoc: POleStr): HResult; stdcall;
    function SetHelpFileName(szHelpFileName: POleStr): HResult; stdcall;
    function SetHelpContext(dwHelpContext: Longint): HResult; stdcall;
    function SetLcid(lcid: TLCID): HResult; stdcall;
    function SetLibFlags(uLibFlags: Integer): HResult; stdcall;
    function SaveAllChanges: HResult; stdcall;
  end;

  {$EXTERNALSYM ICreateTypeLib2}
  ICreateTypeLib2 = interface(ICreateTypeLib)
    ['{0002040F-0000-0000-C000-000000000046}']
    function DeleteTypeInfo(szName: PWideChar): HResult; stdcall;
    function SetCustData(const guid: TGUID; pVarVal: POleVariant): HResult; stdcall;
    function SetHelpStringContext(dwHelpStringContext: Longint): HResult; stdcall;
    function SetHelpStringDll(szFileName: PWideChar): HResult; stdcall;
  end;

{ IEnumVariant interface }

  {$EXTERNALSYM IEnumVariant}
  IEnumVariant = interface(IUnknown)
    ['{00020404-0000-0000-C000-000000000046}']
    function Next(celt: LongWord; var rgvar : OleVariant;
      out pceltFetched: LongWord): HResult; stdcall;
    function Skip(celt: LongWord): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out Enum: IEnumVariant): HResult; stdcall;
  end;

  {$EXTERNALSYM IEnumVariant_D4}
  IEnumVariant_D4 = interface(IUnknown)
    ['{00020404-0000-0000-C000-000000000046}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out Enum: IEnumVariant): HResult; stdcall;
  end;

  { IEnumVariant_D4 is the IEnumVariant interface as used by Delphi 4, and
    has been deprecated due to changes in the type library. IEnumVariant
    has been updated to reflect those changes. }

{ ITypeComp interface }

  TDescKind = Longint;

  PBindPtr = ^TBindPtr;
  {$EXTERNALSYM tagBINDPTR}
  tagBINDPTR = record
    case Integer of
      0: (lpfuncdesc: PFuncDesc);
      1: (lpvardesc: PVarDesc);
      2: (lptcomp: Pointer {ITypeComp});
  end;
  TBindPtr = tagBINDPTR;
  {$EXTERNALSYM BINDPTR}
  BINDPTR = TBindPtr;


  {$EXTERNALSYM ITypeComp}
  ITypeComp = interface(IUnknown)
    ['{00020403-0000-0000-C000-000000000046}']
    function Bind(szName: POleStr; lHashVal: Longint; wflags: Word;
      out tinfo: ITypeInfo; out desckind: TDescKind;
      out bindptr: TBindPtr): HResult; stdcall;
    function BindType(szName: POleStr; lHashVal: Longint;
      out tinfo: ITypeInfo; out tcomp: ITypeComp): HResult;
      stdcall;
  end;

{ ITypeInfo interface }

  {$EXTERNALSYM ITypeInfo}
  ITypeInfo = interface(IUnknown)
    ['{00020401-0000-0000-C000-000000000046}']
    function GetTypeAttr(out ptypeattr: PTypeAttr): HResult; stdcall;
    function GetTypeComp(out tcomp: ITypeComp): HResult; stdcall;
    function GetFuncDesc(index: Integer; out pfuncdesc: PFuncDesc): HResult;
      stdcall;
    function GetVarDesc(index: Integer; out pvardesc: PVarDesc): HResult;
      stdcall;
    function GetNames(memid: TMemberID; rgbstrNames: PBStrList;
      cMaxNames: Integer; out cNames: Integer): HResult; stdcall;
    function GetRefTypeOfImplType(index: Integer; out reftype: HRefType): HResult;
      stdcall;
    function GetImplTypeFlags(index: Integer; out impltypeflags: Integer): HResult;
      stdcall;
    function GetIDsOfNames(rgpszNames: POleStrList; cNames: Integer;
      rgmemid: PMemberIDList): HResult; stdcall;
    function Invoke(pvInstance: Pointer; memid: TMemberID; flags: Word;
      var dispParams: TDispParams; varResult: PVariant;
      excepInfo: PExcepInfo; argErr: PInteger): HResult; stdcall;
    function GetDocumentation(memid: TMemberID; pbstrName: PWideString;
      pbstrDocString: PWideString; pdwHelpContext: PLongint;
      pbstrHelpFile: PWideString): HResult; stdcall;
    function GetDllEntry(memid: TMemberID; invkind: TInvokeKind;
      bstrDllName, bstrName: PWideString; wOrdinal: PWord): HResult;
      stdcall;
    function GetRefTypeInfo(reftype: HRefType; out tinfo: ITypeInfo): HResult;
      stdcall;
    function AddressOfMember(memid: TMemberID; invkind: TInvokeKind;
      out ppv: Pointer): HResult; stdcall;
    function CreateInstance(const unkOuter: IUnknown; const iid: TIID;
      out vObj): HResult; stdcall;
    function GetMops(memid: TMemberID; out bstrMops: WideString): HResult;
      stdcall;
    function GetContainingTypeLib(out tlib: ITypeLib; out pindex: Integer): HResult;
      stdcall;
    procedure ReleaseTypeAttr(ptypeattr: PTypeAttr); stdcall;
    procedure ReleaseFuncDesc(pfuncdesc: PFuncDesc); stdcall;
    procedure ReleaseVarDesc(pvardesc: PVarDesc); stdcall;
  end;

{ ITypeLib interface }

  TSysKind = Longint;

  PTLibAttr = ^TTLibAttr;
  {$EXTERNALSYM tagTLIBATTR}
  tagTLIBATTR = record
    guid: TGUID;
    lcid: TLCID;
    syskind: TSysKind;
    wMajorVerNum: Word;
    wMinorVerNum: Word;
    wLibFlags: Word;
  end;
  TTLibAttr = tagTLIBATTR;
  {$EXTERNALSYM TLIBATTR}
  TLIBATTR = TTLibAttr;


  PTypeInfoList = ^TTypeInfoList;
  TTypeInfoList = array[0..65535] of ITypeInfo;

  {$EXTERNALSYM ITypeLib}
  ITypeLib = interface(IUnknown)
    ['{00020402-0000-0000-C000-000000000046}']
    function GetTypeInfoCount: Integer; stdcall;
    function GetTypeInfo(index: Integer; out tinfo: ITypeInfo): HResult; stdcall;
    function GetTypeInfoType(index: Integer; out tkind: TTypeKind): HResult;
      stdcall;
    function GetTypeInfoOfGuid(const guid: TGUID; out tinfo: ITypeInfo): HResult;
      stdcall;
    function GetLibAttr(out ptlibattr: PTLibAttr): HResult; stdcall;
    function GetTypeComp(out tcomp: ITypeComp): HResult; stdcall;
    function GetDocumentation(index: Integer; pbstrName: PWideString;
      pbstrDocString: PWideString; pdwHelpContext: PLongint;
      pbstrHelpFile: PWideString): HResult; stdcall;
    function IsName(szNameBuf: POleStr; lHashVal: Longint; out fName: BOOL): HResult;
      stdcall;
    function FindName(szNameBuf: POleStr; lHashVal: Longint;
      rgptinfo: PTypeInfoList; rgmemid: PMemberIDList;
      out pcFound: Word): HResult; stdcall;
    procedure ReleaseTLibAttr(ptlibattr: PTLibAttr); stdcall;
  end;

{ ITypeLib2 interface }
  PCustDataItem = ^TCustDataItem;
  {$EXTERNALSYM tagCUSTDATAITEM}
  tagCUSTDATAITEM = record
    guid: TGUID;
    varValue: TVariantArg;
   end;
  TCustDataItem = tagCUSTDATAITEM;
  {$EXTERNALSYM CUSTDATAITEM}
  CUSTDATAITEM = TCustDataItem;

  PCustDataItemList = ^TCustDataItemList;
  TCustDataItemList = array[0..65535] of TCustDataItem;

  PCustData = ^TCustData;
  {$EXTERNALSYM tagCUSTDATA}
  tagCUSTDATA = record
    cCustData: DWORD;
    prgCustData: PCustDataItemList;
  end;
  TCustData = tagCUSTDATA;
  {$EXTERNALSYM CUSTDATA}
  CUSTDATA = TCustData;

  {$EXTERNALSYM ITypeLib2}
  ITypeLib2 = interface(ITypeLib)
    ['{00020411-0000-0000-C000-000000000046}']
    function GetCustData(guid: TGUID;
      out pVarVal: OleVariant): HResult; stdcall;
    function GetLibStatistics(pcUniqueNames: PLongInt;
      out pcchUniqueNames: LongInt): HResult; stdcall;
    function GetDocumentation2(index: Integer; lcid: TLCID;
      pbstrHelpString: PWideString; pdwHelpStringContext: PDWORD;
      pbstrHelpStringDll: PWideString): HResult; stdcall;
    function GetAllCustData(out pCustData: TCustData): HResult; stdcall;
  end;

  {$EXTERNALSYM ITypeInfo2}
  ITypeInfo2 = interface(ITypeInfo)
    ['{00020412-0000-0000-C000-000000000046}']
    function GetTypeKind(out pTypeKind: TTypeKind): HResult; stdcall;
    function GetTypeFlags(out pTypeFlags: LongInt): HResult; stdcall;
    function GetFuncIndexOfMemId(memid: TMemberID; invKind: TInvokeKind;
      out pFuncIndex: UINT): HResult; stdcall;
    function GetVarIndexOfMemId(memid: TMemberID; out pVarIndex: UINT): HResult; stdcall;
    function GetCustData(guid: TGUID; out pVarVal: OleVariant): HResult; stdcall;
    function GetFuncCustData(index: UINT; guid: TGUID;
      out pVarVal: OleVariant): HResult; stdcall;
    function GetParamCustData(indexFunc, indexParam: UINT; guid: TGUID;
      out pVarVal: OleVariant): HResult; stdcall;
    function GetVarCustData(index: UINT; guid: TGUID;
      out pVarVal: OleVariant): HResult; stdcall;
    function GetImplTypeCustData(index: UINT; guid: TGUID;
      out pVarVal: OleVariant): HResult; stdcall;
    function GetDocumentation2(memid: TMemberID; lcid: TLCID;
      pbstrHelpString: PWideString; pdwHelpStringContext: PDWORD;
      pbstrHelpStringDll: PWideString): HResult; stdcall;
    function GetAllCustData(out pCustData: TCustData): HResult; stdcall;
    function GetAllFuncCustData(index: UINT; out pCustData: TCustData): HResult; stdcall;
    function GetAllParamCustData(indexFunc, indexParam: UINT;
      out pCustData: TCustData): HResult; stdcall;
    function GetAllVarCustData(index: UINT; out pCustData: TCustData): HResult; stdcall;
    function GetAllImplTypeCustData(index: UINT; out pCustData: TCustData): HResult; stdcall;
  end;

{ IErrorInfo interface }

  {$EXTERNALSYM IErrorInfo}
  IErrorInfo = interface(IUnknown)
    ['{1CF2B120-547D-101B-8E65-08002B2BD119}']
    function GetGUID(out guid: TGUID): HResult; stdcall;
    function GetSource(out bstrSource: WideString): HResult; stdcall;
    function GetDescription(out bstrDescription: WideString): HResult; stdcall;
    function GetHelpFile(out bstrHelpFile: WideString): HResult; stdcall;
    function GetHelpContext(out dwHelpContext: Longint): HResult; stdcall;
  end;

{ ICreateErrorInfo interface }

  {$EXTERNALSYM ICreateErrorInfo}
  ICreateErrorInfo = interface(IUnknown)
    ['{22F03340-547D-101B-8E65-08002B2BD119}']
    function SetGUID(const guid: TGUID): HResult; stdcall;
    function SetSource(szSource: POleStr): HResult; stdcall;
    function SetDescription(szDescription: POleStr): HResult; stdcall;
    function SetHelpFile(szHelpFile: POleStr): HResult; stdcall;
    function SetHelpContext(dwHelpContext: Longint): HResult; stdcall;
  end;

{ ISupportErrorInfo interface }

  {$EXTERNALSYM ISupportErrorInfo}
  ISupportErrorInfo = interface(IUnknown)
    ['{DF0B3D60-548F-101B-8E65-08002B2BD119}']
    function InterfaceSupportsErrorInfo(const iid: TIID): HResult; stdcall;
  end;

{ from OLEAUTO.H }
{ IDispatch implementation support }

  PParamData = ^TParamData;
  {$EXTERNALSYM tagPARAMDATA}
  tagPARAMDATA = record
    szName: POleStr;
    vt: TVarType;
  end;
  TParamData = tagPARAMDATA;
  {$EXTERNALSYM PARAMDATA}
  PARAMDATA = TParamData;


  PParamDataList = ^TParamDataList;
  TParamDataList = array[0..65535] of TParamData;

  PMethodData = ^TMethodData;
  {$EXTERNALSYM tagMETHODDATA}
  tagMETHODDATA = record
    szName: POleStr;
    ppdata: PParamDataList;
    dispid: TDispID;
    iMeth: Integer;
    cc: TCallConv;
    cArgs: Integer;
    wFlags: Word;
    vtReturn: TVarType;
  end;
  TMethodData = tagMETHODDATA;
  {$EXTERNALSYM METHODDATA}
  METHODDATA = TMethodData;


  PMethodDataList = ^TMethodDataList;
  TMethodDataList = array[0..65535] of TMethodData;

  PInterfaceData = ^TInterfaceData;
  {$EXTERNALSYM tagINTERFACEDATA}
  tagINTERFACEDATA = record
    pmethdata: PMethodDataList;
    cMembers: Integer;
  end;
  TInterfaceData = tagINTERFACEDATA;
  {$EXTERNALSYM INTERFACEDATA}
  INTERFACEDATA = TInterfaceData;

  {$EXTERNALSYM tagREGKIND}
  tagREGKIND = (REGKIND_DEFAULT, REGKIND_REGISTER, REGKIND_NONE);
  TRegKind = tagREGKIND;

{ from OLEIDL.H }
{ IOleAdviseHolder interface }

  {$EXTERNALSYM IOleAdviseHolder}
  IOleAdviseHolder = interface(IUnknown)
    ['{00000111-0000-0000-C000-000000000046}']
    function Advise(const advise: IAdviseSink; out dwConnection: Longint): HResult;
      stdcall;
    function Unadvise(dwConnection: Longint): HResult; stdcall;
    function EnumAdvise(out enumAdvise: IEnumStatData): HResult; stdcall;
    function SendOnRename(const mk: IMoniker): HResult; stdcall;
    function SendOnSave: HResult; stdcall;
    function SendOnClose: HResult; stdcall;
  end;

{ IOleCache interface }

  {$EXTERNALSYM IOleCache}
  IOleCache = interface(IUnknown)
    ['{0000011E-0000-0000-C000-000000000046}']
    function Cache(const formatetc: TFormatEtc; advf: Longint;
      out dwConnection: Longint): HResult; stdcall;
    function Uncache(dwConnection: Longint): HResult; stdcall;
    function EnumCache(out enumStatData: IEnumStatData): HResult;
      stdcall;
    function InitCache(const dataObject: IDataObject): HResult; stdcall;
    function SetData(const formatetc: TFormatEtc; const medium: TStgMedium;
      fRelease: BOOL): HResult; stdcall;
  end;

{ IOleCache2 interface }

  {$EXTERNALSYM IOleCache2}
  IOleCache2 = interface(IOleCache)
    ['{00000128-0000-0000-C000-000000000046}']
    function UpdateCache(const dataObject: IDataObject; grfUpdf: Longint;
      pReserved: Pointer): HResult; stdcall;
    function DiscardCache(dwDiscardOptions: Longint): HResult; stdcall;
  end;

{ IOleCacheControl interface }

  {$EXTERNALSYM IOleCacheControl}
  IOleCacheControl = interface(IUnknown)
    ['{00000129-0000-0000-C000-000000000046}']
    function OnRun(const dataObject: IDataObject): HResult; stdcall;
    function OnStop: HResult; stdcall;
  end;

{ IParseDisplayName interface }

  {$EXTERNALSYM IParseDisplayName}
  IParseDisplayName = interface(IUnknown)
    ['{0000011A-0000-0000-C000-000000000046}']
    function ParseDisplayName(const bc: IBindCtx; pszDisplayName: POleStr;
      out chEaten: Longint; out mkOut: IMoniker): HResult; stdcall;
  end;

{ IOleContainer interface }

  {$EXTERNALSYM IOleContainer}
  IOleContainer = interface(IParseDisplayName)
    ['{0000011B-0000-0000-C000-000000000046}']
    function EnumObjects(grfFlags: Longint; out Enum: IEnumUnknown): HResult;
      stdcall;
    function LockContainer(fLock: BOOL): HResult; stdcall;
  end;

{ IOleClientSite interface }

  {$EXTERNALSYM IOleClientSite}
  IOleClientSite = interface(IUnknown)
    ['{00000118-0000-0000-C000-000000000046}']
    function SaveObject: HResult; stdcall;
    function GetMoniker(dwAssign: Longint; dwWhichMoniker: Longint;
      out mk: IMoniker): HResult; stdcall;
    function GetContainer(out container: IOleContainer): HResult; stdcall;
    function ShowObject: HResult; stdcall;
    function OnShowWindow(fShow: BOOL): HResult; stdcall;
    function RequestNewObjectLayout: HResult; stdcall;
  end;

{ IOleObject interface }

  {$EXTERNALSYM IOleObject}
  IOleObject = interface(IUnknown)
    ['{00000112-0000-0000-C000-000000000046}']
    function SetClientSite(const clientSite: IOleClientSite): HResult;
      stdcall;
    function GetClientSite(out clientSite: IOleClientSite): HResult;
      stdcall;
    function SetHostNames(szContainerApp: POleStr;
      szContainerObj: POleStr): HResult; stdcall;
    function Close(dwSaveOption: Longint): HResult; stdcall;
    function SetMoniker(dwWhichMoniker: Longint; const mk: IMoniker): HResult;
      stdcall;
    function GetMoniker(dwAssign: Longint; dwWhichMoniker: Longint;
      out mk: IMoniker): HResult; stdcall;
    function InitFromData(const dataObject: IDataObject; fCreation: BOOL;
      dwReserved: Longint): HResult; stdcall;
    function GetClipboardData(dwReserved: Longint;
      out dataObject: IDataObject): HResult; stdcall;
    function DoVerb(iVerb: Longint; msg: PMsg; const activeSite: IOleClientSite;
      lindex: Longint; hwndParent: HWND; const posRect: TRect): HResult;
      stdcall;
    function EnumVerbs(out enumOleVerb: IEnumOleVerb): HResult; stdcall;
    function Update: HResult; stdcall;
    function IsUpToDate: HResult; stdcall;
    function GetUserClassID(out clsid: TCLSID): HResult; stdcall;
    function GetUserType(dwFormOfType: Longint; out pszUserType: POleStr): HResult;
      stdcall;
    function SetExtent(dwDrawAspect: Longint; const size: TPoint): HResult;
      stdcall;
    function GetExtent(dwDrawAspect: Longint; out size: TPoint): HResult;
      stdcall;
    function Advise(const advSink: IAdviseSink; out dwConnection: Longint): HResult;
      stdcall;
    function Unadvise(dwConnection: Longint): HResult; stdcall;
    function EnumAdvise(out enumAdvise: IEnumStatData): HResult; stdcall;
    function GetMiscStatus(dwAspect: Longint; out dwStatus: Longint): HResult;
      stdcall;
    function SetColorScheme(const logpal: TLogPalette): HResult; stdcall;
  end;

{ OLE types }

  PObjectDescriptor = ^TObjectDescriptor;
  {$EXTERNALSYM tagOBJECTDESCRIPTOR}
  tagOBJECTDESCRIPTOR = record
    cbSize: Longint;
    clsid: TCLSID;
    dwDrawAspect: Longint;
    size: TPoint;
    point: TPoint;
    dwStatus: Longint;
    dwFullUserTypeName: Longint;
    dwSrcOfCopy: Longint;
  end;
  TObjectDescriptor = tagOBJECTDESCRIPTOR;
  {$EXTERNALSYM OBJECTDESCRIPTOR}
  OBJECTDESCRIPTOR = TObjectDescriptor;


  PLinkSrcDescriptor = PObjectDescriptor;
  TLinkSrcDescriptor = TObjectDescriptor;

{ IOleWindow interface }

  {$EXTERNALSYM IOleWindow}
  IOleWindow = interface(IUnknown)
    ['{00000114-0000-0000-C000-000000000046}']
    function GetWindow(out wnd: HWnd): HResult; stdcall;
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult; stdcall;
  end;

{ IOleLink interface }

  {$EXTERNALSYM IOleLink}
  IOleLink = interface(IUnknown)
    ['{0000011D-0000-0000-C000-000000000046}']
    function SetUpdateOptions(dwUpdateOpt: Longint): HResult;
      stdcall;
    function GetUpdateOptions(out dwUpdateOpt: Longint): HResult; stdcall;
    function SetSourceMoniker(const mk: IMoniker; const clsid: TCLSID): HResult;
      stdcall;
    function GetSourceMoniker(out mk: IMoniker): HResult; stdcall;
    function SetSourceDisplayName(pszDisplayName: POleStr): HResult;
      stdcall;
    function GetSourceDisplayName(out pszDisplayName: POleStr): HResult;
      stdcall;
    function BindToSource(bindflags: Longint; const bc: IBindCtx): HResult;
      stdcall;
    function BindIfRunning: HResult; stdcall;
    function GetBoundSource(out unk: IUnknown): HResult; stdcall;
    function UnbindSource: HResult; stdcall;
    function Update(const bc: IBindCtx): HResult; stdcall;
  end;

{ IOleItemContainer interface }

  {$EXTERNALSYM IOleItemContainer}
  IOleItemContainer = interface(IOleContainer)
    ['{0000011C-0000-0000-C000-000000000046}']
    function GetObject(pszItem: POleStr; dwSpeedNeeded: Longint;
      const bc: IBindCtx; const iid: TIID; out vObject): HResult; stdcall;
    function GetObjectStorage(pszItem: POleStr; const bc: IBindCtx;
      const iid: TIID; out vStorage): HResult; stdcall;
    function IsRunning(pszItem: POleStr): HResult; stdcall;
  end;

{ IOleInPlaceUIWindow interface }

  {$EXTERNALSYM IOleInPlaceUIWindow}
  IOleInPlaceUIWindow = interface(IOleWindow)
    ['{00000115-0000-0000-C000-000000000046}']
    function GetBorder(out rectBorder: TRect): HResult; stdcall;
    function RequestBorderSpace(const borderwidths: TRect): HResult; stdcall;
    function SetBorderSpace(pborderwidths: PRect): HResult; stdcall;
    function SetActiveObject(const activeObject: IOleInPlaceActiveObject;
      pszObjName: POleStr): HResult; stdcall;
  end;

{ IOleInPlaceActiveObject interface }

  {$EXTERNALSYM IOleInPlaceActiveObject}
  IOleInPlaceActiveObject = interface(IOleWindow)
    ['{00000117-0000-0000-C000-000000000046}']
    function TranslateAccelerator(var msg: TMsg): HResult; stdcall;
    function OnFrameWindowActivate(fActivate: BOOL): HResult; stdcall;
    function OnDocWindowActivate(fActivate: BOOL): HResult; stdcall;
    function ResizeBorder(const rcBorder: TRect; const uiWindow: IOleInPlaceUIWindow;
      fFrameWindow: BOOL): HResult; stdcall;
    function EnableModeless(fEnable: BOOL): HResult; stdcall;
  end;

{ IOleInPlaceFrame interface }

  POleInPlaceFrameInfo = ^TOleInPlaceFrameInfo;
  {$EXTERNALSYM tagOIFI}
  tagOIFI = record
    cb: Integer;
    fMDIApp: BOOL;
    hwndFrame: HWND;
    haccel: HAccel;
    cAccelEntries: Integer;
  end;
  TOleInPlaceFrameInfo = tagOIFI;
  {$EXTERNALSYM OLEINPLACEFRAMEINFO}
  OLEINPLACEFRAMEINFO = TOleInPlaceFrameInfo;

  POleMenuGroupWidths = ^TOleMenuGroupWidths;
  {$EXTERNALSYM tagOleMenuGroupWidths}
  tagOleMenuGroupWidths = record
    width: array[0..5] of Longint;
  end;
  TOleMenuGroupWidths = tagOleMenuGroupWidths;
  {$EXTERNALSYM OLEMENUGROUPWIDTHS}
  OLEMENUGROUPWIDTHS = TOleMenuGroupWidths;


  {$EXTERNALSYM IOleInPlaceFrame}
  IOleInPlaceFrame = interface(IOleInPlaceUIWindow)
    ['{00000116-0000-0000-C000-000000000046}']
    function InsertMenus(hmenuShared: HMenu;
      var menuWidths: TOleMenuGroupWidths): HResult; stdcall;
    function SetMenu(hmenuShared: HMenu; holemenu: HMenu;
      hwndActiveObject: HWnd): HResult; stdcall;
    function RemoveMenus(hmenuShared: HMenu): HResult; stdcall;
    function SetStatusText(pszStatusText: POleStr): HResult; stdcall;
    function EnableModeless(fEnable: BOOL): HResult; stdcall;
    function TranslateAccelerator(var msg: TMsg; wID: Word): HResult; stdcall;
  end;

{ IOleInPlaceObject interface }

  {$EXTERNALSYM IOleInPlaceObject}
  IOleInPlaceObject = interface(IOleWindow)
    ['{00000113-0000-0000-C000-000000000046}']
    function InPlaceDeactivate: HResult; stdcall;
    function UIDeactivate: HResult; stdcall;
    function SetObjectRects(const rcPosRect: TRect;
      const rcClipRect: TRect): HResult; stdcall;
    function ReactivateAndUndo: HResult; stdcall;
  end;

{ IOleInPlaceSite interface }

  {$EXTERNALSYM IOleInPlaceSite}
  IOleInPlaceSite = interface(IOleWindow)
    ['{00000119-0000-0000-C000-000000000046}']
    function CanInPlaceActivate: HResult; stdcall;
    function OnInPlaceActivate: HResult; stdcall;
    function OnUIActivate: HResult; stdcall;
    function GetWindowContext(out frame: IOleInPlaceFrame;
      out doc: IOleInPlaceUIWindow; out rcPosRect: TRect;
      out rcClipRect: TRect; out frameInfo: TOleInPlaceFrameInfo): HResult;
      stdcall;
    function Scroll(scrollExtent: TPoint): HResult; stdcall;
    function OnUIDeactivate(fUndoable: BOOL): HResult; stdcall;
    function OnInPlaceDeactivate: HResult; stdcall;
    function DiscardUndoState: HResult; stdcall;
    function DeactivateAndUndo: HResult; stdcall;
    function OnPosRectChange(const rcPosRect: TRect): HResult; stdcall;
  end;

{ IViewObject interface }

  TContinueFunc = function(dwContinue: Longint): BOOL stdcall;

  {$EXTERNALSYM IViewObject}
  IViewObject = interface(IUnknown)
    ['{0000010D-0000-0000-C000-000000000046}']
    function Draw(dwDrawAspect: Longint; lindex: Longint; pvAspect: Pointer;
      ptd: PDVTargetDevice; hicTargetDev: HDC; hdcDraw: HDC;
      prcBounds: PRect; prcWBounds: PRect; fnContinue: TContinueFunc;
      dwContinue: Longint): HResult; stdcall;
    function GetColorSet(dwDrawAspect: Longint; lindex: Longint;
      pvAspect: Pointer; ptd: PDVTargetDevice; hicTargetDev: HDC;
      out colorSet: PLogPalette): HResult; stdcall;
    function Freeze(dwDrawAspect: Longint; lindex: Longint; pvAspect: Pointer;
      out dwFreeze: Longint): HResult; stdcall;
    function Unfreeze(dwFreeze: Longint): HResult; stdcall;
    function SetAdvise(aspects: Longint; advf: Longint;
      const advSink: IAdviseSink): HResult; stdcall;
    function GetAdvise(pAspects: PLongint; pAdvf: PLongint;
      out advSink: IAdviseSink): HResult; stdcall;
  end;

{ IViewObject2 interface }

  {$EXTERNALSYM IViewObject2}
  IViewObject2 = interface(IViewObject)
    ['{00000127-0000-0000-C000-000000000046}']
    function GetExtent(dwDrawAspect: Longint; lindex: Longint;
      ptd: PDVTargetDevice; out size: TPoint): HResult; stdcall;
  end;

{ IDropSource interface }

  {$EXTERNALSYM IDropSource}
  IDropSource = interface(IUnknown)
    ['{00000121-0000-0000-C000-000000000046}']
    function QueryContinueDrag(fEscapePressed: BOOL;
      grfKeyState: Longint): HResult; stdcall;
    function GiveFeedback(dwEffect: Longint): HResult; stdcall;
  end;

{ IDropTarget interface }

  {$EXTERNALSYM IDropTarget}
  IDropTarget = interface(IUnknown)
    ['{00000122-0000-0000-C000-000000000046}']
    function DragEnter(const dataObj: IDataObject; grfKeyState: Longint;
      pt: TPoint; var dwEffect: Longint): HResult; stdcall;
    function DragOver(grfKeyState: Longint; pt: TPoint;
      var dwEffect: Longint): HResult; stdcall;
    function DragLeave: HResult; stdcall;
    function Drop(const dataObj: IDataObject; grfKeyState: Longint; pt: TPoint;
      var dwEffect: Longint): HResult; stdcall;
  end;

{ IEnumOleVerb interface }

  POleVerb = ^TOleVerb;
  {$EXTERNALSYM tagOLEVERB}
  tagOLEVERB = record
    lVerb: Longint;
    lpszVerbName: POleStr;
    fuFlags: Longint;
    grfAttribs: Longint;
  end;
  TOleVerb = tagOLEVERB;
  {$EXTERNALSYM OLEVERB}
  OLEVERB = TOleVerb;


  {$EXTERNALSYM IEnumOLEVERB}
  IEnumOLEVERB = interface(IUnknown)
    ['{00000104-0000-0000-C000-000000000046}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out enm: IEnumOleVerb): HResult; stdcall;
  end;

{ IOleControl interface }

  {$EXTERNALSYM IOleControl}
  IOleControl = interface
    ['{B196B288-BAB4-101A-B69C-00AA00341D07}']
    function GetControlInfo(var ci: TControlInfo): HResult; stdcall;
    function OnMnemonic(msg: PMsg): HResult; stdcall;
    function OnAmbientPropertyChange(dispid: TDispID): HResult; stdcall;
    function FreezeEvents(bFreeze: BOOL): HResult; stdcall;
  end;

{ IOleControlSite interface }

  {$EXTERNALSYM IOleControlSite}
  IOleControlSite = interface
    ['{B196B289-BAB4-101A-B69C-00AA00341D07}']
    function OnControlInfoChanged: HResult; stdcall;
    function LockInPlaceActive(fLock: BOOL): HResult; stdcall;
    function GetExtendedControl(out disp: IDispatch): HResult; stdcall;
    function TransformCoords(var ptlHimetric: TPoint; var ptfContainer: TPointF;
      flags: Longint): HResult; stdcall;
    function TranslateAccelerator(msg: PMsg; grfModifiers: Longint): HResult;
       stdcall;
    function OnFocus(fGotFocus: BOOL): HResult; stdcall;
    function ShowPropertyFrame: HResult; stdcall;
  end;

{ ISimpleFrameSite interface }

  {$EXTERNALSYM ISimpleFrameSite}
  ISimpleFrameSite = interface
    ['{742B0E01-14E6-101B-914E-00AA00300CAB}']
    function PreMessageFilter(wnd: HWnd; msg, wp, lp: Integer;
      out res: Integer; out Cookie: Longint): HResult;
      stdcall;
    function PostMessageFilter(wnd: HWnd; msg, wp, lp: Integer;
      out res: Integer; Cookie: Longint): HResult;
      stdcall;
  end;

{ IObjectWithSite interface }

  {$EXTERNALSYM IObjectWithSite}
  IObjectWithSite = interface
    ['{FC4801A3-2BA9-11CF-A229-00AA003D7352}']
    function SetSite(const pUnkSite: IUnknown ):HResult; stdcall;
    function GetSite(const riid: TIID; out site: IUnknown):HResult; stdcall;
  end;

{ IErrorLog interface }

  {$EXTERNALSYM IErrorLog}
  IErrorLog = interface
    ['{3127CA40-446E-11CE-8135-00AA004BB851}']
    function AddError(pszPropName: POleStr; pExcepInfo: PExcepInfo): HResult; stdcall;
  end;

{ IPropertyBag interface }

  {$EXTERNALSYM IPropertyBag}
  IPropertyBag = interface
    ['{55272A00-42CB-11CE-8135-00AA004BB851}']
    function Read(pszPropName: POleStr; var pvar: OleVariant;
      const pErrorLog: IErrorLog): HResult; stdcall;
    function Write(pszPropName: POleStr; const pvar: OleVariant): HResult; stdcall;
  end;

{ IPersistPropertyBag interface }

  {$EXTERNALSYM IPersistPropertyBag}
  IPersistPropertyBag = interface(IPersist)
    ['{37D84F60-42CB-11CE-8135-00AA004BB851}']
    function InitNew: HResult; stdcall;
    function Load(const pPropBag: IPropertyBag;
      const pErrorLog: IErrorLog): HResult; stdcall;
    function Save(const pPropBag: IPropertyBag; fClearDirty: BOOL;
      fSaveAllProperties: BOOL): HResult; stdcall;
  end;

{ IPersistStreamInit interface }

  {$EXTERNALSYM IPersistStreamInit}
  IPersistStreamInit = interface(IPersistStream)
    ['{7FD52380-4E07-101B-AE2D-08002B2EC713}']
    function InitNew: HResult; stdcall;
  end;

{ IPropertyNotifySink interface }

  {$EXTERNALSYM IPropertyNotifySink}
  IPropertyNotifySink = interface
    ['{9BFBBC02-EFF1-101A-84ED-00AA00341D07}']
    function OnChanged(dispid: TDispID): HResult; stdcall;
    function OnRequestEdit(dispid: TDispID): HResult; stdcall;
  end;

{ IProvideClassInfo interface }

  {$EXTERNALSYM IProvideClassInfo}
  IProvideClassInfo = interface
    ['{B196B283-BAB4-101A-B69C-00AA00341D07}']
    function GetClassInfo(out ti: ITypeInfo): HResult; stdcall;
  end;

{ IConnectionPointContainer interface }

  {$EXTERNALSYM IConnectionPointContainer}
  IConnectionPointContainer = interface
    ['{B196B284-BAB4-101A-B69C-00AA00341D07}']
    function EnumConnectionPoints(out Enum: IEnumConnectionPoints): HResult;
      stdcall;
    function FindConnectionPoint(const iid: TIID;
      out cp: IConnectionPoint): HResult; stdcall;
  end;

{ IEnumConnectionPoints interface }

  {$EXTERNALSYM IEnumConnectionPoints}
  IEnumConnectionPoints = interface
    ['{B196B285-BAB4-101A-B69C-00AA00341D07}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out Enum: IEnumConnectionPoints): HResult;
      stdcall;
  end;

{ IConnectionPoint interface }

  {$EXTERNALSYM IConnectionPoint}
  IConnectionPoint = interface
    ['{B196B286-BAB4-101A-B69C-00AA00341D07}']
    function GetConnectionInterface(out iid: TIID): HResult; stdcall;
    function GetConnectionPointContainer(out cpc: IConnectionPointContainer): HResult;
      stdcall;
    function Advise(const unkSink: IUnknown; out dwCookie: Longint): HResult; stdcall;
    function Unadvise(dwCookie: Longint): HResult; stdcall;
    function EnumConnections(out Enum: IEnumConnections): HResult; stdcall;
  end;

{ from OCIDL.H }
{ TConnectData structure }

  PConnectData = ^TConnectData;
  {$EXTERNALSYM tagCONNECTDATA}
  tagCONNECTDATA = record
    pUnk: IUnknown;
    dwCookie: Longint;
  end;
  TConnectData = tagCONNECTDATA;
  {$EXTERNALSYM CONNECTDATA}
  CONNECTDATA = TConnectData;


{ IEnumConnections interface }

  {$EXTERNALSYM IEnumConnections}
  IEnumConnections = interface
    ['{B196B287-BAB4-101A-B69C-00AA00341D07}']
    function Next(celt: Longint; out elt;
      pceltFetched: PLongint): HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out Enum: IEnumConnections): HResult; stdcall;
  end;

{ TLicInfo structure }

  PLicInfo = ^TLicInfo;
  {$EXTERNALSYM tagLICINFO}
  tagLICINFO = record
    cbLicInfo: Longint;
    fRuntimeKeyAvail: BOOL;
    fLicVerified: BOOL;
  end;
  TLicInfo = tagLICINFO;
  {$EXTERNALSYM LICINFO}
  LICINFO = TLicInfo;


{ IClassFactory2 interface }

  {$EXTERNALSYM IClassFactory2}
  IClassFactory2 = interface(IClassFactory)
    ['{B196B28F-BAB4-101A-B69C-00AA00341D07}']
    function GetLicInfo(var licInfo: TLicInfo): HResult; stdcall;
    function RequestLicKey(dwResrved: Longint; out bstrKey: WideString): HResult;
      stdcall;
    function CreateInstanceLic(const unkOuter: IUnknown; const unkReserved: IUnknown;
      const iid: TIID; const bstrKey: WideString; out vObject): HResult; stdcall;
  end;

{ TCAUUID structure - a counted array of TGUID }

  PGUIDList = ^TGUIDList;
  TGUIDList = array[0..65535] of TGUID;

  PCAGUID = ^TCAGUID;
  {$EXTERNALSYM tagCAUUID}
  tagCAUUID = record
    cElems: Longint;
    pElems: PGUIDList;
  end;
  TCAGUID = tagCAUUID;
  {$EXTERNALSYM CAUUID}
  CAUUID = TCAGUID;


{ TCAPOleStr structure - a counted array of POleStr }

  PCAPOleStr = ^TCAPOleStr; //???
  {$EXTERNALSYM tagCALPOLESTR}
  tagCALPOLESTR = record
    cElems: Longint;
    pElems: POleStrList;
  end;
  {$EXTERNALSYM CALPOLESTR}
  CALPOLESTR = tagCALPOLESTR;
  TCAPOleStr = tagCALPOLESTR;

{ TCALongint - a counted array of Longint }

  PLongintList = ^TLongintList;
  TLongintList = array[0..65535] of Longint;

  PCALongint = ^TCALongint; //???
  {$EXTERNALSYM tagCADWORD}
  tagCADWORD = record
    cElems: Longint;
    pElems: PLongintList;
  end;
  {$EXTERNALSYM CADWORD}
  CADWORD = tagCADWORD;
  TCALongint = tagCADWORD;

{ from OLECTL.H }
{ TOCPFIParams - parameters for OleCreatePropertyFrameIndirect }

  POCPFIParams = ^TOCPFIParams;
  {$EXTERNALSYM tagOCPFIPARAMS}
  tagOCPFIPARAMS = record
    cbStructSize: Longint;
    hWndOwner: HWnd;
    x: Integer;
    y: Integer;
    lpszCaption: POleStr;
    cObjects: Longint;
    pObjects: Pointer;
    cPages: Longint;
    pPages: Pointer;
    lcid: TLCID;
    dispidInitialProperty: TDispID;
  end;
  TOCPFIParams = tagOCPFIPARAMS;
  {$EXTERNALSYM OCPFIPARAMS}
  OCPFIPARAMS = TOCPFIParams;


{ from OCIDL.H }
{ TPropPageInfo structure - information about a property page }

  PPropPageInfo = ^TPropPageInfo;
  {$EXTERNALSYM tagPROPPAGEINFO}
  tagPROPPAGEINFO = record
    cb: Longint;
    pszTitle: POleStr;
    size: TSize;
    pszDocString: POleStr;
    pszHelpFile: POleStr;
    dwHelpContext: Longint;
  end;
  TPropPageInfo = tagPROPPAGEINFO;
  {$EXTERNALSYM PROPPAGEINFO}
  PROPPAGEINFO = TPropPageInfo;


{ ISpecifyPropertyPages interface }

  {$EXTERNALSYM ISpecifyPropertyPages}
  ISpecifyPropertyPages = interface
    ['{B196B28B-BAB4-101A-B69C-00AA00341D07}']
    function GetPages(out pages: TCAGUID): HResult; stdcall;
  end;

{ IPerPropertyBrowsing interface }

  {$EXTERNALSYM IPerPropertyBrowsing}
  IPerPropertyBrowsing = interface
    ['{376BD3AA-3845-101B-84ED-08002B2EC713}']
    function GetDisplayString(dispid: TDispID; out bstr: WideString): HResult;
      stdcall;
    function MapPropertyToPage(dispid: TDispID; out clsid: TCLSID): HResult;
      stdcall;
    function GetPredefinedStrings(dispid: TDispID; out caStringsOut: TCAPOleStr;
      out caCookiesOut: TCALongint): HResult; stdcall;
    function GetPredefinedValue(dispid: TDispID; dwCookie: Longint;
      out varOut: OleVariant): HResult; stdcall;
  end;

{ IPropertyPageSite interface }

  {$EXTERNALSYM IPropertyPageSite}
  IPropertyPageSite = interface
    ['{B196B28C-BAB4-101A-B69C-00AA00341D07}']
    function OnStatusChange(flags: Longint): HResult; stdcall;
    function GetLocaleID(out localeID: TLCID): HResult; stdcall;
    function GetPageContainer(out unk: IUnknown): HResult; stdcall;
    function TranslateAccelerator(msg: PMsg): HResult; stdcall;
  end;

{ IPropertyPage interface }

  {$EXTERNALSYM IPropertyPage}
  IPropertyPage = interface
    ['{B196B28D-BAB4-101A-B69C-00AA00341D07}']
    function SetPageSite(const pageSite: IPropertyPageSite): HResult; stdcall;
    function Activate(hwndParent: HWnd; const rc: TRect; bModal: BOOL): HResult;
      stdcall;
    function Deactivate: HResult; stdcall;
    function GetPageInfo(out pageInfo: TPropPageInfo): HResult; stdcall;
    function SetObjects(cObjects: Longint; pUnkList: PUnknownList): HResult; stdcall;
    function Show(nCmdShow: Integer): HResult; stdcall;
    function Move(const rect: TRect): HResult; stdcall;
    function IsPageDirty: HResult; stdcall;
    function Apply: HResult; stdcall;
    function Help(pszHelpDir: POleStr): HResult; stdcall;
    function TranslateAccelerator(msg: PMsg): HResult; stdcall;
  end;

{ IPropertyPage2 interface }

  {$EXTERNALSYM IPropertyPage2}
  IPropertyPage2 = interface(IPropertyPage)
    ['{01E44665-24AC-101B-84ED-08002B2EC713}']
    function EditProperty(dispid: TDispID): HResult; stdcall;
  end;

{ IFont interface }

  {$EXTERNALSYM IFont}
  IFont = interface
    ['{BEF6E002-A874-101A-8BBA-00AA00300CAB}']
    function get_Name(out name: WideString): HResult; stdcall;
    function put_Name(name: WideString): HResult; stdcall;
    function get_Size(out size: Currency): HResult; stdcall;
    function put_Size(size: Currency): HResult; stdcall;
    function get_Bold(out bold: BOOL): HResult; stdcall;
    function put_Bold(bold: BOOL): HResult; stdcall;
    function get_Italic(out italic: BOOL): HResult; stdcall;
    function put_Italic(italic: BOOL): HResult; stdcall;
    function get_Underline(out underline: BOOL): HResult; stdcall;
    function put_Underline(underline: BOOL): HResult; stdcall;
    function get_Strikethrough(out strikethrough: BOOL): HResult; stdcall;
    function put_Strikethrough(strikethrough: BOOL): HResult; stdcall;
    function get_Weight(out weight: Smallint): HResult; stdcall;
    function put_Weight(weight: Smallint): HResult; stdcall;
    function get_Charset(out charset: Smallint): HResult; stdcall;
    function put_Charset(charset: Smallint): HResult; stdcall;
    function get_hFont(out font: HFont): HResult; stdcall;
    function Clone(out font: IFont): HResult; stdcall;
    function IsEqual(const fontOther: IFont): HResult; stdcall;
    function SetRatio(cyLogical, cyHimetric: Longint): HResult; stdcall;
    function QueryTextMetrics(out tm: TTextMetricOle): HResult; stdcall;
    function AddRefHfont(font: HFont): HResult; stdcall;
    function ReleaseHfont(font: HFont): HResult; stdcall;
  end;

{ Font dispatch interface }

  {$EXTERNALSYM IFontDisp}
  IFontDisp = interface(IDispatch)
    ['{BEF6E003-A874-101A-8BBA-00AA00300CAB}']
  end;

  {$EXTERNALSYM Font}
  Font = IFontDisp;

  {$EXTERNALSYM PSOleAuthenticationService}
  PSOleAuthenticationService = ^TSOleAuthenticationService;
  {$EXTERNALSYM tagSOLE_AUTHENTICATION_SERVICE}
  tagSOLE_AUTHENTICATION_SERVICE = record
    dwAuthnSvc: Longint;
    dwAuthzSvc: Longint;
    pPrincipalName: POleStr;
    hr: HResult;
  end;
  {$EXTERNALSYM TSOleAuthenticationService}
  TSOleAuthenticationService = tagSOLE_AUTHENTICATION_SERVICE;
  {$EXTERNALSYM SOLE_AUTHENTICATION_SERVICE}
  SOLE_AUTHENTICATION_SERVICE = TSOleAuthenticationService;


{ from OLECTL.H }
{ TFontDesc structure }

  PFontDesc = ^TFontDesc;
  {$EXTERNALSYM tagFONTDESC}
  tagFONTDESC = record
    cbSizeofstruct: Integer;
    lpstrName: POleStr;
    cySize: Currency;
    sWeight: Smallint;
    sCharset: Smallint;
    fItalic: BOOL;
    fUnderline: BOOL;
    fStrikethrough: BOOL;
  end;
  TFontDesc = tagFONTDESC;
  {$EXTERNALSYM FONTDESC}
  FONTDESC = TFontDesc;


{ from OCIDL.H }
{ IPicture interface }

  {$EXTERNALSYM IPicture}
  IPicture = interface
    ['{7BF80980-BF32-101A-8BBB-00AA00300CAB}']
    function get_Handle(out handle: OLE_HANDLE): HResult;  stdcall;
    function get_hPal(out handle: OLE_HANDLE): HResult; stdcall;
    function get_Type(out typ: Smallint): HResult; stdcall;
    function get_Width(out width: OLE_XSIZE_HIMETRIC): HResult; stdcall;
    function get_Height(out height: OLE_YSIZE_HIMETRIC): HResult; stdcall;
    function Render(dc: HDC; x, y, cx, cy: Longint;
      xSrc: OLE_XPOS_HIMETRIC; ySrc: OLE_YPOS_HIMETRIC;
      cxSrc: OLE_XSIZE_HIMETRIC; cySrc: OLE_YSIZE_HIMETRIC;
      const rcWBounds: TRect): HResult; stdcall;
    function set_hPal(hpal: OLE_HANDLE): HResult; stdcall;
    function get_CurDC(out dcOut: HDC): HResult; stdcall;
    function SelectPicture(dcIn: HDC; out hdcOut: HDC;
      out bmpOut: OLE_HANDLE): HResult; stdcall;
    function get_KeepOriginalFormat(out fkeep: BOOL): HResult; stdcall;
    function put_KeepOriginalFormat(fkeep: BOOL): HResult; stdcall;
    function PictureChanged: HResult; stdcall;
    function SaveAsFile(const stream: IStream; fSaveMemCopy: BOOL;
      out cbSize: Longint): HResult; stdcall;
    function get_Attributes(out dwAttr: Longint): HResult; stdcall;
  end;

{ Picture dispatch interface }

  {$EXTERNALSYM IPictureDisp}
  IPictureDisp = interface(IDispatch)
    ['{7BF80981-BF32-101A-8BBB-00AA00300CAB}']
  end;

  {$EXTERNALSYM Picture}
  Picture = IPictureDisp;

{ from OLECTL.H }
{ TPictDesc structure }

  PPictDesc = ^TPictDesc;
  {$EXTERNALSYM tagPICTDESC}
  tagPICTDESC = record
    cbSizeofstruct: Integer;
    picType: Integer;
    case Integer of
      PICTYPE_BITMAP: (
  hbitmap: THandle;       { Bitmap }
  hpal: THandle);         { Accompanying palette }
      PICTYPE_METAFILE: (
  hMeta: THandle;         { Metafile }
  xExt, yExt: Integer);   { Extent }
      PICTYPE_ICON: (
  hIcon: THandle);        { Icon }
      PICTYPE_ENHMETAFILE: (
  hemf: THandle);         { Enhanced Metafile }
  end;
  TPictDesc = tagPICTDESC;
  {$EXTERNALSYM PICTDESC}
  PICTDESC = TPictDesc;


{ The following ActiveDoc interfaces come from DocObj.idl }

  {$EXTERNALSYM IOleDocumentView}
  IOleDocumentView = interface(IUnknown)
    ['{b722bcc6-4e68-101b-a2bc-00aa00404770}']
    function SetInPlaceSite(Site: IOleInPlaceSite):HResult; stdcall;
    function GetInPlaceSite(out Site: IOleInPlaceSite):HResult; stdcall;
    function GetDocument(out P: IUnknown):HResult; stdcall;
    function SetRect(const View: TRECT):HResult; stdcall;
    function GetRect(var View: TRECT):HResult; stdcall;
    function SetRectComplex(const View, HScroll, VScroll, SizeBox):HResult; stdcall;
    function Show(fShow: BOOL):HResult; stdcall;
    function UIActivate(fUIActivate: BOOL):HResult; stdcall;
    function Open:HResult; stdcall;
    function CloseView(dwReserved: DWORD):HResult; stdcall;
    function SaveViewState(pstm: IStream):HResult; stdcall;
    function ApplyViewState(pstm: IStream):HResult; stdcall;
    function Clone(NewSite: IOleInPlaceSite; out NewView: IOleDocumentView):HResult; stdcall;
  end;

  {$EXTERNALSYM IEnumOleDocumentViews}
  IEnumOleDocumentViews = interface(IUnknown)
    ['{b722bcc8-4e68-101b-a2bc-00aa00404770}']
    function Next(Count: Longint; out View: IOleDocumentView; var Fetched: Longint):HResult; stdcall;
    function Skip(Count: Longint):HResult; stdcall;
    function Reset:HResult; stdcall;
    function Clone(out Enum: IEnumOleDocumentViews):HResult; stdcall;
  end;

  {$EXTERNALSYM IOleDocument}
  IOleDocument = interface(IUnknown)
    ['{b722bcc5-4e68-101b-a2bc-00aa00404770}']
    function CreateView(Site: IOleInPlaceSite; Stream: IStream; rsrvd: DWORD;
      out View: IOleDocumentView):HResult; stdcall;
    function GetDocMiscStatus(var Status: DWORD):HResult; stdcall;
    function EnumViews(out Enum: IEnumOleDocumentViews;
      out View: IOleDocumentView):HResult; stdcall;
  end;

  {$EXTERNALSYM IOleDocumentSite}
  IOleDocumentSite = interface(IUnknown)
    ['{b722bcc7-4e68-101b-a2bc-00aa00404770}']
    function ActivateMe(View: IOleDocumentView): HRESULT; stdcall;
  end;

  {$EXTERNALSYM IContinueCallback}
  IContinueCallback = interface(IUnknown)
    ['{b722bcca-4e68-101b-a2bc-00aa00404770}']
    function Continue: HResult; stdcall;
    function ContinuePrinting( nCntPrinted, nCurPage: Longint;
      PrintStatus: PWideChar): HResult; stdcall;
  end;

{!! From servprov.idl: }

  {$EXTERNALSYM IServiceProvider}
  IServiceProvider = interface(IUnknown)
    ['{6d5140c1-7436-11ce-8034-00aa006009fa}']
    function QueryService(const rsid, iid: TGuid; out Obj): HResult; stdcall;
  end;


const
  {$EXTERNALSYM PRINTFLAG_MAYBOTHERUSER}
  PRINTFLAG_MAYBOTHERUSER         = 1;
  {$EXTERNALSYM PRINTFLAG_PROMPTUSER}
  PRINTFLAG_PROMPTUSER            = 2;
  {$EXTERNALSYM PRINTFLAG_USERMAYCHANGEPRINTER}
  PRINTFLAG_USERMAYCHANGEPRINTER  = 4;
  {$EXTERNALSYM PRINTFLAG_RECOMPOSETODEVICE}
  PRINTFLAG_RECOMPOSETODEVICE     = 8;
  {$EXTERNALSYM PRINTFLAG_DONTACTUALLYPRINT}
  PRINTFLAG_DONTACTUALLYPRINT     = 16;
  {$EXTERNALSYM PRINTFLAG_FORCEPROPERTIES}
  PRINTFLAG_FORCEPROPERTIES       = 32;
  {$EXTERNALSYM PRINTFLAG_PRINTTOFILE}
  PRINTFLAG_PRINTTOFILE           = 64;

  {$EXTERNALSYM PAGESET_TOLASTPAGE}
  PAGESET_TOLASTPAGE              = Cardinal(-1);

type
  PPageRange = ^TPageRange; //???
  {$EXTERNALSYM tagPAGERANGE}
  tagPAGERANGE = record
    nFromPage: Longint;
    nToPage: Longint;
  end;
  {$EXTERNALSYM PAGERANGE}
  PAGERANGE = tagPAGERANGE;
  TPageRange = tagPAGERANGE;

  PPageSet = ^TPageSet; //???
  {$EXTERNALSYM tagPAGESET}
  tagPAGESET = record
    cbStruct: Cardinal;
    fOddPages: BOOL;
    fEvenPages: BOOL;
    cPageRange: Cardinal;
    rgPages: array [0..0] of TPageRange;
  end;
  {$EXTERNALSYM PAGESET}
  PAGESET = tagPAGESET;
  TPageSet = tagPAGESET;

  {$EXTERNALSYM IPrint}
  IPrint = interface(IUnknown)
    ['{b722bcc9-4e68-101b-a2bc-00aa00404770}']
    function SetInitialPageNum(nFirstPage: Longint): HResult; stdcall;
    function GetPageInfo(var pnFirstPage, pcPages: Longint): HResult; stdcall;
    function Print(grfFlags: DWORD; var td: TDVTARGETDEVICE;
      PageSet: PPageSet; stgmOptions: PStgMedium; Callback: IContinueCallback;
      FirstPage: Longint; pcPagesPrinted, pnLastPage: PLongint): HResult; stdcall;
  end;

const
  {$EXTERNALSYM OLECMDIDF_REFRESH_NORMAL}
  OLECMDIDF_REFRESH_NORMAL     = 0;
  {$EXTERNALSYM OLECMDIDF_REFRESH_IFEXPIRED}
  OLECMDIDF_REFRESH_IFEXPIRED  = 1;
  {$EXTERNALSYM OLECMDIDF_REFRESH_CONTINUE}
  OLECMDIDF_REFRESH_CONTINUE   = 2;
  {$EXTERNALSYM OLECMDIDF_REFRESH_COMPLETELY}
  OLECMDIDF_REFRESH_COMPLETELY = 3;

  {$EXTERNALSYM OLECMDF_SUPPORTED}
  OLECMDF_SUPPORTED       = 1;
  {$EXTERNALSYM OLECMDF_ENABLED}
  OLECMDF_ENABLED         = 2;
  {$EXTERNALSYM OLECMDF_LATCHED}
  OLECMDF_LATCHED         = 4;
  {$EXTERNALSYM OLECMDF_NINCHED}
  OLECMDF_NINCHED         = 8;

  {$EXTERNALSYM OLECMDTEXTF_NONE}
  OLECMDTEXTF_NONE        = 0;
  {$EXTERNALSYM OLECMDTEXTF_NAME}
  OLECMDTEXTF_NAME        = 1;
  {$EXTERNALSYM OLECMDTEXTF_STATUS}
  OLECMDTEXTF_STATUS      = 2;

  {$EXTERNALSYM OLECMDEXECOPT_DODEFAULT}
  OLECMDEXECOPT_DODEFAULT         = 0;
  {$EXTERNALSYM OLECMDEXECOPT_PROMPTUSER}
  OLECMDEXECOPT_PROMPTUSER        = 1;
  {$EXTERNALSYM OLECMDEXECOPT_DONTPROMPTUSER}
  OLECMDEXECOPT_DONTPROMPTUSER    = 2;
  {$EXTERNALSYM OLECMDEXECOPT_SHOWHELP}
  OLECMDEXECOPT_SHOWHELP          = 3;

  {$EXTERNALSYM OLECMDID_OPEN}
  OLECMDID_OPEN                           = 1;
  {$EXTERNALSYM OLECMDID_NEW}
  OLECMDID_NEW                            = 2;
  {$EXTERNALSYM OLECMDID_SAVE}
  OLECMDID_SAVE                           = 3;
  {$EXTERNALSYM OLECMDID_SAVEAS}
  OLECMDID_SAVEAS                         = 4;
  {$EXTERNALSYM OLECMDID_SAVECOPYAS}
  OLECMDID_SAVECOPYAS                     = 5;
  {$EXTERNALSYM OLECMDID_PRINT}
  OLECMDID_PRINT                          = 6;
  {$EXTERNALSYM OLECMDID_PRINTPREVIEW}
  OLECMDID_PRINTPREVIEW                   = 7;
  {$EXTERNALSYM OLECMDID_PAGESETUP}
  OLECMDID_PAGESETUP                      = 8;
  {$EXTERNALSYM OLECMDID_SPELL}
  OLECMDID_SPELL                          = 9;
  {$EXTERNALSYM OLECMDID_PROPERTIES}
  OLECMDID_PROPERTIES                     = 10;
  {$EXTERNALSYM OLECMDID_CUT}
  OLECMDID_CUT                            = 11;
  {$EXTERNALSYM OLECMDID_COPY}
  OLECMDID_COPY                           = 12;
  {$EXTERNALSYM OLECMDID_PASTE}
  OLECMDID_PASTE                          = 13;
  {$EXTERNALSYM OLECMDID_PASTESPECIAL}
  OLECMDID_PASTESPECIAL                   = 14;
  {$EXTERNALSYM OLECMDID_UNDO}
  OLECMDID_UNDO                           = 15;
  {$EXTERNALSYM OLECMDID_REDO}
  OLECMDID_REDO                           = 16;
  {$EXTERNALSYM OLECMDID_SELECTALL}
  OLECMDID_SELECTALL                      = 17;
  {$EXTERNALSYM OLECMDID_CLEARSELECTION}
  OLECMDID_CLEARSELECTION                 = 18;
  {$EXTERNALSYM OLECMDID_ZOOM}
  OLECMDID_ZOOM                           = 19;
  {$EXTERNALSYM OLECMDID_GETZOOMRANGE}
  OLECMDID_GETZOOMRANGE                   = 20;
  {$EXTERNALSYM OLECMDID_UPDATECOMMANDS}
  OLECMDID_UPDATECOMMANDS                 = 21;
  {$EXTERNALSYM OLECMDID_REFRESH}
  OLECMDID_REFRESH                        = 22;
  {$EXTERNALSYM OLECMDID_STOP}
  OLECMDID_STOP                           = 23;
  {$EXTERNALSYM OLECMDID_HIDETOOLBARS}
  OLECMDID_HIDETOOLBARS                   = 24;
  {$EXTERNALSYM OLECMDID_SETPROGRESSMAX}
  OLECMDID_SETPROGRESSMAX                 = 25;
  {$EXTERNALSYM OLECMDID_SETPROGRESSPOS}
  OLECMDID_SETPROGRESSPOS                 = 26;
  {$EXTERNALSYM OLECMDID_SETPROGRESSTEXT}
  OLECMDID_SETPROGRESSTEXT                = 27;
  {$EXTERNALSYM OLECMDID_SETTITLE}
  OLECMDID_SETTITLE                       = 28;
  {$EXTERNALSYM OLECMDID_SETDOWNLOADSTATE}
  OLECMDID_SETDOWNLOADSTATE               = 29;
  {$EXTERNALSYM OLECMDID_STOPDOWNLOAD}
  OLECMDID_STOPDOWNLOAD                   = 30;
    // OLECMDID_STOPDOWNLOAD is supported for QueryStatus Only

// error codes
  {$EXTERNALSYM OLECMDERR_E_FIRST}
  OLECMDERR_E_FIRST           = OLE_E_LAST+1;
  {$EXTERNALSYM OLECMDERR_E_NOTSUPPORTED}
  OLECMDERR_E_NOTSUPPORTED    = OLECMDERR_E_FIRST;
  {$EXTERNALSYM OLECMDERR_E_DISABLED}
  OLECMDERR_E_DISABLED        = OLECMDERR_E_FIRST+1;
  {$EXTERNALSYM OLECMDERR_E_NOHELP}
  OLECMDERR_E_NOHELP          = OLECMDERR_E_FIRST+2;
  {$EXTERNALSYM OLECMDERR_E_CANCELED}
  OLECMDERR_E_CANCELED        = OLECMDERR_E_FIRST+3;
  {$EXTERNALSYM OLECMDERR_E_UNKNOWNGROUP}
  OLECMDERR_E_UNKNOWNGROUP    = OLECMDERR_E_FIRST+4;

  {$EXTERNALSYM MSOCMDERR_E_FIRST}
  MSOCMDERR_E_FIRST           = OLECMDERR_E_FIRST;
  {$EXTERNALSYM MSOCMDERR_E_NOTSUPPORTED}
  MSOCMDERR_E_NOTSUPPORTED    = OLECMDERR_E_NOTSUPPORTED;
  {$EXTERNALSYM MSOCMDERR_E_DISABLED}
  MSOCMDERR_E_DISABLED        = OLECMDERR_E_DISABLED;
  {$EXTERNALSYM MSOCMDERR_E_NOHELP}
  MSOCMDERR_E_NOHELP          = OLECMDERR_E_NOHELP;
  {$EXTERNALSYM MSOCMDERR_E_CANCELED}
  MSOCMDERR_E_CANCELED        = OLECMDERR_E_CANCELED;
  {$EXTERNALSYM MSOCMDERR_E_UNKNOWNGROUP}
  MSOCMDERR_E_UNKNOWNGROUP    = OLECMDERR_E_UNKNOWNGROUP;

type

  POleCmd = ^TOleCmd; //???
  {$EXTERNALSYM _tagOLECMD}
  _tagOLECMD = record
    cmdID: Cardinal;
    cmdf: Longint;
  end;
  {$EXTERNALSYM OLECMD}
  OLECMD = _tagOLECMD;
  TOleCmd = _tagOLECMD;

  POleCmdText = ^TOleCmdText; //???
  {$EXTERNALSYM _tagOLECMDTEXT}
  _tagOLECMDTEXT = record
    cmdtextf: Longint;
    cwActual: Cardinal;
    cwBuf: Cardinal;         // size in wide chars of the buffer for text
    rgwz: array [0..0] of WideChar; // Array into which callee writes the text
  end;
  {$EXTERNALSYM OLECMDTEXT}
  OLECMDTEXT = _tagOLECMDTEXT;
  TOleCmdText = _tagOLECMDTEXT;

  {$EXTERNALSYM IOleCommandTarget}
  IOleCommandTarget = interface(IUnknown)
    ['{b722bccb-4e68-101b-a2bc-00aa00404770}']
    function QueryStatus(CmdGroup: PGUID; cCmds: Cardinal;
      prgCmds: POleCmd; CmdText: POleCmdText): HResult; stdcall;
    function Exec(CmdGroup: PGUID; nCmdID, nCmdexecopt: DWORD;
      const vaIn: OleVariant; var vaOut: OleVariant): HResult; stdcall;
  end;

{ from designer.h}

const
  {$EXTERNALSYM CATID_Designer:}
  CATID_Designer: TGUID = '{4EB304D0-7555-11cf-A0C2-00AA0062BE57}';

type
  {$EXTERNALSYM IActiveDesigner}
  IActiveDesigner = interface
    ['{51AAE3E0-7486-11cf-A0C2-00AA0062BE57}']
    function GetRuntimeClassID(var clsid: TGUID): HResult; stdcall;
    function GetRuntimeMiscStatusFlags(var dwMiscFlags: DWORD): HResult; stdcall;
    function QueryPersistenceInterface(const iid: TGUID): HResult; stdcall;
    function SaveRuntimeState(const iidItf: TGUID; const iidObj: TGUID; Obj: IUnknown): HResult; stdcall;
    function GetExtensibilityObject(var ppvObjOut: IDispatch): HResult; stdcall;
  end;


{ from webdc.h }
const
  {$EXTERNALSYM CATID_WebDesigntimeControl}
  CATID_WebDesigntimeControl: TGUID = '{73cef3dd-ae85-11cf-a406-00aa00c00940}';

type
  {$EXTERNALSYM IPersistTextStream}
  IPersistTextStream = interface(IPersistStreamInit)
    ['{56223fe3-d397-11cf-a42e-00aa00c00940}']
  end;

  {$EXTERNALSYM IProvideRuntimeText}
  IProvideRuntimeText = interface
    ['{56223FE1-D397-11cf-A42E-00AA00C00940}']
    function GetRuntimeText( var strRuntimeText: TBSTR ): HResult; stdcall;
  end;

const
{ from CGUID.H }
{ Standard GUIDs }

  {$EXTERNALSYM GUID_NULL}
  GUID_NULL: TGUID = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM GUID_OLE_COLOR}
  GUID_OLE_COLOR: TGUID = '{66504301-BE0F-101A-8BBB-00AA00300CAB}';

{ Additional GUIDs }

  {$EXTERNALSYM IID_IRpcChannel}
  IID_IRpcChannel: TGUID = '{00000004-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IRpcStub}
  IID_IRpcStub: TGUID = '{00000005-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IStubManager}
  IID_IStubManager: TGUID = '{00000006-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IRpcProxy}
  IID_IRpcProxy: TGUID = '{00000007-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IProxyManager}
  IID_IProxyManager: TGUID = '{00000008-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IPSFactory}
  IID_IPSFactory: TGUID = '{00000009-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IInternalMoniker}
  IID_IInternalMoniker: TGUID = '{00000011-0000-0000-C000-000000000046}';
  {$EXTERNALSYM CLSID_StdMarshal}
  CLSID_StdMarshal: TGUID = '{00000017-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IEnumGeneric}
  IID_IEnumGeneric: TGUID = '{00000106-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IEnumHolder}
  IID_IEnumHolder: TGUID = '{00000107-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IEnumCallback}
  IID_IEnumCallback: TGUID = '{00000108-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IOleManager}
  IID_IOleManager: TGUID = '{0000011F-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IOlePresObj}
  IID_IOlePresObj: TGUID = '{00000120-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IDebug}
  IID_IDebug: TGUID = '{00000123-0000-0000-C000-000000000046}';
  {$EXTERNALSYM IID_IDebugStream}
  IID_IDebugStream: TGUID = '{00000124-0000-0000-C000-000000000046}';

{ Standard class IDs }

  {$EXTERNALSYM CLSID_CFontPropPage}
  CLSID_CFontPropPage: TGUID = '{2542f180-3532-1069-a2cd-00aa0034b50b}';
  {$EXTERNALSYM CLSID_CColorPropPage}
  CLSID_CColorPropPage: TGUID = '{ddf5a600-b9c0-101a-af1a-00aa0034b50b}';
  {$EXTERNALSYM CLSID_CPicturePropPage}
  CLSID_CPicturePropPage: TGUID = '{fc7af71d-fc74-101a-84ed-08002b2ec713}';
  {$EXTERNALSYM CLSID_PersistPropset}
  CLSID_PersistPropset: TGUID = '{fb8f0821-0164-101b-84ed-08002b2ec713}';
  {$EXTERNALSYM CLSID_ConvertVBX}
  CLSID_ConvertVBX: TGUID = '{fb8f0822-0164-101b-84ed-08002b2ec713}';
  {$EXTERNALSYM CLSID_StdFont}
  CLSID_StdFont: TGUID = '{fb8f0823-0164-101b-84ed-08002b2ec713}';
  {$EXTERNALSYM CLSID_StdPicture}
  CLSID_StdPicture: TGUID = '{fb8f0824-0164-101b-84ed-08002b2ec713}';

{ from comcat.h }
{ COM Category Manager Interfaces }
type
  IEnumGUID = interface;
  IEnumCATEGORYINFO = interface;
  ICatRegister = interface;
  ICatInformation = interface;

  PCATEGORYINFO = ^TCATEGORYINFO;
  TCATEGORYINFO = record
    catid: TGUID;
    lcid: UINT;
    szDescription: array[0..127] of WideChar;
  end;

  IEnumGUID = interface(IUnknown)
    ['{0002E000-0000-0000-C000-000000000046}']
    function Next(celt: UINT; out rgelt: TGUID; out pceltFetched: UINT): HResult; stdcall;
    function Skip(celt: UINT): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppenum: IEnumGUID): HResult; stdcall;
  end;

  IEnumCATEGORYINFO = interface(IUnknown)
    ['{0002E011-0000-0000-C000-000000000046}']
    function Next(celt: UINT; out rgelt: TCATEGORYINFO; out pceltFetched: UINT): HResult; stdcall;
    function Skip(celt: UINT): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppenum: IEnumCATEGORYINFO): HResult; stdcall;
  end;

  ICatRegister = interface(IUnknown)
    ['{0002E012-0000-0000-C000-000000000046}']
    function RegisterCategories(cCategories: UINT; rgCategoryInfo: PCATEGORYINFO): HResult; stdcall;
    function UnRegisterCategories(cCategories: UINT; rgcatid: Pointer): HResult; stdcall;
    function RegisterClassImplCategories(const rclsid: TGUID; cCategories: UINT; rgcatid: Pointer): HResult; stdcall;
    function UnRegisterClassImplCategories(const rclsid: TGUID; cCategories: UINT; rgcatid: Pointer): HResult; stdcall;
    function RegisterClassReqCategories(const rclsid: TGUID; cCategories: UINT; rgcatid: Pointer): HResult; stdcall;
    function UnRegisterClassReqCategories(const rclsid: TGUID; cCategories: UINT; rgcatid: Pointer): HResult; stdcall;
  end;

  ICatInformation = interface(IUnknown)
    ['{0002E013-0000-0000-C000-000000000046}']
    function EnumCategories(lcid: UINT; out ppenumCategoryInfo: IEnumCATEGORYINFO): HResult; stdcall;
    function GetCategoryDesc(const rcatid: TGUID; lcid: UINT; out pszDesc: PWideChar): HResult; stdcall;
    function EnumClassesOfCategories(cImplemented: UINT; rgcatidImpl: Pointer; cRequired: UINT; rgcatidReq: Pointer; out ppenumClsid: IEnumGUID): HResult; stdcall;
    function IsClassOfCategories(const rclsid: TGUID; cImplemented: UINT; rgcatidImpl: Pointer; cRequired: UINT; rgcatidReq: Pointer): HResult; stdcall;
    function EnumImplCategoriesOfClass(var rclsid: TGUID; out ppenumCatid: IEnumGUID): HResult; stdcall;
    function EnumReqCategoriesOfClass(var rclsid: TGUID; out ppenumCatid: IEnumGUID): HResult; stdcall;
  end;


{ IBindHost Interface }
  {$EXTERNALSYM IBindHost}
  IBindHost = interface(IUnknown)
    ['{fc4801a1-2ba9-11cf-a229-00aa003d7352}']
  end;

{ IOleUndoManager Interface }
  {$EXTERNALSYM IOleUndoManager}
  IOleUndoManager = interface(IUnknown)
    ['{d001f200-ef97-11ce-9bc9-00aa00608e01}']
  end;

{ IQuickActivate Interface }

  {$EXTERNALSYM tagQACONTAINER}
  tagQACONTAINER = record
    cbSize: LongInt;
    pClientSite: IOleClientSite;
    pAdviseSink: IAdviseSink;
    pPropertyNotifySink: IPropertyNotifySink;
    pUnkEventSink: IUnknown;
    dwAmbientFlags: LongInt;
    colorFore: OLE_COLOR;
    colorBack: OLE_COLOR;
    pFont: IFont;
    pUndoMgr: IOleUndoManager;
    dwAppearance: LongInt;
    lcid: LongInt;
    hpal: HPALETTE;
    pBindHost: IBindHost;
  end;

  PQaContainer = ^tagQACONTAINER;
  TQaContainer =  tagQACONTAINER;

  {$EXTERNALSYM tagQACONTROL}
  tagQACONTROL = record
    cbSize: LongInt;
    dwMiscStatus: LongInt;
    dwViewStatus: LongInt;
    dwEventCookie: LongInt;
    dwPropNotifyCookie: LongInt;
    dwPointerActivationPolicy: LongInt;
  end;

  PQaControl = ^TQaControl;
  TQaControl =  tagQACONTROL;

  {$EXTERNALSYM IQuickActivate}
  IQuickActivate = interface(IUnknown)
    ['{cf51ed10-62fe-11cf-bf86-00a0c9034836}']
    function QuickActivate(var qaCont: tagQACONTAINER; var qaCtrl: tagQACONTROL): HResult; stdcall;
    function SetContentExtent(const sizel: TPoint): HResult; stdcall;
    function GetContentExtent(out sizel: TPoint): HResult; stdcall;
  end;

const
  CLSID_StdComponentCategoryMgr: TGUID = '{0002E005-0000-0000-C000-000000000046}';

{ from OBJSAFE.H }

//+--------------------------------------------------------------------------=
//
//  Contents:   IObjectSafety definition
//
//
//  IObjectSafety should be implemented by objects that have interfaces which
//      support "untrusted" clients (for example, scripts). It allows the owner of
//      the object to specify which interfaces need to be protected from untrusted
//      use. Examples of interfaces that might be protected in this way are:
//
//      IID_IDispatch           - "Safe for automating with untrusted automation client or script"
//      IID_IPersist*           - "Safe for initializing with untrusted data"
//      IID_IActiveScript       - "Safe for running untrusted scripts"
//
//---------------------------------------------------------------------------=

const
  // Option bit definitions for IObjectSafety:
  {$EXTERNALSYM INTERFACESAFE_FOR_UNTRUSTED_CALLER}
  INTERFACESAFE_FOR_UNTRUSTED_CALLER = 1;   // Caller of interface may be untrusted
  {$EXTERNALSYM INTERFACESAFE_FOR_UNTRUSTED_DATA}
  INTERFACESAFE_FOR_UNTRUSTED_DATA = 2;     // Data passed into interface may be untrusted

type
  {$EXTERNALSYM IObjectSafety}
  IObjectSafety = interface(IUnknown)
    ['{CB5BDC81-93C1-11CF-8F20-00805F2CD064}']
    function GetInterfaceSafetyOptions(const IID: TIID; pdwSupportedOptions,
      pdwEnabledOptions: PDWORD): HResult; stdcall;
    function SetInterfaceSafetyOptions(const IID: TIID; dwOptionSetMask,
      dwEnabledOptions: DWORD): HResult; stdcall;
  end;

{ from OBJBASE.H }
{ HResult manipulation routines }

{$EXTERNALSYM Succeeded}
function Succeeded(Res: HResult): Boolean;
{$EXTERNALSYM Failed}
function Failed(Res: HResult): Boolean;
{$EXTERNALSYM ResultCode}
function ResultCode(Res: HResult): Integer;
{$EXTERNALSYM ResultFacility}
function ResultFacility(Res: HResult): Integer;
{$EXTERNALSYM ResultSeverity}
function ResultSeverity(Res: HResult): Integer;
{$EXTERNALSYM MakeResult}
function MakeResult(Severity, Facility, Code: Integer): HResult;

{ GUID functions }

{$EXTERNALSYM IsEqualGUID}
function IsEqualGUID(const guid1, guid2: TGUID): Boolean; stdcall;
{$EXTERNALSYM IsEqualIID}
function IsEqualIID(const iid1, iid2: TIID): Boolean; stdcall;
{$EXTERNALSYM IsEqualCLSID}
function IsEqualCLSID(const clsid1, clsid2: TCLSID): Boolean; stdcall;

{ Standard object API functions }

{$EXTERNALSYM CoBuildVersion}
function CoBuildVersion: Longint; stdcall;

{ Init/Uninit }

const
  // flags passed as the coInit parameter to CoInitializeEx.
  {$EXTERNALSYM COINIT_MULTITHREADED}
  COINIT_MULTITHREADED      = 0;      // OLE calls objects on any thread.
  {$EXTERNALSYM COINIT_APARTMENTTHREADED}
  COINIT_APARTMENTTHREADED  = 2;      // Apartment model
  {$EXTERNALSYM COINIT_DISABLE_OLE1DDE}
  COINIT_DISABLE_OLE1DDE    = 4;      // Don't use DDE for Ole1 support.
  {$EXTERNALSYM COINIT_SPEED_OVER_MEMORY}
  COINIT_SPEED_OVER_MEMORY  = 8;      // Trade memory for speed.

{$EXTERNALSYM CoInitialize}
function CoInitialize(pvReserved: Pointer): HResult; stdcall;
{$EXTERNALSYM CoUninitialize}
procedure CoUninitialize; stdcall;
{$EXTERNALSYM CoGetMalloc}
function CoGetMalloc(dwMemContext: Longint; out malloc: IMalloc): HResult; stdcall;
{$EXTERNALSYM CoGetCurrentProcess}
function CoGetCurrentProcess: Longint; stdcall;
{$EXTERNALSYM CoRegisterMallocSpy}
function CoRegisterMallocSpy(mallocSpy: IMallocSpy): HResult; stdcall;
{$EXTERNALSYM CoRevokeMallocSpy}
function CoRevokeMallocSpy: HResult stdcall;
{$EXTERNALSYM CoCreateStandardMalloc}
function CoCreateStandardMalloc(memctx: Longint; out malloc: IMalloc): HResult; stdcall;
{$EXTERNALSYM CoInitializeEx}
function CoInitializeEx(pvReserved: Pointer; coInit: Longint): HResult; stdcall;

{ Register, revoke, and get class objects }

{$EXTERNALSYM CoGetClassObject}
function CoGetClassObject(const clsid: TCLSID; dwClsContext: Longint;
  pvReserved: Pointer; const iid: TIID; out pv): HResult; stdcall;
{$EXTERNALSYM CoRegisterClassObject}
function CoRegisterClassObject(const clsid: TCLSID; unk: IUnknown;
  dwClsContext: Longint; flags: Longint; out dwRegister: Longint): HResult; stdcall;
{$EXTERNALSYM CoRevokeClassObject}
function CoRevokeClassObject(dwRegister: Longint): HResult; stdcall;
{$EXTERNALSYM CoResumeClassObjects}
function CoResumeClassObjects: HResult; stdcall;
{$EXTERNALSYM CoSuspendClassObjects}
function CoSuspendClassObjects: HResult; stdcall;
{$EXTERNALSYM CoAddRefServerProcess}
function CoAddRefServerProcess: Longint; stdcall;
{$EXTERNALSYM CoReleaseServerProcess}
function CoReleaseServerProcess: Longint; stdcall;
{$EXTERNALSYM CoGetPSClsid}
function CoGetPSClsid(const iid: TIID; var pClsid: TCLSID): HResult; stdcall;
{$EXTERNALSYM CoRegisterPSClsid}
function CoRegisterPSClsid(const iid: TIID; clsid: TCLSID): HResult; stdcall;

{ Marshaling interface pointers }

{$EXTERNALSYM CoGetMarshalSizeMax}
function CoGetMarshalSizeMax(out ulSize: Longint; const iid: TIID;
  unk: IUnknown; dwDestContext: Longint; pvDestContext: Pointer;
  mshlflags: Longint): HResult; stdcall;
{$EXTERNALSYM CoMarshalInterface}
function CoMarshalInterface(stm: IStream; const iid: TIID; unk: IUnknown;
  dwDestContext: Longint; pvDestContext: Pointer;
  mshlflags: Longint): HResult; stdcall;
{$EXTERNALSYM CoUnmarshalInterface}
function CoUnmarshalInterface(stm: IStream; const iid: TIID;
  out pv): HResult; stdcall;
{$EXTERNALSYM CoMarshalHResult}
function CoMarshalHResult(stm: IStream; result: HResult): HResult; stdcall;
{$EXTERNALSYM CoUnmarshalHResult}
function CoUnmarshalHResult(stm: IStream; out result: HResult): HResult; stdcall;
{$EXTERNALSYM CoReleaseMarshalData}
function CoReleaseMarshalData(stm: IStream): HResult; stdcall;
{$EXTERNALSYM CoDisconnectObject}
function CoDisconnectObject(unk: IUnknown; dwReserved: Longint): HResult; stdcall;
{$EXTERNALSYM CoLockObjectExternal}
function CoLockObjectExternal(unk: IUnknown; fLock: BOOL;
  fLastUnlockReleases: BOOL): HResult; stdcall;
{$EXTERNALSYM CoGetStandardMarshal}
function CoGetStandardMarshal(const iid: TIID; unk: IUnknown;
  dwDestContext: Longint; pvDestContext: Pointer; mshlflags: Longint;
  out marshal: IMarshal): HResult; stdcall;

{$EXTERNALSYM CoIsHandlerConnected}
function CoIsHandlerConnected(unk: IUnknown): BOOL; stdcall;
{$EXTERNALSYM CoHasStrongExternalConnections}
function CoHasStrongExternalConnections(unk: IUnknown): BOOL; stdcall;

{ Apartment model inter-thread interface passing helpers }

{$EXTERNALSYM CoMarshalInterThreadInterfaceInStream}
function CoMarshalInterThreadInterfaceInStream(const iid: TIID;
  unk: IUnknown; out stm: IStream): HResult; stdcall;
{$EXTERNALSYM CoGetInterfaceAndReleaseStream}
function CoGetInterfaceAndReleaseStream(stm: IStream; const iid: TIID;
  out pv): HResult; stdcall;
{$EXTERNALSYM CoCreateFreeThreadedMarshaler}
function CoCreateFreeThreadedMarshaler(unkOuter: IUnknown;
  out unkMarshal: IUnknown): HResult; stdcall;

{ DLL loading helpers; keeps track of ref counts and unloads all on exit }

{$EXTERNALSYM CoLoadLibrary}
function CoLoadLibrary(pszLibName: POleStr; bAutoFree: BOOL): THandle; stdcall;
{$EXTERNALSYM CoFreeLibrary}
procedure CoFreeLibrary(hInst: THandle); stdcall;
{$EXTERNALSYM CoFreeAllLibraries}
procedure CoFreeAllLibraries; stdcall;
{$EXTERNALSYM CoFreeUnusedLibraries}
procedure CoFreeUnusedLibraries; stdcall;

{ Call Security. }

{$EXTERNALSYM CoInitializeSecurity}
function CoInitializeSecurity(pSecDesc: PSecurityDescriptor; cAuthSvc: Longint;
  asAuthSvc: PSOleAuthenticationService; pReserved1: Pointer;
  dwAuthnLevel, dImpLevel: Longint; pReserved2: Pointer; dwCapabilities: Longint;
  pReserved3: Pointer): HResult; stdcall;
{$EXTERNALSYM CoGetCallContext}
function CoGetCallContext(const iid: TIID; pInterface: Pointer): HResult; stdcall;
{$EXTERNALSYM CoQueryProxyBlanket}
function CoQueryProxyBlanket(Proxy: IUnknown; pwAuthnSvc, pAuthzSvc: PLongint;
  pServerPrincName: POleStr; pAuthnLevel, pImpLevel: PLongint;
  pAuthInfo: Pointer; pCapabilites: PLongint): HResult; stdcall;
{$EXTERNALSYM CoSetProxyBlanket}
function CoSetProxyBlanket(Proxy: IUnknown; dwAuthnSvc, dwAuthzSvc: Longint;
  pServerPrincName: POleStr; dwAuthnLevel, dwImpLevel: Longint;
  pAuthInfo: Pointer; dwCapabilites: Longint): HResult; stdcall;
{$EXTERNALSYM CoCopyProxy}
function CoCopyProxy(Proxy: IUnknown; var pCopy: IUnknown): HResult; stdcall;
{$EXTERNALSYM CoQueryClientBlanket}
function CoQueryClientBlanket(pwAuthnSvc, pAuthzSvc: PLongint;
  pServerPrincName: POleStr; dwAuthnLevel, dwImpLevel: Longint;
  pPrivs: Pointer; dwCapabilites: Longint): HResult; stdcall;
{$EXTERNALSYM CoImpersonateClient}
function CoImpersonateClient: HResult; stdcall;
{$EXTERNALSYM CoRevertToSelf}
function CoRevertToSelf: HResult; stdcall;
{$EXTERNALSYM CoQueryAuthenticationServices}
function CoQueryAuthenticationServices(pcAuthSvc: PLongint;
  asAuthSvc: PSOleAuthenticationService): HResult; stdcall;
{$EXTERNALSYM CoSwitchCallContext}
function CoSwitchCallContext(NewObject: IUnknown; var pOldObject: IUnknown): HResult; stdcall;

{ Helper for creating instances }

{$EXTERNALSYM CoCreateInstance}
function CoCreateInstance(const clsid: TCLSID; unkOuter: IUnknown;
  dwClsContext: Longint; const iid: TIID; out pv): HResult; stdcall;
{$EXTERNALSYM CoGetInstanceFromFile}
function CoGetInstanceFromFile(ServerInfo: PCoServerInfo; clsid: PCLSID;
  punkOuter: IUnknown; dwClsCtx, grfMode: Longint; pwszName: POleStr;
  dwCount: Longint; rgmqResults: PMultiQIArray): HResult; stdcall;
{$EXTERNALSYM CoGetInstanceFromIStorage}
function CoGetInstanceFromIStorage(ServerInfo: PCoServerInfo; clsid: PCLSID;
  punkOuter: IUnknown; dwClsCtx: Longint; stg: IUnknown;
  dwCount: Longint; rgmqResults: PMultiQIArray): HResult; stdcall;
{$EXTERNALSYM CoCreateInstanceEx}
function CoCreateInstanceEx(const clsid: TCLSID;
  unkOuter: IUnknown; dwClsCtx: Longint; ServerInfo: PCoServerInfo;
  dwCount: Longint; rgmqResults: PMultiQIArray): HResult; stdcall;

{ Other helpers }

{$EXTERNALSYM StringFromCLSID}
function StringFromCLSID(const clsid: TCLSID; out psz: POleStr): HResult; stdcall;
{$EXTERNALSYM CLSIDFromString}
function CLSIDFromString(psz: POleStr; out clsid: TCLSID): HResult; stdcall;
{$EXTERNALSYM StringFromIID}
function StringFromIID(const iid: TIID; out psz: POleStr): HResult; stdcall;
{$EXTERNALSYM IIDFromString}
function IIDFromString(psz: POleStr; out iid: TIID): HResult; stdcall;
{$EXTERNALSYM CoIsOle1Class}
function CoIsOle1Class(const clsid: TCLSID): BOOL; stdcall;
{$EXTERNALSYM ProgIDFromCLSID}
function ProgIDFromCLSID(const clsid: TCLSID; out pszProgID: POleStr): HResult; stdcall;
{$EXTERNALSYM CLSIDFromProgID}
function CLSIDFromProgID(pszProgID: POleStr; out clsid: TCLSID): HResult; stdcall;
{$EXTERNALSYM StringFromGUID2}
function StringFromGUID2(const guid: TGUID; psz: POleStr; cbMax: Integer): Integer; stdcall;

{$EXTERNALSYM CoCreateGuid}
function CoCreateGuid(out guid: TGUID): HResult; stdcall;

{$EXTERNALSYM CoFileTimeToDosDateTime}
function CoFileTimeToDosDateTime(const filetime: TFileTime; out dosDate: Word;
  out dosTime: Word): BOOL; stdcall;
{$EXTERNALSYM CoDosDateTimeToFileTime}
function CoDosDateTimeToFileTime(nDosDate: Word; nDosTime: Word;
  out filetime: TFileTime): BOOL; stdcall;
{$EXTERNALSYM CoFileTimeNow}
function CoFileTimeNow(out filetime: TFileTime): HResult; stdcall;
{$EXTERNALSYM CoRegisterMessageFilter}
function CoRegisterMessageFilter(messageFilter: IMessageFilter;
  out pMessageFilter: IMessageFilter): HResult; stdcall;
{$EXTERNALSYM CoRegisterChannelHook}
function CoRegisterChannelHook(const ExtensionUuid: TGUID;
  ChannelHook: IChannelHook): HResult; stdcall;

{ TreatAs APIs }

{$EXTERNALSYM CoGetTreatAsClass}
function CoGetTreatAsClass(const clsidOld: TCLSID; out clsidNew: TCLSID): HResult; stdcall;
{$EXTERNALSYM CoTreatAsClass}
function CoTreatAsClass(const clsidOld: TCLSID; const clsidNew: TCLSID): HResult; stdcall;

{ The server DLLs must define their DllGetClassObject and DllCanUnloadNow
  to match these; the typedefs are located here to ensure all are changed at
  the same time }

type
  {$EXTERNALSYM TDLLGetClassObject}
  TDLLGetClassObject = function(const clsid: TCLSID; const iid: TIID;
    out pv): HResult stdcall;
  {$EXTERNALSYM TDLLCanUnloadNow}
  TDLLCanUnloadNow = function: HResult stdcall;

{ Default memory allocation }

{$EXTERNALSYM CoTaskMemAlloc}
function CoTaskMemAlloc(cb: Longint): Pointer; stdcall;
{$EXTERNALSYM CoTaskMemRealloc}
function CoTaskMemRealloc(pv: Pointer; cb: Longint): Pointer; stdcall;
{$EXTERNALSYM CoTaskMemFree}
procedure CoTaskMemFree(pv: Pointer); stdcall;

{ DV APIs }

{$EXTERNALSYM CreateDataAdviseHolder}
function CreateDataAdviseHolder(out DAHolder: IDataAdviseHolder): HResult; stdcall;
{$EXTERNALSYM CreateDataCache}
function CreateDataCache(unkOuter: IUnknown; const clsid: TCLSID;
  const iid: TIID; out pv): HResult; stdcall;

{ Storage API prototypes }

{$EXTERNALSYM StgCreateDocfile}
function StgCreateDocfile(pwcsName: POleStr; grfMode: Longint;
  reserved: Longint; out stgOpen: IStorage): HResult; stdcall;
{$EXTERNALSYM StgCreateDocfileOnILockBytes}
function StgCreateDocfileOnILockBytes(lkbyt: ILockBytes; grfMode: Longint;
  reserved: Longint; out stgOpen: IStorage): HResult; stdcall;
{$EXTERNALSYM StgOpenStorage}
function StgOpenStorage(pwcsName: POleStr; stgPriority: IStorage;
  grfMode: Longint; snbExclude: TSNB; reserved: Longint;
  out stgOpen: IStorage): HResult; stdcall;
{$EXTERNALSYM StgOpenStorageOnILockBytes}
function StgOpenStorageOnILockBytes(lkbyt: ILockBytes; stgPriority: IStorage;
  grfMode: Longint; snbExclude: TSNB; reserved: Longint;
  out stgOpen: IStorage): HResult; stdcall;
{$EXTERNALSYM StgIsStorageFile}
function StgIsStorageFile(pwcsName: POleStr): HResult; stdcall;
{$EXTERNALSYM StgIsStorageILockBytes}
function StgIsStorageILockBytes(lkbyt: ILockBytes): HResult; stdcall;
{$EXTERNALSYM StgSetTimes}
function StgSetTimes(pszName: POleStr; const ctime: TFileTime;
  const atime: TFileTime; const mtime: TFileTime): HResult; stdcall;
{$EXTERNALSYM StgOpenAsyncDocfileOnIFillLockBytes}
function StgOpenAsyncDocfileOnIFillLockBytes(flb: IFillLockBytes;
  grfMode, asyncFlags: Longint; var stgOpen: IStorage): HResult; stdcall;
{$EXTERNALSYM StgGetIFillLockBytesOnILockBytes}
function StgGetIFillLockBytesOnILockBytes(ilb: ILockBytes;
  var flb: IFillLockBytes): HResult; stdcall;
{$EXTERNALSYM StgGetIFillLockBytesOnFile}
function StgGetIFillLockBytesOnFile(pwcsName: POleStr;
  var flb: IFillLockBytes): HResult; stdcall;
{$EXTERNALSYM StgOpenLayoutDocfile}
function StgOpenLayoutDocfile(pwcsDfName: POleStr; grfMode, reserved: Longint;
  var stgOpen: IStorage): HResult; stdcall;


{ Moniker APIs }

{$EXTERNALSYM BindMoniker}
function BindMoniker(mk: IMoniker; grfOpt: Longint; const iidResult: TIID;
  out pvResult): HResult; stdcall;
{$EXTERNALSYM CoGetObject}
function CoGetObject(pszName: PWideString; pBindOptions: PBindOpts;
  const iid: TIID; ppv: Pointer): HResult; stdcall;
{$EXTERNALSYM MkParseDisplayName}
function MkParseDisplayName(bc: IBindCtx; szUserName: POleStr;
  out chEaten: Longint; out mk: IMoniker): HResult; stdcall;
{$EXTERNALSYM MonikerRelativePathTo}
function MonikerRelativePathTo(mkSrc: IMoniker; mkDest: IMoniker;
  out mkRelPath: IMoniker; dwReserved: BOOL): HResult; stdcall;
{$EXTERNALSYM MonikerCommonPrefixWith}
function MonikerCommonPrefixWith(mkThis: IMoniker; mkOther: IMoniker;
  out mkCommon: IMoniker): HResult; stdcall;
{$EXTERNALSYM CreateBindCtx}
function CreateBindCtx(reserved: Longint; out bc: IBindCtx): HResult; stdcall;
{$EXTERNALSYM CreateGenericComposite}
function CreateGenericComposite(mkFirst: IMoniker; mkRest: IMoniker;
  out mkComposite: IMoniker): HResult; stdcall;
{$EXTERNALSYM GetClassFile}
function GetClassFile(szFilename: POleStr; out clsid: TCLSID): HResult; stdcall;
{$EXTERNALSYM CreateFileMoniker}
function CreateFileMoniker(pszPathName: POleStr; out mk: IMoniker): HResult; stdcall;
{$EXTERNALSYM CreateItemMoniker}
function CreateItemMoniker(pszDelim: POleStr; pszItem: POleStr;
  out mk: IMoniker): HResult; stdcall;
{$EXTERNALSYM CreateAntiMoniker}
function CreateAntiMoniker(out mk: IMoniker): HResult; stdcall;
{$EXTERNALSYM CreatePointerMoniker}
function CreatePointerMoniker(unk: IUnknown; out mk: IMoniker): HResult; stdcall;
{$EXTERNALSYM GetRunningObjectTable}
function GetRunningObjectTable(reserved: Longint;
  out rot: IRunningObjectTable): HResult; stdcall;

{ from OLEAUTO.H }
{ TBStr API }

{$EXTERNALSYM SysAllocString}
function SysAllocString(psz: POleStr): TBStr; stdcall;
{$EXTERNALSYM SysReAllocString}
function SysReAllocString(var bstr: TBStr; psz: POleStr): Integer; stdcall;
{$EXTERNALSYM SysAllocStringLen}
function SysAllocStringLen(psz: POleStr; len: Integer): TBStr; stdcall;
{$EXTERNALSYM SysReAllocStringLen}
function SysReAllocStringLen(var bstr: TBStr; psz: POleStr;
  len: Integer): Integer; stdcall;
{$EXTERNALSYM SysFreeString}
procedure SysFreeString(bstr: TBStr); stdcall;
{$EXTERNALSYM SysStringLen}
function SysStringLen(bstr: TBStr): Integer; stdcall;
{$EXTERNALSYM SysStringByteLen}
function SysStringByteLen(bstr: TBStr): Integer; stdcall;
{$EXTERNALSYM SysAllocStringByteLen}
function SysAllocStringByteLen(psz: PChar; len: Integer): TBStr; stdcall;

{ Time API }

{$EXTERNALSYM DosDateTimeToVariantTime}
function DosDateTimeToVariantTime(wDosDate, wDosTime: Word;
  out vtime: TOleDate): Integer; stdcall;
{$EXTERNALSYM VariantTimeToDosDateTime}
function VariantTimeToDosDateTime(vtime: TOleDate; out wDosDate,
  wDosTime: Word): Integer; stdcall;
{$EXTERNALSYM SystemTimeToVariantTime}
function SystemTimeToVariantTime(var SystemTime: TSystemTime;
  out vtime: TOleDate): Integer; stdcall;
{$EXTERNALSYM VariantTimeToSystemTime}
function VariantTimeToSystemTime(vtime: TOleDate;
  out SystemTime: TSystemTime): Integer; stdcall;

{ SafeArray API }

{$EXTERNALSYM SafeArrayAllocDescriptor}
function SafeArrayAllocDescriptor(cDims: Integer; out psaOut: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayAllocData}
function SafeArrayAllocData(psa: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayCreate}
function SafeArrayCreate(vt: TVarType; cDims: Integer; const rgsabound): PSafeArray; stdcall;
{$EXTERNALSYM SafeArrayCreateVector}
function SafeArrayCreateVector(vt: TVarType; Lbound, cElements: Longint): PSafeArray; stdcall;
{$EXTERNALSYM SafeArrayCopyData}
function SafeArrayCopyData(psaSource, psaTarget: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayDestroyDescriptor}
function SafeArrayDestroyDescriptor(psa: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayDestroyData}
function SafeArrayDestroyData(psa: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayDestroy}
function SafeArrayDestroy(psa: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayRedim}
function SafeArrayRedim(psa: PSafeArray; const saboundNew: TSafeArrayBound): HResult; stdcall;
{$EXTERNALSYM SafeArrayGetDim}
function SafeArrayGetDim(psa: PSafeArray): Integer; stdcall;
{$EXTERNALSYM SafeArrayGetElemsize}
function SafeArrayGetElemsize(psa: PSafeArray): Integer; stdcall;
{$EXTERNALSYM SafeArrayGetUBound}
function SafeArrayGetUBound(psa: PSafeArray; nDim: Integer; out lUbound: Longint): HResult; stdcall;
{$EXTERNALSYM SafeArrayGetLBound}
function SafeArrayGetLBound(psa: PSafeArray; nDim: Integer; out lLbound: Longint): HResult; stdcall;
{$EXTERNALSYM SafeArrayLock}
function SafeArrayLock(psa: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayUnlock}
function SafeArrayUnlock(psa: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayAccessData}
function SafeArrayAccessData(psa: PSafeArray; out pvData: Pointer): HResult; stdcall;
{$EXTERNALSYM SafeArrayUnaccessData}
function SafeArrayUnaccessData(psa: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayGetElement}
function SafeArrayGetElement(psa: PSafeArray; const rgIndices; out pv): HResult; stdcall;
{$EXTERNALSYM SafeArrayPutElement}
function SafeArrayPutElement(psa: PSafeArray; const rgIndices; const pv): HResult; stdcall;
{$EXTERNALSYM SafeArrayCopy}
function SafeArrayCopy(psa: PSafeArray; out psaOut: PSafeArray): HResult; stdcall;
{$EXTERNALSYM SafeArrayPtrOfIndex}
function SafeArrayPtrOfIndex(psa: PSafeArray; var rgIndices; out pvData: Pointer): HResult; stdcall;

{ Variant API }

{$EXTERNALSYM VariantInit}
procedure VariantInit(var varg: OleVariant); stdcall;
{$EXTERNALSYM VariantClear}
function VariantClear(var varg: OleVariant): HResult; stdcall;
{$EXTERNALSYM VariantCopy}
function VariantCopy(var vargDest: OleVariant; const vargSrc: OleVariant): HResult; stdcall;
{$EXTERNALSYM VariantCopyInd}
function VariantCopyInd(var varDest: OleVariant; const vargSrc: OleVariant): HResult; stdcall;
{$EXTERNALSYM VariantChangeType}
function VariantChangeType(var vargDest: OleVariant; const vargSrc: OleVariant;
  wFlags: Word; vt: TVarType): HResult; stdcall;
{$EXTERNALSYM VariantChangeTypeEx}
function VariantChangeTypeEx(var vargDest: OleVariant; const vargSrc: OleVariant;
  lcid: TLCID; wFlags: Word; vt: TVarType): HResult; stdcall;

{ Vector <-> Bstr conversion APIs }

{$EXTERNALSYM VectorFromBstr}
function VectorFromBstr(bstr: TBStr; out psa: PSafeArray): HResult; stdcall;
{$EXTERNALSYM BstrFromVector}
function BstrFromVector(psa: PSafeArray; out bstr: TBStr): HResult; stdcall;

{ VarType coercion API }

{ Note: The routines that convert from a string are defined
  to take a POleStr rather than a TBStr because no allocation is
  required, and this makes the routines a bit more generic.
  They may of course still be passed a TBStr as the strIn param. }

{ Any of the coersion functions that converts either from or to a string
  takes an additional lcid and dwFlags arguments. The lcid argument allows
  locale specific parsing to occur.  The dwFlags allow additional function
  specific condition to occur.  All function that accept the dwFlags argument
  can include either 0 or LOCALE_NOUSEROVERRIDE flag. In addition, the
  VarDateFromStr functions also accepts the VAR_TIMEVALUEONLY and
  VAR_DATEVALUEONLY flags }

{$EXTERNALSYM VarUI1FromI2}
function VarUI1FromI2(sIn: Smallint; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromI4}
function VarUI1FromI4(lIn: Longint; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromR4}
function VarUI1FromR4(fltIn: Single; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromR8}
function VarUI1FromR8(dblIn: Double; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromCy}
function VarUI1FromCy(cyIn: Currency; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromDate}
function VarUI1FromDate(dateIn: TOleDate; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromStr}
function VarUI1FromStr(const strIn: WideString; lcid: TLCID; dwFlags: Longint; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromDisp}
function VarUI1FromDisp(dispIn: IDispatch; lcid: TLCID; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromBool}
function VarUI1FromBool(boolIn: TOleBool; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromI1}
function VarUI1FromI1(cIn: Char; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromUI2}
function VarUI1FromUI2(uiIn: Word; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromUI4}
function VarUI1FromUI4(ulIn: Longint; out bOut: Byte): HResult; stdcall;
{$EXTERNALSYM VarUI1FromDec}
function VarUI1FromDec(pdecIn: PDecimal; out bOut: Byte): HResult; stdcall;

{$EXTERNALSYM VarI2FromUI1}
function VarI2FromUI1(bIn: Byte; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromI4}
function VarI2FromI4(lIn: Longint; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromR4}
function VarI2FromR4(fltIn: Single; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromR8}
function VarI2FromR8(dblIn: Double; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromCy}
function VarI2FromCy(cyIn: Currency; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromDate}
function VarI2FromDate(dateIn: TOleDate; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromStr}
function VarI2FromStr(const strIn: WideString; lcid: TLCID; dwFlags: Longint; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromDisp}
function VarI2FromDisp(dispIn: IDispatch; lcid: TLCID; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromBool}
function VarI2FromBool(boolIn: TOleBool; out sOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromI1}
function VarI2FromI1(cIn: Char; out bOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromUI2}
function VarI2FromUI2(uiIn: Word; out bOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromUI4}
function VarI2FromUI4(ulIn: Longint; out bOut: Smallint): HResult; stdcall;
{$EXTERNALSYM VarI2FromDec}
function VarI2FromDec(pdecIn: PDecimal; out bOut: Smallint): HResult; stdcall;

{$EXTERNALSYM VarI4FromUI1}
function VarI4FromUI1(bIn: Byte; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromI2}
function VarI4FromI2(sIn: Smallint; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromR4}
function VarI4FromR4(fltIn: Single; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromR8}
function VarI4FromR8(dblIn: Double; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromCy}
function VarI4FromCy(cyIn: Currency; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromDate}
function VarI4FromDate(dateIn: TOleDate; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromStr}
function VarI4FromStr(const strIn: WideString; lcid: TLCID; dwFlags: Longint; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromDisp}
function VarI4FromDisp(dispIn: IDispatch; lcid: TLCID; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromBool}
function VarI4FromBool(boolIn: TOleBool; out lOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromI1}
function VarI4FromI1(cIn: Char; out bOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromUI2}
function VarI4FromUI2(uiIn: Word; out bOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromUI4}
function VarI4FromUI4(ulIn: Longint; out bOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromDec}
function VarI4FromDec(pdecIn: PDecimal; out bOut: Longint): HResult; stdcall;
{$EXTERNALSYM VarI4FromInt}
function VarI4FromInt(intIn: Integer; out bOut: Longint): HResult; stdcall;

{$EXTERNALSYM VarR4FromUI1}
function VarR4FromUI1(bIn: Byte; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromI2}
function VarR4FromI2(sIn: Smallint; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromI4}
function VarR4FromI4(lIn: Longint; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromR8}
function VarR4FromR8(dblIn: Double; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromCy}
function VarR4FromCy(cyIn: Currency; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromDate}
function VarR4FromDate(dateIn: TOleDate; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromStr}
function VarR4FromStr(const strIn: WideString; lcid: TLCID; dwFlags: Longint; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromDisp}
function VarR4FromDisp(dispIn: IDispatch; lcid: TLCID; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromBool}
function VarR4FromBool(boolIn: TOleBool; out fltOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromI1}
function VarR4FromI1(cIn: Char; out bOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromUI2}
function VarR4FromUI2(uiIn: Word; out bOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromUI4}
function VarR4FromUI4(ulIn: Longint; out bOut: Single): HResult; stdcall;
{$EXTERNALSYM VarR4FromDec}
function VarR4FromDec(pdecIn: PDecimal; out bOut: Single): HResult; stdcall;

{$EXTERNALSYM VarR8FromUI1}
function VarR8FromUI1(bIn: Byte; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromI2}
function VarR8FromI2(sIn: Smallint; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromI4}
function VarR8FromI4(lIn: Longint; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromR4}
function VarR8FromR4(fltIn: Single; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromCy}
function VarR8FromCy(cyIn: Currency; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromDate}
function VarR8FromDate(dateIn: TOleDate; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromStr}
function VarR8FromStr(const strIn: WideString; lcid: TLCID; dwFlags: Longint; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromDisp}
function VarR8FromDisp(dispIn: IDispatch; lcid: TLCID; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromBool}
function VarR8FromBool(boolIn: TOleBool; out dblOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromI1}
function VarR8FromI1(cIn: Char; out bOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromUI2}
function VarR8FromUI2(uiIn: Word; out bOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromUI4}
function VarR8FromUI4(ulIn: Longint; out bOut: Double): HResult; stdcall;
{$EXTERNALSYM VarR8FromDec}
function VarR8FromDec(pdecIn: PDecimal; out bOut: Double): HResult; stdcall;

{$EXTERNALSYM VarDateFromUI1}
function VarDateFromUI1(bIn: Byte; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromI2}
function VarDateFromI2(sIn: Smallint; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromI4}
function VarDateFromI4(lIn: Longint; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromR4}
function VarDateFromR4(fltIn: Single; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromR8}
function VarDateFromR8(dblIn: Double; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromCy}
function VarDateFromCy(cyIn: Currency; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromStr}
function VarDateFromStr(const strIn: WideString; lcid: TLCID; dwFlags: Longint; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromDisp}
function VarDateFromDisp(dispIn: IDispatch; lcid: TLCID; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromBool}
function VarDateFromBool(boolIn: TOleBool; out dateOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromI1}
function VarDateFromI1(cIn: Char; out bOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromUI2}
function VarDateFromUI2(uiIn: Word; out bOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromUI4}
function VarDateFromUI4(ulIn: Longint; out bOut: TOleDate): HResult; stdcall;
{$EXTERNALSYM VarDateFromDec}
function VarDateFromDec(pdecIn: PDecimal; out bOut: TOleDate): HResult; stdcall;

{$EXTERNALSYM VarCyFromUI1}
function VarCyFromUI1(bIn: Byte; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromI2}
function VarCyFromI2(sIn: Smallint; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromI4}
function VarCyFromI4(lIn: Longint; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromR4}
function VarCyFromR4(fltIn: Single; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromR8}
function VarCyFromR8(dblIn: Double; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromDate}
function VarCyFromDate(dateIn: TOleDate; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromStr}
function VarCyFromStr(const strIn: WideString; lcid: TLCID; dwFlags: Longint; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromDisp}
function VarCyFromDisp(dispIn: IDispatch; lcid: TLCID; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromBool}
function VarCyFromBool(boolIn: TOleBool; out cyOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromI1}
function VarCyFromI1(cIn: Char; out bOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromUI2}
function VarCyFromUI2(uiIn: Word; out bOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromUI4}
function VarCyFromUI4(ulIn: Longint; out bOut: Currency): HResult; stdcall;
{$EXTERNALSYM VarCyFromDec}
function VarCyFromDec(pdecIn: PDecimal; out bOut: Currency): HResult; stdcall;

{$EXTERNALSYM VarBStrFromUI1}
function VarBStrFromUI1(bVal: Byte; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromI2}
function VarBStrFromI2(iVal: Smallint; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromI4}
function VarBStrFromI4(lIn: Longint; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromR4}
function VarBStrFromR4(fltIn: Single; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromR8}
function VarBStrFromR8(dblIn: Double; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromCy}
function VarBStrFromCy(cyIn: Currency; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromDate}
function VarBStrFromDate(dateIn: TOleDate; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromDisp}
function VarBStrFromDisp(dispIn: IDispatch; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromBool}
function VarBStrFromBool(boolIn: TOleBool; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromI1}
function VarBStrFromI1(cIn: Char; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromUI2}
function VarBStrFromUI2(uiIn: Word; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromUI4}
function VarBStrFromUI4(ulIn: Longint; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;
{$EXTERNALSYM VarBStrFromDec}
function VarBStrFromDec(pdecIn: PDecimal; lcid: TLCID; dwFlags: Longint; out bstrOut: WideString): HResult; stdcall;

{$EXTERNALSYM VarBoolFromUI1}
function VarBoolFromUI1(bIn: Byte; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromI2}
function VarBoolFromI2(sIn: Smallint; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromI4}
function VarBoolFromI4(lIn: Longint; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromR4}
function VarBoolFromR4(fltIn: Single; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromR8}
function VarBoolFromR8(dblIn: Double; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromDate}
function VarBoolFromDate(dateIn: TOleDate; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromCy}
function VarBoolFromCy(cyIn: Currency; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromStr}
function VarBoolFromStr(const strIn: WideString; lcid: TLCID; dwFlags: Longint; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromDisp}
function VarBoolFromDisp(dispIn: IDispatch; lcid: TLCID; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromI1}
function VarBoolFromI1(cIn: Char; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromUI2}
function VarBoolFromUI2(uiIn: Word; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromUI4}
function VarBoolFromUI4(ulIn: Longint; out boolOut: TOleBool): HResult; stdcall;
{$EXTERNALSYM VarBoolFromDec}
function VarBoolFromDec(pdecIn: PDecimal; out boolOut: TOleBool): HResult; stdcall;

{ TypeInfo API }

{$EXTERNALSYM LHashValOfNameSys}
function LHashValOfNameSys(syskind: TSysKind; lcid: TLCID;
  szName: POleStr): Longint; stdcall;
{$EXTERNALSYM LHashValOfNameSysA}
function LHashValOfNameSysA(syskind: TSysKind; lcid: TLCID;
  szName: PChar): Longint; stdcall;

{$EXTERNALSYM LHashValOfName}
function LHashValOfName(lcid: TLCID; szName: POleStr): Longint;
{$EXTERNALSYM WHashValOfLHashVal}
function WHashValOfLHashVal(lhashval: Longint): Word;
{$EXTERNALSYM IsHashValCompatible}
function IsHashValCompatible(lhashval1, lhashval2: Longint): Boolean;

{$EXTERNALSYM LoadTypeLib}
function LoadTypeLib(szFile: POleStr; out tlib: ITypeLib): HResult; stdcall;
{$EXTERNALSYM LoadTypeLibEx}
function LoadTypeLibEx(szFile: POleStr; regkind: TRegKind; out tlib: ITypeLib): HResult; stdcall;
{$EXTERNALSYM LoadRegTypeLib}
function LoadRegTypeLib(const guid: TGUID; wVerMajor, wVerMinor: Word;
  lcid: TLCID; out tlib: ITypeLib): HResult; stdcall;
{$EXTERNALSYM QueryPathOfRegTypeLib}
function QueryPathOfRegTypeLib(const guid: TGUID; wMaj, wMin: Word;
  lcid: TLCID; out bstrPathName: WideString): HResult; stdcall;
{$EXTERNALSYM RegisterTypeLib}
function RegisterTypeLib(tlib: ITypeLib; szFullPath, szHelpDir: POleStr): HResult; stdcall;
{$EXTERNALSYM UnRegisterTypeLib}
function UnRegisterTypeLib(const libID: TGUID; wVerMajor, wVerMinor: Word;
  lcid: TLCID; syskind: TSysKind): HResult; stdcall;
{$EXTERNALSYM CreateTypeLib}
function CreateTypeLib(syskind: TSysKind; szFile: POleStr;
  out ctlib: ICreateTypeLib): HResult; stdcall;
{$EXTERNALSYM CreateTypeLib2}
function CreateTypeLib2(syskind: TSysKind; szFile: POleStr;
  out ctlib: ICreateTypeLib2): HResult; stdcall;

{ IDispatch implementation support }

{$EXTERNALSYM DispGetParam}
function DispGetParam(const dispparams: TDispParams; position: Integer;
  vtTarg: TVarType; var varResult: OleVariant; var puArgErr: Integer): HResult; stdcall;
{$EXTERNALSYM DispGetIDsOfNames}
function DispGetIDsOfNames(tinfo: ITypeInfo; rgszNames: POleStrList;
  cNames: Integer; rgdispid: PDispIDList): HResult; stdcall;
{$EXTERNALSYM DispInvoke}
function DispInvoke(This: Pointer; tinfo: ITypeInfo; dispidMember: TDispID;
  wFlags: Word; var params: TDispParams; varResult: PVariant;
  excepinfo: PExcepInfo; puArgErr: PInteger): HResult; stdcall;
{$EXTERNALSYM CreateDispTypeInfo}
function CreateDispTypeInfo(var idata: TInterfaceData; lcid: TLCID;
  out tinfo: ITypeInfo): HResult; stdcall;
{$EXTERNALSYM CreateStdDispatch}
function CreateStdDispatch(unkOuter: IUnknown; pvThis: Pointer;
  tinfo: ITypeInfo; out unkStdDisp: IUnknown): HResult; stdcall;
{$EXTERNALSYM DispCallFunc}
function DispCallFunc(pvInstance: Pointer; oVft: Longint; cc: TCallConv;
  vtReturn: TVarType; cActuals: Longint; var rgvt: TVarType; var prgpvarg: OleVariant;
  var vargResult: OleVariant): HResult; stdcall;


{ Active object registration API }
const
  {$EXTERNALSYM ACTIVEOBJECT_STRONG}
  ACTIVEOBJECT_STRONG = 0;
  {$EXTERNALSYM ACTIVEOBJECT_WEAK}
  ACTIVEOBJECT_WEAK = 1;

{$EXTERNALSYM RegisterActiveObject}
function RegisterActiveObject(unk: IUnknown; const clsid: TCLSID;
  dwFlags: Longint; out dwRegister: Longint): HResult; stdcall;
{$EXTERNALSYM RevokeActiveObject}
function RevokeActiveObject(dwRegister: Longint; pvReserved: Pointer): HResult; stdcall;
{$EXTERNALSYM GetActiveObject}
function GetActiveObject(const clsid: TCLSID; pvReserved: Pointer;
  out unk: IUnknown): HResult; stdcall;

{ ErrorInfo API }

{$EXTERNALSYM SetErrorInfo}
function SetErrorInfo(dwReserved: Longint; errinfo: IErrorInfo): HResult; stdcall;
{$EXTERNALSYM GetErrorInfo}
function GetErrorInfo(dwReserved: Longint; out errinfo: IErrorInfo): HResult; stdcall;
{$EXTERNALSYM CreateErrorInfo}
function CreateErrorInfo(out errinfo: ICreateErrorInfo): HResult; stdcall;

{ Misc API }

{$EXTERNALSYM OaBuildVersion}
function OaBuildVersion: Longint; stdcall;

procedure ClearCustData(var pCustData: TCustData); stdcall;
{$EXTERNALSYM ClearCustData}

{ from OLE2.H }
{ OLE API prototypes }

{$EXTERNALSYM OleBuildVersion}
function OleBuildVersion: HResult; stdcall;

{ helper functions }

{$EXTERNALSYM ReadClassStg}
function ReadClassStg(stg: IStorage; out clsid: TCLSID): HResult; stdcall;
{$EXTERNALSYM WriteClassStg}
function WriteClassStg(stg: IStorage; const clsid: TIID): HResult; stdcall;
{$EXTERNALSYM ReadClassStm}
function ReadClassStm(stm: IStream; out clsid: TCLSID): HResult; stdcall;
{$EXTERNALSYM WriteClassStm}
function WriteClassStm(stm: IStream; const clsid: TIID): HResult; stdcall;
{$EXTERNALSYM WriteFmtUserTypeStg}
function WriteFmtUserTypeStg(stg: IStorage; cf: TClipFormat;
  pszUserType: POleStr): HResult; stdcall;
{$EXTERNALSYM ReadFmtUserTypeStg}
function ReadFmtUserTypeStg(stg: IStorage; out cf: TClipFormat;
  out pszUserType: POleStr): HResult; stdcall;

{ Initialization and termination }

{$EXTERNALSYM OleInitialize}
function OleInitialize(pwReserved: Pointer): HResult; stdcall;
{$EXTERNALSYM OleUninitialize}
procedure OleUninitialize; stdcall;

{ APIs to query whether (Embedded/Linked) object can be created from
  the data object }

{$EXTERNALSYM OleQueryLinkFromData}
function OleQueryLinkFromData(srcDataObject: IDataObject): HResult; stdcall;
{$EXTERNALSYM OleQueryCreateFromData}
function OleQueryCreateFromData(srcDataObject: IDataObject): HResult; stdcall;

{ Object creation APIs }

{$EXTERNALSYM OleCreate}
function OleCreate(const clsid: TCLSID; const iid: TIID; renderopt: Longint;
  formatEtc: PFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateEx}
function OleCreateEx(const clsid: TCLSID; const iid: TIID;
  dwFlags, renderopt, cFormats: Longint; rgAdvf: PLongintList; rgFFormatEtc: PFormatEtc;
  AdviseSink: IAdviseSink; rgdwConnection: PLongintList; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateFromData}
function OleCreateFromData(srcDataObj: IDataObject; const iid: TIID;
  renderopt: Longint; formatEtc: PFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateFromDataEx}
function OleCreateFromDataEx(srcDataObj: IDataObject; const iid: TIID;
  dwFlags, renderopt, cFormats: Longint; rgAdvf: PLongintList; rgFFormatEtc: PFormatEtc;
  AdviseSink: IAdviseSink; rgdwConnection: PLongintList; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateLinkFromData}
function OleCreateLinkFromData(srcDataObj: IDataObject; const iid: TIID;
  renderopt: Longint; formatEtc: PFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateLinkFromDataEx}
function OleCreateLinkFromDataEx(srcDataObj: IDataObject; const iid: TIID;
  dwFlags, renderopt, cFormats: Longint; rgAdvf: PLongintList; rgFFormatEtc: PFormatEtc;
  AdviseSink: IAdviseSink; rgdwConnection: PLongintList; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateStaticFromData}
function OleCreateStaticFromData(srcDataObj: IDataObject; const iid: TIID;
  renderopt: Longint; formatEtc: PFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateLink}
function OleCreateLink(mkLinkSrc: IMoniker; const iid: TIID;
  renderopt: Longint; formatEtc: PFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateLinkEx}
function OleCreateLinkEx(mkLinkSrc: IMoniker; const iid: TIID;
  dwFlags, renderopt, cFormats: Longint; rgAdvf: PLongintList; rgFFormatEtc: PFormatEtc;
  AdviseSink: IAdviseSink; rgdwConnection: PLongintList; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateLinkToFile}
function OleCreateLinkToFile(pszFileName: POleStr; const iid: TIID;
  renderopt: Longint; formatEtc: PFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateLinkToFileEx}
function OleCreateLinkToFileEx(pszFileName: POleStr; const iid: TIID;
  dwFlags, renderopt, cFormats: Longint; rgAdvf: PLongintList; rgFFormatEtc: PFormatEtc;
  AdviseSink: IAdviseSink; rgdwConnection: PLongintList; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateFromFile}
function OleCreateFromFile(const clsid: TCLSID; pszFileName: POleStr;
  const iid: TIID; renderopt: Longint; formatEtc: PFormatEtc;
  clientSite: IOleClientSite; stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateFromFileEx}
function OleCreateFromFileEx(const clsid: TCLSID; pszFileName: POleStr; const iid: TIID;
  dwFlags, renderopt, cFormats: Longint; rgAdvf: PLongintList; rgFFormatEtc: PFormatEtc;
  AdviseSink: IAdviseSink; rgdwConnection: PLongintList; clientSite: IOleClientSite;
  stg: IStorage; out vObj): HResult; stdcall;
{$EXTERNALSYM OleLoad}
function OleLoad(stg: IStorage; const iid: TIID; clientSite: IOleClientSite;
  out vObj): HResult; stdcall;
{$EXTERNALSYM OleSave}
function OleSave(ps: IPersistStorage; stg: IStorage; fSameAsLoad: BOOL): HResult; stdcall;
{$EXTERNALSYM OleLoadFromStream}
function OleLoadFromStream(stm: IStream; const iidInterface: TIID;
  out vObj): HResult; stdcall;
{$EXTERNALSYM OleSaveToStream}
function OleSaveToStream(pstm: IPersistStream; stm: IStream): HResult; stdcall;
{$EXTERNALSYM OleSetContainedObject}
function OleSetContainedObject(unknown: IUnknown; fContained: BOOL): HResult; stdcall;
{$EXTERNALSYM OleNoteObjectVisible}
function OleNoteObjectVisible(unknown: IUnknown; fVisible: BOOL): HResult; stdcall;

{ DragDrop APIs }

{$EXTERNALSYM RegisterDragDrop}
function RegisterDragDrop(wnd: HWnd; dropTarget: IDropTarget): HResult; stdcall;
{$EXTERNALSYM RevokeDragDrop}
function RevokeDragDrop(wnd: HWnd): HResult; stdcall;
{$EXTERNALSYM DoDragDrop}
function DoDragDrop(dataObj: IDataObject; dropSource: IDropSource;
  dwOKEffects: Longint; var dwEffect: Longint): HResult; stdcall;

{ Clipboard APIs }

{$EXTERNALSYM OleSetClipboard}
function OleSetClipboard(dataObj: IDataObject): HResult; stdcall;
{$EXTERNALSYM OleGetClipboard}
function OleGetClipboard(out dataObj: IDataObject): HResult; stdcall;
{$EXTERNALSYM OleFlushClipboard}
function OleFlushClipboard: HResult; stdcall;
{$EXTERNALSYM OleIsCurrentClipboard}
function OleIsCurrentClipboard(dataObj: IDataObject): HResult; stdcall;

{ In-place editing APIs }

{$EXTERNALSYM OleCreateMenuDescriptor}
function OleCreateMenuDescriptor(hmenuCombined: HMenu;
  var menuWidths: TOleMenuGroupWidths): HMenu; stdcall;
{$EXTERNALSYM OleSetMenuDescriptor}
function OleSetMenuDescriptor(holemenu: HMenu; hwndFrame: HWnd;
  hwndActiveObject: HWnd; frame: IOleInPlaceFrame;
  activeObj: IOleInPlaceActiveObject): HResult; stdcall;
{$EXTERNALSYM OleDestroyMenuDescriptor}
function OleDestroyMenuDescriptor(holemenu: HMenu): HResult; stdcall;
{$EXTERNALSYM OleTranslateAccelerator}
function OleTranslateAccelerator(frame: IOleInPlaceFrame;
  var frameInfo: TOleInPlaceFrameInfo; msg: PMsg): HResult; stdcall;

{ Helper APIs }

{$EXTERNALSYM OleDuplicateData}
function OleDuplicateData(hSrc: THandle; cfFormat: TClipFormat;
  uiFlags: Integer): THandle; stdcall;
{$EXTERNALSYM OleDraw}
function OleDraw(unknown: IUnknown; dwAspect: Longint; hdcDraw: HDC;
  const rcBounds: TRect): HResult; stdcall;
{$EXTERNALSYM OleRun}
function OleRun(unknown: IUnknown): HResult; stdcall;
{$EXTERNALSYM OleIsRunning}
function OleIsRunning(obj: IOleObject): BOOL; stdcall;
{$EXTERNALSYM OleLockRunning}
function OleLockRunning(unknown: IUnknown; fLock: BOOL;
  fLastUnlockCloses: BOOL): HResult; stdcall;
{$EXTERNALSYM ReleaseStgMedium}
procedure ReleaseStgMedium(var medium: TStgMedium); stdcall;
{$EXTERNALSYM CreateOleAdviseHolder}
function CreateOleAdviseHolder(out OAHolder: IOleAdviseHolder): HResult; stdcall;
{$EXTERNALSYM OleCreateDefaultHandler}
function OleCreateDefaultHandler(const clsid: TCLSID; unkOuter: IUnknown;
  const iid: TIID; out vObj): HResult; stdcall;
{$EXTERNALSYM OleCreateEmbeddingHelper}
function OleCreateEmbeddingHelper(const clsid: TCLSID; unkOuter: IUnknown;
  flags: Longint; cf: IClassFactory; const iid: TIID; out vObj): HResult; stdcall;
{$EXTERNALSYM IsAccelerator}
function IsAccelerator(accel: HAccel; cAccelEntries: Integer; msg: PMsg;
  var pwCmd: Word): BOOL; stdcall;

{ Icon extraction helper APIs }

{$EXTERNALSYM OleGetIconOfFile}
function OleGetIconOfFile(pszPath: POleStr; fUseFileAsLabel: BOOL): HGlobal; stdcall;
{$EXTERNALSYM OleGetIconOfClass}
function OleGetIconOfClass(const clsid: TCLSID; pszLabel: POleStr;
  fUseTypeAsLabel: BOOL): HGlobal; stdcall;
{$EXTERNALSYM OleMetafilePictFromIconAndLabel}
function OleMetafilePictFromIconAndLabel(icon: HIcon; pszLabel: POleStr;
  pszSourceFile: POleStr; iIconIndex: Integer): HGlobal; stdcall;

{ Registration database helper APIs }

{$EXTERNALSYM OleRegGetUserType}
function OleRegGetUserType(const clsid: TCLSID; dwFormOfType: Longint;
  out pszUserType: POleStr): HResult; stdcall;
{$EXTERNALSYM OleRegGetMiscStatus}
function OleRegGetMiscStatus(const clsid: TCLSID; dwAspect: Longint;
  out dwStatus: Longint): HResult; stdcall;
{$EXTERNALSYM OleRegEnumFormatEtc}
function OleRegEnumFormatEtc(const clsid: TCLSID; dwDirection: Longint;
  out Enum: IEnumFormatEtc): HResult; stdcall;
{$EXTERNALSYM OleRegEnumVerbs}
function OleRegEnumVerbs(const clsid: TCLSID;
  out Enum: IEnumOleVerb): HResult; stdcall;

{ OLE 1.0 conversion APIs }

{$EXTERNALSYM OleConvertIStorageToOLESTREAM}
function OleConvertIStorageToOLESTREAM(stg: IStorage;
  polestm: Pointer): HResult; stdcall;
{$EXTERNALSYM OleConvertOLESTREAMToIStorage}
function OleConvertOLESTREAMToIStorage(polestm: Pointer; stg: IStorage;
  td: PDVTargetDevice): HResult; stdcall;
{$EXTERNALSYM OleConvertIStorageToOLESTREAMEx}
function OleConvertIStorageToOLESTREAMEx(stg: IStorage; cfFormat: TClipFormat;
  lWidth: Longint; lHeight: Longint; dwSize: Longint; var medium: TStgMedium;
  polestm: Pointer): HResult; stdcall;
{$EXTERNALSYM OleConvertOLESTREAMToIStorageEx}
function OleConvertOLESTREAMToIStorageEx(polestm: Pointer; stg: IStorage;
  var cfFormat: TClipFormat; var lWidth: Longint; var lHeight: Longint;
  var dwSize: Longint; var medium: TStgMedium): HResult; stdcall;

{ Storage utility APIs }

{$EXTERNALSYM GetHGlobalFromILockBytes}
function GetHGlobalFromILockBytes(lkbyt: ILockBytes; out hglob: HGlobal): HResult; stdcall;
{$EXTERNALSYM CreateILockBytesOnHGlobal}
function CreateILockBytesOnHGlobal(hglob: HGlobal; fDeleteOnRelease: BOOL;
  out lkbyt: ILockBytes): HResult; stdcall;
{$EXTERNALSYM GetHGlobalFromStream}
function GetHGlobalFromStream(stm: IStream; out hglob: HGlobal): HResult; stdcall;
{$EXTERNALSYM CreateStreamOnHGlobal}
function CreateStreamOnHGlobal(hglob: HGlobal; fDeleteOnRelease: BOOL;
  out stm: IStream): HResult; stdcall;

{ ConvertTo APIs }

{$EXTERNALSYM OleDoAutoConvert}
function OleDoAutoConvert(stg: IStorage; out clsidNew: TCLSID): HResult; stdcall;
{$EXTERNALSYM OleGetAutoConvert}
function OleGetAutoConvert(const clsidOld: TCLSID; out clsidNew: TCLSID): HResult; stdcall;
{$EXTERNALSYM OleSetAutoConvert}
function OleSetAutoConvert(const clsidOld: TCLSID; const clsidNew: TCLSID): HResult; stdcall;
{$EXTERNALSYM GetConvertStg}
function GetConvertStg(stg: IStorage): HResult; stdcall;
{$EXTERNALSYM SetConvertStg}
function SetConvertStg(stg: IStorage; fConvert: BOOL): HResult; stdcall;

{ from OLECTL.H }
{ Property frame APIs }

{$EXTERNALSYM OleCreatePropertyFrame}
function OleCreatePropertyFrame(hwndOwner: HWnd; x, y: Integer;
  lpszCaption: POleStr; cObjects: Integer; pObjects: Pointer;
  cPages: Integer; pPageCLSIDs: Pointer; lcid: TLCID; dwReserved: Longint;
  pvReserved: Pointer): HResult; stdcall;
{$EXTERNALSYM OleCreatePropertyFrameIndirect}
function OleCreatePropertyFrameIndirect(const Params: TOCPFIParams): HResult; stdcall;

{ Standard type APIs }

{$EXTERNALSYM OleTranslateColor}
function OleTranslateColor(clr: TOleColor; hpal: HPalette;
 out colorref: TColorRef): HResult; stdcall;
{$EXTERNALSYM OleCreateFontIndirect}
function OleCreateFontIndirect(const FontDesc: TFontDesc; const iid: TIID;
  out vObject): HResult; stdcall;
{$EXTERNALSYM OleCreatePictureIndirect}
function OleCreatePictureIndirect(const PictDesc: TPictDesc; const iid: TIID;
  fOwn: BOOL; out vObject): HResult; stdcall;
{$EXTERNALSYM OleLoadPicture}
function OleLoadPicture(stream: IStream; lSize: Longint; fRunmode: BOOL;
  const iid: TIID; out vObject): HResult; stdcall;
{$EXTERNALSYM OleLoadPicturePath}
function OleLoadPicturePath(szURLorPath: POleStr; unkCaller: IUnknown;
  dwReserved: Longint; clrReserved: TOleColor; const iid: TIID;
  ppvRet: Pointer): HResult; stdcall;
{$EXTERNALSYM OleLoadPictureFile}
function OleLoadPictureFile(varFileName: OleVariant;
  var lpdispPicture: IDispatch): HResult; stdcall;
{$EXTERNALSYM OleSavePictureFile}
function OleSavePictureFile(dispPicture: IDispatch;
  bstrFileName: TBStr): HResult; stdcall;
{$EXTERNALSYM OleIconToCursor}
function OleIconToCursor(hinstExe: THandle; hIcon: THandle): HCursor; stdcall;

// Macros for parsing the OS Version of the Property Set Header
{$EXTERNALSYM PROPSETHDR_OSVER_KIND}
function PROPSETHDR_OSVER_KIND(dwOSVer: DWORD): Word;
{$EXTERNALSYM PROPSETHDR_OSVER_MAJOR}
function PROPSETHDR_OSVER_MAJOR(dwOSVer: DWORD): Byte;
{$EXTERNALSYM PROPSETHDR_OSVER_MINOR}
function PROPSETHDR_OSVER_MINOR(dwOSVer: DWORD): Byte;

const
  {$EXTERNALSYM PROPSETHDR_OSVERSION_UNKNOWN}
  PROPSETHDR_OSVERSION_UNKNOWN        = $FFFFFFFF;

implementation

const
  ole32    = 'ole32.dll';
  oleaut32 = 'oleaut32.dll';
  olepro32 = 'olepro32.dll';

{ Externals from ole32.dll }

function IsEqualGUID;                   external ole32 name 'IsEqualGUID';
function IsEqualIID;                    external ole32 name 'IsEqualGUID';
function IsEqualCLSID;                  external ole32 name 'IsEqualGUID';
function CoBuildVersion;                external ole32 name 'CoBuildVersion';
function CoInitialize;                  external ole32 name 'CoInitialize';
function CoInitializeEx;                external ole32 name 'CoInitializeEx';
procedure CoUninitialize;               external ole32 name 'CoUninitialize';
function CoGetMalloc;                   external ole32 name 'CoGetMalloc';
function CoGetCurrentProcess;           external ole32 name 'CoGetCurrentProcess';
function CoRegisterMallocSpy;           external ole32 name 'CoRegisterMallocSpy';
function CoRevokeMallocSpy;             external ole32 name 'CoRevokeMallocSpy';
function CoCreateStandardMalloc;        external ole32 name 'CoCreateStandardMalloc';
function CoGetClassObject;              external ole32 name 'CoGetClassObject';
function CoRegisterClassObject;         external ole32 name 'CoRegisterClassObject';
function CoRevokeClassObject;           external ole32 name 'CoRevokeClassObject';
function CoResumeClassObjects;          external ole32 name 'CoResumeClassObjects';
function CoSuspendClassObjects;         external ole32 name 'CoSuspendClassObjects';
function CoAddRefServerProcess;         external ole32 name 'CoAddRefServerProcess';
function CoReleaseServerProcess;        external ole32 name 'CoReleaseServerProcess';
function CoGetPSClsid;                  external ole32 name 'CoGetPSClsid';
function CoRegisterPSClsid;             external ole32 name 'CoRegisterPSClsid';
function CoGetMarshalSizeMax;           external ole32 name 'CoGetMarshalSizeMax';
function CoMarshalInterface;            external ole32 name 'CoMarshalInterface';
function CoUnmarshalInterface;          external ole32 name 'CoUnmarshalInterface';
function CoMarshalHResult;              external ole32 name 'CoMarshalHResult';
function CoUnmarshalHResult;            external ole32 name 'CoUnmarshalHResult';
function CoReleaseMarshalData;          external ole32 name 'CoReleaseMarshalData';
function CoDisconnectObject;            external ole32 name 'CoDisconnectObject';
function CoLockObjectExternal;          external ole32 name 'CoLockObjectExternal';
function CoGetStandardMarshal;          external ole32 name 'CoGetStandardMarshal';
function CoIsHandlerConnected;          external ole32 name 'CoIsHandlerConnected';
function CoHasStrongExternalConnections; external ole32 name 'CoHasStrongExternalConnections';
function CoMarshalInterThreadInterfaceInStream; external ole32 name 'CoMarshalInterThreadInterfaceInStream';
function CoGetInterfaceAndReleaseStream; external ole32 name 'CoGetInterfaceAndReleaseStream';
function CoCreateFreeThreadedMarshaler; external ole32 name 'CoCreateFreeThreadedMarshaler';
function CoLoadLibrary;                 external ole32 name 'CoLoadLibrary';
procedure CoFreeLibrary;                external ole32 name 'CoFreeLibrary';
procedure CoFreeAllLibraries;           external ole32 name 'CoFreeAllLibraries';
procedure CoFreeUnusedLibraries;        external ole32 name 'CoFreeUnusedLibraries';
function CoInitializeSecurity;          external ole32 name 'CoInitializeSecurity';
function CoGetCallContext;              external ole32 name 'CoGetCallContext';
function CoQueryProxyBlanket;           external ole32 name 'CoQueryProxyBlanket';
function CoSetProxyBlanket;             external ole32 name 'CoSetProxyBlanket';
function CoCopyProxy;                   external ole32 name 'CoCopyProxy';
function CoQueryClientBlanket;          external ole32 name 'CoQueryClientBlanket';
function CoImpersonateClient;           external ole32 name 'CoImpersonateClient';
function CoRevertToSelf;                external ole32 name 'CoRevertToSelf';
function CoQueryAuthenticationServices; external ole32 name 'CoQueryAuthenticationServices';
function CoSwitchCallContext;           external ole32 name 'CoSwitchCallContext';
function CoCreateInstance;              external ole32 name 'CoCreateInstance';
function CoGetInstanceFromFile;         external ole32 name 'CoGetInstanceFromFile';
function CoGetInstanceFromIStorage;     external ole32 name 'CoGetInstanceFromIStorage';
function CoCreateInstanceEx;            external ole32 name 'CoCreateInstanceEx';
function StringFromCLSID;               external ole32 name 'StringFromCLSID';
function CLSIDFromString;               external ole32 name 'CLSIDFromString';
function StringFromIID;                 external ole32 name 'StringFromIID';
function IIDFromString;                 external ole32 name 'IIDFromString';
function CoIsOle1Class;                 external ole32 name 'CoIsOle1Class';
function ProgIDFromCLSID;               external ole32 name 'ProgIDFromCLSID';
function CLSIDFromProgID;               external ole32 name 'CLSIDFromProgID';
function StringFromGUID2;               external ole32 name 'StringFromGUID2';
function CoCreateGuid;                  external ole32 name 'CoCreateGuid';
function CoFileTimeToDosDateTime;       external ole32 name 'CoFileTimeToDosDateTime';
function CoDosDateTimeToFileTime;       external ole32 name 'CoDosDateTimeToFileTime';
function CoFileTimeNow;                 external ole32 name 'CoFileTimeNow';
function CoRegisterMessageFilter;       external ole32 name 'CoRegisterMessageFilter';
function CoRegisterChannelHook;         external ole32 name 'CoRegisterChannelHook';
function CoGetTreatAsClass;             external ole32 name 'CoGetTreatAsClass';
function CoTreatAsClass;                external ole32 name 'CoTreatAsClass';
function CoTaskMemAlloc;                external ole32 name 'CoTaskMemAlloc';
function CoTaskMemRealloc;              external ole32 name 'CoTaskMemRealloc';
procedure CoTaskMemFree;                external ole32 name 'CoTaskMemFree';
function CreateDataAdviseHolder;        external ole32 name 'CreateDataAdviseHolder';
function CreateDataCache;               external ole32 name 'CreateDataCache';
function StgCreateDocfile;              external ole32 name 'StgCreateDocfile';
function StgCreateDocfileOnILockBytes;  external ole32 name 'StgCreateDocfileOnILockBytes';
function StgOpenStorage;                external ole32 name 'StgOpenStorage';
function StgOpenStorageOnILockBytes;    external ole32 name 'StgOpenStorageOnILockBytes';
function StgIsStorageFile;              external ole32 name 'StgIsStorageFile';
function StgIsStorageILockBytes;        external ole32 name 'StgIsStorageILockBytes';
function StgSetTimes;                   external ole32 name 'StgSetTimes';
function StgOpenAsyncDocfileOnIFillLockBytes; external ole32 name 'StgOpenAsyncDocfileOnIFillLockBytes';
function StgGetIFillLockBytesOnILockBytes; external ole32 name 'StgGetIFillLockBytesOnILockBytes';
function StgGetIFillLockBytesOnFile;    external ole32 name 'StgGetIFillLockBytesOnFile';
function StgOpenLayoutDocfile;          external ole32 name 'StgOpenLayoutDocfile';
function BindMoniker;                   external ole32 name 'BindMoniker';
function CoGetObject;                   external ole32 name 'CoGetObject';
function MkParseDisplayName;            external ole32 name 'MkParseDisplayName';
function MonikerRelativePathTo;         external ole32 name 'MonikerRelativePathTo';
function MonikerCommonPrefixWith;       external ole32 name 'MonikerCommonPrefixWith';
function CreateBindCtx;                 external ole32 name 'CreateBindCtx';
function CreateGenericComposite;        external ole32 name 'CreateGenericComposite';
function GetClassFile;                  external ole32 name 'GetClassFile';
function CreateFileMoniker;             external ole32 name 'CreateFileMoniker';
function CreateItemMoniker;             external ole32 name 'CreateItemMoniker';
function CreateAntiMoniker;             external ole32 name 'CreateAntiMoniker';
function CreatePointerMoniker;          external ole32 name 'CreatePointerMoniker';
function GetRunningObjectTable;         external ole32 name 'GetRunningObjectTable';
function OleBuildVersion;               external ole32 name 'OleBuildVersion';
function ReadClassStg;                  external ole32 name 'ReadClassStg';
function WriteClassStg;                 external ole32 name 'WriteClassStg';
function ReadClassStm;                  external ole32 name 'ReadClassStm';
function WriteClassStm;                 external ole32 name 'WriteClassStm';
function WriteFmtUserTypeStg;           external ole32 name 'WriteFmtUserTypeStg';
function ReadFmtUserTypeStg;            external ole32 name 'ReadFmtUserTypeStg';
function OleInitialize;                 external ole32 name 'OleInitialize';
procedure OleUninitialize;              external ole32 name 'OleUninitialize';
function OleQueryLinkFromData;          external ole32 name 'OleQueryLinkFromData';
function OleQueryCreateFromData;        external ole32 name 'OleQueryCreateFromData';
function OleCreate;                     external ole32 name 'OleCreate';
function OleCreateEx;                   external ole32 name 'OleCreateEx';
function OleCreateFromDataEx;           external ole32 name 'OleCreateFromDataEx';
function OleCreateFromData;             external ole32 name 'OleCreateFromData';
function OleCreateLinkFromData;         external ole32 name 'OleCreateLinkFromData';
function OleCreateLinkFromDataEx;       external ole32 name 'OleCreateLinkFromDataEx';
function OleCreateStaticFromData;       external ole32 name 'OleCreateStaticFromData';
function OleCreateLink;                 external ole32 name 'OleCreateLink';
function OleCreateLinkEx;               external ole32 name 'OleCreateLinkEx';
function OleCreateLinkToFile;           external ole32 name 'OleCreateLinkToFile';
function OleCreateLinkToFileEx;         external ole32 name 'OleCreateLinkToFileEx';
function OleCreateFromFile;             external ole32 name 'OleCreateFromFile';
function OleCreateFromFileEx;           external ole32 name 'OleCreateFromFileEx';
function OleLoad;                       external ole32 name 'OleLoad';
function OleSave;                       external ole32 name 'OleSave';
function OleLoadFromStream;             external ole32 name 'OleLoadFromStream';
function OleSaveToStream;               external ole32 name 'OleSaveToStream';
function OleSetContainedObject;         external ole32 name 'OleSetContainedObject';
function OleNoteObjectVisible;          external ole32 name 'OleNoteObjectVisible';
function RegisterDragDrop;              external ole32 name 'RegisterDragDrop';
function RevokeDragDrop;                external ole32 name 'RevokeDragDrop';
function DoDragDrop;                    external ole32 name 'DoDragDrop';
function OleSetClipboard;               external ole32 name 'OleSetClipboard';
function OleGetClipboard;               external ole32 name 'OleGetClipboard';
function OleFlushClipboard;             external ole32 name 'OleFlushClipboard';
function OleIsCurrentClipboard;         external ole32 name 'OleIsCurrentClipboard';
function OleCreateMenuDescriptor;       external ole32 name 'OleCreateMenuDescriptor';
function OleSetMenuDescriptor;          external ole32 name 'OleSetMenuDescriptor';
function OleDestroyMenuDescriptor;      external ole32 name 'OleDestroyMenuDescriptor';
function OleTranslateAccelerator;       external ole32 name 'OleTranslateAccelerator';
function OleDuplicateData;              external ole32 name 'OleDuplicateData';
function OleDraw;                       external ole32 name 'OleDraw';
function OleRun;                        external ole32 name 'OleRun';
function OleIsRunning;                  external ole32 name 'OleIsRunning';
function OleLockRunning;                external ole32 name 'OleLockRunning';
procedure ReleaseStgMedium;             external ole32 name 'ReleaseStgMedium';
function CreateOleAdviseHolder;         external ole32 name 'CreateOleAdviseHolder';
function OleCreateDefaultHandler;       external ole32 name 'OleCreateDefaultHandler';
function OleCreateEmbeddingHelper;      external ole32 name 'OleCreateEmbeddingHelper';
function IsAccelerator;                 external ole32 name 'IsAccelerator';
function OleGetIconOfFile;              external ole32 name 'OleGetIconOfFile';
function OleGetIconOfClass;             external ole32 name 'OleGetIconOfClass';
function OleMetafilePictFromIconAndLabel; external ole32 name 'OleMetafilePictFromIconAndLabel';
function OleRegGetUserType;             external ole32 name 'OleRegGetUserType';
function OleRegGetMiscStatus;           external ole32 name 'OleRegGetMiscStatus';
function OleRegEnumFormatEtc;           external ole32 name 'OleRegEnumFormatEtc';
function OleRegEnumVerbs;               external ole32 name 'OleRegEnumVerbs';
function OleConvertIStorageToOLESTREAM; external ole32 name 'OleConvertIStorageToOLESTREAM';
function OleConvertOLESTREAMToIStorage; external ole32 name 'OleConvertOLESTREAMToIStorage';
function OleConvertIStorageToOLESTREAMEx; external ole32 name 'OleConvertIStorageToOLESTREAMEx';
function OleConvertOLESTREAMToIStorageEx; external ole32 name 'OleConvertOLESTREAMToIStorageEx';
function GetHGlobalFromILockBytes;      external ole32 name 'GetHGlobalFromILockBytes';
function CreateILockBytesOnHGlobal;     external ole32 name 'CreateILockBytesOnHGlobal';
function GetHGlobalFromStream;          external ole32 name 'GetHGlobalFromStream';
function CreateStreamOnHGlobal;         external ole32 name 'CreateStreamOnHGlobal';
function OleDoAutoConvert;              external ole32 name 'OleDoAutoConvert';
function OleGetAutoConvert;             external ole32 name 'OleGetAutoConvert';
function OleSetAutoConvert;             external ole32 name 'OleSetAutoConvert';
function GetConvertStg;                 external ole32 name 'GetConvertStg';
function SetConvertStg;                 external ole32 name 'SetConvertStg';

{ Externals from oleaut32.dll }

function SysAllocString;                external oleaut32 name 'SysAllocString';
function SysReAllocString;              external oleaut32 name 'SysReAllocString';
function SysAllocStringLen;             external oleaut32 name 'SysAllocStringLen';
function SysReAllocStringLen;           external oleaut32 name 'SysReAllocStringLen';
procedure SysFreeString;                external oleaut32 name 'SysFreeString';
function SysStringLen;                  external oleaut32 name 'SysStringLen';
function SysStringByteLen;              external oleaut32 name 'SysStringByteLen';
function SysAllocStringByteLen;         external oleaut32 name 'SysAllocStringByteLen';
function DosDateTimeToVariantTime;      external oleaut32 name 'DosDateTimeToVariantTime';
function VariantTimeToDosDateTime;      external oleaut32 name 'VariantTimeToDosDateTime';
function SystemTimeToVariantTime;       external oleaut32 name 'SystemTimeToVariantTime';
function VariantTimeToSystemTime;       external oleaut32 name 'VariantTimeToSystemTime';
function SafeArrayAllocDescriptor;      external oleaut32 name 'SafeArrayAllocDescriptor';
function SafeArrayAllocData;            external oleaut32 name 'SafeArrayAllocData';
function SafeArrayCreate;               external oleaut32 name 'SafeArrayCreate';
function SafeArrayCreateVector;         external oleaut32 name 'SafeArrayCreateVector';
function SafeArrayCopyData;             external oleaut32 name 'SafeArrayCopyData';
function SafeArrayDestroyDescriptor;    external oleaut32 name 'SafeArrayDestroyDescriptor';
function SafeArrayDestroyData;          external oleaut32 name 'SafeArrayDestroyData';
function SafeArrayDestroy;              external oleaut32 name 'SafeArrayDestroy';
function SafeArrayRedim;                external oleaut32 name 'SafeArrayRedim';
function SafeArrayGetDim;               external oleaut32 name 'SafeArrayGetDim';
function SafeArrayGetElemsize;          external oleaut32 name 'SafeArrayGetElemsize';
function SafeArrayGetUBound;            external oleaut32 name 'SafeArrayGetUBound';
function SafeArrayGetLBound;            external oleaut32 name 'SafeArrayGetLBound';
function SafeArrayLock;                 external oleaut32 name 'SafeArrayLock';
function SafeArrayUnlock;               external oleaut32 name 'SafeArrayUnlock';
function SafeArrayAccessData;           external oleaut32 name 'SafeArrayAccessData';
function SafeArrayUnaccessData;         external oleaut32 name 'SafeArrayUnaccessData';
function SafeArrayGetElement;           external oleaut32 name 'SafeArrayGetElement';
function SafeArrayPutElement;           external oleaut32 name 'SafeArrayPutElement';
function SafeArrayCopy;                 external oleaut32 name 'SafeArrayCopy';
function SafeArrayPtrOfIndex;           external oleaut32 name 'SafeArrayPtrOfIndex';
procedure VariantInit;                  external oleaut32 name 'VariantInit';
function VariantClear;                  external oleaut32 name 'VariantClear';
function VariantCopy;                   external oleaut32 name 'VariantCopy';
function VariantCopyInd;                external oleaut32 name 'VariantCopyInd';
function VariantChangeType;             external oleaut32 name 'VariantChangeType';
function VariantChangeTypeEx;           external oleaut32 name 'VariantChangeTypeEx';
function VectorFromBstr;                external oleaut32 name 'VectorFromBstr';
function BstrFromVector;                external oleaut32 name 'BstrFromVector';
function VarUI1FromI2;                  external oleaut32 name 'VarUI1FromI2';
function VarUI1FromI4;                  external oleaut32 name 'VarUI1FromI4';
function VarUI1FromR4;                  external oleaut32 name 'VarUI1FromR4';
function VarUI1FromR8;                  external oleaut32 name 'VarUI1FromR8';
function VarUI1FromCy;                  external oleaut32 name 'VarUI1FromCy';
function VarUI1FromDate;                external oleaut32 name 'VarUI1FromDate';
function VarUI1FromStr;                 external oleaut32 name 'VarUI1FromStr';
function VarUI1FromDisp;                external oleaut32 name 'VarUI1FromDisp';
function VarUI1FromBool;                external oleaut32 name 'VarUI1FromBool';
function VarUI1FromI1;                  external oleaut32 name 'VarUI1FromI1';
function VarUI1FromUI2;                 external oleaut32 name 'VarUI1FromUI2';
function VarUI1FromUI4;                 external oleaut32 name 'VarUI1FromUI4';
function VarUI1FromDec;                 external oleaut32 name 'VarUI1FromDec';
function VarI2FromUI1;                  external oleaut32 name 'VarI2FromUI1';
function VarI2FromI4;                   external oleaut32 name 'VarI2FromI4';
function VarI2FromR4;                   external oleaut32 name 'VarI2FromR4';
function VarI2FromR8;                   external oleaut32 name 'VarI2FromR8';
function VarI2FromCy;                   external oleaut32 name 'VarI2FromCy';
function VarI2FromDate;                 external oleaut32 name 'VarI2FromDate';
function VarI2FromStr;                  external oleaut32 name 'VarI2FromStr';
function VarI2FromDisp;                 external oleaut32 name 'VarI2FromDisp';
function VarI2FromBool;                 external oleaut32 name 'VarI2FromBool';
function VarI2FromI1;                   external oleaut32 name 'VarI2FromI1';
function VarI2FromUI2;                  external oleaut32 name 'VarI2FromUI2';
function VarI2FromUI4;                  external oleaut32 name 'VarI2FromUI4';
function VarI2FromDec;                  external oleaut32 name 'VarI2FromDec';
function VarI4FromUI1;                  external oleaut32 name 'VarI4FromUI1';
function VarI4FromI2;                   external oleaut32 name 'VarI4FromI2';
function VarI4FromR4;                   external oleaut32 name 'VarI4FromR4';
function VarI4FromR8;                   external oleaut32 name 'VarI4FromR8';
function VarI4FromCy;                   external oleaut32 name 'VarI4FromCy';
function VarI4FromDate;                 external oleaut32 name 'VarI4FromDate';
function VarI4FromStr;                  external oleaut32 name 'VarI4FromStr';
function VarI4FromDisp;                 external oleaut32 name 'VarI4FromDisp';
function VarI4FromBool;                 external oleaut32 name 'VarI4FromBool';
function VarI4FromI1;                   external oleaut32 name 'VarI4FromI1';
function VarI4FromUI2;                  external oleaut32 name 'VarI4FromUI2';
function VarI4FromUI4;                  external oleaut32 name 'VarI4FromUI4';
function VarI4FromDec;                  external oleaut32 name 'VarI4FromDec';
function VarI4FromInt;                  external oleaut32 name 'VarI4FromInt';
function VarR4FromUI1;                  external oleaut32 name 'VarR4FromUI1';
function VarR4FromI2;                   external oleaut32 name 'VarR4FromI2';
function VarR4FromI4;                   external oleaut32 name 'VarR4FromI4';
function VarR4FromR8;                   external oleaut32 name 'VarR4FromR8';
function VarR4FromCy;                   external oleaut32 name 'VarR4FromCy';
function VarR4FromDate;                 external oleaut32 name 'VarR4FromDate';
function VarR4FromStr;                  external oleaut32 name 'VarR4FromStr';
function VarR4FromDisp;                 external oleaut32 name 'VarR4FromDisp';
function VarR4FromBool;                 external oleaut32 name 'VarR4FromBool';
function VarR4FromI1;                   external oleaut32 name 'VarR4FromI1';
function VarR4FromUI2;                  external oleaut32 name 'VarR4FromUI2';
function VarR4FromUI4;                  external oleaut32 name 'VarR4FromUI4';
function VarR4FromDec;                  external oleaut32 name 'VarR4FromDec';
function VarR8FromUI1;                  external oleaut32 name 'VarR8FromUI1';
function VarR8FromI2;                   external oleaut32 name 'VarR8FromI2';
function VarR8FromI4;                   external oleaut32 name 'VarR8FromI4';
function VarR8FromR4;                   external oleaut32 name 'VarR8FromR4';
function VarR8FromCy;                   external oleaut32 name 'VarR8FromCy';
function VarR8FromDate;                 external oleaut32 name 'VarR8FromDate';
function VarR8FromStr;                  external oleaut32 name 'VarR8FromStr';
function VarR8FromDisp;                 external oleaut32 name 'VarR8FromDisp';
function VarR8FromBool;                 external oleaut32 name 'VarR8FromBool';
function VarR8FromI1;                   external oleaut32 name 'VarR8FromI1';
function VarR8FromUI2;                  external oleaut32 name 'VarR8FromUI2';
function VarR8FromUI4;                  external oleaut32 name 'VarR8FromUI4';
function VarR8FromDec;                  external oleaut32 name 'VarR8FromDec';
function VarDateFromUI1;                external oleaut32 name 'VarDateFromUI1';
function VarDateFromI2;                 external oleaut32 name 'VarDateFromI2';
function VarDateFromI4;                 external oleaut32 name 'VarDateFromI4';
function VarDateFromR4;                 external oleaut32 name 'VarDateFromR4';
function VarDateFromR8;                 external oleaut32 name 'VarDateFromR8';
function VarDateFromCy;                 external oleaut32 name 'VarDateFromCy';
function VarDateFromStr;                external oleaut32 name 'VarDateFromStr';
function VarDateFromDisp;               external oleaut32 name 'VarDateFromDisp';
function VarDateFromBool;               external oleaut32 name 'VarDateFromBool';
function VarDateFromI1;                 external oleaut32 name 'VarDateFromI1';
function VarDateFromUI2;                external oleaut32 name 'VarDateFromUI2';
function VarDateFromUI4;                external oleaut32 name 'VarDateFromUI4';
function VarDateFromDec;                external oleaut32 name 'VarDateFromDec';
function VarCyFromUI1;                  external oleaut32 name 'VarCyFromUI1';
function VarCyFromI2;                   external oleaut32 name 'VarCyFromI2';
function VarCyFromI4;                   external oleaut32 name 'VarCyFromI4';
function VarCyFromR4;                   external oleaut32 name 'VarCyFromR4';
function VarCyFromR8;                   external oleaut32 name 'VarCyFromR8';
function VarCyFromDate;                 external oleaut32 name 'VarCyFromDate';
function VarCyFromStr;                  external oleaut32 name 'VarCyFromStr';
function VarCyFromDisp;                 external oleaut32 name 'VarCyFromDisp';
function VarCyFromBool;                 external oleaut32 name 'VarCyFromBool';
function VarCyFromI1;                   external oleaut32 name 'VarCyFromI1';
function VarCyFromUI2;                  external oleaut32 name 'VarCyFromUI2';
function VarCyFromUI4;                  external oleaut32 name 'VarCyFromUI4';
function VarCyFromDec;                  external oleaut32 name 'VarCyFromDec';
function VarBStrFromUI1;                external oleaut32 name 'VarBStrFromUI1';
function VarBStrFromI2;                 external oleaut32 name 'VarBStrFromI2';
function VarBStrFromI4;                 external oleaut32 name 'VarBStrFromI4';
function VarBStrFromR4;                 external oleaut32 name 'VarBStrFromR4';
function VarBStrFromR8;                 external oleaut32 name 'VarBStrFromR8';
function VarBStrFromCy;                 external oleaut32 name 'VarBStrFromCy';
function VarBStrFromDate;               external oleaut32 name 'VarBStrFromDate';
function VarBStrFromDisp;               external oleaut32 name 'VarBStrFromDisp';
function VarBStrFromBool;               external oleaut32 name 'VarBStrFromBool';
function VarBstrFromI1;                 external oleaut32 name 'VarBstrFromI1';
function VarBstrFromUI2;                external oleaut32 name 'VarBstrFromUI2';
function VarBstrFromUI4;                external oleaut32 name 'VarBstrFromUI4';
function VarBstrFromDec;                external oleaut32 name 'VarBstrFromDec';
function VarBoolFromUI1;                external oleaut32 name 'VarBoolFromUI1';
function VarBoolFromI2;                 external oleaut32 name 'VarBoolFromI2';
function VarBoolFromI4;                 external oleaut32 name 'VarBoolFromI4';
function VarBoolFromR4;                 external oleaut32 name 'VarBoolFromR4';
function VarBoolFromR8;                 external oleaut32 name 'VarBoolFromR8';
function VarBoolFromDate;               external oleaut32 name 'VarBoolFromDate';
function VarBoolFromCy;                 external oleaut32 name 'VarBoolFromCy';
function VarBoolFromStr;                external oleaut32 name 'VarBoolFromStr';
function VarBoolFromDisp;               external oleaut32 name 'VarBoolFromDisp';
function VarBoolFromI1;                 external oleaut32 name 'VarBoolFromI1';
function VarBoolFromUI2;                external oleaut32 name 'VarBoolFromUI2';
function VarBoolFromUI4;                external oleaut32 name 'VarBoolFromUI4';
function VarBoolFromDec;                external oleaut32 name 'VarBoolFromDec';
function LHashValOfNameSys;             external oleaut32 name 'LHashValOfNameSys';
function LHashValOfNameSysA;            external oleaut32 name 'LHashValOfNameSysA';
function LoadTypeLib;                   external oleaut32 name 'LoadTypeLib';
function LoadTypeLibEx;                 external oleaut32 name 'LoadTypeLibEx';
function LoadRegTypeLib;                external oleaut32 name 'LoadRegTypeLib';
function QueryPathOfRegTypeLib;         external oleaut32 name 'QueryPathOfRegTypeLib';
function RegisterTypeLib;               external oleaut32 name 'RegisterTypeLib';
function UnRegisterTypeLib;             external oleaut32 name 'UnRegisterTypeLib';
function CreateTypeLib;                 external oleaut32 name 'CreateTypeLib';
function CreateTypeLib2;                external oleaut32 name 'CreateTypeLib2';
function DispGetParam;                  external oleaut32 name 'DispGetParam';
function DispGetIDsOfNames;             external oleaut32 name 'DispGetIDsOfNames';
function DispInvoke;                    external oleaut32 name 'DispInvoke';
function CreateDispTypeInfo;            external oleaut32 name 'CreateDispTypeInfo';
function CreateStdDispatch;             external oleaut32 name 'CreateStdDispatch';
function DispCallFunc;                  external oleaut32 name 'DispCallFunc';
function RegisterActiveObject;          external oleaut32 name 'RegisterActiveObject';
function RevokeActiveObject;            external oleaut32 name 'RevokeActiveObject';
function GetActiveObject;               external oleaut32 name 'GetActiveObject';
function SetErrorInfo;                  external oleaut32 name 'SetErrorInfo';
function GetErrorInfo;                  external oleaut32 name 'GetErrorInfo';
function CreateErrorInfo;               external oleaut32 name 'CreateErrorInfo';
function OaBuildVersion;                external oleaut32 name 'OaBuildVersion';
procedure ClearCustData;                external oleaut32 name 'ClearCustData';

{ Externals from olepro32.dll }

function OleCreatePropertyFrame;        external olepro32 name 'OleCreatePropertyFrame';
function OleCreatePropertyFrameIndirect; external olepro32 name 'OleCreatePropertyFrameIndirect';
function OleTranslateColor;             external olepro32 name 'OleTranslateColor';
function OleCreateFontIndirect;         external olepro32 name 'OleCreateFontIndirect';
function OleCreatePictureIndirect;      external olepro32 name 'OleCreatePictureIndirect';
function OleLoadPicture;                external olepro32 name 'OleLoadPicture';
function OleLoadPicturePath;            external olepro32 name 'OleLoadPicturePath';
function OleLoadPictureFile;            external olepro32 name 'OleLoadPictureFile';
function OleSavePictureFile;            external olepro32 name 'OleSavePictureFile';
function OleIconToCursor;               external olepro32 name 'OleIconToCursor';

{ Helper functions }

function Succeeded(Res: HResult): Boolean;
begin
  Result := Res and $80000000 = 0;
end;

function Failed(Res: HResult): Boolean;
begin
  Result := Res and $80000000 <> 0;
end;

function ResultCode(Res: HResult): Integer;
begin
  Result := Res and $0000FFFF;
end;

function ResultFacility(Res: HResult): Integer;
begin
  Result := (Res shr 16) and $00001FFF;
end;

function ResultSeverity(Res: HResult): Integer;
begin
  Result := Res shr 31;
end;

function MakeResult(Severity, Facility, Code: Integer): HResult;
begin
  Result := (Severity shl 31) or (Facility shl 16) or Code;
end;

function LHashValOfName(lcid: TLCID; szName: POleStr): Longint;
begin
  Result := LHashValOfNameSys(SYS_WIN32, lcid, szName);
end;

function WHashValOfLHashVal(lhashval: Longint): Word;
begin
  Result := lhashval and $0000FFFF;
end;

function IsHashValCompatible(lhashval1, lhashval2: Longint): Boolean;
begin
  Result := lhashval1 and $00FF0000 = lhashval2 and $00FF0000;
end;

function PROPSETHDR_OSVER_KIND(dwOSVer: DWORD): Word;
begin
  Result := HiWord(dwOSVer);
end;

function PROPSETHDR_OSVER_MAJOR(dwOSVer: DWORD): Byte;
begin
  Result := LoByte(dwOSVer);
end;

function PROPSETHDR_OSVER_MINOR(dwOSVer: DWORD): Byte;
begin
  Result := HiByte(LoWord(dwOSVer));
end;

end.
