unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, ExtCtrls, ComCtrls, Menus, ActiveX, StdCtrls, Buttons, isp3;

type
  TChatForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    FileConnectItem: TMenuItem;
    FileListenItem: TMenuItem;
    StatusBar1: TStatusBar;
    Bevel1: TBevel;
    Panel1: TPanel;
    TCP1: TTCP;
    Memo1: TMemo;
    TCP2: TTCP;
    Memo2: TMemo;
    N1: TMenuItem;
    SpeedButton1: TSpeedButton;
    Disconnect1: TMenuItem;
    procedure FileListenItemClick(Sender: TObject);
    procedure TCP1ConnectionRequest(Sender: TObject; requestID: Integer);
    procedure FileConnectItemClick(Sender: TObject);
    procedure TCP1DataArrival(Sender: TObject; bytesTotal: Integer);
    procedure Exit1Click(Sender: TObject);
    procedure TCP1Close(Sender: TObject);
    procedure Memo1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure TCP2Connect(Sender: TObject);
    procedure TCP1Error(Sender: TObject; Number: Smallint;
      var Description: string; Scode: Integer; const Source,
      HelpFile: string; HelpContext: Integer; var CancelDisplay: Wordbool);
    procedure Disconnect1Click(Sender: TObject);
    procedure TCP2Close(Sender: TObject);
  end;

var
  ChatForm: TChatForm;
  Server: String;
  N: Integer;

implementation

{$R *.DFM}

procedure TChatForm.FileListenItemClick(Sender: TObject);
begin
  FileListenItem.Checked := not FileListenItem.Checked;
  if FileListenItem.Checked then
  begin
    TCP2.Close;
    TCP1.Listen;
    Statusbar1.Panels[0].Text := 'Listening...'
  end
  else
  begin
    if TCP1.State <> sckClosed then
      TCP1.Close;
    Statusbar1.Panels[0].Text := '';
  end;
end;

procedure TChatForm.TCP1ConnectionRequest(Sender: TObject;
  requestID: Integer);
begin
  FileListenItemClick(nil);
  TCP2.Accept(requestID);
  Statusbar1.Panels[0].Text := 'Connected to: ' + TCP1.RemoteHostIP;
end;

procedure TChatForm.FileConnectItemClick(Sender: TObject);
begin
  if TCP2.State <> sckClosed then TCP2.Close;
  if InputQuery('Computer to connect to', 'IP Address :', Server) then
    if Length(Server) > 0 then
      TCP2.Connect(Server, 1024);
end;

procedure TChatForm.TCP1DataArrival(Sender: TObject; bytesTotal: Integer);
var
  Data: OleVariant;
begin
  TCP2.GetData(Data, VT_BSTR, bytesTotal);
  Memo2.Lines.Add(Data);
end;

procedure TChatForm.Exit1Click(Sender: TObject);
begin
  TCP1.Close;
  TCP2.Close;
  Close;
end;

procedure TChatForm.TCP1Close(Sender: TObject);
begin
  ShowMessage('TCP1.Close');
  Statusbar1.Panels[0].Text := 'Disconnected';
end;

procedure TChatForm.Memo1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_Return then
    TCP2.SendData(Memo1.Lines[Memo1.Lines.Count - 1]);
end;

procedure TChatForm.FormCreate(Sender: TObject);
begin
  FileListenItemClick(nil);
end;

procedure TChatForm.TCP2Connect(Sender: TObject);
begin
  if TCP1.State = sckListening then
    FileListenItemClick(nil);
  Statusbar1.Panels[0].Text := 'Connected to: ' + Server;
end;

procedure TChatForm.TCP1Error(Sender: TObject; Number: Smallint;
  var Description: string; Scode: Integer; const Source, HelpFile: string;
  HelpContext: Integer; var CancelDisplay: Wordbool);
begin
  ShowMessage(Description);
end;

procedure TChatForm.Disconnect1Click(Sender: TObject);
begin
  TCP2.Close;
  FileListenItemClick(nil);
end;

procedure TChatForm.TCP2Close(Sender: TObject);
begin
  TCP1.Close;
  FileListenItemClick(nil);
end;

end.
