/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;

public abstract class Signature {
    private static boolean debug;
    private String algorithm;
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;

    protected Signature(String string) {
        this.algorithm = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return (Signature)Security.getImpl(string, "Signature", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError("please send a bug report to java-security@java.sun.com");
        }
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return (Signature)Security.getImpl(string, "Signature", string2);
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
        this.state = 3;
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey);
        this.state = 2;
    }

    public final byte[] sign() throws SignatureException {
        if (this.state == 2) {
            return this.engineSign();
        }
        throw new SignatureException("object not initialized for signing.");
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        if (this.state == 3) {
            return this.engineVerify(byArray);
        }
        throw new SignatureException("object not initialized for verification.");
    }

    public final void update(byte by) throws SignatureException {
        if (this.state == 3 || this.state == 2) {
            this.engineUpdate(by);
            return;
        }
        throw new SignatureException("object not initialized for signature or verification.");
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state == 2 || this.state == 3) {
            this.engineUpdate(byArray, n, n2);
            return;
        }
        throw new SignatureException("object not initialized for signature or verification.");
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        String string = "";
        switch (this.state) {
            case 0: {
                string = "<not initialized>";
                break;
            }
            case 3: {
                string = "<initialized for verifying>";
                break;
            }
            case 2: {
                string = "<initialized for signing>";
                break;
            }
        }
        return "Signature object: " + this.getAlgorithm() + string;
    }

    public final void setParameter(String string, Object object) throws InvalidParameterException {
        this.engineSetParameter(string, object);
    }

    public final Object getParameter(String string) throws InvalidParameterException {
        return this.engineGetParameter(string);
    }

    protected abstract void engineInitVerify(PublicKey var1) throws InvalidKeyException;

    protected abstract void engineInitSign(PrivateKey var1) throws InvalidKeyException;

    protected abstract void engineUpdate(byte var1) throws SignatureException;

    protected abstract void engineUpdate(byte[] var1, int var2, int var3) throws SignatureException;

    protected abstract byte[] engineSign() throws SignatureException;

    protected abstract boolean engineVerify(byte[] var1) throws SignatureException;

    protected abstract void engineSetParameter(String var1, Object var2) throws InvalidParameterException;

    protected abstract Object engineGetParameter(String var1) throws InvalidParameterException;

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    private static void debug(Exception exception) {
        if (debug) {
            exception.printStackTrace();
        }
    }
}

