/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;

public class MulticastSocket
extends DatagramSocket {
    public MulticastSocket() throws IOException {
    }

    public MulticastSocket(int n) throws IOException {
        super(n);
    }

    void create(int n, InetAddress inetAddress) throws SocketException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        try {
            this.impl = (DatagramSocketImpl)DatagramSocket.implClass.newInstance();
        }
        catch (Exception exception) {
            throw new SocketException("can't instantiate DatagramSocketImpl" + exception.toString());
        }
        this.impl.create();
        this.impl.setOption(4, new Integer(-1));
        this.impl.bind(n, InetAddress.anyLocalAddress);
    }

    public void setTTL(byte by) throws IOException {
        this.impl.setTTL(by);
    }

    public byte getTTL() throws IOException {
        return this.impl.getTTL();
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        this.impl.join(inetAddress);
    }

    public void leaveGroup(InetAddress inetAddress) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        this.impl.leave(inetAddress);
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        this.impl.setOption(16, inetAddress);
    }

    public InetAddress getInterface() throws SocketException {
        return (InetAddress)this.impl.getOption(16);
    }

    public synchronized void send(DatagramPacket datagramPacket, byte by) throws IOException {
        byte by2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (datagramPacket.getAddress().isMulticastAddress()) {
                securityManager.checkMulticast(datagramPacket.getAddress(), by);
            } else {
                securityManager.checkConnect(datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
            }
        }
        if (by != (by2 = this.getTTL())) {
            this.impl.setTTL(by);
        }
        this.impl.send(datagramPacket);
        if (by != by2) {
            this.impl.setTTL(by2);
        }
    }
}

