/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.ipp;

import com.visigenic.vbroker.util.ipp.IppException;
import com.visigenic.vbroker.util.ipp.Token;

public class Literal
extends Token {
    private String _ext_value;
    private Object _value;

    Literal(int n) {
        super(n);
    }

    void initLiteral(Literal literal) {
        this.initToken(literal);
        this._value = literal._value;
        this._ext_value = literal._ext_value;
    }

    void initLong(Token token2, long l) {
        this.initToken(token2);
        this._value = new Long(l);
    }

    Literal(char c, String string, int n) {
        super(54, n);
        this._value = new Character(c);
        this._ext_value = string;
    }

    Literal(long l, String string, int n) {
        super(55, n);
        this._value = new Long(l);
        this._ext_value = string;
    }

    Literal(String string, int n, int n2) {
        super(56, n);
        this._value = string;
        this._ext_value = string;
    }

    Literal(String string, int n) {
        super(57, n);
        this._value = string;
        this._ext_value = "\"" + string + "\"";
    }

    Object value() {
        return this._value;
    }

    String ext_value() {
        return this._ext_value;
    }

    long longValue() throws IppException {
        if (this._value instanceof Long) {
            return ((Long)this._value).intValue();
        }
        throw new IppException("** internal error - expected an integer value", this);
    }

    char charValue() throws IppException {
        if (this._value instanceof Character) {
            return ((Character)this._value).charValue();
        }
        throw new IppException("** internal error - expected a character value", this);
    }

    static long hexToLong(char c) throws IppException {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
        }
        throw new IppException("** internal error - bad hexacecimal digit: " + c, null);
    }
}

