/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.be.idl;

import com.visigenic.vbroker.ir.AliasDef;
import com.visigenic.vbroker.ir.AttributeDef;
import com.visigenic.vbroker.ir.ConstantDef;
import com.visigenic.vbroker.ir.Contained;
import com.visigenic.vbroker.ir.Container;
import com.visigenic.vbroker.ir.EnumDef;
import com.visigenic.vbroker.ir.EstructDef;
import com.visigenic.vbroker.ir.ExceptionDef;
import com.visigenic.vbroker.ir.InterfaceDef;
import com.visigenic.vbroker.ir.ModuleDef;
import com.visigenic.vbroker.ir.OperationDef;
import com.visigenic.vbroker.ir.Repository;
import com.visigenic.vbroker.ir.RepositoryHelper;
import com.visigenic.vbroker.ir.StructDef;
import com.visigenic.vbroker.ir.UnionDef;
import com.visigenic.vbroker.ir._VisitorImplBase;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Dictionary;
import java.util.Hashtable;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.ArrayDefHelper;
import org.omg.CORBA.AttributeMode;
import org.omg.CORBA.BOA;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.OperationMode;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.SequenceDefHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;

public class IdlTraverser
extends _VisitorImplBase {
    private PrintStream _out;
    private int _indent;
    private Dictionary _visited = new Hashtable();
    private boolean _dependencyCheck = true;

    public IdlTraverser(PrintStream printStream, int n) {
        this(printStream);
        this._indent = n;
    }

    public IdlTraverser(PrintStream printStream) {
        this();
        this._out = printStream;
    }

    public IdlTraverser() {
        this._visited.put("Object", "Object");
        this._visited.put("CORBA::Object", "CORBA::Object");
        this._visited.put("::CORBA::Object", "::CORBA::Object");
        this._visited.put("Principal", "Principal");
        this._visited.put("CORBA::Principal", "CORBA::Principal");
        this._visited.put("::CORBA::Principal", "::CORBA::Principal");
        this._visited.put("TypeCode", "TypeCode");
        this._visited.put("CORBA::TypeCode", "CORBA::TypeCode");
        this._visited.put("::CORBA::TypeCode", "::CORBA::TypeCode");
    }

    public void dependencyCheck(boolean bl) {
        this._dependencyCheck = bl;
    }

    public void visited(String string, boolean bl) {
        if (bl) {
            this._visited.put(string, string);
            return;
        }
        this._visited.put(string, "soft");
    }

    public boolean checkDependency(Contained[] containedArray, String string) {
        int n = 0;
        while (n < containedArray.length) {
            if (this._visited.get(containedArray[n].absolute_name()) == null && !containedArray[n].absolute_name().equals(string)) {
                int n2 = containedArray[n].absolute_name().lastIndexOf("::");
                String string2 = "";
                if (n2 != -1) {
                    string2 = containedArray[n].absolute_name().substring(0, n2);
                }
                if (!string2.startsWith(string)) {
                    return this._dependencyCheck;
                }
            }
            ++n;
        }
        return false;
    }

    public boolean checkHardDependency(Contained[] containedArray, String string) {
        int n = 0;
        while (n < containedArray.length) {
            String string2 = (String)this._visited.get(containedArray[n].absolute_name());
            if (!(string2 != null && string2.equals(containedArray[n].absolute_name()) || containedArray[n].absolute_name().equals(string))) {
                int n2 = containedArray[n].absolute_name().lastIndexOf("::");
                String string3 = "";
                if (n2 != -1) {
                    string3 = containedArray[n].absolute_name().substring(0, n2);
                }
                if (!string3.startsWith(string)) {
                    return this._dependencyCheck;
                }
            }
            ++n;
        }
        return false;
    }

    public boolean isVisited(String string) {
        String string2 = (String)this._visited.get(string);
        return string2 != null && string2.equals(string);
    }

    public boolean isSoftVisited(String string) {
        String string2 = (String)this._visited.get(string);
        return string2 != null && string2.equals("soft");
    }

    private String comma(int n, Object[] objectArray) {
        if (n == objectArray.length - 1) {
            return "";
        }
        return ",";
    }

    private void println(Object object) {
        int n = 0;
        while (n < this._indent) {
            this._out.print("  ");
            ++n;
        }
        this._out.println(object);
    }

    private String toIdl(IDLType iDLType, String string) {
        String string2;
        switch (iDLType.def_kind().value()) {
            case 15: {
                SequenceDef sequenceDef = SequenceDefHelper.narrow(iDLType);
                int n = sequenceDef.bound();
                String string3 = n == 0 ? "" : "," + n;
                string2 = "sequence<" + this.toIdl(sequenceDef.element_type_def(), null) + string3 + ">";
                break;
            }
            case 16: {
                ArrayDef arrayDef = ArrayDefHelper.narrow(iDLType);
                string2 = this.toIdl(arrayDef.element_type_def(), String.valueOf(string) + "[" + arrayDef.length() + "]");
                string = null;
                break;
            }
            default: {
                org.omg.CORBA.Contained contained = ContainedHelper.narrow(iDLType);
                string2 = contained == null ? iDLType.type().toString() : contained.absolute_name();
            }
        }
        if (string == null) {
            return string2;
        }
        return String.valueOf(string2) + " " + string;
    }

    private String toExpandedIdl(Contained contained, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IdlTraverser idlTraverser = new IdlTraverser(new PrintStream(byteArrayOutputStream), this._indent);
        this._indent = 0;
        this._boa().obj_is_ready(idlTraverser);
        contained.visit(idlTraverser);
        this._boa().deactivate_obj(idlTraverser);
        String string2 = new String(byteArrayOutputStream.toByteArray(), 0);
        string2 = string2.substring(0, string2.lastIndexOf(59));
        if (string == null) {
            return string2;
        }
        return String.valueOf(string2) + " " + string;
    }

    public boolean visitConstant(ConstantDef constantDef) {
        this.println("const " + this.toIdl(constantDef.type_def(), constantDef.name()) + " = " + constantDef.value() + ";");
        this.visited(constantDef.absolute_name(), true);
        return true;
    }

    public boolean visitStruct(StructDef structDef) {
        this.println("struct " + structDef.name() + " {");
        this.visited(structDef.absolute_name(), true);
        ++this._indent;
        this.traverse(structDef);
        StructMember[] structMemberArray = structDef.members();
        int n = 0;
        while (n < structMemberArray.length) {
            this.println(String.valueOf(this.toIdl(structMemberArray[n].type_def, structMemberArray[n].name)) + ";");
            ++n;
        }
        --this._indent;
        this.println("};");
        return true;
    }

    public boolean visitEstruct(EstructDef estructDef) {
        if (estructDef.forward_declared()) {
            this.println("extensible struct " + estructDef.name() + ";");
            this.visited(estructDef.absolute_name(), false);
            return true;
        }
        if (!estructDef.canVisit(estructDef.absolute_name(), this)) {
            this.println("extensible struct " + estructDef.name() + ";");
            this.visited(estructDef.absolute_name(), false);
            return false;
        }
        String string = "";
        if (estructDef.base_def() != null) {
            string = " : " + estructDef.base_def().absolute_name();
        }
        this.println("extensible struct " + estructDef.name() + string + " {");
        this.visited(estructDef.absolute_name(), true);
        ++this._indent;
        this.traverse(estructDef);
        StructMember[] structMemberArray = estructDef.members();
        int n = 0;
        while (n < structMemberArray.length) {
            this.println(String.valueOf(this.toIdl(structMemberArray[n].type_def, structMemberArray[n].name)) + ";");
            ++n;
        }
        --this._indent;
        this.println("};");
        return true;
    }

    public boolean visitUnion(UnionDef unionDef) {
        try {
            this.println("union " + unionDef.name() + " switch(" + this.toIdl(unionDef.discriminator_type_def(), null) + ") {");
            this.visited(unionDef.absolute_name(), true);
            UnionMember[] unionMemberArray = unionDef.members();
            int n = unionDef.type().default_index();
            ++this._indent;
            int n2 = 0;
            while (n2 < unionMemberArray.length) {
                if (n2 == n) {
                    this.println("default:");
                } else {
                    this.println("case " + unionMemberArray[n2].label + ":");
                }
                if (n2 == unionMemberArray.length - 1 || !unionMemberArray[n2].name.equals(unionMemberArray[n2 + 1].name)) {
                    ++this._indent;
                    Contained contained = com.visigenic.vbroker.ir.ContainedHelper.narrow(unionMemberArray[n2].type_def);
                    if (contained != null && contained.defined_in() == unionDef) {
                        int n3 = this._indent;
                        this.println(String.valueOf(this.toExpandedIdl(contained, unionMemberArray[n2].name)) + ";");
                        this._indent = n3 - 1;
                    } else {
                        this.println(String.valueOf(this.toIdl(unionMemberArray[n2].type_def, unionMemberArray[n2].name)) + ";");
                        --this._indent;
                    }
                }
                ++n2;
            }
            --this._indent;
            this.println("};");
            return true;
        }
        catch (BadKind badKind) {
            throw new INTERNAL(badKind.toString());
        }
    }

    public boolean visitException(ExceptionDef exceptionDef) {
        this.println("exception " + exceptionDef.name() + " {");
        this.visited(exceptionDef.absolute_name(), true);
        ++this._indent;
        this.traverse(exceptionDef);
        StructMember[] structMemberArray = exceptionDef.members();
        int n = 0;
        while (n < structMemberArray.length) {
            this.println(String.valueOf(this.toIdl(structMemberArray[n].type_def, structMemberArray[n].name)) + ";");
            ++n;
        }
        --this._indent;
        this.println("};");
        return true;
    }

    public boolean visitEnum(EnumDef enumDef) {
        try {
            TypeCode typeCode = enumDef.type();
            this.println("enum " + typeCode.name() + " {");
            ++this._indent;
            int n = typeCode.member_count();
            int n2 = 0;
            while (n2 < n) {
                this.println(String.valueOf(typeCode.member_name(n2)) + (n2 == n - 1 ? "" : ","));
                ++n2;
            }
            --this._indent;
            this.println("};");
            this.visited(enumDef.absolute_name(), true);
            return true;
        }
        catch (UserException userException) {
            throw new INTERNAL(userException.toString());
        }
    }

    public boolean visitAlias(AliasDef aliasDef) {
        this.println("typedef " + this.toIdl(aliasDef.original_type_def(), aliasDef.name()) + ";");
        this.visited(aliasDef.absolute_name(), true);
        return true;
    }

    public boolean visitAttribute(AttributeDef attributeDef) {
        String string = attributeDef.mode() == AttributeMode.ATTR_READONLY ? "readonly " : "";
        this.println(String.valueOf(string) + "attribute " + this.toIdl(attributeDef.type_def(), attributeDef.name()) + ";");
        this.visited(attributeDef.absolute_name(), true);
        return true;
    }

    public boolean visitOperation(OperationDef operationDef) {
        String string = String.valueOf(operationDef.mode() == OperationMode.OP_ONEWAY ? "oneway " : "") + this.toIdl(operationDef.result_def(), operationDef.name()) + "(";
        Object[] objectArray = operationDef.params();
        Object[] objectArray2 = operationDef.exceptions();
        Object[] objectArray3 = operationDef.contexts();
        if (objectArray.length == 0 && objectArray2.length == 0 && objectArray3.length == 0) {
            this.println(String.valueOf(string) + ");");
        } else {
            this.println(string);
            ++this._indent;
            int n = 0;
            while (n < objectArray.length) {
                String[] stringArray = new String[]{"in", "out", "inout"};
                this.println(String.valueOf(stringArray[objectArray[n].mode.value()]) + " " + this.toIdl(objectArray[n].type_def, objectArray[n].name) + this.comma(n, objectArray));
                ++n;
            }
            --this._indent;
            if (objectArray2.length > 0) {
                this.println(")");
                this.println("raises(");
                ++this._indent;
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    this.println(String.valueOf(objectArray2[n2].absolute_name()) + this.comma(n2, objectArray2));
                    ++n2;
                }
                --this._indent;
            }
            if (objectArray3.length > 0) {
                this.println(")");
                this.println("context(");
                ++this._indent;
                int n3 = 0;
                while (n3 < objectArray3.length) {
                    this.println("\"" + objectArray3[n3] + "\"" + this.comma(n3, objectArray3));
                    ++n3;
                }
                --this._indent;
            }
            this.println(");");
        }
        this.visited(operationDef.absolute_name(), true);
        return true;
    }

    public boolean visitInterface(InterfaceDef interfaceDef) {
        if (interfaceDef.forward_declared()) {
            this.println("interface " + interfaceDef.name() + ";");
            this.visited(interfaceDef.absolute_name(), false);
            return true;
        }
        if (!interfaceDef.canVisit(interfaceDef.absolute_name(), this)) {
            this.println("interface " + interfaceDef.name() + ";");
            this.visited(interfaceDef.absolute_name(), false);
            return false;
        }
        Object[] objectArray = interfaceDef.base_interfaces();
        String string = "";
        if (objectArray.length > 0) {
            string = String.valueOf(string) + " :";
            int n = 0;
            while (n < objectArray.length) {
                string = String.valueOf(string) + " " + objectArray[n].absolute_name() + this.comma(n, objectArray);
                ++n;
            }
        }
        this.println("interface " + interfaceDef.name() + string + " {");
        this.visited(interfaceDef.absolute_name(), true);
        ++this._indent;
        this.traverse(interfaceDef);
        --this._indent;
        this.println("};");
        return true;
    }

    public boolean visitModule(ModuleDef moduleDef) {
        this.println("module " + moduleDef.name() + " {");
        ++this._indent;
        boolean bl = this.traverse(moduleDef);
        --this._indent;
        this.println("};");
        this.visited(moduleDef.absolute_name(), bl);
        return bl;
    }

    public boolean traverse(Container container) {
        return container.traverse(this);
    }

    public static void main(String[] stringArray) {
        try {
            ORB oRB = ORB.init();
            BOA bOA = oRB.BOA_init();
            IdlTraverser idlTraverser = new IdlTraverser(System.out);
            bOA.obj_is_ready(idlTraverser);
            Repository repository = RepositoryHelper.bind(oRB);
            idlTraverser.traverse(repository);
            return;
        }
        catch (SystemException systemException) {
            systemException.printStackTrace();
            return;
        }
    }
}

