/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.be.cpp;

import com.visigenic.vbroker.ir.AliasDef;
import com.visigenic.vbroker.ir.AttributeDef;
import com.visigenic.vbroker.ir.ConstantDef;
import com.visigenic.vbroker.ir.EnumDef;
import com.visigenic.vbroker.ir.EstructDef;
import com.visigenic.vbroker.ir.ExceptionDef;
import com.visigenic.vbroker.ir.InterfaceDef;
import com.visigenic.vbroker.ir.ModuleDef;
import com.visigenic.vbroker.ir.OperationDef;
import com.visigenic.vbroker.ir.StructDef;
import com.visigenic.vbroker.ir.UnionDef;
import com.visigenic.vbroker.util.be.cpp.CppBaseUtil;
import com.visigenic.vbroker.util.be.cpp.CppBaseUtilEnv;
import org.omg.CORBA.INTERNAL;

public class CppVisitor
extends CppBaseUtil {
    public boolean visitConstant(ConstantDef constantDef) {
        int n = this.selectMode();
        this.nameOf(constantDef);
        this.fullNameOf(constantDef);
        this._genCons.gen(constantDef, n, this.nameOf(constantDef), this.fullNameOf(constantDef));
        this.visited(constantDef.absolute_name(), true);
        return true;
    }

    public boolean visitEnum(EnumDef enumDef) {
        int n = this.selectMode();
        String string = this.nameOf(enumDef);
        String string2 = this.fullNameOf(enumDef);
        this._genEnum.gen(enumDef, n, string, string2);
        this._genTypeCodes.gen(enumDef, n, string, string2);
        this.visited(enumDef.absolute_name(), true);
        return true;
    }

    public boolean visitStruct(StructDef structDef) {
        int n = this.selectMode();
        String string = this.nameOf(structDef);
        String string2 = this.fullNameOf(structDef);
        this.visited(structDef.absolute_name(), true);
        this._genStruct.gen(structDef, n, string, string2);
        this._genTypeCodes.gen(structDef, n, string, string2);
        return true;
    }

    public boolean visitEstruct(EstructDef estructDef) {
        throw new INTERNAL("Ext. structs not supported in C++");
    }

    public boolean visitUnion(UnionDef unionDef) {
        int n = this.selectMode();
        String string = this.nameOf(unionDef);
        String string2 = this.fullNameOf(unionDef);
        this.visited(unionDef.absolute_name(), true);
        this._genUnion.gen(unionDef, n, string, string2);
        this._genTypeCodes.gen(unionDef, n, string, string2);
        return true;
    }

    public boolean visitException(ExceptionDef exceptionDef) {
        int n = this.selectMode();
        String string = this.nameOf(exceptionDef);
        String string2 = this.fullNameOf(exceptionDef);
        this.visited(exceptionDef.absolute_name(), true);
        this._genException.gen(exceptionDef, n, string, string2);
        this._genTypeCodes.gen(exceptionDef, n, string, string2);
        return true;
    }

    public boolean visitAlias(AliasDef aliasDef) {
        int n = this.selectMode();
        String string = this.nameOf(aliasDef);
        String string2 = this.fullNameOf(aliasDef);
        this._genAlias.gen(aliasDef, n, string, string2);
        this._genTypeCodes.gen(aliasDef, n, string, string2);
        this.visited(aliasDef.absolute_name(), true);
        return true;
    }

    public boolean visitModule(ModuleDef moduleDef) {
        if (!moduleDef.canVisit(moduleDef.absolute_name(), this) && !this._genNamespace) {
            throw new INTERNAL("Broken modules cannot be supported without namespaces");
        }
        int n = this.selectMode();
        String string = "";
        String string2 = "";
        boolean bl = false;
        if (this.isTopSymbol(moduleDef)) {
            this._generateMode = 1;
            CppBaseUtilEnv cppBaseUtilEnv = this.begin(moduleDef, this._generateMode);
            string = this.nameOf(moduleDef);
            string2 = this.fullNameOf(moduleDef);
            bl = this._genModule.gen(moduleDef, this._generateMode, string, string2);
            this.end(cppBaseUtilEnv);
            this._generateMode = 3;
            cppBaseUtilEnv = this.begin(moduleDef, this._generateMode);
            string = "_sk_" + this.nameOf(moduleDef);
            string2 = this.skelNameOf(moduleDef);
            this._genModule.gen(moduleDef, this._generateMode, string, string2);
            this.end(cppBaseUtilEnv);
            if (this.genTie()) {
                this._generateMode = 4;
                this._generatePtieMode = false;
                cppBaseUtilEnv = this.begin(moduleDef, this._generateMode);
                string = this.nameOf(moduleDef);
                string2 = this.fullNameOf(moduleDef);
                this._genModule.gen(moduleDef, this._generateMode, string, string2);
                this.end(cppBaseUtilEnv);
            }
            if (this.genPtie()) {
                this._generateMode = 4;
                this._generatePtieMode = true;
                cppBaseUtilEnv = this.begin(moduleDef, this._generateMode);
                string = this.nameOf(moduleDef);
                string2 = this.fullNameOf(moduleDef);
                this._genModule.gen(moduleDef, this._generateMode, string, string2);
                this.end(cppBaseUtilEnv);
            }
            this._generateMode = 1;
        } else {
            switch (n) {
                case 1: {
                    string = this.nameOf(moduleDef);
                    string2 = this.fullNameOf(moduleDef);
                    break;
                }
                case 3: {
                    string = "_sk_" + this.nameOf(moduleDef);
                    string2 = this.skelNameOf(moduleDef);
                    break;
                }
                case 4: {
                    string = this.nameOf(moduleDef);
                    string2 = this.fullNameOf(moduleDef);
                    break;
                }
            }
            this._genModule.gen(moduleDef, this._generateMode, string, string2);
        }
        this.visited(moduleDef.absolute_name(), "hard");
        return bl;
    }

    public boolean visitInterface(InterfaceDef interfaceDef) {
        if (!interfaceDef.canVisit(interfaceDef.absolute_name(), this)) {
            if (!interfaceDef.isSoftVisited(this)) {
                this.forwardDeclare(interfaceDef);
                this.visited(interfaceDef.absolute_name(), false);
            }
            return false;
        }
        this.visited(interfaceDef.absolute_name(), true);
        if (interfaceDef.forward_declared()) {
            return true;
        }
        int n = this.selectMode();
        String string = this.nameOf(interfaceDef);
        String string2 = this.fullNameOf(interfaceDef);
        if (this.isTopSymbol(interfaceDef)) {
            CppBaseUtilEnv cppBaseUtilEnv;
            if (!interfaceDef.isSoftVisited(this)) {
                this._generateMode = 2;
                cppBaseUtilEnv = this.begin(interfaceDef, this._generateMode);
                this._genInterface.gen(interfaceDef, this._generateMode, string, string2);
                this.end(cppBaseUtilEnv);
            }
            this._generateMode = 1;
            cppBaseUtilEnv = this.begin(interfaceDef, this._generateMode);
            this._genInterface.gen(interfaceDef, this._generateMode, string, string2);
            this._genTypeCodes.gen(interfaceDef, this._generateMode, string, string2);
            this.end(cppBaseUtilEnv);
            if (this.genObjectWrapper()) {
                this._generateMode = 6;
                cppBaseUtilEnv = this.begin(interfaceDef, this._generateMode);
                this._genInterface.gen(interfaceDef, this._generateMode, string, string2);
                this.end(cppBaseUtilEnv);
            }
            this._generateMode = 3;
            cppBaseUtilEnv = this.begin(interfaceDef, this._generateMode);
            this._genInterface.gen(interfaceDef, this._generateMode, string, string2);
            this.end(cppBaseUtilEnv);
            if (this.genTie()) {
                this._generateMode = 4;
                this._generatePtieMode = false;
                cppBaseUtilEnv = this.begin(interfaceDef, this._generateMode);
                this._genInterface.gen(interfaceDef, this._generateMode, string, string2);
                this.end(cppBaseUtilEnv);
            }
            if (this.genPtie()) {
                this._generateMode = 4;
                this._generatePtieMode = true;
                cppBaseUtilEnv = this.begin(interfaceDef, this._generateMode);
                this._genInterface.gen(interfaceDef, this._generateMode, string, string2);
                this.end(cppBaseUtilEnv);
            }
            this._generateMode = 1;
            this.visited(interfaceDef.absolute_name(), "hard");
            return true;
        }
        switch (n) {
            case 1: {
                CppBaseUtilEnv cppBaseUtilEnv;
                if (!interfaceDef.isSoftVisited(this)) {
                    this._generateMode = 2;
                    cppBaseUtilEnv = this.begin(interfaceDef, this._generateMode);
                    this._genInterface.gen(interfaceDef, this._generateMode, string, string2);
                    this.end(cppBaseUtilEnv);
                    this._generateMode = 1;
                }
                this._genTypeCodes.gen(interfaceDef, n, string, string2);
                this._genInterface.gen(interfaceDef, n, string, string2);
                if (!this.genObjectWrapper()) break;
                this._generateMode = 6;
                cppBaseUtilEnv = this.begin(interfaceDef, this._generateMode);
                this._genInterface.gen(interfaceDef, this._generateMode, string, string2);
                this.end(cppBaseUtilEnv);
                this._generateMode = 1;
                break;
            }
            case 3: 
            case 4: {
                this._genInterface.gen(interfaceDef, n, string, string2);
                break;
            }
        }
        this.visited(interfaceDef.absolute_name(), "hard");
        return true;
    }

    public boolean visitAttribute(AttributeDef attributeDef) {
        return true;
    }

    public boolean visitOperation(OperationDef operationDef) {
        return true;
    }
}

