/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.be.cpp;

import com.visigenic.vbroker.ir.Contained;
import com.visigenic.vbroker.ir.InterfaceDef;
import com.visigenic.vbroker.ir.InterfaceDefHelper;
import com.visigenic.vbroker.util.be.cpp.CppBaseUtil;
import com.visigenic.vbroker.util.be.cpp.CppGenTypeCodesIf;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.AliasDefHelper;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.ArrayDefHelper;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.EnumDefHelper;
import org.omg.CORBA.EstructDef;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.PrimitiveDef;
import org.omg.CORBA.PrimitiveDefHelper;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.SequenceDefHelper;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructDefHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionDefHelper;
import org.omg.CORBA.UnionMember;

public class CppGenTypeCodes
implements CppGenTypeCodesIf {
    private static final int ALIAS = 0;
    private static final int ARRAY = 1;
    private static final int ENUM = 2;
    private static final int EXCEPTION = 3;
    private static final int INTERFACE = 4;
    private static final int SEQUEVISE = 5;
    private static final int STRUCT = 6;
    private static final int ESTRUCT = 7;
    private static final int UNION = 8;
    private CppBaseUtil _h = null;
    String friend_str;
    String tc_prefix;
    String tc_name;
    String full_tc_name;
    String s_tc_name;
    String m_tc_name;
    String _full_name;
    private static final String[] TC_TABLE = new String[]{"CORBA::_tc_null", "CORBA::_tc_void", "CORBA::_tc_short", "CORBA::_tc_long", "CORBA::_tc_ushort", "CORBA::_tc_ulong", "CORBA::_tc_float", "CORBA::_tc_double", "CORBA::_tc_boolean", "CORBA::_tc_char", "CORBA::_tc_octet", "CORBA::_tc_any", "CORBA::_tc_TypeCode", "CORBA::_tc_Principal", "CORBA::_tc_string", "CORBA::_tc_Object", "CORBA::_tc_longlong", "CORBA::_tc_ulonglong", "CORBA::_tc_longdouble", "CORBA::_tc_wchar", "CORBA::_tc_wstring", null};

    public void setBaseUtil(CppBaseUtil cppBaseUtil) {
        this._h = cppBaseUtil;
    }

    public void gen(Contained contained, int n, String string, String string2) {
        if (this._h == null) {
            throw new INTERNAL("CppGenTypeCodes: helper not set");
        }
        if (!this._h.genTypeCodeInfo()) {
            return;
        }
        if (!this._h.genInclFilesCode() && !this._h.isDefinedInTopLevelFile(contained)) {
            return;
        }
        int n2 = -1;
        IDLType iDLType = null;
        if (contained instanceof EnumDef) {
            n2 = 2;
        } else if (contained instanceof ExceptionDef) {
            n2 = 3;
        } else if (contained instanceof org.omg.CORBA.InterfaceDef) {
            n2 = 4;
        } else if (contained instanceof StructDef) {
            n2 = 6;
        } else if (contained instanceof EstructDef) {
            n2 = 7;
        } else if (contained instanceof UnionDef) {
            n2 = 8;
        } else if (contained instanceof AliasDef) {
            n2 = 0;
        } else {
            throw new BAD_PARAM("CppGenTypeCodes: Unknown type");
        }
        if (n != 1) {
            if (n2 != 4) {
                return;
            }
            if (n != 2) {
                return;
            }
        }
        this._full_name = string2;
        if (this._h.isContainerClass(contained)) {
            this.friend_str = "friend ";
            this.tc_prefix = "static";
        } else {
            this.friend_str = "";
            this.tc_prefix = "extern " + this._h.export();
        }
        this.tc_name = "_tc_" + string;
        this.full_tc_name = this._h.baseName(string2);
        this.full_tc_name = this.full_tc_name.equals("") ? this.tc_name : String.valueOf(this.full_tc_name) + "::" + this.tc_name;
        this.s_tc_name = "_s_tc_" + this._h.scopeToUnderline(this._h.baseName(string2)) + this.tc_name;
        this.m_tc_name = "__tc_" + this._h.scopeToUnderline(this._h.baseName(string2)) + this.tc_name;
        if (n2 == 0) {
            iDLType = AliasDefHelper.narrow(contained).original_type_def();
            if (this._h.isAnonArray(iDLType)) {
                this.genHH(1, string, string2);
            } else if (this._h.isAnonSeq(iDLType)) {
                this.genHH(5, string, string2);
            } else {
                this.genHH(0, string, string2);
            }
        } else if (n2 == 4) {
            if (n == 2) {
                this.genHH(n2, string, string2);
            }
        } else {
            this.genHH(n2, string, string2);
        }
        if (n2 != 4 || n != 2) {
            this._h.p_cc("CORBA::TypeCode_ptr " + this.full_tc_name + "_get() { ");
            this._h.push_cc();
            this._h.p_cc("return " + this.tc_name + ";");
            this._h.pop_cc();
            this._h.p_cc("}");
        }
        switch (n2) {
            case 0: {
                iDLType = AliasDefHelper.narrow(contained).original_type_def();
                if (this._h.isAnonArray(iDLType)) {
                    this.genCCArray(iDLType, this.s_tc_name);
                    break;
                }
                if (this._h.isAnonSeq(iDLType)) {
                    this.genCCSequence(iDLType, string, contained.id(), this.s_tc_name);
                    break;
                }
                this.genCCAlias(contained);
                break;
            }
            case 2: {
                this.genCCEnum(contained);
                break;
            }
            case 3: {
                this.genCCStructOrExcep(contained, true);
                break;
            }
            case 4: {
                if (n != 1) break;
                InterfaceDef interfaceDef = InterfaceDefHelper.narrow(contained);
                if (interfaceDef.forward_declared()) {
                    return;
                }
                this.genCCInterface(contained);
                break;
            }
            case 6: {
                this.genCCStructOrExcep(contained, false);
                break;
            }
            case 7: {
                this.genCCEstruct(contained);
                break;
            }
            case 8: {
                this.genCCUnion(contained);
                break;
            }
        }
        if (n2 == 4 && n == 2) {
            return;
        }
        this._h.p_cc("CORBA::TypeCode_ptr " + this.full_tc_name + " = &" + this.s_tc_name + ";\n");
    }

    private void genHH(int n, String string, String string2) {
        String string3 = null;
        String string4 = null;
        this._h.p_hh(String.valueOf(this.tc_prefix) + " CORBA::TypeCode_ptr " + this.tc_name + ";");
        this._h.p_hh(String.valueOf(this.tc_prefix) + " CORBA::TypeCode_ptr " + this.tc_name + "_get();");
        if (n == 0) {
            return;
        }
        switch (n) {
            case 1: {
                string3 = "const " + string + "_forany&";
                string4 = String.valueOf(string) + "_forany&";
                break;
            }
            case 2: {
                string3 = string;
                string4 = String.valueOf(string) + "&";
                break;
            }
            case 4: {
                string3 = "const " + string + "_ptr";
                string4 = String.valueOf(string) + "_ptr&";
                break;
            }
            default: {
                string3 = "const " + string + "&";
                string4 = String.valueOf(string) + "&";
            }
        }
        if (n != 4) {
            this._h.p_hh("inline " + this.friend_str + "void operator<<=(CORBA::Any& _a, " + string3 + " _val) {");
            this._h.push_hh();
        } else {
            this._h.p_hh(String.valueOf(this._h.export()) + this.friend_str + "void operator<<=(CORBA::Any& _a, " + string3 + " _val);");
        }
        switch (n) {
            case 2: {
                this._h.p_hh(String.valueOf(string) + " *__val = (" + string + "*)CORBA::ULong_alloc();");
                this._h.p_hh("*__val = _val;");
                this._h.p_hh("_a.replace(" + this.tc_name + "_get(),__val, 1);");
                break;
            }
            case 1: {
                this._h.p_hh("CORBA::MarshalOutBuffer _mbuf;");
                this._h.p_hh("VISostream& _tstrm = _mbuf;");
                this._h.p_hh("_tstrm << _val;");
                this._h.p_hh("_a.replace(" + this.tc_name + "_get(), _mbuf);");
                break;
            }
            default: {
                this._h.p_hh("CORBA::MarshalOutBuffer _mbuf;");
                this._h.p_hh("_mbuf << _val;");
                this._h.p_hh("_a.replace(" + this.tc_name + "_get(), _mbuf);");
            }
            case 4: 
        }
        if (n != 4) {
            this._h.pop_hh();
            this._h.p_hh("}");
            this._h.p_hh("inline " + this.friend_str + "CORBA::Boolean operator>>=(const CORBA::Any& _a, " + string4 + " _val) {");
            this._h.p_hh("CORBA::TypeCode_var _tc(_a.type());");
            this._h.p_hh("if ( !_tc->equal(" + this.tc_name + "_get()) ) return 0;");
            this._h.push_hh();
        } else {
            this._h.p_hh(String.valueOf(this._h.export()) + this.friend_str + "CORBA::Boolean operator>>=(const CORBA::Any& _a, " + string4 + " _val);");
        }
        switch (n) {
            case 2: {
                this._h.p_hh("_val = *(" + string + " *)_a.value();");
                break;
            }
            default: {
                this._h.p_hh("CORBA::MarshalInBuffer _mbuf((char *)_a.value(), ");
                this._h.push_hh();
                this._h.push_hh();
                this._h.p_hh("(CORBA::ULong)_a.len());");
                this._h.pop_hh();
                this._h.pop_hh();
            }
            case 4: 
        }
        switch (n) {
            case 3: {
                this._h.p_hh("_mbuf.getString();");
                this._h.p_hh("_val._copy(_mbuf);");
                break;
            }
            case 1: {
                this._h.p_hh("VISistream& _tstrm = _mbuf;");
                this._h.p_hh("_tstrm >> _val;");
                break;
            }
            default: {
                this._h.p_hh("_mbuf >> _val;");
            }
            case 2: 
            case 4: 
        }
        if (n != 4) {
            this._h.p_hh("return 1;");
            this._h.pop_hh();
            this._h.p_hh("}\n");
        }
    }

    private void genCCArray(IRObject iRObject, String string) {
        ArrayDef arrayDef = ArrayDefHelper.narrow(iRObject);
        IDLType iDLType = arrayDef.element_type_def();
        if (string == null) {
            this._h.p_cc("new CORBA::TypeCode(");
        } else {
            this._h.p_cc("static CORBA::TypeCode " + string + "(");
        }
        this._h.push_cc();
        this._h.p_cc("CORBA::tk_array,");
        this._h.p_cc(String.valueOf(arrayDef.length()) + ",");
        if (iDLType.def_kind() == DefinitionKind.dk_Array) {
            this.genCCArray(iDLType, null);
        } else {
            this._h.p_cc(String.valueOf(this.defToFullTcName(iDLType)) + ",");
        }
        if (string == null) {
            this._h.p_cc("0),");
        } else {
            this._h.p_cc("1);");
        }
        this._h.pop_cc();
    }

    private void genCCEnum(IRObject iRObject) {
        EnumDef enumDef = EnumDefHelper.narrow(iRObject);
        String[] stringArray = enumDef.members();
        int n = stringArray.length;
        String string = "";
        this._h.p_cc("static char* " + this.m_tc_name + "[] = {");
        this._h.push_cc();
        int n2 = 0;
        while (n2 < n) {
            string = n2 < n - 1 ? "," : "";
            this._h.p_cc("(char *)\"" + stringArray[n2] + "\"" + string);
            ++n2;
        }
        this._h.pop_cc();
        this._h.p_cc("};");
        this._h.p_cc("static CORBA::TypeCode " + this.s_tc_name + "(");
        this._h.push_cc();
        this._h.p_cc("\"" + enumDef.id() + "\",");
        this._h.p_cc("\"" + this._h.unconvertedName(enumDef) + "\",");
        this._h.p_cc("CORBA::EnumMemberSeq(" + n + ", " + n + ",");
        this._h.push_cc();
        this._h.p_cc(String.valueOf(this.m_tc_name) + "),");
        this._h.pop_cc();
        this._h.p_cc("1);");
        this._h.pop_cc();
    }

    private void genCCAlias(IRObject iRObject) {
        AliasDef aliasDef = AliasDefHelper.narrow(iRObject);
        this._h.p_cc("static CORBA::TypeCode " + this.s_tc_name + " (");
        this._h.push_cc();
        this._h.p_cc("\"" + aliasDef.id() + "\",");
        this._h.p_cc("\"" + this._h.unconvertedName(aliasDef) + "\",");
        this._h.p_cc(String.valueOf(this.defToFullTcName(aliasDef.original_type_def())) + ",");
        this._h.p_cc("1);");
        this._h.pop_cc();
    }

    private void genCCSequence(IRObject iRObject, String string, String string2, String string3) {
        String string4;
        SequenceDef sequenceDef = SequenceDefHelper.narrow(iRObject);
        if (sequenceDef.element_type_def() instanceof SequenceDef) {
            string4 = String.valueOf(string3) + "_elem";
            this.genCCSequence(sequenceDef.element_type_def(), null, null, string4);
            string4 = "&" + string3 + "_elem_elem";
        } else {
            string4 = this.defToFullTcName(sequenceDef.element_type_def());
        }
        this._h.p_cc("static CORBA::TypeCode " + string3 + "_elem (");
        this._h.push_cc();
        this._h.p_cc("CORBA::tk_sequence,");
        this._h.p_cc(String.valueOf(sequenceDef.bound()) + ",");
        this._h.p_cc(String.valueOf(string4) + ",");
        this._h.p_cc("1);");
        this._h.pop_cc();
        if (string != null) {
            this._h.p_cc("static CORBA::TypeCode " + string3 + " (");
            this._h.push_cc();
            this._h.p_cc("\"" + string2 + "\",");
            this._h.p_cc("\"" + string + "\",");
            this._h.p_cc("&" + string3 + "_elem,");
            this._h.p_cc("1);");
            this._h.pop_cc();
        }
    }

    private void genCCStructOrExcep(IRObject iRObject, boolean bl) {
        StructDef structDef = StructDefHelper.narrow(iRObject);
        ExceptionDef exceptionDef = ExceptionDefHelper.narrow(iRObject);
        StructMember[] structMemberArray = null;
        structMemberArray = bl ? exceptionDef.members() : structDef.members();
        int n = structMemberArray.length;
        String string = "";
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                String string2 = String.valueOf(this.s_tc_name) + "_" + structMemberArray[n2].name;
                if (structMemberArray[n2].type_def instanceof SequenceDef) {
                    this.genCCSequence(structMemberArray[n2].type_def, null, null, string2);
                } else if (structMemberArray[n2].type_def instanceof ArrayDef) {
                    this.genCCArray(structMemberArray[n2].type_def, string2);
                }
                ++n2;
            }
            this._h.p_cc("static CORBA::StructMember " + this.m_tc_name + "[] = {");
            this._h.push_cc();
            int n3 = 0;
            while (n3 < n) {
                this._h.p_cc("CORBA::StructMember(");
                this._h.push_cc();
                this._h.p_cc("\"" + structMemberArray[n3].name + "\",");
                if (structMemberArray[n3].type_def instanceof SequenceDef) {
                    this._h.p_cc("&" + this.s_tc_name + "_" + structMemberArray[n3].name + "_elem,");
                } else if (structMemberArray[n3].type_def instanceof ArrayDef) {
                    this._h.p_cc("&" + this.s_tc_name + "_" + structMemberArray[n3].name + ",");
                } else {
                    this._h.p_cc(String.valueOf(this.defToFullTcName(structMemberArray[n3].type_def)) + ",");
                }
                string = n3 < n - 1 ? "," : "";
                this._h.p_cc("CORBA::IDLType::_nil() )" + string);
                this._h.pop_cc();
                ++n3;
            }
            this._h.pop_cc();
            this._h.p_cc("};");
        }
        this._h.p_cc("static CORBA::TypeCode " + this.s_tc_name + " (");
        this._h.push_cc();
        if (bl) {
            this._h.p_cc("CORBA::tk_except,");
        } else {
            this._h.p_cc("CORBA::tk_struct,");
        }
        if (bl) {
            this._h.p_cc("\"" + exceptionDef.id() + "\",");
            this._h.p_cc("\"" + this._h.unconvertedName(exceptionDef) + "\",");
        } else {
            this._h.p_cc("\"" + structDef.id() + "\",");
            this._h.p_cc("\"" + this._h.unconvertedName(structDef) + "\",");
        }
        if (n > 0) {
            this._h.p_cc("CORBA::StructMemberSeq (");
            this._h.push_cc();
            this._h.p_cc(n + ", " + n + ",");
            this._h.p_cc(String.valueOf(this.m_tc_name) + "),");
            this._h.pop_cc();
        } else {
            this._h.p_cc("CORBA::StructMemberSeq(0),");
        }
        this._h.p_cc("1);");
        this._h.pop_cc();
    }

    private void genCCUnion(IRObject iRObject) {
        UnionDef unionDef = UnionDefHelper.narrow(iRObject);
        IDLType iDLType = unionDef.discriminator_type_def();
        String string = this._h.fullNameOf(iDLType);
        String string2 = null;
        UnionMember[] unionMemberArray = unionDef.members();
        int n = unionMemberArray.length;
        String[] stringArray = new String[n];
        int n2 = -1;
        try {
            n2 = unionDef.type().default_index();
        }
        catch (Exception exception) {
            n2 = -1;
        }
        String string3 = "";
        int n3 = 0;
        while (n3 < n) {
            if (n3 == n2) {
                string3 = "default";
            }
            string3 = String.valueOf(n3);
            stringArray[n3] = "__tc_" + this._h.scopeToUnderline(this._h.baseName(this._full_name)) + this.tc_name + "_" + string3;
            string2 = this._h.valueOfType(unionMemberArray[n3].label, iDLType);
            if (iDLType.def_kind().value() == 12) {
                string2 = n3 == n2 ? this._h.defaultLabel(unionMemberArray, iDLType, n2) : this._h.memLabelToString(string2, string, "");
                string3 = "CORBA::ULong";
            } else {
                string3 = this._h.fullNameOf(iDLType);
            }
            this._h.p_cc("static " + string3 + " " + stringArray[n3] + " = " + string2 + ";");
            ++n3;
        }
        String string4 = this.defToFullTcName(iDLType);
        int n4 = 0;
        while (n4 < n) {
            if (n4 >= n - 1 || !unionMemberArray[n4].name.equals(unionMemberArray[n4 + 1].name)) {
                String string5 = String.valueOf(this.s_tc_name) + "_" + unionMemberArray[n4].name;
                if (unionMemberArray[n4].type_def instanceof SequenceDef) {
                    this.genCCSequence(unionMemberArray[n4].type_def, null, null, string5);
                } else if (unionMemberArray[n4].type_def instanceof ArrayDef) {
                    this.genCCArray(unionMemberArray[n4].type_def, string5);
                }
            }
            ++n4;
        }
        this._h.p_cc("static CORBA::UnionMember " + this.m_tc_name + "[] = {");
        this._h.push_cc();
        int n5 = 0;
        while (n5 < n) {
            this._h.p_cc("CORBA::UnionMember (");
            this._h.push_cc();
            this._h.p_cc("\"" + unionMemberArray[n5].name + "\",");
            if (iDLType.def_kind().value() == 12 && n5 == n2) {
                this._h.p_cc("(CORBA::Any&) CORBA::Any(CORBA::_tc_octet, &" + stringArray[n5] + "),");
            } else {
                this._h.p_cc("(CORBA::Any&) CORBA::Any(" + string4 + ", &" + stringArray[n5] + "),");
            }
            if (unionMemberArray[n5].type_def instanceof SequenceDef) {
                this._h.p_cc("&" + this.s_tc_name + "_" + unionMemberArray[n5].name + "_elem,");
            } else if (unionMemberArray[n5].type_def instanceof ArrayDef) {
                this._h.p_cc("&" + this.s_tc_name + "_" + unionMemberArray[n5].name + ",");
            } else {
                this._h.p_cc(String.valueOf(this.defToFullTcName(unionMemberArray[n5].type_def)) + ",");
            }
            string3 = n5 < n - 1 ? "," : "";
            this._h.p_cc("CORBA::IDLType::_nil() )" + string3);
            this._h.pop_cc();
            ++n5;
        }
        this._h.pop_cc();
        this._h.p_cc("};");
        this._h.p_cc("static CORBA::TypeCode " + this.s_tc_name + " (");
        this._h.push_cc();
        this._h.p_cc("\"" + unionDef.id() + "\",");
        this._h.p_cc("\"" + this._h.unconvertedName(unionDef) + "\",");
        this._h.p_cc(String.valueOf(this.defToFullTcName(iDLType)) + ",");
        this._h.p_cc("CORBA::UnionMemberSeq (");
        this._h.push_cc();
        this._h.p_cc(n + ", " + n + ",");
        this._h.p_cc(String.valueOf(this.m_tc_name) + "),");
        this._h.pop_cc();
        this._h.p_cc("1);");
        this._h.pop_cc();
    }

    private void genCCEstruct(IRObject iRObject) {
    }

    private void genCCInterface(IRObject iRObject) {
        org.omg.CORBA.InterfaceDef interfaceDef = org.omg.CORBA.InterfaceDefHelper.narrow(iRObject);
        this._h.p_cc("static CORBA::TypeCode " + this.s_tc_name + " (");
        this._h.push_cc();
        this._h.p_cc("\"" + interfaceDef.id() + "\",");
        this._h.p_cc("\"" + this._h.unconvertedName(interfaceDef) + "\", 1);");
        this._h.pop_cc();
        this._h.p_cc("void operator<<=(CORBA::Any& _a, const " + this._full_name + "_ptr _val) {");
        this._h.push_cc();
        this._h.p_cc("_a <<= (const CORBA::Object_ptr)_val;");
        this._h.pop_cc();
        this._h.p_cc("}");
        this._h.p_cc("CORBA::Boolean operator>>=(const CORBA::Any& _a, " + this._full_name + "_ptr& _val) {");
        this._h.push_cc();
        this._h.p_cc("CORBA::Object_var _temp;");
        this._h.p_cc("CORBA::Boolean _result = 0;");
        this._h.p_cc("if ( _a >>= CORBA_Any::to_object(_temp.out()) ) {");
        this._h.push_cc();
        this._h.p_cc("_val = " + this._full_name + "::_narrow(_temp);");
        this._h.p_cc("_result = (_val != " + this._full_name + "::_nil());");
        this._h.pop_cc();
        this._h.p_cc("}");
        this._h.p_cc("return _result;");
        this._h.pop_cc();
        this._h.p_cc("}");
    }

    private String defToFullTcName(IRObject iRObject) {
        String string = null;
        switch (iRObject.def_kind().value()) {
            case 14: {
                return "CORBA::_tc_string";
            }
            case 18: {
                return "CORBA::_tc_wstring";
            }
        }
        if (iRObject.def_kind() != DefinitionKind.dk_Alias && iRObject.def_kind() != DefinitionKind.dk_Interface && iRObject.def_kind() != DefinitionKind.dk_Enum && (this._h.isPrimitive(iRObject) || this._h.isInterface(iRObject) || this._h.isTypeCode(iRObject) || this._h.isPrincipal(iRObject) || this._h.isString(iRObject) || this._h.isAny(iRObject))) {
            PrimitiveDef primitiveDef = PrimitiveDefHelper.narrow(iRObject);
            return TC_TABLE[primitiveDef.kind().value()];
        }
        string = this._h.baseName(this._h.fullNameOf(iRObject));
        if (!string.equals("")) {
            string = String.valueOf(string) + "::";
        }
        return String.valueOf(string) + "_tc_" + this._h.nameOf(iRObject) + "_get()";
    }
}

