/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.tools;

import com.visigenic.vbroker.ir.RepositoryImpl;
import com.visigenic.vbroker.orb.PrintVersion;
import com.visigenic.vbroker.tools.ir.ReadException;
import com.visigenic.vbroker.tools.ir.RepositoryManager;
import com.visigenic.vbroker.tools.ir.RepositoryManagerHelper;
import com.visigenic.vbroker.util.ipp.IppException;
import com.visigenic.vbroker.util.ipp.IppHelper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.ORB;

public class idl2ir {
    private static boolean VERBOSE;

    private static void exit(Exception exception) {
        if (VERBOSE && exception != null) {
            System.err.println(exception);
            exception.printStackTrace();
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-version")) {
                PrintVersion.main(stringArray);
                System.exit(1);
            } else if (stringArray[n].equals("-replace")) {
                bl = true;
            } else if (stringArray[n].equals("-ir")) {
                if (++n >= stringArray.length) {
                    System.err.println("-ir flag requires a name");
                    return;
                }
                string = stringArray[n];
            } else if (stringArray[n].equals("-verbose")) {
                VERBOSE = true;
            } else if (stringArray[n].startsWith("-")) {
                vector.addElement(stringArray[n]);
            } else {
                vector2.addElement(stringArray[n]);
            }
            ++n;
        }
        if (!vector.isEmpty() && !IppHelper.CheckArgs(vector) || vector2.size() == 0) {
            System.out.println("Usage: idl2ir [-options] files...\n\nwhere options include:\n  -ir <name>               The name of the interface repository\n  -replace                 Replace definitions, instead of updating them\n  -verbose                 Turn verbose mode on\n  -version                 Print version\npre-processor options:\n" + IppHelper.GetUsageMessage());
            idl2ir.exit(null);
        }
        ORB oRB = ORB.init(stringArray, null);
        RepositoryManager repositoryManager = RepositoryManagerHelper.bind(oRB, string);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = null;
            try {
                string3 = IppHelper.preProcess(vector, string2);
                repositoryManager.read_text(string2, string3, bl);
            }
            catch (IppException ippException) {
                System.err.println(ippException);
                idl2ir.exit(ippException);
            }
            catch (IOException iOException) {
                idl2ir.exit(iOException);
            }
            catch (ReadException readException) {
                System.err.println(RepositoryImpl.format(readException));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-2);
            }
        }
    }
}

