/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.services.ORBManager;

import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.services.ORBManager.Adapter;
import com.visigenic.vbroker.services.ORBManager.AdapterImpl;
import com.visigenic.vbroker.services.ORBManager.AttributeSetPackage.Attribute;
import com.visigenic.vbroker.services.ORBManager.AttributeSetPackage.AttributeReadOnly;
import com.visigenic.vbroker.services.ORBManager.AttributeSetPackage.InvalidAttributeId;
import com.visigenic.vbroker.services.ORBManager.AttributeSetPackage.InvalidAttributeType;
import com.visigenic.vbroker.services.ORBManager.AttributeSetPackage.InvalidAttributeValue;
import com.visigenic.vbroker.services.ORBManager._ServerImplBase;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;

public class ServerImpl
extends _ServerImplBase {
    private Dictionary _adapters = new Hashtable();
    private ORB _orb;

    public void init(ORB oRB) {
        this._orb = oRB;
    }

    public Adapter get_adapter(String string) {
        AdapterImpl adapterImpl = (AdapterImpl)this._adapters.get(string);
        if (adapterImpl == null) {
            if (this._orb.adapterManager().getAdapter(string) == null) {
                return null;
            }
            adapterImpl = new AdapterImpl(string);
            adapterImpl.init(this._orb);
            this._adapters.put(string, adapterImpl);
        }
        return adapterImpl;
    }

    public Adapter[] get_all_adapters() {
        Enumeration enumeration = this._orb.adapterManager().getAdapters();
        Adapter[] adapterArray = new Adapter[this._orb.adapterManager().getNumAdapters()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            adapterArray[n] = this.get_adapter((String)enumeration.nextElement());
            ++n;
        }
        return adapterArray;
    }

    public void shutdown() {
        if (this._orb.getPropertyManager().getBoolean("ORBsecureShutdown")) {
            throw new NO_PERMISSION("shutdown");
        }
        this._orb.shutdown();
    }

    public Any get_attribute(String string) throws InvalidAttributeId {
        Any any = this._orb.create_any();
        try {
            any.insert_string(this._orb.getPropertyManager().getString(string));
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new InvalidAttributeId();
        }
        return any;
    }

    public void set_attribute(String string, Any any) throws InvalidAttributeId, InvalidAttributeType, InvalidAttributeValue, AttributeReadOnly {
        if (any.type().kind().value() != 18) {
            throw new InvalidAttributeType();
        }
        try {
            this._orb.getPropertyManager().setProperty(string, any.extract_string());
            return;
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (bAD_PARAM.getMessage().equals("Unknown property " + string)) {
                throw new InvalidAttributeId();
            }
            throw new InvalidAttributeValue();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            throw new AttributeReadOnly();
        }
    }

    public Attribute[] get_all_attributes() {
        int n = 0;
        Attribute[] attributeArray = new Attribute[this._orb.getPropertyManager().getNumProperties()];
        Enumeration enumeration = this._orb.getPropertyManager().getProperties();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this._orb.getPropertyManager().getString(string);
            if (string2 == null) {
                string2 = "";
            }
            attributeArray[n] = new Attribute();
            attributeArray[n].id = string;
            attributeArray[n].value = this._orb.create_any();
            attributeArray[n].value.insert_string(string2);
            attributeArray[n].is_readonly = this._orb.getPropertyManager().getPropertyReadOnly(string);
            ++n;
        }
        return attributeArray;
    }

    public int activation_policy() {
        return 0;
    }

    public int process_id() {
        return this._orb.getPropertyManager().getInt("ORBprocId");
    }
}

