/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.SocketConnectionFactory;
import com.visigenic.vbroker.orb.TcpConnection;

public class TcpConnectionFactory
implements SocketConnectionFactory,
OrbObject {
    private ORB _orb;
    IiopProtocol _protocol;

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        this._protocol = (IiopProtocol)objectArray[0];
    }

    public Object hashEndpoint(TaggedProfile taggedProfile) {
        return new TcpEndpoint(taggedProfile);
    }

    public Connection connect(TaggedProfile taggedProfile) {
        Object[] objectArray;
        if (this._orb.debug) {
            objectArray = this._protocol.profileBody(taggedProfile);
            this._orb.println("TcpConnectionFactory trying to connect to " + objectArray.host + ":" + this._protocol.port((ProfileBody)objectArray));
        }
        objectArray = new Object[]{this._protocol, this._orb.create(this._orb.proxy() ? 20 : 19), this};
        TcpConnection tcpConnection = (TcpConnection)this._orb.create(27, objectArray);
        tcpConnection.connect(taggedProfile);
        return tcpConnection;
    }

    public Connection connect(String string, int n, TaggedProfile taggedProfile) {
        Object[] objectArray;
        if (this._orb.debug) {
            objectArray = this._protocol.profileBody(taggedProfile);
            this._orb.println("TcpConnectionFactory trying to connect to " + objectArray.host + ":" + this._protocol.port((ProfileBody)objectArray) + " from " + string + ":" + n);
        }
        objectArray = new Object[]{this._protocol, this._orb.create(this._orb.proxy() ? 20 : 19), this};
        TcpConnection tcpConnection = (TcpConnection)this._orb.create(27, objectArray);
        tcpConnection.connect(string, n, taggedProfile);
        return tcpConnection;
    }

    public ConnectionFactory.Listener listen(TaggedProfile taggedProfile) {
        Object[] objectArray = new Object[]{this, taggedProfile};
        return (ConnectionFactory.Listener)this._orb.create(22, objectArray);
    }

    class TcpEndpoint {
        private String _host;
        private int _port;

        public TcpEndpoint(TaggedProfile taggedProfile) {
            TcpConnectionFactory.this = TcpConnectionFactory.this;
            ProfileBody profileBody = TcpConnectionFactory.this._protocol.profileBody(taggedProfile);
            this._host = profileBody.host;
            this._port = TcpConnectionFactory.this._protocol.port(profileBody);
        }

        public int hashCode() {
            return this._host.hashCode() + this._port;
        }

        public boolean equals(Object object) {
            if (object instanceof TcpEndpoint) {
                TcpEndpoint tcpEndpoint = (TcpEndpoint)object;
                if (this._port == tcpEndpoint._port && this._host.equals(tcpEndpoint._host)) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this._host) + ":" + this._port;
        }
    }
}

