/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.GIOP.Version;
import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IIOP_1_1.ProfileBodyHelper;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.BaseSocket;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.SocketConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;

public class TcpConnection
implements SocketConnection,
OrbObject,
Cloneable {
    private ORB _orb;
    private IiopProtocol _protocol;
    private BaseSocket _socket;
    private TaggedProfile _endpoint;
    private ConnectionFactory _factory;
    private int _refCount = 1;
    private static final byte[] EMPTY_OBJECT_KEY = new byte[0];

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        if (!(objectArray[0] instanceof IiopProtocol)) {
            throw new INTERNAL("TcpConnecion requires IiopProtocol");
        }
        this._protocol = (IiopProtocol)objectArray[0];
        this.socket((BaseSocket)objectArray[1]);
        this._factory = (ConnectionFactory)objectArray[2];
    }

    public void connect(TaggedProfile taggedProfile) {
        this._endpoint = taggedProfile;
        ProfileBody profileBody = this._protocol.profileBody(taggedProfile);
        this._socket.doConnect(profileBody.host, this._protocol.port(profileBody));
    }

    public void connect(String string, int n, TaggedProfile taggedProfile) {
        this._endpoint = taggedProfile;
        ProfileBody profileBody = this._protocol.profileBody(taggedProfile);
        this._socket.doConnect(string, n, profileBody.host, this._protocol.port(profileBody));
    }

    public void read(byte[] byArray, int n, int n2) {
        try {
            InputStream inputStream = this.getInputStream();
            if (this._orb.debug) {
                this._orb.print("Reading " + n2 + " bytes at offset " + n + " from " + this._socket + " ... ");
            }
            while (n2 > 0) {
                int n3 = inputStream.read(byArray, n, n2);
                if (n3 == -1) {
                    throw new IOException("Peer disconnected socket");
                }
                n += n3;
                n2 -= n3;
            }
            if (this._orb.debug) {
                this._orb.println("complete");
                return;
            }
        }
        catch (IOException iOException) {
            if (this._orb.debug) {
                this._orb.println("failed");
            }
            this.close();
            throw new COMM_FAILURE(iOException.toString());
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            OutputStream outputStream = this.getOutputStream();
            if (this._orb.debug) {
                this._orb.print("Writing " + n2 + " bytes at offset " + n + " to " + this._socket + " ... ");
            }
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            if (this._orb.debug) {
                this._orb.println("complete");
                return;
            }
        }
        catch (IOException iOException) {
            if (this._orb.debug) {
                this._orb.println("failed");
            }
            this.close();
            throw new COMM_FAILURE(iOException.toString());
        }
    }

    public void close() {
        this._socket.close();
    }

    public boolean isPeerAlive() {
        try {
            this.getInputStream().available();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public TaggedProfile getPeerProfile() {
        if (this._endpoint == null) {
            Version version = new Version(1, 0);
            ProfileBody profileBody = new ProfileBody(version, this._socket.getHostName(), (short)this._socket.getPortNumber(), EMPTY_OBJECT_KEY, null);
            GiopOutputStream giopOutputStream = this._orb.newGiopOutputStream();
            giopOutputStream.write_boolean(false);
            ProfileBodyHelper.write(giopOutputStream, profileBody);
            this._endpoint = new TaggedProfile(0, giopOutputStream.toByteArray());
        }
        return this._endpoint;
    }

    public Object clone() {
        TcpConnection tcpConnection = null;
        try {
            tcpConnection = (TcpConnection)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new INTERNAL(cloneNotSupportedException.toString());
        }
        tcpConnection._socket = (BaseSocket)this._socket.clone();
        tcpConnection._refCount = 1;
        return tcpConnection;
    }

    public BaseSocket socket() {
        return this._socket;
    }

    public void socket(BaseSocket baseSocket) {
        this._socket = baseSocket;
    }

    public OutputStream getOutputStream() {
        return this._socket.getOutputStream();
    }

    public InputStream getInputStream() {
        return this._socket.getInputStream();
    }

    public String getLocalHostName() {
        return this._socket.getLocalHostName();
    }

    public int getLocalPortNumber() {
        return this._socket.getLocalPortNumber();
    }

    public String toString() {
        return "TcpConnection[socket=" + this._socket + "]";
    }
}

