/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.ServerRequest;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.Context;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.MethodPointer;
import org.omg.CORBA.portable.OutputStream;

public class ServerRequestImpl
extends ServerRequest
implements OrbObject {
    private ORB _orb;
    private String _op_name;
    private InputStream _input;
    private OutputStream _output;
    private NVList _params;
    private Any _result;
    private Any _exception;

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
    }

    public boolean invoke(DynamicImplementation dynamicImplementation, MethodPointer methodPointer, InputStream inputStream, OutputStream outputStream) {
        this._op_name = methodPointer.method_name;
        this._input = inputStream;
        this._output = outputStream;
        dynamicImplementation.invoke(this);
        return this.write();
    }

    public String op_name() {
        return this._op_name;
    }

    public Context ctx() {
        throw new INTERNAL();
    }

    public void params(NVList nVList) {
        this._params = nVList;
        this.read();
    }

    private void read() {
        if (this._params != null) {
            try {
                int n = this._params.count();
                int n2 = 0;
                while (n2 < n) {
                    NamedValue namedValue = this._params.item(n2);
                    if ((namedValue.flags() & 1) != 0) {
                        namedValue.value().read_value(this._input, namedValue.value().type());
                        if (this._orb.debug) {
                            this._orb.println("ServerRequest read param: " + namedValue);
                        }
                    }
                    ++n2;
                }
                return;
            }
            catch (Bounds bounds) {
                throw new INTERNAL(bounds.toString());
            }
        }
    }

    private boolean write() {
        if (this._exception != null) {
            if (this._orb.debug) {
                this._orb.println("ServerRequest write exception: " + this._exception);
            }
            this._exception.write_value(this._output);
            return true;
        }
        if (this._result != null) {
            if (this._orb.debug) {
                this._orb.println("ServerRequest write result: " + this._result);
            }
            this._result.write_value(this._output);
        }
        if (this._params != null) {
            try {
                int n = this._params.count();
                int n2 = 0;
                while (n2 < n) {
                    NamedValue namedValue = this._params.item(n2);
                    if ((namedValue.flags() & 2) != 0) {
                        if (this._orb.debug) {
                            this._orb.println("ServerRequest write param: " + namedValue);
                        }
                        namedValue.value().write_value(this._output);
                    }
                    ++n2;
                }
            }
            catch (Bounds bounds) {
                throw new INTERNAL(bounds.toString());
            }
        }
        return false;
    }

    public void result(Any any) {
        this._result = any;
    }

    public void except(Any any) {
        this._exception = any;
    }
}

