/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.IORHelper;
import com.visigenic.vbroker.interceptor.Closure;
import com.visigenic.vbroker.orb.GiopConnection;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.GiopStream;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.TypeCode;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.portable.InputStream;

public class GiopOutputStreamImpl
extends GiopOutputStream
implements GiopStream,
OrbObject {
    private ORB _orb;
    private byte[] _bytes;
    private int _offset;
    private int _dataOffset = -1;
    private int _align;
    private boolean _byteOrder = false;
    private RequestHeader _request;
    private Closure _closure;
    private GiopConnection _connection;
    private int _nesting;
    private Dictionary _typeCodes;
    private Vector _encapsulations = new Vector();

    GiopOutputStreamImpl() {
    }

    public void init(ORB oRB, java.lang.Object[] objectArray) {
        this._orb = oRB;
        this._bytes = new byte[100];
    }

    public int offset() {
        return this._offset;
    }

    public void offset(int n) {
        this._offset = n;
    }

    public int dataOffset() {
        return this._dataOffset;
    }

    public void dataOffset(int n) {
        this._dataOffset = n;
    }

    public boolean byteOrder() {
        return this._byteOrder;
    }

    public void byteOrder(boolean bl) {
        this._byteOrder = bl;
    }

    public void startEncapsulation() {
        this._encapsulations.addElement(new EncapsulationState(this._align));
        this.write_long(0);
        this._align = this._offset;
        this.write_boolean(this._byteOrder);
    }

    public void endEncapsulation() {
        int n = this._offset - this._align;
        int n2 = this._offset;
        EncapsulationState encapsulationState = (EncapsulationState)this._encapsulations.lastElement();
        this._encapsulations.removeElement(encapsulationState);
        this._offset = this._align - 4;
        this._align = encapsulationState.align;
        this.write_long(n);
        this._offset = n2;
    }

    final void alignAndExtend(int n, int n2) {
        int n3;
        int n4 = (this._offset - this._align) % n;
        if (n4 != 0) {
            this._offset += n - n4;
        }
        if ((n3 = this._offset + n2) >= this._bytes.length) {
            this.expand(n3);
        }
    }

    public byte[] bytes() {
        return this._bytes;
    }

    public byte[] toByteArray() {
        int n = this.offset();
        byte[] byArray = new byte[n];
        System.arraycopy(this._bytes, 0, byArray, 0, n);
        return byArray;
    }

    public RequestHeader request() {
        return this._request;
    }

    public void request(RequestHeader requestHeader) {
        this._request = requestHeader;
    }

    public Closure closure() {
        return this._closure;
    }

    public void closure(Closure closure) {
        this._closure = closure;
    }

    public GiopConnection connection() {
        return this._connection;
    }

    public void connection(GiopConnection giopConnection) {
        this._connection = giopConnection;
    }

    public InputStream create_input_stream() {
        GiopInputStream giopInputStream = this._orb.newGiopInputStream(this._bytes);
        giopInputStream.byteOrder(this.byteOrder());
        return giopInputStream;
    }

    public void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this._bytes, n, byArray, 0, n2);
    }

    void expand(int n) {
        byte[] byArray = new byte[Math.max(this._bytes.length * 2, n)];
        System.arraycopy(this._bytes, 0, byArray, 0, this._bytes.length);
        this._bytes = byArray;
    }

    public void write_Object(Object object) {
        IOR iOR = object == null ? this._orb.nullIor() : this._orb.getDelegate(object).ior(object);
        IORHelper.write(this, iOR);
    }

    public void write_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        block6: {
            if (typeCode == null || !(typeCode instanceof TypeCode)) {
                throw new BAD_PARAM("Invalid TypeCode: " + typeCode);
            }
            try {
                if (this._nesting++ == 0) {
                    this._typeCodes = new Hashtable();
                }
                java.lang.Object var4_2 = null;
                java.lang.Object v = this._typeCodes.get(typeCode);
                var4_2 = v;
                if (v != null) {
                    int n = var4_2;
                    this.write_ulong(-1);
                    this.write_long(n - this._offset);
                    break block6;
                }
                this._typeCodes.put(typeCode, new Integer(this._offset));
                ((TypeCode)typeCode).write(this, this._orb.backwardCompatible);
            }
            catch (Throwable throwable) {
                block7: {
                    java.lang.Object var3_5 = null;
                    if (--this._nesting != 0) break block7;
                    this._typeCodes = null;
                }
                throw throwable;
            }
        }
        java.lang.Object var3_4 = null;
        if (--this._nesting == 0) {
            this._typeCodes = null;
        }
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM("Null parameter: any");
        }
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public void write_Principal(Principal principal) {
        byte[] byArray = principal.name();
        this.write_long(byArray.length);
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write_boolean(boolean bl) {
        this.write_octet((byte)(bl ? 1 : 0));
    }

    public void write_char(char c) {
        this.write_octet((byte)c);
    }

    public void write_wchar(char c) {
        short s = (short)c;
        if (s <= -8193 && s >= -10240) {
            throw new DATA_CONVERSION("Cannot encode Unicode character " + c + " as UTF-16 value.");
        }
        this.write_short((short)c);
    }

    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public void write_octet(byte by) {
        int n = this._offset + 1;
        if (n >= this._bytes.length) {
            this.expand(n);
        }
        this._bytes[this._offset++] = by;
    }

    public void write_short(short s) {
        this.alignAndExtend(2, 2);
        if (!this._byteOrder) {
            this._bytes[this._offset++] = (byte)(s >>> 8);
            this._bytes[this._offset++] = (byte)s;
            return;
        }
        this._bytes[this._offset++] = (byte)s;
        this._bytes[this._offset++] = (byte)(s >>> 8);
    }

    public void write_long(int n) {
        this.alignAndExtend(4, 4);
        if (!this._byteOrder) {
            this._bytes[this._offset++] = (byte)(n >>> 24);
            this._bytes[this._offset++] = (byte)(n >>> 16);
            this._bytes[this._offset++] = (byte)(n >>> 8);
            this._bytes[this._offset++] = (byte)n;
            return;
        }
        this._bytes[this._offset++] = (byte)n;
        this._bytes[this._offset++] = (byte)(n >>> 8);
        this._bytes[this._offset++] = (byte)(n >>> 16);
        this._bytes[this._offset++] = (byte)(n >>> 24);
    }

    public void write_longlong(long l) {
        this.alignAndExtend(8, 8);
        if (!this._byteOrder) {
            this._bytes[this._offset++] = (byte)(l >>> 56);
            this._bytes[this._offset++] = (byte)(l >>> 48);
            this._bytes[this._offset++] = (byte)(l >>> 40);
            this._bytes[this._offset++] = (byte)(l >>> 32);
            this._bytes[this._offset++] = (byte)(l >>> 24);
            this._bytes[this._offset++] = (byte)(l >>> 16);
            this._bytes[this._offset++] = (byte)(l >>> 8);
            this._bytes[this._offset++] = (byte)l;
            return;
        }
        this._bytes[this._offset++] = (byte)l;
        this._bytes[this._offset++] = (byte)(l >>> 8);
        this._bytes[this._offset++] = (byte)(l >>> 16);
        this._bytes[this._offset++] = (byte)(l >>> 24);
        this._bytes[this._offset++] = (byte)(l >>> 32);
        this._bytes[this._offset++] = (byte)(l >>> 40);
        this._bytes[this._offset++] = (byte)(l >>> 48);
        this._bytes[this._offset++] = (byte)(l >>> 56);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        if (string == null) {
            if (this._orb.nullString) {
                this.write_long(0);
                return;
            }
            throw new BAD_PARAM("null Strings are illegal in IIOP.  Please correct your application or run the ORB in backward compatibility mode.");
        }
        int n = string.length() + 1;
        this.write_long(n);
        byte[] byArray = new byte[n];
        string.getBytes(0, n - 1, byArray, 0);
        byArray[n - 1] = 0;
        this.write_octet_array(byArray, 0, n);
    }

    public void write_wstring(String string) {
        if (string == null) {
            if (this._orb.nullString) {
                this.write_long(0);
                return;
            }
            throw new BAD_PARAM("null Strings are illegal in IIOP.  Please correct your application or run the ORB in backward compatibility mode.");
        }
        int n = string.length() + 1;
        this.write_long(n);
        char[] cArray = new char[n];
        string.getChars(0, n - 1, cArray, 0);
        cArray[n - 1] = '\u0000';
        this.write_wchar_array(cArray, 0, n);
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        int n3 = this._offset + n2;
        if (n3 >= this._bytes.length) {
            this.expand(n3);
        }
        System.arraycopy(byArray, n, this._bytes, this._offset, n2);
        this._offset = n3;
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_boolean(blArray[n3]);
            ++n3;
        }
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_char(cArray[n3]);
            ++n3;
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_wchar(cArray[n3]);
            ++n3;
        }
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_short(sArray[n3]);
            ++n3;
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_long(nArray[n3]);
            ++n3;
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_longlong(lArray[n3]);
            ++n3;
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_float(fArray[n3]);
            ++n3;
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_double(dArray[n3]);
            ++n3;
        }
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(int n) throws IOException {
        this.write_octet((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.write_octet_array(byArray, n, n2);
    }

    class EncapsulationState {
        int align;

        EncapsulationState(int n) {
            GiopOutputStreamImpl.this = GiopOutputStreamImpl.this;
            this.align = n;
        }
    }
}

