/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.GIOP.MsgType;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.GarbageCollector;
import com.visigenic.vbroker.orb.GiopConnection;
import com.visigenic.vbroker.orb.GiopConnectionFactory;
import com.visigenic.vbroker.orb.GiopMessage;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.GiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.ProtocolManager;
import com.visigenic.vbroker.util.PropertyManager;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_RESOURCES;

public class GiopConnectionFactoryImpl
implements Observer,
GiopConnectionFactory,
OrbObject,
GarbageCollector.Collectable {
    protected Hashtable _activeConnections = new Hashtable();
    protected Dictionary _cachedConnections = new Hashtable();
    protected MessagePool _messagePool;
    protected BufferPool _bufferPool;
    protected ORB _orb;
    protected int _bufferSize;
    protected int _maxConnections;
    protected int _connectionIdleTime;
    protected long _timeStamp;
    protected int _maxCache;
    protected final Object connectionLock = new Object();
    private static final byte[] HEADER = new byte[]{71, 73, 79, 80, 1, 0};
    private static final byte[] LENGTH = new byte[]{0, 0, 0, 0};

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        PropertyManager propertyManager = this._orb.getPropertyManager();
        this.update(propertyManager, "ORBmbufSize");
        this.update(propertyManager, "ORBconnectionMax");
        this.update(propertyManager, "ORBconnectionMaxIdle");
        this.update(propertyManager, "ORBconnectionCacheMax");
        this._orb.garbageCollector().addCollectable(this);
    }

    public void collect(long l) {
        if (this._connectionIdleTime == 0) {
            return;
        }
        Object object = this.connectionLock;
        synchronized (object) {
            Enumeration enumeration = this._cachedConnections.elements();
            while (enumeration.hasMoreElements()) {
                GiopConnection giopConnection = (GiopConnection)enumeration.nextElement();
                if (l - giopConnection.lastUsed() <= (long)this._connectionIdleTime) continue;
                Connection connection = giopConnection.connection();
                TaggedProfile taggedProfile = connection.getPeerProfile();
                ConnectionFactory connectionFactory = this._orb.protocolManager().getProtocol(taggedProfile).connectionFactory();
                Object object2 = connectionFactory.hashEndpoint(taggedProfile);
                this._cachedConnections.remove(object2);
                giopConnection.close();
            }
            return;
        }
    }

    private void closeOldestConnection() {
        Cloneable cloneable;
        Cloneable cloneable2 = null;
        Dictionary dictionary = null;
        dictionary = this._cachedConnections.size() > 0 ? this._cachedConnections : this._activeConnections;
        Enumeration enumeration = dictionary.elements();
        long l = System.currentTimeMillis();
        while (enumeration.hasMoreElements()) {
            cloneable = (GiopConnection)enumeration.nextElement();
            if (cloneable.inUse() || cloneable.lastUsed() >= l) continue;
            l = cloneable.lastUsed();
            cloneable2 = cloneable;
        }
        if (cloneable2 == null) {
            throw new NO_RESOURCES("Too many connections in use");
        }
        cloneable = cloneable2.connection();
        TaggedProfile taggedProfile = cloneable.getPeerProfile();
        ConnectionFactory connectionFactory = this._orb.protocolManager().getProtocol(taggedProfile).connectionFactory();
        Object object = connectionFactory.hashEndpoint(taggedProfile);
        dictionary.remove(object);
        cloneable2.close();
    }

    protected Connection connect(ConnectionFactory connectionFactory, TaggedProfile taggedProfile) {
        return connectionFactory.connect(taggedProfile);
    }

    public GiopConnection connect(TaggedProfile taggedProfile) {
        ConnectionFactory connectionFactory = null;
        ProtocolManager.Protocol protocol = this._orb.protocolManager().getProtocol(taggedProfile);
        if (protocol == null || !(protocol instanceof GiopProtocol)) {
            throw new BAD_PARAM("GiopConnectionFactory: trying to connect using unknown protocol");
        }
        connectionFactory = protocol.connectionFactory();
        Object object = connectionFactory.hashEndpoint(taggedProfile);
        Object object2 = this.connectionLock;
        synchronized (object2) {
            GiopConnection giopConnection = (GiopConnection)this._activeConnections.get(object);
            if (giopConnection == null) {
                giopConnection = (GiopConnection)this._cachedConnections.remove(object);
                if (giopConnection != null) {
                    if (this._orb.debug) {
                        this._orb.println("Found cached connection: " + giopConnection);
                    }
                    this._activeConnections.put(object, giopConnection);
                }
            } else if (this._orb.debug) {
                this._orb.println("Found active connection: " + giopConnection);
            }
            if (giopConnection == null) {
                if (this._maxConnections != 0 && this._activeConnections.size() + this._cachedConnections.size() >= this._maxConnections) {
                    this.closeOldestConnection();
                }
                Connection connection = this.connect(connectionFactory, taggedProfile);
                Object[] objectArray = new Object[]{connection, this};
                giopConnection = (GiopConnection)this._orb.create(32, objectArray);
                if (this._orb.debug) {
                    this._orb.println("Adding to active connections: " + connection);
                }
                this._activeConnections.put(object, giopConnection);
            } else {
                giopConnection.duplicate();
            }
            GiopConnection giopConnection2 = giopConnection;
            Object var7_10 = null;
            return giopConnection2;
        }
    }

    public GiopConnection create(Connection connection) {
        Object[] objectArray = new Object[]{connection, this};
        return (GiopConnection)this._orb.create(32, objectArray);
    }

    public void destroy(GiopConnection giopConnection, boolean bl) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (giopConnection.refCount() == 0 || bl) {
                if (!this._activeConnections.contains(giopConnection)) {
                    Object var4_4 = null;
                    return;
                }
                TaggedProfile taggedProfile = giopConnection.connection().getPeerProfile();
                Object object2 = this._orb.protocolManager().getProtocol(taggedProfile).connectionFactory().hashEndpoint(taggedProfile);
                if (this._activeConnections.remove(object2) != giopConnection) {
                    throw new INTERNAL();
                }
                if (!bl) {
                    if (this._maxCache > 0 && this._cachedConnections.size() > this._maxCache) {
                        this.closeOldestConnection();
                    }
                    if (this._orb.debug) {
                        this._orb.println("Caching connection: " + giopConnection);
                    }
                    this._cachedConnections.put(object2, giopConnection);
                }
            }
            return;
        }
    }

    public void close(GiopConnection giopConnection) {
        giopConnection.connection().close();
    }

    public synchronized GiopMessage getMessage() {
        if (this._messagePool == null) {
            return new MessagePool(this._orb, new byte[this._bufferSize]);
        }
        MessagePool messagePool = this._messagePool;
        this._messagePool = messagePool.next;
        return messagePool;
    }

    synchronized void addMessage(GiopMessage giopMessage) {
        MessagePool messagePool = (MessagePool)giopMessage;
        messagePool.next = this._messagePool;
        this._messagePool = messagePool;
    }

    public void release(GiopOutputStream giopOutputStream) {
        if (giopOutputStream.bytes().length <= this._bufferSize) {
            BufferPool bufferPool = new BufferPool();
            bufferPool.output = giopOutputStream;
            GiopConnectionFactoryImpl giopConnectionFactoryImpl = this;
            synchronized (giopConnectionFactoryImpl) {
                bufferPool.next = this._bufferPool;
                this._bufferPool = bufferPool;
                return;
            }
        }
    }

    public GiopOutputStream newMessage(MsgType msgType, boolean bl) {
        GiopOutputStream giopOutputStream;
        GiopConnectionFactoryImpl giopConnectionFactoryImpl = this;
        synchronized (giopConnectionFactoryImpl) {
            if (this._bufferPool != null) {
                giopOutputStream = this._bufferPool.output;
                this._bufferPool = this._bufferPool.next;
            } else {
                giopOutputStream = this._orb.newGiopOutputStream();
            }
        }
        giopOutputStream.offset(0);
        giopOutputStream.byteOrder(bl);
        giopOutputStream.write_octet_array(HEADER, 0, HEADER.length);
        giopOutputStream.write_octet((byte)(bl ? 1 : 0));
        giopOutputStream.write_octet((byte)msgType.value());
        giopOutputStream.write_octet_array(LENGTH, 0, LENGTH.length);
        return giopOutputStream;
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        PropertyManager propertyManager = (PropertyManager)observable;
        if (string.equals("ORBmbufSize")) {
            this._bufferSize = propertyManager.getInt(string);
            return;
        }
        if (string.equals("ORBconnectionMax")) {
            this._maxConnections = propertyManager.getInt(string);
            return;
        }
        if (string.equals("ORBconnectionMaxIdle")) {
            this._connectionIdleTime = propertyManager.getInt(string);
            this._connectionIdleTime *= 1000;
            return;
        }
        if (string.equals("ORBconnectionCacheMax")) {
            this._maxCache = propertyManager.getInt(string);
        }
    }

    private class MessagePool
    extends GiopMessage {
        MessagePool next;

        MessagePool(ORB oRB, byte[] byArray) {
            super(oRB, byArray);
            GiopConnectionFactoryImpl.this = GiopConnectionFactoryImpl.this;
        }

        public void release() {
            GiopConnectionFactoryImpl.this.addMessage(this);
        }
    }

    private class BufferPool {
        GiopOutputStream output;
        BufferPool next;

        BufferPool() {
            GiopConnectionFactoryImpl.this = GiopConnectionFactoryImpl.this;
        }
    }
}

