/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ServerThreadInfo;
import com.visigenic.vbroker.orb.ThreadLocal;
import com.visigenic.vbroker.orb.ThreadPool;
import com.visigenic.vbroker.util.PropertyManager;
import java.util.Observable;
import java.util.Observer;

public class AdapterThreadPool
extends ThreadPool
implements Observer {
    private ORB _orb;
    private Adapter _adapter;
    private int _connectionCount;
    private int _threadMax;

    public AdapterThreadPool(ORB oRB, Adapter adapter) {
        this._orb = oRB;
        PropertyManager propertyManager = adapter.getPropertyManager();
        this.update(propertyManager, "OAthreadMin");
        this.update(propertyManager, "OAthreadMax");
        this.update(propertyManager, "OAthreadMaxIdle");
        propertyManager.addObserver(this);
    }

    public ThreadLocal tls() {
        return ServerThreadInfo.instance(this._orb);
    }

    public synchronized void addConnection() {
        ++this._connectionCount;
        if (this._threadMax > 0) {
            this.maxThreads(this._threadMax + this._connectionCount);
        }
    }

    public synchronized void removeConnection() {
        --this._connectionCount;
        if (this._threadMax > 0) {
            this.maxThreads(this._threadMax + this._connectionCount);
        }
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        PropertyManager propertyManager = (PropertyManager)observable;
        if (string.equals("OAthreadMin")) {
            this.minThreads(propertyManager.getInt(string));
            return;
        }
        if (string.equals("OAthreadMax")) {
            this._threadMax = propertyManager.getInt(string);
            if (this._threadMax > 0) {
                this.maxThreads(this._threadMax + this._connectionCount);
                return;
            }
        } else if (string.equals("OAthreaadMaxIdle")) {
            this.threadIdleTime(propertyManager.getInt(string) * 1000);
        }
    }
}

