/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.interceptor;

import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.interceptor.ChainBindInterceptor;
import com.visigenic.vbroker.interceptor.ChainBindInterceptorHelper;
import com.visigenic.vbroker.interceptor.ChainClientInterceptorFactory;
import com.visigenic.vbroker.interceptor.ChainClientInterceptorFactoryHelper;
import com.visigenic.vbroker.interceptor.ChainServerInterceptorFactory;
import com.visigenic.vbroker.interceptor.ChainServerInterceptorFactoryHelper;
import com.visigenic.vbroker.interceptor.ClientEventHandler;
import com.visigenic.vbroker.interceptor.ConnectionInfo;
import com.visigenic.vbroker.interceptor.EventBindInterceptor;
import com.visigenic.vbroker.interceptor.HandlerExists;
import com.visigenic.vbroker.interceptor.HandlerRegistry;
import com.visigenic.vbroker.interceptor.HandlerRegistryClientFactory;
import com.visigenic.vbroker.interceptor.HandlerRegistryServerFactory;
import com.visigenic.vbroker.interceptor.ImplEventHandler;
import com.visigenic.vbroker.interceptor.InvalidObject;
import com.visigenic.vbroker.interceptor.NoHandler;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ProtocolManager;
import com.visigenic.vbroker.orb.PseudoObject;
import com.visigenic.vbroker.orb.ServerThreadInfo;
import java.util.Hashtable;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Skeleton;

public class HandlerRegistryImpl
extends PseudoObject
implements HandlerRegistry {
    private ORB _orb;
    Hashtable _clientHandlers = new Hashtable();
    Hashtable _implHandlers = new Hashtable();
    ClientEventHandler _globalClientHandler;
    ImplEventHandler _globalImplHandler;

    public HandlerRegistryImpl(ORB oRB) {
        this._orb = oRB;
        try {
            ChainBindInterceptor chainBindInterceptor = ChainBindInterceptorHelper.narrow(this._orb.resolve_initial_references("ChainBindInterceptor"));
            chainBindInterceptor.add(new EventBindInterceptor(this._orb, this));
            ChainClientInterceptorFactory chainClientInterceptorFactory = ChainClientInterceptorFactoryHelper.narrow(this._orb.resolve_initial_references("ChainClientInterceptorFactory"));
            chainClientInterceptorFactory.add(new HandlerRegistryClientFactory(this._orb, this));
            ChainServerInterceptorFactory chainServerInterceptorFactory = ChainServerInterceptorFactoryHelper.narrow(this._orb.resolve_initial_references("ChainServerInterceptorFactory"));
            chainServerInterceptorFactory.add(new HandlerRegistryServerFactory(this._orb, this));
            return;
        }
        catch (InvalidName invalidName) {
            throw new INITIALIZE("Chain Interceptors are not installed");
        }
    }

    public synchronized ClientEventHandler get_obj_client_handler(Object object) {
        return (ClientEventHandler)this._clientHandlers.get(object);
    }

    public synchronized ImplEventHandler get_obj_impl_handler(Object object) {
        return (ImplEventHandler)this._implHandlers.get(object);
    }

    public synchronized ClientEventHandler get_glob_client_handler() {
        return this._globalClientHandler;
    }

    public synchronized ImplEventHandler get_glob_impl_handler() {
        return this._globalImplHandler;
    }

    public synchronized void reg_obj_client_handler(Object object, ClientEventHandler clientEventHandler) throws HandlerExists, InvalidObject {
        if (clientEventHandler == null) {
            throw new BAD_PARAM("Handler is null");
        }
        if (object == null || !(object instanceof ObjectImpl) || object instanceof Skeleton) {
            throw new InvalidObject();
        }
        if (this._clientHandlers.get(object) != null) {
            throw new HandlerExists();
        }
        this._clientHandlers.put(object, clientEventHandler);
    }

    public synchronized void reg_obj_impl_handler(Object object, ImplEventHandler implEventHandler) throws HandlerExists, InvalidObject {
        if (implEventHandler == null) {
            throw new BAD_PARAM("Handler is null");
        }
        if (object == null || !(object instanceof Skeleton) && !(object instanceof DynamicImplementation)) {
            throw new InvalidObject();
        }
        if (this._implHandlers.get(object) != null) {
            throw new HandlerExists();
        }
        this._implHandlers.put(object, implEventHandler);
    }

    public synchronized void reg_glob_client_handler(ClientEventHandler clientEventHandler) throws HandlerExists {
        if (clientEventHandler == null) {
            throw new BAD_PARAM("Handler is null");
        }
        if (this._globalClientHandler != null) {
            throw new HandlerExists();
        }
        this._globalClientHandler = clientEventHandler;
    }

    public synchronized void reg_glob_impl_handler(ImplEventHandler implEventHandler) throws HandlerExists {
        if (implEventHandler == null) {
            throw new BAD_PARAM("Handler is null");
        }
        if (this._globalImplHandler != null) {
            throw new HandlerExists();
        }
        this._globalImplHandler = implEventHandler;
    }

    public synchronized void unreg_obj_client_handler(Object object) throws NoHandler, InvalidObject {
        if (object == null) {
            throw new InvalidObject();
        }
        if (this._clientHandlers.remove(object) == null) {
            throw new NoHandler();
        }
    }

    public synchronized void unreg_obj_impl_handler(Object object) throws NoHandler, InvalidObject {
        if (object == null) {
            throw new InvalidObject();
        }
        if (this._implHandlers.remove(object) == null) {
            throw new NoHandler();
        }
    }

    public synchronized void unreg_glob_client_handler() throws NoHandler {
        if (this._globalClientHandler == null) {
            throw new NoHandler();
        }
        this._globalClientHandler = null;
    }

    public synchronized void unreg_glob_impl_handler() throws NoHandler {
        if (this._globalImplHandler == null) {
            throw new NoHandler();
        }
        this._globalImplHandler = null;
    }

    public ConnectionInfo get_client_info(Object object) {
        ServerThreadInfo serverThreadInfo = (ServerThreadInfo)this._orb.getThreadLocalObject("com.visigenic.vbroker.orb.ServerThreadInfo");
        if (serverThreadInfo != null && serverThreadInfo.target == object && serverThreadInfo.connection != null) {
            TaggedProfile taggedProfile = serverThreadInfo.connection.getPeerProfile();
            ProtocolManager.Protocol protocol = this._orb.protocolManager().getProtocol(taggedProfile);
            if (protocol instanceof IiopProtocol) {
                IiopProtocol iiopProtocol = (IiopProtocol)protocol;
                ProfileBody profileBody = iiopProtocol.profileBody(taggedProfile);
                return new ConnectionInfo(profileBody.host, iiopProtocol.port(profileBody));
            }
        }
        return null;
    }
}

