/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.activationImpl.OADaccessor;
import com.visigenic.vbroker.extension.CreationImplDef;
import com.visigenic.vbroker.extension.CreationImplDefHelper;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.ORB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;

class Repository {
    private File _rep_file;
    private File _backup_file;
    private ORB _orb;
    private boolean _verbose;

    Repository(ORB oRB, boolean bl, String string, String string2) {
        this._rep_file = new File(string, string2);
        this._backup_file = new File(string, String.valueOf(string2) + ".tmp");
        File file = new File(string);
        if (!(file.isDirectory() && file.canWrite() && file.canRead())) {
            throw new NO_PERMISSION("OAD needs read/write permission for directory [" + string + "]");
        }
        this._orb = oRB;
        this._verbose = bl;
    }

    Vector ReadImpls() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this._rep_file);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            GiopInputStream giopInputStream = this._orb.newGiopInputStream(byArray);
            if (this._verbose) {
                System.out.println("Repository: Read " + byArray.length + " bytes");
            }
            int n = giopInputStream.read_long();
            if (this._verbose) {
                System.out.println("Repository: Contains " + n + " impldefs");
            }
            Vector<CreationImplDef> vector = new Vector<CreationImplDef>(n);
            int n2 = 0;
            while (n2 < n) {
                CreationImplDef creationImplDef = CreationImplDefHelper.read(giopInputStream);
                if (this._verbose) {
                    System.out.println("Repository: Adding impl #" + (n2 + 1) + "=" + OADaccessor.PrintImpl(creationImplDef));
                }
                vector.addElement(creationImplDef);
                ++n2;
            }
            return vector;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File \"" + this._rep_file + "\" does not exist");
            return new Vector(0);
        }
        catch (IOException iOException) {
            if (this._verbose) {
                System.out.println("File \"" + this._rep_file + "\" is not a valid implementation repository.\n" + "(Be sure to convert VisiCpp2.0 impl_rep files using 'oad_upd')");
            }
            throw new INTERNAL(iOException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new INTERNAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    void UpdateRepository(Vector vector) {
        try {
            GiopOutputStream giopOutputStream = this._orb.newGiopOutputStream();
            giopOutputStream.write_long(vector.size());
            int n = 0;
            while (n < vector.size()) {
                CreationImplDefHelper.write(giopOutputStream, (CreationImplDef)vector.elementAt(n));
                ++n;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this._backup_file);
            fileOutputStream.write(giopOutputStream.toByteArray());
            fileOutputStream.close();
            if (this._orb.getBoolean("JDKrenameBug") && this._rep_file.exists() && !this._rep_file.delete()) {
                System.out.println("Workaround for JDK1.1 bug #4017593 failed:");
                System.out.println("File \"" + this._rep_file + "\" exists but could not be deleted.");
                System.out.println("This file must be deleted for subsequent rename to succeed.");
            }
            if (!this._backup_file.renameTo(this._rep_file)) {
                System.out.println("Could not create repository file \"" + this._rep_file + "\".  Backup is stored in file \"" + this._backup_file + "\"");
                throw new BAD_PARAM("Could not create repository file \"" + this._rep_file + "\"");
            }
        }
        catch (IOException iOException) {
            if (this._verbose) {
                System.out.println("Exception during update of repository file \"" + this._rep_file + "\":" + iOException);
            }
            throw new INTERNAL(iOException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new INTERNAL(arrayIndexOutOfBoundsException.toString());
        }
    }
}

