/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.Activation.Busy;
import com.visigenic.vbroker.Activation.DuplicateEntry;
import com.visigenic.vbroker.Activation.FailedToExecute;
import com.visigenic.vbroker.Activation.ImplementationStatus;
import com.visigenic.vbroker.Activation.InvalidPath;
import com.visigenic.vbroker.Activation.IsActive;
import com.visigenic.vbroker.Activation.NotRegistered;
import com.visigenic.vbroker.Activation.NotResponding;
import com.visigenic.vbroker.Activation._OADImplBase;
import com.visigenic.vbroker.activationImpl.Forwarder;
import com.visigenic.vbroker.activationImpl.ForwarderFactory;
import com.visigenic.vbroker.activationImpl.OADInterceptorFactory;
import com.visigenic.vbroker.activationImpl.OADaccessor;
import com.visigenic.vbroker.activationImpl.Repository;
import com.visigenic.vbroker.extension.CreationImplDef;
import com.visigenic.vbroker.extension.CreationImplDefImpl;
import com.visigenic.vbroker.extension.Policy;
import com.visigenic.vbroker.interceptor.ChainServerInterceptorFactoryHelper;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.PrintVersion;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.BindOptions;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

class OADImpl
extends _OADImplBase {
    int DEFAULT_TIMEOUT = 20;
    private boolean _verbose;
    private ORB _orb;
    private String _rep_filename;
    private String _rep_path;
    private int _timeout;
    private Repository _repository;
    private ForwarderFactory _forwarderFact;
    private boolean _kill_on_unregister;
    private boolean _verify_registration;
    private String _ior_file;
    private Hashtable _impldefs;

    OADImpl(ORB oRB, String[] stringArray) {
        super(oRB.getLocalHost());
        this._orb = oRB;
        this._timeout = this.DEFAULT_TIMEOUT;
        this._verbose = false;
        this._rep_path = null;
        this._rep_filename = null;
        this._repository = null;
        this._kill_on_unregister = false;
        this._verify_registration = true;
        if (!this._parseArgs(stringArray)) {
            this._printUsage();
            System.exit(1);
        }
        this._impldefs = new Hashtable();
        try {
            ChainServerInterceptorFactoryHelper.narrow(oRB.resolve_initial_references("ChainServerInterceptorFactory")).add(new OADInterceptorFactory(this, oRB, this._verbose));
        }
        catch (InvalidName invalidName) {
            throw new INITIALIZE("Chain interceptors not installed: " + invalidName);
        }
        if (this._verbose) {
            System.out.println("OAD initializing:\n   path=" + oRB.getString("OAD_PATH") + "\n" + "   classpath=" + System.getProperty("java.class.path") + "\n" + "   vbj path=" + oRB.getString("OAD_VBJ") + "\n" + "   VBROKER_ADM=" + oRB.getString("VBROKER_ADM") + "\n" + "   VBROKER_IMPL_PATH=" + oRB.getString("VBROKER_IMPL_PATH") + "\n" + "   VBROKER_IMPL_NAME=" + oRB.getString("VBROKER_IMPL_NAME"));
            System.out.println();
        }
    }

    public void SetFactory(ForwarderFactory forwarderFactory) {
        this._forwarderFact = forwarderFactory;
        this._forwarderFact.destroy_on_removal(this._kill_on_unregister);
    }

    public void SetRepository(String string, String string2) {
        if (this._rep_path == null) {
            this._rep_path = string;
        }
        if (this._rep_filename == null) {
            if (string2 != null) {
                this._rep_filename = string2;
            } else {
                if (this.Verbose()) {
                    System.out.println("No repository will be created for this Activation Daemon");
                }
                return;
            }
        }
        this._repository = new Repository((ORB)this._orb(), this.Verbose(), this._rep_path, this._rep_filename);
        try {
            Vector vector = this._repository.ReadImpls();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CreationImplDef creationImplDef = (CreationImplDef)enumeration.nextElement();
                try {
                    this._registerImpl(creationImplDef, false);
                }
                catch (InvalidPath invalidPath) {
                    System.out.println("**Ignoring registration due to invalid executable path: \n" + OADaccessor.PrintImpl(creationImplDef));
                }
                catch (DuplicateEntry duplicateEntry) {
                    System.out.println("**Ignoring registration (already registered) executable path: \n" + OADaccessor.PrintImpl(creationImplDef));
                }
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new INTERNAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public CreationImplDef create_CreationImplDef() {
        return new CreationImplDefImpl();
    }

    public Object reg_implementation(CreationImplDef creationImplDef) throws DuplicateEntry, InvalidPath {
        this._registerImpl(creationImplDef, true);
        BindOptions bindOptions = new BindOptions(true, false);
        bindOptions.defer_bind = true;
        return this._orb.bind(creationImplDef.repository_id(), creationImplDef.object_name(), null, bindOptions);
    }

    public void unreg_implementation(String string, String string2) throws NotRegistered {
        this._removeImplementation(string, string2, false);
    }

    public void unreg_interface(String string) throws NotRegistered {
        Hashtable hashtable = this._implsForRepid(string);
        this._impldefs.remove(string);
        Enumeration enumeration = hashtable.elements();
        this._deactivateForwarders(enumeration);
        if (this._repository != null) {
            this._repository.UpdateRepository(this.allImpls());
        }
        if (this.Verbose()) {
            System.out.println("Unregistered all implementations from OAD for repository ID: " + string);
        }
    }

    public CreationImplDef get_implementation(String string, String string2) throws NotRegistered {
        return this._getForwarder(string, string2).registration_info();
    }

    public void change_implementation(CreationImplDef creationImplDef, CreationImplDef creationImplDef2) throws NotRegistered, InvalidPath, IsActive {
        if (!this._removeImplementation(creationImplDef.repository_id(), creationImplDef.object_name(), true)) {
            throw new IsActive();
        }
        try {
            this.reg_implementation(creationImplDef2);
            return;
        }
        catch (DuplicateEntry duplicateEntry) {
            throw new INTERNAL(duplicateEntry.toString());
        }
    }

    public void destroy_on_unregister(boolean bl) {
        this._forwarderFact.destroy_on_removal(bl);
    }

    public boolean destroy_on_unregister() {
        return this._forwarderFact.destroy_on_removal();
    }

    public void unregister_all() {
        Hashtable hashtable = this._impldefs;
        synchronized (hashtable) {
            try {
                Enumeration enumeration = this._impldefs.elements();
                while (enumeration.hasMoreElements()) {
                    Hashtable hashtable2 = (Hashtable)enumeration.nextElement();
                    Enumeration enumeration2 = hashtable2.elements();
                    this._deactivateForwarders(enumeration2);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new INTERNAL(noSuchElementException.toString());
            }
            this._impldefs.clear();
            if (this._repository != null) {
                this._repository.UpdateRepository(this.allImpls());
            }
        }
        if (this.Verbose()) {
            System.out.println("Unregistered all implementations");
        }
    }

    public ImplementationStatus get_status(String string, String string2) throws NotRegistered {
        return this._getForwarder(string, string2).status();
    }

    public ImplementationStatus[] get_status_interface(String string) throws NotRegistered {
        Enumeration enumeration;
        ImplementationStatus[] implementationStatusArray;
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = this._implsForRepid(string);
        synchronized (hashtable2) {
            implementationStatusArray = new ImplementationStatus[hashtable.size()];
            enumeration = hashtable.elements();
        }
        int n = 0;
        while (enumeration.hasMoreElements()) {
            try {
                Forwarder forwarder = (Forwarder)enumeration.nextElement();
                implementationStatusArray[n] = forwarder.status();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new INTERNAL(arrayIndexOutOfBoundsException.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new INTERNAL(noSuchElementException.toString());
            }
            ++n;
        }
        return implementationStatusArray;
    }

    public ImplementationStatus[] get_status_all() {
        java.lang.Object object;
        ImplementationStatus[] implementationStatusArray;
        Vector vector = new Vector();
        try {
            implementationStatusArray = this._impldefs.elements();
            while (implementationStatusArray.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)implementationStatusArray.nextElement();
                object = hashtable.elements();
                while (object.hasMoreElements()) {
                    vector.addElement(object.nextElement());
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new INTERNAL(noSuchElementException.toString());
        }
        implementationStatusArray = new ImplementationStatus[vector.size()];
        try {
            int n = 0;
            while (n < vector.size()) {
                object = (Forwarder)vector.elementAt(n);
                implementationStatusArray[n] = object.status();
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new INTERNAL(arrayIndexOutOfBoundsException.toString());
        }
        return implementationStatusArray;
    }

    public boolean verify_registration() {
        return this._verify_registration;
    }

    public Object lookup_interface(String string, int n) throws NotRegistered, FailedToExecute, NotResponding, Busy {
        Hashtable hashtable = this._implsForRepid(string);
        Forwarder forwarder = null;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                forwarder = (Forwarder)enumeration.nextElement();
                if (forwarder.registration_info().activation_policy() != Policy.SHARED_SERVER || !forwarder.isActive()) continue;
                break;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new INTERNAL(noSuchElementException.toString());
            }
        }
        if (forwarder == null) {
            throw new NotRegistered();
        }
        return forwarder.getObject();
    }

    public Object lookup_implementation(String string, String string2, int n) throws NotRegistered, FailedToExecute, NotResponding, Busy {
        Forwarder forwarder = this._getForwarder(string, string2);
        return forwarder.getObject();
    }

    public CreationImplDef boa_activate_obj(Object object, String string, int n) throws NotRegistered {
        try {
            if (object instanceof Forwarder) {
                if (this.Verbose()) {
                    System.out.println("Registration of forwarder [" + object + ";" + string + "]");
                }
                throw new NotRegistered();
            }
            Forwarder forwarder = this._getForwarder(string, object._object_name());
            forwarder.setObject(n, object);
            return forwarder.registration_info();
        }
        catch (RuntimeException runtimeException) {
            System.out.println("Caught excep: " + runtimeException);
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    public void boa_deactivate_obj(Object object, String string, int n) throws NotRegistered {
        Forwarder forwarder = this._getForwarder(string, object._object_name());
        forwarder.removeChild(n, object);
    }

    int Timeout() {
        return this._timeout;
    }

    boolean Verbose() {
        return this._verbose;
    }

    private boolean _parseArgs(String[] stringArray) {
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-version")) {
                    PrintVersion.main(stringArray);
                    System.exit(0);
                } else if (stringArray[n].startsWith("-v")) {
                    this._verbose = true;
                } else if (stringArray[n].startsWith("-t")) {
                    this._timeout = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].startsWith("-f")) {
                    this._rep_filename = stringArray[++n];
                } else if (stringArray[n].startsWith("-p")) {
                    this._rep_path = stringArray[++n];
                } else if (stringArray[n].startsWith("-k")) {
                    this._kill_on_unregister = true;
                } else if (stringArray[n].startsWith("-no_verify")) {
                    this._verify_registration = false;
                } else if (stringArray[n].startsWith("-IOR")) {
                    this._ior_file = new String(stringArray[++n]);
                } else {
                    if (stringArray[n].startsWith("-help") || stringArray[n].startsWith("-usage")) {
                        return false;
                    }
                    System.out.println("Invalid argument '" + stringArray[n] + "'");
                    return false;
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Missing value for argument: " + stringArray[n - 1]);
            return false;
        }
        return true;
    }

    private void _printUsage() {
        System.out.println("Usage: oadj [-options]");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("    -?                       Prints usage information\n    -verbose                 Verbose mode prints debug information to console\n    -version                 Prints version information\n    -path <directory name>   Directory for storing implementation repository\n    -filename <rep filename> Filename for implementation repository\n    -timeout <integer>       Wait for 'integer' number of seconds for a\n                             spawned server to activate the required\n                             object before killing the server and throwing\n                             CORBA::NO_RESPONSE.  Default timeout is 20 seconds.\n                             A value of 0 forces OAD to wait without a timeout.\n    -kill                    Kill spawned servers on unregistration\n    -IOR <IOR filename> Filename for OADj's stringified IOR    -no_verify               Turns off check for validity of registrations\n");
    }

    Hashtable _implsForRepid(String string) throws NotRegistered {
        java.lang.Object v;
        if (this._orb.getBoolean("VisiCpp2Compat") && !string.startsWith("IDL:")) {
            string = this.StringToRepId(string);
        }
        if (this.Verbose()) {
            System.out.println("Looking up repository ID=" + string);
        }
        if ((v = this._impldefs.get(string)) == null) {
            throw new NotRegistered();
        }
        if (!(v instanceof Hashtable)) {
            throw new INTERNAL("Found object: " + v + " instead of hashtable for " + "repository ID: " + string);
        }
        return (Hashtable)v;
    }

    private String StringToRepId(String string) {
        String string2;
        if (string.startsWith("IDL:")) {
            return string;
        }
        String string3 = new String();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            if (string3.length() > 0) {
                string3 = string3.concat("/");
            }
            string3 = string3.concat(string2);
        }
        string2 = "IDL:" + string3 + ":1.0";
        if (this.Verbose()) {
            System.out.println("Converted {" + string + "} ===> {" + string2 + "}");
        }
        return string2;
    }

    Forwarder _fwdForObjectName(Hashtable hashtable, String string) throws NotRegistered {
        java.lang.Object v;
        if (this.Verbose()) {
            System.out.println("Looking up object name " + string);
        }
        if ((v = hashtable.get(string)) == null) {
            throw new NotRegistered();
        }
        if (!(v instanceof Forwarder)) {
            throw new INTERNAL("Found object: " + v + " instead of Forwarder for" + " object_name: " + string);
        }
        return (Forwarder)v;
    }

    private Forwarder _getForwarder(String string, String string2) throws NotRegistered {
        Hashtable hashtable = this._implsForRepid(string);
        return this._fwdForObjectName(hashtable, string2);
    }

    private Forwarder _registerImpl(CreationImplDef creationImplDef, boolean bl) throws InvalidPath, DuplicateEntry {
        Hashtable<String, java.lang.Object> hashtable;
        java.lang.Object object = creationImplDef;
        synchronized (object) {
            try {
                hashtable = this._implsForRepid(creationImplDef.repository_id());
            }
            catch (NotRegistered notRegistered) {
                hashtable = new Hashtable<String, java.lang.Object>();
                this._impldefs.put(creationImplDef.repository_id(), hashtable);
            }
        }
        Hashtable<String, java.lang.Object> hashtable2 = hashtable;
        synchronized (hashtable2) {
            try {
                object = this._fwdForObjectName(hashtable, creationImplDef.object_name());
                throw new DuplicateEntry();
            }
            catch (NotRegistered notRegistered) {
                object = this._forwarderFact.createForwarder(creationImplDef);
                hashtable.put(creationImplDef.object_name(), object);
            }
        }
        if (bl && this._repository != null) {
            this._repository.UpdateRepository(this.allImpls());
        }
        if (this.Verbose()) {
            System.out.println("New registration with OAD:\n" + OADaccessor.PrintImpl(creationImplDef));
        }
        return object;
    }

    private void _deactivateForwarders(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this._deactivateForwarder((Forwarder)enumeration.nextElement());
        }
    }

    private void _deactivateForwarder(Forwarder forwarder) {
        forwarder.removeChildren();
    }

    private boolean _removeImplementation(String string, String string2, boolean bl) throws NotRegistered {
        Hashtable hashtable = this._implsForRepid(string);
        Forwarder forwarder = this._fwdForObjectName(hashtable, string2);
        if (bl && forwarder.isActive()) {
            return false;
        }
        hashtable.remove(string2);
        this._deactivateForwarder(forwarder);
        if (hashtable.isEmpty()) {
            this._impldefs.remove(string);
        }
        if (this._repository != null) {
            this._repository.UpdateRepository(this.allImpls());
        }
        if (this.Verbose()) {
            System.out.println("Unregistered implementation from OAD for repository ID: " + string + "; object name: " + string2);
        }
        return true;
    }

    private Vector allImpls() {
        Vector<CreationImplDef> vector = new Vector<CreationImplDef>();
        try {
            Enumeration enumeration = this._impldefs.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)enumeration.nextElement();
                Enumeration enumeration2 = hashtable.elements();
                while (enumeration2.hasMoreElements()) {
                    Forwarder forwarder = (Forwarder)enumeration2.nextElement();
                    vector.addElement(forwarder.registration_info());
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new INTERNAL(noSuchElementException.toString());
        }
        return vector;
    }

    public String ior_file() {
        if (this._ior_file == null) {
            this._ior_file = new String("oadj.ior");
        }
        return this._ior_file;
    }
}

