/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.activationImpl.ExecForwarder;
import com.visigenic.vbroker.activationImpl.ExecInfo;
import com.visigenic.vbroker.activationImpl.ExecObjectStatusWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

class ExecPrinterThread
implements Runnable {
    private Vector _execs;
    private boolean _verbose;

    ExecPrinterThread(boolean bl) {
        this._verbose = bl;
        this._execs = new Vector();
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
        if (this._verbose) {
            System.out.println("OAD::PrinterThread:Started PrinterThread");
        }
    }

    void AddCommand(ExecForwarder execForwarder, ExecObjectStatusWrapper execObjectStatusWrapper, String[] stringArray) {
        InputStream inputStream = execObjectStatusWrapper._process.getInputStream();
        InputStream inputStream2 = execObjectStatusWrapper._process.getErrorStream();
        ExecInfo execInfo = new ExecInfo(execForwarder, execObjectStatusWrapper, stringArray, inputStream, inputStream2);
        System.out.println("#" + execInfo.unique_id + "=" + execInfo.command);
        this._execs.addElement(execInfo);
    }

    public void run() {
        while (true) {
            Enumeration enumeration = this._execs.elements();
            while (enumeration.hasMoreElements()) {
                ExecInfo execInfo = (ExecInfo)enumeration.nextElement();
                try {
                    this._printForInfo(execInfo);
                }
                catch (IOException iOException) {
                    execInfo.removeFromForwarder();
                }
                try {
                    int n = execInfo.exec.exitValue();
                    if (this._verbose) {
                        System.out.println("OAD::PrinterThread:(" + execInfo.command + ") exit=" + n);
                    }
                    execInfo.removeFromForwarder();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    void RemoveCommand(Process process) {
        ExecInfo execInfo = new ExecInfo(process);
        if (!this._execs.removeElement(execInfo) && this._verbose) {
            System.out.println("OAD::PrinterThread:RemoveCommand: Process not in list");
        }
    }

    private void _writeAvailableBytes(String string, InputStream inputStream) throws IOException {
        try {
            int n = 0;
            n = inputStream.available();
            if (n != 0) {
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                if (this._verbose) {
                    System.out.println(String.valueOf(string) + new String(byArray, 0));
                    System.out.println();
                    return;
                }
            }
        }
        catch (IOException iOException) {
            if (this._verbose) {
                System.out.println("OAD::PrinterThread:(" + string + ") exception=" + iOException);
            }
            throw iOException;
        }
    }

    private void _printForInfo(ExecInfo execInfo) throws IOException {
        this._writeAvailableBytes("#" + Integer.toString(execInfo.unique_id) + " output:\t", execInfo.output);
        this._writeAvailableBytes("#" + Integer.toString(execInfo.unique_id) + " error:\t", execInfo.error);
    }
}

