unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  HTTPApp, DBWeb, DBTables, Db;

type
  TCustomerInfoModule = class(TWebModule)
    Query1: TQuery;
    CustomerOrders: TQueryTableProducer;
    CustomerList: TPageProducer;
    Customer: TTable;
    CustomerCustNo: TFloatField;
    CustomerCompany: TStringField;
    CustSource: TDataSource;
    procedure CustomerListHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure DataModule1Create(Sender: TObject);
    procedure WebModule1CustomerListAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1QueryActionAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
  private
    ScriptName: String;
  public
    { Public declarations }
  end;

var
  CustomerInfoModule: TCustomerInfoModule;

implementation

{$R *.DFM}

procedure TCustomerInfoModule.CustomerListHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
var
  Customers: String;
begin
  if CompareText(TagString, 'CUSTLIST') = 0 then
  begin
    Customers := '';
    Customer.First;
    while not Customer.Eof do
    begin
      Customers := Customers + '<A HREF="' + ScriptName + '/runquery?CustNo=' +
        CustomerCustNo.AsString + '">' + CustomerCompany.AsString + '</A><BR>';
      Customer.Next;
    end;
  end;
  ReplaceText := Customers;
end;

procedure TCustomerInfoModule.DataModule1Create(Sender: TObject);
var
  FN: array[0..MAX_PATH- 1] of char;
begin
  Customer.Open;
  SetString(ScriptName, FN, GetModuleFileName(hInstance, FN, SizeOf(FN)));
  ScriptName := ExtractFileName(ScriptName);
end;

procedure TCustomerInfoModule.WebModule1CustomerListAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.Content := CustomerList.Content;
end;

procedure TCustomerInfoModule.WebModule1QueryActionAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  if Customer.Locate('CustNo', Request.QueryFields.Values['CustNo'], []) then
  begin
    CustomerOrders.Header.Clear;
    CustomerOrders.Header.Add('Orders for: ' + CustomerCompany.AsString);
    Response.Content := CustomerOrders.Content;
  end
  else
    Response.Content := Format('<html><body><b>Customer: %s not found</b></body></html>',
      [Request.QueryFields.Values['CustNo']]);
end;

end.
