unit ToolDockHost;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls;

type
  TToolForm = class(TForm)
    procedure FormDockDrop(Sender: TObject; Source: TDragDockObject; X,
      Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ToolForm: TToolForm;

implementation

{$R *.DFM}

uses Main;

procedure TToolForm.FormDockDrop(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer);
begin
  Caption := (Source.Control as TToolBar).Caption;
  (Source.Control as TToolBar).DragMode := dmManual;
  Visible := True;
end;

procedure TToolForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if ControlCount = 0 then
    Action := caFree
  else begin
    Action := caHide;
    MainForm.ViewToolbar1Execute(Sender);
  end;
end;

end.
