unit Memo_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Memo Editor Application }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_Memo: TGUID = '{55E49D30-9FFE-11D0-8095-0020AF74DE39}';

const

{ Component class GUIDs }
  Class_MemoApp: TGUID = '{F7FF4880-200D-11CF-BD2F-0020AF0E5B81}';
  Class_MemoDoc: TGUID = '{55E49D35-9FFE-11D0-8095-0020AF74DE39}';

type

{ Forward declarations: Interfaces }
  IMemoApp = interface;
  IMemoAppDisp = dispinterface;
  IMemoDoc = interface;
  IMemoDocDisp = dispinterface;

{ Forward declarations: CoClasses }
  MemoApp = IMemoApp;
  MemoDoc = IMemoDoc;

{ Dispatch interface for MemoApp Object }

  IMemoApp = interface(IDispatch)
    ['{55E49D31-9FFE-11D0-8095-0020AF74DE39}']
    function NewMemo: OleVariant; safecall;
    function OpenMemo(const FileName: WideString): OleVariant; safecall;
    procedure TileWindows; safecall;
    procedure CascadeWindows; safecall;
    function Get_MemoCount: Integer; safecall;
    function Get_Memos(Index: Integer): OleVariant; safecall;
    property MemoCount: Integer read Get_MemoCount;
    property Memos[Index: Integer]: OleVariant read Get_Memos;
  end;

{ DispInterface declaration for Dual Interface IMemoApp }

  IMemoAppDisp = dispinterface
    ['{55E49D31-9FFE-11D0-8095-0020AF74DE39}']
    function NewMemo: OleVariant; dispid 1;
    function OpenMemo(const FileName: WideString): OleVariant; dispid 2;
    procedure TileWindows; dispid 3;
    procedure CascadeWindows; dispid 4;
    property MemoCount: Integer readonly dispid 5;
    property Memos[Index: Integer]: OleVariant readonly dispid 6;
  end;

{ Dispatch interface for MemoDoc Object }

  IMemoDoc = interface(IDispatch)
    ['{55E49D34-9FFE-11D0-8095-0020AF74DE39}']
    procedure Clear; safecall;
    procedure Insert(const Text: WideString); safecall;
    procedure Save; safecall;
    procedure Close; safecall;
    function Get_FileName: WideString; safecall;
    procedure Set_FileName(const Value: WideString); safecall;
    function Get_Modified: WordBool; safecall;
    property FileName: WideString read Get_FileName write Set_FileName;
    property Modified: WordBool read Get_Modified;
  end;

{ DispInterface declaration for Dual Interface IMemoDoc }

  IMemoDocDisp = dispinterface
    ['{55E49D34-9FFE-11D0-8095-0020AF74DE39}']
    procedure Clear; dispid 1;
    procedure Insert(const Text: WideString); dispid 2;
    procedure Save; dispid 3;
    procedure Close; dispid 4;
    property FileName: WideString dispid 5;
    property Modified: WordBool readonly dispid 6;
  end;

{ MemoAppObject }

  CoMemoApp = class
    class function Create: IMemoApp;
    class function CreateRemote(const MachineName: string): IMemoApp;
  end;

{ MemoDocObject }

  CoMemoDoc = class
    class function Create: IMemoDoc;
    class function CreateRemote(const MachineName: string): IMemoDoc;
  end;



implementation

uses ComObj;

class function CoMemoApp.Create: IMemoApp;
begin
  Result := CreateComObject(Class_MemoApp) as IMemoApp;
end;

class function CoMemoApp.CreateRemote(const MachineName: string): IMemoApp;
begin
  Result := CreateRemoteComObject(MachineName, Class_MemoApp) as IMemoApp;
end;

class function CoMemoDoc.Create: IMemoDoc;
begin
  Result := CreateComObject(Class_MemoDoc) as IMemoDoc;
end;

class function CoMemoDoc.CreateRemote(const MachineName: string): IMemoDoc;
begin
  Result := CreateRemoteComObject(MachineName, Class_MemoDoc) as IMemoDoc;
end;


end.
