/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.fe.idl;

import com.visigenic.vbroker.util.fe.idl.IDLParser;
import com.visigenic.vbroker.util.fe.idl.IDLParserTreeConstants;
import com.visigenic.vbroker.util.fe.idl.Node;
import com.visigenic.vbroker.util.fe.idl.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected IDLParser parser;
    protected Token beginToken;
    protected Token endToken;
    protected String FileName;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(IDLParser iDLParser, int n) {
        this(n);
        this.parser = iDLParser;
    }

    public static Node jjtCreate(int n) {
        return new SimpleNode(n);
    }

    public static Node jjtCreate(IDLParser iDLParser, int n) {
        return new SimpleNode(iDLParser, n);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.length;
    }

    String context() {
        StringBuffer stringBuffer = new StringBuffer();
        Token token2 = this.beginToken;
        while (token2 != this.endToken) {
            stringBuffer.append(token2.image);
            if (stringBuffer.length() > 70) break;
            token2 = token2.next;
        }
        if (token2 != null && token2 == this.endToken) {
            stringBuffer.append(token2.image);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return IDLParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return String.valueOf(string) + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(String.valueOf(string) + " ");
                }
                ++n;
            }
        }
    }
}

