/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.orb.GarbageCollector;
import com.visigenic.vbroker.orb.Work;
import com.visigenic.vbroker.orb.WorkerThread;
import com.visigenic.vbroker.orb.WorkerThreadMonitor;

public class ThreadPool
extends WorkerThreadMonitor
implements GarbageCollector.Collectable {
    private WorkerThread[] _availableThreads = new WorkerThread[100];
    private int _numAvailable;
    private WorkerThread[] _pool = new WorkerThread[100];
    private int _poolSize;
    private int _maxThreads;
    private int _minThreads;
    private long _threadIdleTime = 300000L;
    private boolean _waiter = false;
    private long _lastCollectionTime = System.currentTimeMillis();

    public synchronized void collect(long l) {
        if (this._threadIdleTime == 0L) {
            return;
        }
        int n = (int)(l - this._lastCollectionTime);
        this._lastCollectionTime = l;
        int n2 = 0;
        while (n2 < this._poolSize) {
            if ((long)this._pool[n2].idleTime(n) >= this._threadIdleTime) {
                this.removeThread(this._pool[n2]);
            }
            ++n2;
        }
    }

    private void removeThread(WorkerThread workerThread) {
        int n;
        int n2 = 0;
        while (n2 < this._poolSize) {
            if (this._pool[n2] == workerThread) {
                n = this._poolSize - n2 - 1;
                if (n > 0) {
                    System.arraycopy(this._pool, n2 + 1, this._pool, n2, n);
                }
                --this._poolSize;
                break;
            }
            ++n2;
        }
        n = 0;
        while (n < this._numAvailable) {
            if (this._availableThreads[n] == workerThread) {
                int n3 = this._numAvailable - n - 1;
                if (n3 > 0) {
                    System.arraycopy(this._availableThreads, n + 1, this._availableThreads, n, n3);
                }
                --this._numAvailable;
                break;
            }
            ++n;
        }
        workerThread.exit();
    }

    public synchronized void available(WorkerThread workerThread) {
        if (this._maxThreads != 0 && this._poolSize > this._maxThreads) {
            this.removeThread(workerThread);
            return;
        }
        this._availableThreads[this._numAvailable++] = workerThread;
        if (this._waiter) {
            this.notify();
        }
    }

    private synchronized WorkerThread getThread() {
        while (this._numAvailable == 0) {
            if (this._maxThreads == 0 || this._poolSize < this._maxThreads) {
                Object object;
                if (this._pool.length <= this._poolSize) {
                    object = new WorkerThread[2 * this._pool.length];
                    System.arraycopy(this._pool, 0, object, 0, this._pool.length);
                    this._pool = object;
                    object = new WorkerThread[2 * this._pool.length];
                    System.arraycopy(this._availableThreads, 0, object, 0, this._availableThreads.length);
                    this._availableThreads = object;
                }
                WorkerThread workerThread = new WorkerThread(this);
                this._pool[this._poolSize++] = workerThread;
                object = workerThread;
                ((WorkerThread)object).start();
                return object;
            }
            this._waiter = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            this._waiter = false;
        }
        return this._availableThreads[--this._numAvailable];
    }

    public WorkerThread doWork(Work work) {
        WorkerThread workerThread = this.getThread();
        workerThread.doWork(work);
        return workerThread;
    }

    public void minThreads(int n) {
        this._minThreads = n;
    }

    public void maxThreads(int n) {
        this._maxThreads = n;
    }

    public void threadIdleTime(int n) {
        this._threadIdleTime = n;
    }

    public int allocatedThreads() {
        return this._poolSize;
    }
}

