/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ir;

import com.visigenic.vbroker.ir.RepositoryImpl;
import com.visigenic.vbroker.tools.ir.Language;
import com.visigenic.vbroker.util.gui.ConsoleOutput;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

class IrGui
extends Frame {
    private RepositoryImpl _rep;
    private TextField _in;
    private Button _lookup;
    private TextArea _display;
    private TextArea _out;
    private PrintStream _outStream;
    private final int _gap = 10;
    private Insets _insets = new Insets(70, 20, 20, 20);
    private static String MENU_FILE_LOAD = "Load...";
    private static String MENU_FILE_SAVE = "Save";
    private static String MENU_FILE_SAVE_AS = "Save As...";
    private static String MENU_FILE_EXIT = "Exit";
    private static String MENU_LANGUAGE_IDL = "IDL";
    private static String MENU_LANGUAGE_JAVA = "Java";
    private static String MENU_LANGUAGE_CPP = "C++";

    IrGui(String string, RepositoryImpl repositoryImpl) {
        super(string);
        if (repositoryImpl instanceof RepositoryImpl) {
            this._rep = repositoryImpl;
        } else {
            System.out.println("Invalid Repository");
            System.exit(0);
        }
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout(10, 10));
        ((Component)this).reshape(30, 30, 650, 550);
        Panel panel = new Panel();
        this.add("North", panel);
        panel.setLayout(new BorderLayout(10, 10));
        Label label = new Label("Name:");
        label.setAlignment(2);
        panel.add("West", label);
        this._in = new TextField();
        panel.add("Center", this._in);
        this._lookup = new Button("Lookup");
        panel.add("East", this._lookup);
        this._display = new TextArea(12, 80);
        this.add("Center", this._display);
        this._display.setEditable(false);
        this._out = new TextArea(5, 80);
        this.add("South", this._out);
        this._out.setEditable(false);
        this._outStream = new PrintStream(new ConsoleOutput(this._out, 1000));
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menu.add(new MenuItem(MENU_FILE_LOAD));
        menu.add(new MenuItem(MENU_FILE_SAVE));
        menu.add(new MenuItem(MENU_FILE_SAVE_AS));
        menu.add(new MenuItem("-"));
        menu.add(new MenuItem(MENU_FILE_EXIT));
        menuBar.add(menu);
        Menu menu2 = new Menu("Language");
        menu2.add(new MenuItem(MENU_LANGUAGE_IDL));
        menu2.add(new MenuItem(MENU_LANGUAGE_JAVA));
        menu2.add(new MenuItem(MENU_LANGUAGE_CPP));
        menuBar.add(menu2);
        this.setMenuBar(menuBar);
    }

    PrintStream out() {
        return this._outStream;
    }

    public Insets insets() {
        return this._insets;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            System.exit(0);
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof MenuItem) {
            String string = (String)object;
            if (string.equals(MENU_FILE_LOAD)) {
                FileDialog fileDialog = new FileDialog((Frame)this, "File Open Dialog");
                fileDialog.show();
                if (fileDialog.getFile() != null) {
                    this._rep.doLoad(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
                }
            } else if (string.startsWith(MENU_FILE_SAVE)) {
                if (this._rep.saveFileName() != null && string.equals(MENU_FILE_SAVE)) {
                    this._rep.doSave(this._rep.saveFileName());
                } else {
                    FileDialog fileDialog = new FileDialog((Frame)this, "File Open Dialog");
                    fileDialog.show();
                    if (fileDialog.getFile() != null) {
                        this._rep.doSave(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
                    }
                }
            } else if (string.equals(MENU_FILE_EXIT)) {
                this._rep.doExit();
            } else if (string.equals(MENU_LANGUAGE_IDL)) {
                this._rep.setLanguage(Language.Idl);
            } else if (string.equals(MENU_LANGUAGE_JAVA)) {
                this._rep.setLanguage(Language.Java);
            } else if (string.equals(MENU_LANGUAGE_CPP)) {
                this._rep.setLanguage(Language.Cpp);
            }
        } else if (event.target == this._lookup) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            this._rep.doLookup(this._in.getText(), printStream);
            this._display.setText(new String(byteArrayOutputStream.toByteArray(), 0));
        }
        return true;
    }
}

