/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.Activation.NotRegistered;
import com.visigenic.vbroker.Activation.OAD;
import com.visigenic.vbroker.Activation.OADHelper;
import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.activationImpl.PerMethodServerInterceptorFactory;
import com.visigenic.vbroker.activationImpl.UnsharedServerInterceptorFactory;
import com.visigenic.vbroker.extension.CreationImplDef;
import com.visigenic.vbroker.extension.Policy;
import com.visigenic.vbroker.interceptor.ChainServerInterceptorFactory;
import com.visigenic.vbroker.interceptor.ChainServerInterceptorFactoryHelper;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.SkeletonDelegate;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Skeleton;

public class OADUser {
    private OAD _oad;
    private boolean _hasLookedForOAD;
    private ORB _orb;
    private boolean debug;
    private Hashtable _registeredSkels;
    private ChainServerInterceptorFactory csif;

    OADUser(ORB oRB, boolean bl) {
        this._orb = oRB;
        this._oad = null;
        this._hasLookedForOAD = false;
        this._registeredSkels = new Hashtable();
        this.debug = bl;
    }

    public boolean informOAD(Skeleton skeleton, String string, boolean bl) {
        OAD oAD = this._getOAD();
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<String> vector = null;
        if (oAD != null) {
            int n = this._getActivationUID();
            if (bl) {
                if (this._registeredSkels.containsKey(string)) {
                    vector = (Vector<String>)this._registeredSkels.get(string);
                    bl3 = vector.contains(skeleton._object_name());
                }
                if (!bl3 && (bl2 = this._activateSkel(oAD, skeleton, string, n))) {
                    if (vector == null) {
                        vector = new Vector<String>();
                        this._registeredSkels.put(string, vector);
                    }
                    vector.addElement(skeleton._object_name());
                }
            } else {
                bl2 = this._deactivateSkel(oAD, skeleton, string, n);
                if (bl2 && this._registeredSkels.containsKey(string) && (vector = (Vector)this._registeredSkels.get(string)).contains(skeleton._object_name())) {
                    vector.removeElement(skeleton._object_name());
                }
            }
        }
        return bl2;
    }

    private boolean _activateSkel(OAD oAD, Skeleton skeleton, String string, int n) {
        CreationImplDef creationImplDef = null;
        try {
            Object object;
            Object object2;
            creationImplDef = oAD.get_implementation(string, skeleton._object_name());
            if (this.debug) {
                System.out.println("Found registration in OAD:[" + string + ";" + n + "policy=" + creationImplDef.activation_policy() + "]");
            }
            try {
                if (this.csif == null) {
                    this.csif = ChainServerInterceptorFactoryHelper.narrow(this._orb.resolve_initial_references("ChainServerInterceptorFactory"));
                }
            }
            catch (InvalidName invalidName) {
                System.out.println("OADUser::_activateSkel: Chain Interceptors are not installed");
                throw new INITIALIZE("Chain Interceptors are not installed");
            }
            if (creationImplDef.activation_policy() == Policy.UNSHARED_SERVER) {
                this.csif.add(new UnsharedServerInterceptorFactory(this._orb, skeleton));
                System.out.println("OADUser::_activateSkel: UnsharedServerInterceptorFactory installed");
            } else if (creationImplDef.activation_policy() == Policy.SERVER_PER_METHOD) {
                this.csif.add(new PerMethodServerInterceptorFactory(this._orb, this.debug, n));
                System.out.println("OADUser::_activateSkel: PerMethodServerInterceptorFactory installed");
            }
            creationImplDef = oAD.boa_activate_obj(skeleton, string, n);
            if (this.debug) {
                System.out.println("Completed registration with OAD:[" + string + ";" + n + "]");
            }
            IOR iOR = this._orb.getDelegate(oAD).ior(oAD);
            SkeletonDelegate skeletonDelegate = (SkeletonDelegate)this._orb.getDelegate(skeleton);
            ObjectId objectId = skeletonDelegate.object_id(skeleton);
            TaggedProfile[] taggedProfileArray = new TaggedProfile[iOR.profiles.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < iOR.profiles.length) {
                object2 = this._orb.protocolManager().getProtocol(iOR.profiles[n3]);
                if (object2 instanceof IiopProtocol) {
                    object = (IiopProtocol)object2;
                    ProfileBody profileBody = object.profileBody(iOR.profiles[n3]);
                    profileBody.object_key = objectId.bytes();
                    taggedProfileArray[n2++] = object.taggedProfile(profileBody);
                }
                ++n3;
            }
            object2 = new IOR();
            object = skeletonDelegate.ior(skeleton);
            if (creationImplDef.activation_policy() == Policy.SHARED_SERVER) {
                ((IOR)object2).profiles = new TaggedProfile[((IOR)object).profiles.length + n2];
                int n4 = 0;
                while (n4 < ((IOR)object).profiles.length) {
                    ((IOR)object2).profiles[n4] = ((IOR)object).profiles[n4];
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n2) {
                    ((IOR)object2).profiles[n4++] = taggedProfileArray[n5];
                    ++n5;
                }
            } else if (n2 != taggedProfileArray.length) {
                ((IOR)object2).profiles = new TaggedProfile[n2];
                int n6 = 0;
                while (n6 < n2) {
                    ((IOR)object2).profiles[n6] = taggedProfileArray[n6];
                    ++n6;
                }
            } else {
                ((IOR)object2).profiles = taggedProfileArray;
            }
            ((IOR)object2).type_id = skeletonDelegate.repository_id(skeleton);
            skeletonDelegate.ior(skeleton, (IOR)object2);
        }
        catch (NotRegistered notRegistered) {}
        return creationImplDef != null;
    }

    private boolean _deactivateSkel(OAD oAD, Skeleton skeleton, String string, int n) {
        try {
            oAD.boa_deactivate_obj(skeleton, string, n);
            return true;
        }
        catch (NotRegistered notRegistered) {
            return false;
        }
    }

    private int _getActivationUID() {
        return this._orb.getInt("OAoad_uid");
    }

    private OAD _getOAD() {
        if (this.debug) {
            System.out.println("GettingOAD:[" + (this._oad == null) + "]");
        }
        if (this._oad == null) {
            if (!this._hasLookedForOAD || this._orb.getBoolean("OAoadLocateAlways")) {
                try {
                    String string = this._orb.getString("OAactivateIOR");
                    if (string == null) {
                        this._oad = OADHelper.bind(this._orb, null, this._orb.getLocalHost(), null);
                    } else {
                        if (this.debug) {
                            System.out.println("Converting IOR to OAD [" + string + "]");
                        }
                        this._oad = OADHelper.narrow(this._orb.string_to_object(string));
                    }
                }
                catch (SystemException systemException) {}
            }
            this._hasLookedForOAD = true;
        }
        if (this.debug) {
            System.out.println("GotOAD:[" + (this._oad != null) + "]");
        }
        return this._oad;
    }
}

