/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.ds.DSResource;
import java.net.DatagramPacket;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;

public class IStream {
    private static final int BOUNDARY = 4;
    DatagramPacket _packet;
    private byte[] _bytes;
    private int _index;
    private static final String CLASS_PREFIX = "com.visigenic.vbroker.ds.";
    public static boolean debug;

    public IStream(DatagramPacket datagramPacket) {
        this._packet = datagramPacket;
        this._index = 0;
        this._bytes = datagramPacket.getData();
        int n = this.read_int();
        if (n != this._packet.getLength()) {
            throw new COMM_FAILURE();
        }
        if (debug) {
            System.out.println("Reading packet with " + n + " bytes");
        }
    }

    public int read_int() {
        try {
            if (debug) {
                System.out.print("[read_int(" + this._index + ")]");
            }
            int n = this._index;
            int n2 = this._bytes[n] & 0xFF;
            int n3 = this._bytes[n + 1] & 0xFF;
            int n4 = this._bytes[n + 2] & 0xFF;
            int n5 = this._bytes[n + 3] & 0xFF;
            this._index += 4;
            int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
            if (debug) {
                System.out.print(": " + n6 + "]");
                System.out.flush();
            }
            return n6;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public char read_char() {
        try {
            if (debug) {
                System.out.print("[read_char(" + this._index + ")]");
            }
            char c = (char)this._bytes[this._index];
            this._index += 4;
            if (debug) {
                System.out.print(": " + c + "]");
                System.out.flush();
            }
            return c;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    byte[] read_bytes(int n) {
        try {
            if (debug) {
                System.out.print("[read_bytes: " + n + "]");
                System.out.flush();
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this._bytes, this._index, byArray, 0, n);
            this._index += n;
            return byArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MARSHAL(arrayIndexOutOfBoundsException.toString());
        }
    }

    public String read_String() {
        int n;
        byte[] byArray;
        if (debug) {
            System.out.print("[read_String(" + this._index + ")]");
        }
        if ((byArray = this.read_bytes(n = this.read_int()))[0] == 0) {
            return null;
        }
        int n2 = n - 4;
        while (n2 < n) {
            if (byArray[n2] == 0) break;
            ++n2;
        }
        return new String(byArray, 0, 0, n2);
    }

    public DSResource read_Resource() {
        try {
            if (debug) {
                System.out.print("[read_Resource(" + this._index + ")]");
            }
            char c = this.read_char();
            switch (c) {
                case ':': {
                    String string = this.read_String();
                    if (debug) {
                        System.out.println("read the class named: " + string);
                    }
                    if (string.equals("::")) {
                        return null;
                    }
                    try {
                        DSResource dSResource = (DSResource)Class.forName(CLASS_PREFIX + string).newInstance();
                        dSResource.read(this);
                        return dSResource;
                    }
                    catch (Exception exception) {
                        throw new INTERNAL("Error using DS class: " + string + ":" + exception.toString());
                    }
                }
                case '#': 
                case '@': {
                    throw new INTERNAL("Not supporting delimiter \"" + c + "\"");
                }
            }
            throw new INTERNAL("Invalid delimiter \"" + c + "\"");
        }
        catch (SystemException systemException) {
            systemException.printStackTrace();
            try {
                byte[] byArray = this._packet.getData();
                int n = 0;
                while (n < this._packet.getLength()) {
                    byte by = byArray[n];
                    System.out.print("[");
                    if (by >= 32 && by <= 126) {
                        char[] cArray = new char[]{' ', (char)by, ' '};
                        System.out.print(cArray);
                    } else {
                        System.out.print(Character.forDigit(by / 100, 10));
                        System.out.print(Character.forDigit(by / 10 % 10, 10));
                        System.out.print(Character.forDigit(by % 10, 10));
                    }
                    System.out.print("]");
                    ++n;
                }
                System.out.println();
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

