/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.ds.DSResource;
import com.visigenic.vbroker.ds.DSString;
import com.visigenic.vbroker.ds.DSUser;
import com.visigenic.vbroker.ds.IStream;
import com.visigenic.vbroker.ds.OStream;
import org.omg.CORBA.MARSHAL;

class DSAMessage
implements DSResource {
    static final int HEARTBEAT = 1;
    static final int ARE_YOU_ALIVE = 2;
    static final int NEW_PROVIDER = 3;
    static final int GET_PROVIDER = 4;
    static final int REPLY = 5;
    static final int GET_CLIENT_HANDLER_ADDR = 6;
    static final int MARK_SUSPECT = 7;
    static final int ORDERLY_RELEASE = 8;
    static final int GET_TCP_CLIENT_HANDLER_ADDR = 9;
    private static final String[] _messageTypeString = new String[]{null, "HEARTBEAT", "ARE_YOU_ALIVE", "NEW_PROVIDER", "GET_PROVIDER", "REPLY", "GET_CLIENT_HANDLER_ADDR", "MARK_SUSPECT", "ORDERLY_RELEASE", "GET_TCP_CLIENT_HANDLER_ADDR"};
    static final DSString VERSION = new DSString("ORBeline 2.0");
    static final int USER_DATA_LENGTH = 4;
    static final byte[] USER_DATA = new byte[4];
    private DSString _version;
    private int _messageType;
    private int _messageNumber;
    private DSResource _messageObject;
    private int _userDataLength;
    private byte[] _userData;

    public DSAMessage(int n, DSResource dSResource) {
        this._version = VERSION;
        this._messageType = n;
        this._messageNumber = DSUser.counter();
        this._messageObject = dSResource;
        this._userDataLength = 4;
        this._userData = USER_DATA;
    }

    DSAMessage() {
    }

    public void read(IStream iStream) {
        this._version = new DSString(iStream);
        if (!this._version.string().equals(VERSION.string())) {
            throw new MARSHAL("Invalid version: " + this._version);
        }
        this._messageType = iStream.read_int();
        if (this._messageType < 1 || this._messageType > 9) {
            throw new MARSHAL("Invalid type: " + this._messageType);
        }
        this._messageNumber = iStream.read_int();
        this._messageObject = iStream.read_Resource();
        this._userDataLength = iStream.read_int();
        this._userData = iStream.read_bytes(this._userDataLength);
    }

    public void write(OStream oStream) {
        this._version.write(oStream);
        oStream.write_int(this._messageType);
        oStream.write_int(this._messageNumber);
        oStream.write_Resource(this._messageObject);
        oStream.write_int(this._userDataLength);
        oStream.write_bytes(this._userData);
    }

    public String toString() {
        String string = "DSAMessage[version=" + this._version + ", messageType=" + _messageTypeString[this._messageType] + ", messageNumber=" + this._messageNumber + ", messageObject=" + this._messageObject + ", userDataLength=" + this._userDataLength + ", userData=";
        int n = 0;
        while (n < this._userDataLength) {
            string = String.valueOf(string) + "[" + this._userData[n] + "]";
            ++n;
        }
        return String.valueOf(string) + "]";
    }

    int messageNumber() {
        return this._messageNumber;
    }

    DSResource messageObject() {
        return this._messageObject;
    }
}

