/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.activationImpl;

import com.visigenic.vbroker.Activation.DuplicateEntry;
import com.visigenic.vbroker.Activation.InvalidPath;
import com.visigenic.vbroker.activationImpl.OADaccessor;
import com.visigenic.vbroker.extension.CreationImplDef;
import com.visigenic.vbroker.orb.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.SystemException;

public class OADreg
extends OADaccessor {
    public OADreg(ORB oRB, String[] stringArray) {
        super(oRB, stringArray);
    }

    protected String ProgramName() {
        return "oadutil reg";
    }

    protected boolean CheckParams(CreationImplDef creationImplDef) {
        if (!super.CheckParams(creationImplDef)) {
            return false;
        }
        if (creationImplDef.object_name() == null || creationImplDef.object_name().equals("")) {
            System.out.println("Registration requires an Object Name to be specified");
            return false;
        }
        if (creationImplDef.path_name() == null || creationImplDef.path_name().equals("")) {
            System.out.println("Registration requires either -java or -cpp");
            return false;
        }
        return true;
    }

    protected String RequiredUsage() {
        return "    -i interface_name -o object name or\n    -r repository_id  -o object_name or\n    -s service_name (for registering service Activators)\n       Specifies the IDL interface name (or Repository ID) and instance name\n    -cpp filename_to_execute | -java full_classname\n       Specifies full path for executable, which must create and register an\n       object that matches the -o/-r/-s args.  Applications registered with\n       '-cpp' should be stand-alone executables.  Classes registered with\n       '-java' will be executed with the command 'vbj full_classname'\n";
    }

    protected String OptionalUsage() {
        return String.valueOf(super.OptionalUsage()) + "    -d referenceData    " + "Specifies reference data passed to spawned executable\n" + "    -a arg1 -a arg2...  " + "Specifies command-line arguments for spawned executable\n" + "    -e env1 -e env2...  " + "Specifies environment variables for spawned executable\n" + "                        NOTE: System settings will not be passed when using this\n" + "                        option, and must be explicitly defined\n" + "    -p {shared | unshared | per-method} (default: shared)\n" + "                        " + "Specifies the activation policy of spawned objects\n";
    }

    private void RegisterImpl(CreationImplDef creationImplDef) {
        try {
            this.oad().reg_implementation(creationImplDef);
            System.out.println("Completed registration of " + OADaccessor.PrintImpl(creationImplDef) + "for OAD on host " + this.OADhost());
            return;
        }
        catch (DuplicateEntry duplicateEntry) {
            if (this.Verbose()) {
                duplicateEntry.printStackTrace();
            }
            this.Error("Entry already exists in oad at (" + this.OADhost() + ") for: \n" + OADaccessor.PrintImpl(creationImplDef));
            return;
        }
        catch (InvalidPath invalidPath) {
            try {
                if (this.Verbose()) {
                    invalidPath.printStackTrace();
                }
                String string = creationImplDef.path_name().equals("vbj") ? "Class '" + creationImplDef.args()[0] + "'" : "Executable path '" + creationImplDef.path_name() + "'";
                this.Error(String.valueOf(string) + " invalid for OAD on host '" + this.OADhost() + "'");
                return;
            }
            catch (SystemException systemException) {
                if (this.Verbose()) {
                    invalidPath.printStackTrace();
                }
                this.Error("Failed to obtain path_name of implementation: " + systemException);
                return;
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            System.out.println("\nInvalid parameter specified to registration\n");
            if (this.Verbose()) {
                bAD_PARAM.printStackTrace();
            }
            this.printUsageAndExit(1);
            return;
        }
        catch (SystemException systemException) {
            if (this.Verbose()) {
                systemException.printStackTrace();
            }
            this.Error("Unexpected SystemException " + systemException);
            return;
        }
    }

    protected void Execute() {
        this.RegisterImpl(this.ImplDef());
    }
}

