import os
import sys
from _typeshed import StrPath, SupportsRead, SupportsWrite
from typing import Any, AnyStr, Callable, Iterable, List, NamedTuple, Optional, Sequence, Set, Tuple, TypeVar, Union, overload

_PathT = TypeVar("_PathT", str, os.PathLike[str])
# Return value of some functions that may either return a path-like object that was passed in or
# a string
_PathReturn = Any

class Error(OSError): ...
class SameFileError(Error): ...
class SpecialFileError(OSError): ...
class ExecError(OSError): ...
class ReadError(OSError): ...
class RegistryError(Exception): ...

def copyfileobj(fsrc: SupportsRead[AnyStr], fdst: SupportsWrite[AnyStr], length: int = ...) -> None: ...
def copyfile(src: StrPath, dst: _PathT, *, follow_symlinks: bool = ...) -> _PathT: ...
def copymode(src: StrPath, dst: StrPath, *, follow_symlinks: bool = ...) -> None: ...
def copystat(src: StrPath, dst: StrPath, *, follow_symlinks: bool = ...) -> None: ...
def copy(src: StrPath, dst: StrPath, *, follow_symlinks: bool = ...) -> _PathReturn: ...
def copy2(src: StrPath, dst: StrPath, *, follow_symlinks: bool = ...) -> _PathReturn: ...
def ignore_patterns(*patterns: StrPath) -> Callable[[Any, List[str]], Set[str]]: ...

if sys.version_info >= (3, 8):
    def copytree(
        src: StrPath,
        dst: StrPath,
        symlinks: bool = ...,
        ignore: Union[None, Callable[[str, List[str]], Iterable[str]], Callable[[StrPath, List[str]], Iterable[str]]] = ...,
        copy_function: Callable[[str, str], None] = ...,
        ignore_dangling_symlinks: bool = ...,
        dirs_exist_ok: bool = ...,
    ) -> _PathReturn: ...

else:
    def copytree(
        src: StrPath,
        dst: StrPath,
        symlinks: bool = ...,
        ignore: Union[None, Callable[[str, List[str]], Iterable[str]], Callable[[StrPath, List[str]], Iterable[str]]] = ...,
        copy_function: Callable[[str, str], None] = ...,
        ignore_dangling_symlinks: bool = ...,
    ) -> _PathReturn: ...

def rmtree(
    path: Union[bytes, StrPath], ignore_errors: bool = ..., onerror: Optional[Callable[[Any, Any, Any], Any]] = ...
) -> None: ...

_CopyFn = Union[Callable[[str, str], None], Callable[[StrPath, StrPath], None]]

if sys.version_info >= (3, 9):
    def move(src: StrPath, dst: StrPath, copy_function: _CopyFn = ...) -> _PathReturn: ...

else:
    # See https://bugs.python.org/issue32689
    def move(src: str, dst: StrPath, copy_function: _CopyFn = ...) -> _PathReturn: ...

class _ntuple_diskusage(NamedTuple):
    total: int
    used: int
    free: int

def disk_usage(path: StrPath) -> _ntuple_diskusage: ...
def chown(path: StrPath, user: Optional[Union[str, int]] = ..., group: Optional[Union[str, int]] = ...) -> None: ...

if sys.version_info >= (3, 8):
    @overload
    def which(cmd: StrPath, mode: int = ..., path: Optional[StrPath] = ...) -> Optional[str]: ...
    @overload
    def which(cmd: bytes, mode: int = ..., path: Optional[StrPath] = ...) -> Optional[bytes]: ...

else:
    def which(cmd: StrPath, mode: int = ..., path: Optional[StrPath] = ...) -> Optional[str]: ...

def make_archive(
    base_name: str,
    format: str,
    root_dir: Optional[StrPath] = ...,
    base_dir: Optional[StrPath] = ...,
    verbose: bool = ...,
    dry_run: bool = ...,
    owner: Optional[str] = ...,
    group: Optional[str] = ...,
    logger: Optional[Any] = ...,
) -> str: ...
def get_archive_formats() -> List[Tuple[str, str]]: ...
def register_archive_format(
    name: str,
    function: Callable[..., Any],
    extra_args: Optional[Sequence[Union[Tuple[str, Any], List[Any]]]] = ...,
    description: str = ...,
) -> None: ...
def unregister_archive_format(name: str) -> None: ...

if sys.version_info >= (3, 7):
    def unpack_archive(filename: StrPath, extract_dir: Optional[StrPath] = ..., format: Optional[str] = ...) -> None: ...

else:
    # See http://bugs.python.org/issue30218
    def unpack_archive(filename: str, extract_dir: Optional[StrPath] = ..., format: Optional[str] = ...) -> None: ...

def register_unpack_format(
    name: str, extensions: List[str], function: Any, extra_args: Optional[Sequence[Tuple[str, Any]]] = ..., description: str = ...
) -> None: ...
def unregister_unpack_format(name: str) -> None: ...
def get_unpack_formats() -> List[Tuple[str, List[str], str]]: ...
def get_terminal_size(fallback: Tuple[int, int] = ...) -> os.terminal_size: ...
