from enum import Enum

from six import StringIO

g_max_string_length = 250

g_force_suppress_errors = False
g_max_num_children = 10000

g_max_recursion_level = 50
g_recursion_level = -1

g_enable_formatting = True


class DiagnosticsLevel(Enum):
    DISABLED = 0
    ERRORS_ONLY = 1
    VERBOSE = 2


def set_diagnostics_level(level):
    global g_force_suppress_errors
    if level == DiagnosticsLevel.VERBOSE:
        g_force_suppress_errors = False
    elif level == DiagnosticsLevel.ERRORS_ONLY:
        g_force_suppress_errors = False
    elif level == DiagnosticsLevel.DISABLED:
        g_force_suppress_errors = True
    else:
        raise Exception('Invalid argument passed, expected level 0, 1 or 2')


def set_max_string_length(val: int):
    global g_max_string_length
    g_max_string_length = val


def get_max_string_length() -> int:
    global g_max_string_length
    return g_max_string_length


def enable_disable_formatting(val: bool):
    global g_enable_formatting
    g_enable_formatting = val


def is_enabled_formatting():
    global g_enable_formatting
    return g_enable_formatting


def set_recursion_level(level: int) -> int:
    global g_recursion_level
    prev = g_recursion_level
    g_recursion_level = level
    return prev


def get_recursion_level() -> int:
    global g_recursion_level
    return g_recursion_level
