;;  Copyright 2021 Autodesk, Inc.  All rights reserved.
;;
;;  Use of this software is subject to the terms of the Autodesk license 
;;  agreement provided at the time of installation or download, or which 
;;  otherwise accompanies this software in either electronic or hard copy form.
;;
;;  Version 2.0
;;  AutoCAD Hatch Patterns
;;  Customized for ISO scaling
;;
;;
;;  Note: in order to ease migration of this file when upgrading 
;;  to a future version of AutoCAD, it is recommended that you add
;;  your customizations to the User Defined Hatch Patterns section at the
;;  end of this file.
;;
*SOLID, Solid fill
45, 0,0, 0,.125
*ANGLE,Angle steel
0, 0, 0, 0, 6.985, 5.08, -1.905 
90, 0, 0, 0, 6.985, 5.08, -1.905 
*ANSI31,ANSI Iron, Brick, Stone masonry
45, 0, 0, 0, 3.175 
*ANSI32,ANSI Steel
45, 0, 0, 0, 9.525 
45, 4.49013, 0, 0, 9.525 
*ANSI33,ANSI Bronze, Brass, Copper
45, 0, 0, 0, 6.35 
45, 4.49013, 0, 0, 6.35, 3.175, -1.5875 
*ANSI34,ANSI Plastic, Rubber
45, 0, 0, 0, 19.05 
45, 4.49013, 0, 0, 19.05 
45, 8.98026, 0, 0, 19.05 
45, 13.4704, 0, 0, 19.05 
*ANSI35,ANSI Fire brick, Refractory material
45, 0, 0, 0, 6.35 
45, 4.49013, 0, 0, 6.35, 7.9375, -1.5875, 0, -1.5875 
*ANSI36,ANSI Marble, Slate, Glass
45, 0, 0, 5.55625, 3.175, 7.9375, -1.5875, 0, -1.5875 
*ANSI37,ANSI Lead, Zinc, Magnesium, Sound/Heat/Elec Insulation
45, 0, 0, 0, 3.175 
135, 0, 0, 0, 3.175 
*ANSI38,ANSI Aluminum
45, 0, 0, 0, 3.175 
135, 0, 0, 6.35, 3.175, 7.9375, -4.7625 
*AR-B816, 8x16 block elevation stretcher bond
0, 0, 0, 0, 203.2 
90, 0, 0, 203.2, 203.2, 203.2, -203.2 
*AR-B816C, 8x16 block elevation stretcher bond with mortar joints
0, 0, 0, 203.2, 203.2, 396.875, -9.525 
0, -203.2, 9.525, 203.2, 203.2, 396.875, -9.525 
90, 0, 0, 203.2, 203.2, -212.725, 193.675 
90, -9.525, 0, 203.2, 203.2, -212.725, 193.675 
*AR-B88, 8x8 block elevation stretcher bond
0, 0, 0, 0, 203.2 
90, 0, 0, 203.2, 101.6, 203.2, -203.2 
*AR-BRELM, standard brick elevation english bond with mortar joints
0, 0, 0, 0, 135.484, 193.675, -9.525 
0, 0, 57.15, 0, 135.484, 193.675, -9.525 
0, 50.8, 67.7418, 0, 135.484, 92.075, -9.525 
0, 50.8, 124.892, 0, 135.484, 92.075, -9.525 
90, 0, 0, 0, 203.2, 57.15, -78.334 
90, -9.525, 0, 0, 203.2, 57.15, -78.334
90, 50.8, 67.7418, 0, 101.6, 57.15, -78.334
90, 41.275, 67.7418, 0, 101.6, 57.15, -78.334
*AR-BRSTD, standard brick elevation stretcher bond
0, 0, 0, 0, 67.7418 
90, 0, 0, 67.7418, 101.6, 67.7418, -67.7418 
*AR-CONC, random dot and stone pattern
50, 0, 0, 104.896, -149.807, 19.05, -209.55 
355, 0, 0, -51.76101082,187.25814969, 15.24, -167.64058417
100.4514447,15.182007,-1.3282535,145.5569059,-176.270089,16.1900088,-178.0902446
46.1842, 0, 50.8, 157.343, -224.71, 28.575, -314.325 
96.63555761,22.5899,47.2965,218.33577212,-264.40480444,24.28502314,-267.13560816
351.18415117,0,50.8,196.67912063,280.88740361,22.85996707,-251.45973192
21, 25.4, 38.1, 104.89565868, -149.80652586, 19.05, -209.55 
326, 25.4, 38.1, -51.7604, 187.258, 15.24, -167.64 
71.451445,38.0345326,29.5779001,145.5567546,-176.2700748,16.1900088,-178.0899376
37.5, 0, 0, 53.9242, 65.2018, 0,        -165.608, 0, -170.18, 0, -168.275 
7.5, 0, 0, 79.3242, 90.6018, 0, -97.028, 0, -161.798, 0, -64.135 
-32.5, -56.642, 0, 117.434, 68.0212, 0, -63.5, 0, -198.12, 0, -262.89 
-42.5, -82.042, 0, 92.0344, 118.821, 0, -82.55, 0, -131.572, 0, -186.69 
*AR-HBONE, standard brick herringbone pattern @ 45 degrees
45, 0, 0, 101.6, 101.6, 304.8, -101.6 
135, 71.842, 71.842, 101.6, -101.6, 304.8, -101.6 
*AR-PARQ1, 2x12 parquet flooring: pattern of 12x12
90, 0, 0, 304.8, 304.8, 304.8, -304.8 
90, 50.8, 0, 304.8, 304.8, 304.8, -304.8 
90, 101.6, 0, 304.8, 304.8, 304.8, -304.8 
90, 152.4, 0, 304.8, 304.8, 304.8, -304.8 
90, 203.2, 0, 304.8, 304.8, 304.8, -304.8 
90, 254, 0, 304.8, 304.8, 304.8, -304.8 
90, 304.8, 0, 304.8, 304.8, 304.8, -304.8 
0, 0, 304.8, 304.8, -304.8, 304.8, -304.8 
0, 0, 355.6, 304.8, -304.8, 304.8, -304.8 
0, 0, 406.4, 304.8, -304.8, 304.8, -304.8 
0, 0, 457.2, 304.8, -304.8, 304.8, -304.8 
0, 0, 508, 304.8, -304.8, 304.8, -304.8 
0, 0, 558.8, 304.8, -304.8, 304.8, -304.8 
0, 0, 609.6, 304.8, -304.8, 304.8, -304.8 
*AR-RROOF, roof shingle texture
0, 0, 0, 55.88, 25.4, 381, -50.8, 127, -25.4 
0, 33.782, 12.7, -25.4, 33.782, 76.2, -8.382, 152.4, -19.05 
0, 12.7, 21.59, 132.08, 17.018, 203.2, -35.56, 101.6, -25.4 
*AR-RSHKE, roof wood shake texture
0, 0, 0, 647.7, 304.8, 152.4,   -127, 177.8, -76.2, 228.6, -101.6 
0, 152.4, 12.7, 647.7, 304.8, 127, -482.6, 101.6, -152.4 
0, 457.2, -19.05, 647.7, 304.8, 76.2, -787.4 
90, 0, 0, 304.8, 215.9, 292.1, -927.1 
90, 152.4, 0, 304.8, 215.9, 285.75, -933.45 
90, 279.4, 0, 304.8, 215.9, 266.7, -952.5 
90, 457.2, -19.05, 304.8, 215.9, 292.1, -927.1 
90, 533.4, -19.05, 304.8, 215.9, 292.1, -927.1 
90, 762, 0, 304.8, 215.9, 279.4, -939.8 
*AR-SAND, random dot pattern
37.5, 0, 0, 28.5242, 39.8018, 0,        -38.608, 0, -43.18, 0, -41.275 
7.5, 0, 0, 53.9242, 65.2018, 0, -20.828, 0, -34.798, 0, -13.335 
-32.5, -31.242, 0, 66.6344, 42.6212, 0, -12.7, 0, -45.72, 0, -59.69 
-42.5, -31.242, 0, 41.2344, 68.0212, 0, -6.35, 0, -29.972, 0, -34.29
*BOX,Box steel
90, 0, 0, 0, 25.4 
90, 6.35, 0, 0, 25.4 
0, 0, 0, 0, 25.4, -6.35, 6.35 
0, 0, 6.35, 0, 25.4, -6.35, 6.35 
0, 0, 12.7, 0, 25.4, 6.35, -6.35 
0, 0, 19.05, 0, 25.4, 6.35, -6.35 
90, 12.7, 0, 0, 25.4, 6.35, -6.35 
90, 19.05, 0, 0, 25.4, 6.35, -6.35 
*BRASS,Brass material
0, 0, 0, 0, 6.35 
0, 0, 3.175, 0, 6.35, 3.175, -1.5875 
*BRICK,Brick or masonry-type surface
0, 0, 0, 0, 6.35 
90, 0, 0, 0, 12.7, 6.35, -6.35 
90, 6.35, 0, 0, 12.7, -6.35, 6.35 
*BRSTONE,Brick and stone
0, 0, 0, 0, 8.382 
90, 22.86, 0, 8.382, 12.7, 8.382, -8.382 
90, 20.32, 0, 8.382, 12.7, 8.382, -8.382 
0, 22.86, 1.397, 12.7, 8.382, -22.86, 2.54 
0, 22.86, 2.794, 12.7, 8.382, -22.86, 2.54 
0, 22.86, 4.191, 12.7, 8.382, -22.86, 2.54 
0, 22.86, 5.588, 12.7, 8.382, -22.86, 2.54 
0, 22.86, 6.985, 12.7, 8.382, -22.86, 2.54 
*CLAY,Clay material
0, 0, 0, 0, 4.7625 
0, 0, 0.79375, 0, 4.7625 
0, 0, 1.5875, 0, 4.7625 
0, 0, 3.175, 0, 4.7625, 4.7625, -3.175 
*CORK,Cork material
0, 0, 0, 0, 3.175 
135, 1.5875, -1.5875, 0, 8.98026, 4.49013, -4.49013 
135, 2.38125, -1.5875, 0, 8.98026, 4.49013, -4.49013 
135, 3.175, -1.5875, 0, 8.98026, 4.49013, -4.49013 
*CROSS,A series of crosses
0, 0, 0, 6.35, 6.35, 3.175, -9.525 
90, 1.5875, -1.5875, 6.35, 6.35, 3.175, -9.525 
*DASH,Dashed lines
0, 0, 0, 3.175, 3.175, 3.175, -3.175 
*DOLMIT,Geological rock layering
0, 0, 0, 0, 6.35 
45, 0, 0, 0, 17.9605,8.98025612106915355989072339,-17.9605122421383071197814467
*DOTS,A series of dots
0, 0, 0, 0.79375, 1.5875, 0, -1.5875 
*EARTH,Earth or ground (subterranean)
0, 0, 0, 6.35, 6.35, 6.35, -6.35 
0, 0, 2.38125, 6.35, 6.35, 6.35, -6.35 
0, 0, 4.7625, 6.35, 6.35, 6.35, -6.35 
90, 0.79375, 5.55625, 6.35, 6.35, 6.35, -6.35 
90, 3.175, 5.55625, 6.35, 6.35, 6.35, -6.35 
90, 5.55625, 5.55625, 6.35, 6.35, 6.35, -6.35 
*ESCHER,Escher pattern
60, 0, 0, -15.24, 26.3964542936, 27.94, -2.54 
180, 0, 0, -15.24, 26.3964542936, 27.94, -2.54 
300, 0, 0, 15.24, 26.3964542936, 27.94, -2.54 
60, 2.54, 0, -15.24, 26.3964542936, 5.08, -25.4 
300, 2.54, 0, 15.24, 26.3964542936, 5.08, -25.4 
60, -1.27, 2.199704516, -15.24, 26.3964542936, 5.08, -25.4 
180, -1.27, 2.199704516, -15.24, 26.3964542936, 5.08, -25.4 
300, -1.27, -2.199704516, 15.24, 26.3964542936, 5.08, -25.4 
180, -1.27, -2.199704516, -15.24, 26.3964542936, 5.08, -25.4 
60, -10.16, 0, -15.24, 26.3964542936, 5.08, -25.4 
300, -10.16, 0, 15.24, 26.3964542936, 5.08, -25.4 
60, 5.08, -8.7988180894, -15.24, 26.3964542936, 5.08, -25.4 
180, 5.08, -8.7988180894, -15.24, 26.3964542936, 5.08, -25.4 
300, 5.08, 8.7988180894, 15.24, 26.3964542936, 5.08, -25.4 
180, 5.08, 8.7988180894, -15.24, 26.3964542936, 5.08, -25.4 
0, 5.08, 4.3994090574, -15.24, 26.3964542936, 17.78, -12.7 
0, 5.08, -4.3994090574, -15.24, 26.3964542936, 17.78, -12.7 
120, 1.27, 6.5991135734, 15.24, 26.3964542936, 17.78, -12.7 
120, -6.35, 2.199704516, 15.24, 26.3964542936, 17.78, -12.7 
240, -6.35, -2.199704516, 15.24, 26.3964542936, 17.78, -12.7 
240, 1.27, -6.5991135734, 15.24, 26.3964542936, 17.78, -12.7 
*FLEX,Flexible material
0, 0, 0, 0, 6.35, 6.35, -6.35 
45,6.35,0,4.490128053,4.490128053,1.5875,-5.8052561314,1.5875,-8.9802561314
*GOST_GLASS,glass material
45, 0, 0, 6, -6, 5, -7
45, 2.121320, 0, 6, -6, 2, -10
45, 0, 2.121320, 6, -6, 2, -10
*GOST_WOOD,wood material
90, 0, 0, 0, -6, 10, -2
90, 2, -2, 0, -6, 6, -1.5, 3, -1.5
90, 4, -5, 0, -6, 10, -2
*GOST_GROUND,ground
45, 0, 0, 10, -10, 20
45, 3, 0, 10, -10, 20
45, 6, 0, 10, -10, 20
*GRASS,Grass area
90, 0, 0, 17.96051224, 17.96051224, 4.7625, -31.15852448
45, 0, 0, 0, 25.4, 4.7625, -20.6375 
135, 0, 0, 0, 25.4, 4.7625, -20.6375 
*GRATE,Grated area
0, 0, 0, 0, 0.79375 
90, 0, 0, 0, 3.175 
*GRAVEL,Gravel pattern
228.0127875,18.288,25.4,305.85067529778,1.88796713245,3.4172144,-338.30483639565
184.969741,16.002,22.86,-305.8545235377,1.10019612724,5.8640472,-580.54048893524
132.5104471,10.16,22.352,-377.59492241548,1.56030959675,4.1348152,-409.347227941
267.273689,.254,16.002,-508.63316875916,1.20815479432,5.3400452,-528.66437425738
292.83365418,0.0,10.668,-330.19770134945,1.23208097566,5.236337,-518.39807745344
357.273689,2.032,5.842,-508.63316875916,1.20815479432,5.3400452,-528.66437425738
37.69424047,7.366,5.588,-416.58997273292,.91357450169,7.0619366,-699.13115314247
72.25532837,12.954,9.906,586.40373773403,.96766293399,6.6671952,-660.05256601905
121.42956562,14.986,16.256,387.71230339293,1.2040754753,5.35813,-530.45545698712
175.2363583,12.192,20.828,-280.5442400419,2.10935518695,6.1171328,-299.7393695
222.3974378,6.096,21.336,413.48123885686,.81554484621,7.9107792,-783.16772512177
138.81407483,25.4,15.748,234.164238558,2.38943100688,2.7000454,-267.30565824344
171.4692344,23.368,17.526,-334.082478726,1.25594916784,5.1368198,-508.5463899704
225.00000,18.288,18.288,17.96051224214,17.96051224214,3.5920934,-32.32893108428
203.19859051,16.51,21.336,-136.74251918,3.33518339548,1.9344132,-191.50622368894
291.80140949,14.732,20.574,-80.18324702488,4.71666158921,2.7356562,-134.0475299
30.96375653,15.748,18.034,91.47734531502,4.35606406258,4.4431966,-143.6629815291
161.56505118,19.558,20.32,-56.2252967978,8.03218525675,3.2128714,-77.10898116828
16.389540334,0.0,20.574,265.17991128726,1.43340492604,4.50088,-445.58826672539
70.34617594,4.318,21.844,-297.29446803469,1.70858889651,3.7759894,-373.822156782
293.19859051,19.558,25.4,-136.7425191801,3.33518339548,3.868801,-189.57183588894
343.61045967,21.082,21.844,-265.17991128725,1.433404926,4.50088,-445.5882667254
339.44395478,0.0,4.826,-136.75087638398,2.97284513779,4.340352,-212.67734313106
294.7751406,4.064,3.302,-306.90424056705,1.77401295215,3.6367212,-360.0359338072
66.80140949,19.812,0.0,136.74251918012,3.33518339452,3.868801,-189.57183588894
17.35402464,21.336,3.556,-345.47402804977,1.51523696536,4.2578274,-421.523759802
69.44395478,7.366,0.0,-136.75087638396,2.97284513874,2.170176,-214.84751913106
101.309932474,18.288,0.0,104.60834648271,4.98134983255,1.295146,-128.21994964526
165.963756532,18.034,1.27,-80.085263387,6.16040487582,5.236337,-99.49054589069
186.00900596,12.954,2.54,-255.26337856879,1.32949676118,4.85267,-480.41364863337
303.69006753,15.748,15.748,-56.35753993648,7.0446924921,3.6632388,-87.9177635968
353.15722659,17.78,12.7,434.77679606606,1.0087628707,6.3955676,-633.16009065031
60.9453959,24.13,11.938,-204.76648550216,2.46706609031,2.6150824,-258.8939231811
90.0000000,25.4,14.224,25.4,25.4,1.524,-23.876
120.25643716,12.446,3.302,-204.77318477297,1.8283320086,3.5286696,-349.339407732
48.01278750,10.668,6.35,305.85067529778,1.88796713138,6.8344288,-334.88762199565
0.000000000,15.24,11.43,25.4,25.4,6.604,-18.796
325.3048465,21.844,11.43,310.04235091354,-1.6064370526,4.0160956,-397.5931672414
254.0546041,25.146,9.144,104.6687497289,3.48895832444,3.6982908,-181.21650038772
207.64597536,24.13,5.588,545.36007557253,1.07143433066,6.021451,-596.12464422938
175.42607874,18.796,2.794,331.1739336186,1.01276432357,6.3702946,-630.6584645624
*HEX,Hexagons
0, 0, 0, 0, 5.4992613154, 3.175, -6.35 
120, 0, 0, 0, 5.4992613154, 3.175, -6.35 
60, 3.175, 0, 0, 5.4992613154, 3.175, -6.35 
*HONEY,Honeycomb pattern
0, 0, 0, 4.7625, 2.749630645, 3.175, -6.35 
120, 0, 0, 4.7625, 2.749630645, 3.175, -6.35 
60, 0, 0, 4.7625, 2.749630645, -6.35, 3.175 
*HOUND,Houndstooth check
0, 0, 0, 6.35, 1.5875, 25.4, -12.7 
90, 0, 0, -6.35, 1.5875, 25.4, -12.7 
*INSUL,Insulation material
0, 0, 0, 0, 9.525 
0, 0, 3.175, 0, 9.525, 3.175, -3.175 
0, 0, 6.35, 0, 9.525, 3.175, -3.175 
;;
;;  Hatch Pattern Definition related to ISO/DIS 12011 line types
;;
;;  (Width * 5 = Distance between lines)
;;
;;  The size of the line segments related to the ISO/DIS 12011 linetypes
;;  define the following hatch pattern. 
;;  The pen width of 1 mm is the base of the definition. To use them with
;;  the other ISO/DIS 12011 predefined pen widths, the line has to be scaled
;;  with the appropriate value (e.g. pen width 0,5 mm -> ltscale 0.5).
;;
*ACAD_ISO02W100, dashed line
0, 0,0, 0,5, 12,-3
*ACAD_ISO03W100, dashed space line
0, 0,0, 0,5, 12,-18
*ACAD_ISO04W100, long dashed dotted line
0, 0,0, 0,5, 24,-3,.5,-3
*ACAD_ISO05W100, long dashed double dotted line
0, 0,0, 0,5, 24,-3,.5,-3,.5,-3
*ACAD_ISO06W100, long dashed triplicate dotted line
0, 0,0, 0,5, 24,-3,.5,-3,.5,-6.5
0, 0,0, 0,5, -34,.5,-3
*ACAD_ISO07W100, dotted line
0, 0,0, 0,5, .5,-3
*ACAD_ISO08W100, long dashed short dashed line
0, 0,0, 0,5, 24,-3,6,-3
*ACAD_ISO09W100, long dashed double-short-dashed line
0, 0,0, 0,5, 24,-3,6,-3,6,-3
*ACAD_ISO10W100, dashed dotted line
0, 0,0, 0,5, 12,-3,.5,-3
*ACAD_ISO11W100, double-dashed dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-3
*ACAD_ISO12W100, dashed double-dotted line
0, 0,0, 0,5, 12,-3,.5,-3,.5,-3
*ACAD_ISO13W100, double-dashed double-dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-6.5
0, 0,0, 0,5, -33.5,.5,-3
*ACAD_ISO14W100, dashed triplicate-dotted line
0, 0,0, 0,5, 12,-3,.5,-3,.5,-6.5
0, 0,0, 0,5, -22,.5,-3
*ACAD_ISO15W100, double-dashed triplicate-dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-10
0, 0,0, 0,5, -33.5,.5,-3,.5,-3
;;
;; end of ACAD_ISO hatch pattern definition
;;
;;  Hatch Pattern Definition related to JIS A 0150
;;
*JIS_LC_20, LC JIS A 0150(@20)
45,0,0,0,20
45,.4,0,0,20
*JIS_LC_20A, LC JIS A 0150(@20)
45,0,0,0,20
45,1,0,0,20
*JIS_LC_8, LC JIS A 0150(@8)
45,0,0,0,7.8
45,.4,0,0,7.8
*JIS_LC_8A, LC JIS A 0150(@8)
45,0,0,0,7.8
45,1,0,0,7.8
*JIS_RC_10, RC JIS A 0150(@10)
45,0,0,0,10
45,.725,0,0,10
45,1.45,0,0,10
*JIS_RC_15, RC JIS A 0150(@15)
45,0,0,0,15
45,.725,0,0,15
45,1.45,0,0,15
*JIS_RC_18, RC JIS A 0150(@18)
45,0,0,0,18
45,1,0,0,18
45,2,0,0,18
*JIS_RC_30, RC JIS A 0150(@30)
45,0,0,0,30
45,1,0,0,30
45,2,0,0,30
*JIS_STN_1E, STONE JIS A 0150(@1)
45, 0, 0, 0, 1
45, .705, 0, 0,1, 1, -.5
*JIS_STN_2.5, STONE JIS A 0150(@2.5)
45, 0, 0, 0, 2.5
45, 1.765, 0, 0,2.5, 1.2, -.5
*JIS_WOOD, WOOD JIS A 0150
45,0,0,0,.70710678
;;
*LINE,Parallel horizontal lines
0, 0, 0, 0, 3.175 
*MUDST,Mud and sand
0, 0, 0, 12.7, 6.35, 6.35,      -6.35, 0, -6.35, 0, -6.35 
*NET,Horizontal / vertical grid
0, 0, 0, 0, 3.175 
90, 0, 0, 0, 3.175 
*NET3,Network pattern 0-60-120
0, 0, 0, 0, 3.175 
60, 0, 0, 0, 3.175 
120, 0, 0, 0, 3.175 
*PLAST,Plastic material
0, 0, 0, 0, 6.35 
0, 0, 0.79375, 0, 6.35 
0, 0, 1.5875, 0, 6.35 
*PLASTI,Plastic material
0, 0, 0, 0, 6.35 
0, 0, 0.79375, 0, 6.35 
0, 0, 1.5875, 0, 6.35 
0, 0, 3.96875, 0, 6.35 
*SACNCR,Concrete
45, 0, 0, 0, 2.38125 
45, 1.6838, 0, 0, 2.38125, 0, -2.38125 
*SQUARE,Small aligned squares
0, 0, 0, 0, 3.175, 3.175, -3.175 
90, 0, 0, 0, 3.175, 3.175, -3.175 
*STARS,Star of David
0, 0, 0, 0, 5.4992613154, 3.175, -3.175 
60, 0, 0, 0, 5.4992613154, 3.175, -3.175 
120, 1.5875, 2.7496306704, 0, 5.4992613154, 3.175, -3.175 
*STEEL,Steel material
45, 0, 0, 0, 3.175 
45, 0, 1.5875, 0, 3.175 
*SWAMP,Swampy area
0, 0, 0, 12.7, 21.9970452362, 3.175, -22.225 
90, 1.5875, 0, 21.9970452362, 12.7, 1.5875, -42.4065904724 
90, 1.984375, 0, 21.9970452362, 12.7, 1.27, -42.7240904724 
90, 1.190625, 0, 21.9970452362, 12.7, 1.27, -42.7240904724 
60, 2.38125, 0, 12.7, 21.9970452362, 1.016, -24.384 
120, 0.79375, 0, 12.7, 21.9970452362, 1.016, -24.384 
*TRANS,Heat transfer material
0, 0, 0, 0, 6.35 
0, 0, 3.175, 0, 6.35, 3.175, -3.175 
*TRIANG,Equilateral triangles
60, 0, 0, 4.7625, 8.2488919604, 4.7625, -4.7625 
120, 0, 0, 4.7625, 8.2488919604, 4.7625, -4.7625 
0, -2.38125, 4.1244459802, 4.7625, 8.2488919604, 4.7625, -4.7625 
*ZIGZAG,Staircase effect
0, 0, 0, 3.175, 3.175, 3.175, -3.175 
90, 3.175, 0, 3.175, 3.175, 3.175, -3.175

;;  
;;  User Defined Hatch Patterns
;;  Add any hatch patterns that you define to this section of
;;  the file to ensure that they migrate properly when
;;  upgrading to a future AutoCAD version.  If duplicate hatch
;;  patterns are found in this file, items in the User Defined
;;  Hatch Patterns section take precedence over patterns that
;;  appear earlier in the file.
;;
